% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summed_proportions.r
\name{get_summed_proportions}
\alias{get_summed_proportions}
\title{Get summed proportions}
\usage{
get_summed_proportions(
  hits,
  sct_data,
  annotLevel,
  reps,
  no_cores = 1,
  geneSizeControl,
  controlledCT = NULL,
  control_network = NULL,
  store_gene_data = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{hits}{list of gene names. The target gene set.}

\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{annotLevel}{An integer indicating which level of \code{sct_data} to
analyse (\emph{Default: 1}).}

\item{reps}{Number of random gene lists to generate (\emph{Default: 100},
but should be >=10,000 for publication-quality results).}

\item{no_cores}{Number of cores to parallelise
bootstrapping \code{reps} over.}

\item{geneSizeControl}{Whether you want to control for
GC content and transcript length. Recommended if the gene list originates
from genetic studies (\emph{Default: FALSE}).
If set to \code{TRUE}, then \code{hits} must be from humans.}

\item{controlledCT}{[Optional] If not NULL, and instead is the name of a
cell type, then the bootstrapping controls for expression within that
cell type.}

\item{control_network}{If \code{geneSizeControl=TRUE},
then must provide the control network.}

\item{store_gene_data}{Store sampled gene data for every bootstrap iteration.
When the number of bootstrap \code{reps} is very high (>=100k) and/or
 the number of genes in \code{hits} is very high, you may want
 to set \code{store_gene_data=FALSE} to avoid using excessive amounts of 
 CPU memory.}

\item{verbose}{Print messages.}
}
\value{
A list containing three elements:
\itemize{
  \item \code{hit.cells}: vector containing the summed proportion of
  expression in each cell type for the target list.
  \item \code{gene_data: } data.table showing the number of time each gene 
   appeared in the bootstrap sample.
  \item \code{bootstrap_data}: matrix in which each row represents the
  summed proportion of expression in each cell type for one of the
  random lists
  \item \code{controlledCT}: the controlled cell type (if applicable)
}
}
\description{
\code{get_summed_proportions} Given the target gene set, randomly sample
gene lists of equal length, obtain the specificity of these and then
obtain the mean specificity in each sampled list (and the target list).
}
\details{
See \link[EWCE]{bootstrap_enrichment_test} for examples.
}
\keyword{internal}
