% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_ctd_genes.R
\name{filter_ctd_genes}
\alias{filter_ctd_genes}
\title{Filter genes in a CellTypeDataset}
\usage{
filter_ctd_genes(ctd, gene_subset)
}
\arguments{
\item{ctd}{CellTypeDataset.}

\item{gene_subset}{Genes to subset to.}
}
\value{
Filtered CellTypeDataset.
}
\description{
Removes rows from each matrix within a CellTypeDataset (CTD) that are not 
within \code{gene_subset}.
}
\examples{
 
ctd <- ewceData::ctd()
ctd <- standardise_ctd(ctd, input_species="mouse")
gene_subset <- rownames(ctd[[1]]$mean_exp)[1:100]
ctd_subset <- EWCE::filter_ctd_genes(ctd = ctd, gene_subset = gene_subset) 
}
