% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_controlled_args.R
\name{check_controlled_args}
\alias{check_controlled_args}
\title{check_controlled_args}
\usage{
check_controlled_args(
  bg,
  sct_data,
  annotLevel,
  disease_genes,
  hits,
  functional_genes,
  funcGenes,
  combinedGenes
)
}
\arguments{
\item{bg}{List of gene symbols containing the background gene list
(including hit genes). If \code{bg=NULL},
 an appropriate gene background will be created automatically.}

\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{annotLevel}{An integer indicating which level of \code{sct_data} to
analyse (\emph{Default: 1}).}

\item{disease_genes}{Array of gene symbols containing the disease gene list.
Does not have to be disease genes. Must be from same species as the single
cell transcriptome dataset.}

\item{hits}{Hit genes.}

\item{functional_genes}{Array of gene symbols containing the functional gene
list. The enrichment of this gene set within the disease_genes is tested.
Must be from same species as the single cell transcriptome dataset.}

\item{funcGenes}{\code{functional_genes} that are within
\code{combinedGenes}.}

\item{combinedGenes}{\code{sct_data} genes that are in the background 
\code{bg}.}
}
\value{
Null output.
}
\description{
Check the input arguments of the 
\link[EWCE]{controlled_geneset_enrichment}.
}
\keyword{internal}
