% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_res_to_merging_list.r
\name{add_res_to_merging_list}
\alias{add_res_to_merging_list}
\title{Add to results to merging list}
\usage{
add_res_to_merging_list(full_res, existing_results = NULL)
}
\arguments{
\item{full_res}{Results list generated using
\link[EWCE]{bootstrap_enrichment_test}
or \link[EWCE]{ewce_expression_data} functions.
 Multiple results tables can be merged into one
results table, as long as the 'list' column is set to distinguish them.}

\item{existing_results}{Output of previous rounds from adding results to
list. Leave empty if this is the first item in the list.}
}
\value{
Merged results list.
}
\description{
\code{add_res_to_merging_list} adds EWCE results to a list
for merging analysis.
}
\examples{
# Load the single cell data
ctd <- ewceData::ctd()

# Load the data
tt_alzh <- ewceData::tt_alzh()
# tt_alzh_BA36 <- ewceData::tt_alzh_BA36()
# Use 3 bootstrap lists for speed, for publishable analysis use >10000
reps <- 3
# Use 5 up/down regulated genes (thresh) for speed, default is 250
thresh <- 5
# Run EWCE analysis
# tt_results <- ewce_expression_data(
#    sct_data = ctd, tt = tt_alzh, annotLevel = 1, thresh = thresh,
#    reps = reps, ttSpecies = "human", sctSpecies = "mouse"
# )
# tt_results_36 <- ewce_expression_data(
#    sct_data = ctd, tt = tt_alzh_BA36, annotLevel = 1, thresh = thresh,
#    reps = reps, ttSpecies = "human", sctSpecies = "mouse"
# )

# Fill a list with the results
results <- add_res_to_merging_list(tt_alzh)
# results <- add_res_to_merging_list(tt_alzh_BA36, results)
}
