% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combination_gen.R
\name{comb_gen}
\alias{comb_gen}
\title{Calculate unique combinations of samples at varying replicate number}
\usage{
comb_gen(condition_table = NULL, n_repetition = 30)
}
\arguments{
\item{condition_table}{A condition table with two columns and each sample
as a row. Column 1 contains sample names and Column 2 contains sample
condition (e.g. Control, Treatment).}

\item{n_repetition}{The number of maximum unique combinations to generate
at each replicate level. More tests will be performed with a bigger value,
but run time also increases linearly. Default set to 30 unique combinations.}
}
\value{
A list of character vectors containing sample combinations. Each
element in the list corresponds to a replicate level. Each combination
within the character vector is a single string with sample names separated
by semicolon.
}
\description{
\code{comb_gen} function takes the list of samples in each condition
and generate unique combination of sample names that allow
subsampling at varying replicate numbers.
}
\details{
At each replicate number (2 to N-1), the total number of unique combination
of samples is computed. For example, 10 condition A samples subsampled
at replicate number of 2 has 45 unique combinations.

When the total number of possible combinations at a particular
replicate number is more than the specified x number of
repetition (default=30), then only x unique combinations are selected.

When the total number of possible combination is smaller than the
specified x number of repetitions, then only unique combinations
are selected. For example, 10 samples subsample for 9 replicates
has 10 unique combinations and only 10 combinations will be selected
instead of 30.

This is repeated for both conditions and another level of combination
is performed to combine samples from the two conditions. Again, only
x number of unique combinations selected. When total unique combination
is smaller than x, then all unique combinations are selected.

Selected combinations of samples at each replicate number are then
returned.
}
\examples{
# Use example condition_table
# example dataset containing 1000 genes, 4 replicates and 5 comb. per rep.
# level
data(condition_table.partial, package = "ERSSA")

combinations.partial = comb_gen(condition_table.partial, n_repetition=5)

}
\author{
Zixuan Shao, \email{Zixuanshao.zach@gmail.com}
}
