
#' Example count table of GTEx RNA-seq experiment
#'
#' Count table generated using data downloaded from Recount2 website
#' with processed Raw GTEx dataset. Table has samples on columns and genes
#' on rows.
#' Contains 10 samples each from heart and muscle.
#'
#' @name count_table.full
#' @references \url{https://jhubiostatistics.shinyapps.io/recount/}
#'
#' Melé, Marta, Pedro G. Ferreira, Ferran Reverter, David S. DeLuca, Jean
#' Monlong, Michael Sammeth, Taylor R. Young, et al. “The Human Transcriptome
#' across Tissues and Individuals.” Science 348, no. 6235 (May 8, 2015):
#' 660–65. https://doi.org/10.1126/science.aaa0355.
#'
#' Collado-Torres, Leonardo, Abhinav Nellore, Kai Kammers, Shannon E. Ellis,
#' Margaret A. Taub, Kasper D. Hansen, Andrew E. Jaffe, Ben Langmead, and
#' Jeffrey T. Leek. “Reproducible RNA-Seq Analysis Using Recount2.” Nature
#' Biotechnology 35, no. 4 (April 2017): 319–21.
#' https://doi.org/10.1038/nbt.3838.
NULL



#' Example table of sample names and conditions
#'
#' Example condition table with two columns. Column 1 contains sample name,
#' column 2 contains condition name. Use in conjuncture with count_table.
#' Contains 10 GTEx samples each from heart and muscle.
#'
#' @name condition_table.full
NULL


#' Example count table of GTEx RNA-seq experiment
#'
#' Count table generated using data downloaded from Recount2 website
#' that processed Raw GTEx dataset. Table has samples on columns and genes
#' on rows.
#' This is a partial count table containing 1000 genes and 4 replicates each
#' from heart and muscle. Used for testing purposes and to shorten run time.
#'
#' @name count_table.partial
#' @references \url{https://jhubiostatistics.shinyapps.io/recount/}
#'
#' Melé, Marta, Pedro G. Ferreira, Ferran Reverter, David S. DeLuca, Jean
#' Monlong, Michael Sammeth, Taylor R. Young, et al. “The Human Transcriptome
#' across Tissues and Individuals.” Science 348, no. 6235 (May 8, 2015):
#' 660–65. https://doi.org/10.1126/science.aaa0355.
#'
#' Collado-Torres, Leonardo, Abhinav Nellore, Kai Kammers, Shannon E. Ellis,
#' Margaret A. Taub, Kasper D. Hansen, Andrew E. Jaffe, Ben Langmead, and
#' Jeffrey T. Leek. “Reproducible RNA-Seq Analysis Using Recount2.” Nature
#' Biotechnology 35, no. 4 (April 2017): 319–21.
#' https://doi.org/10.1038/nbt.3838.
NULL


#' Example count table of GTEx RNA-seq experiment, fitered by count_filter
#' function
#'
#' A filtered version of the example count_table.partial.
#' Contains 974 genes that passed the filter. Used for testing purposes and
#' to shorten run time.
#'
#'
#' @name count_table.filtered.partial
#' @references \url{https://jhubiostatistics.shinyapps.io/recount/}
#'
#' Melé, Marta, Pedro G. Ferreira, Ferran Reverter, David S. DeLuca, Jean
#' Monlong, Michael Sammeth, Taylor R. Young, et al. “The Human Transcriptome
#' across Tissues and Individuals.” Science 348, no. 6235 (May 8, 2015):
#' 660–65. https://doi.org/10.1126/science.aaa0355.
#'
#' Collado-Torres, Leonardo, Abhinav Nellore, Kai Kammers, Shannon E. Ellis,
#' Margaret A. Taub, Kasper D. Hansen, Andrew E. Jaffe, Ben Langmead, and
#' Jeffrey T. Leek. “Reproducible RNA-Seq Analysis Using Recount2.” Nature
#' Biotechnology 35, no. 4 (April 2017): 319–21.
#' https://doi.org/10.1038/nbt.3838.
NULL

#' Example table of sample names and conditions
#'
#' Example condition table with two columns. Column 1 contains sample name,
#' column 2 contains condition name. Use in conjuncture with count_table.
#' A partial condition table containing 4 replicates each of heart and muscle.
#' Used for testing purposes and to shorten run time.
#'
#' @name condition_table.partial
#'
NULL

#' Example list of combinations generated by comb_gen function.
#'
#' Generated with example sample set that contains 4 replicates each of heart
#' and muscle from GTeX. 5 combinations generated per replicate level.
#' Used for testing purposes and to shorten run time.
#'
#' @name combinations.partial
#'
NULL

#' Example list of DE genes generated by edgeR
#'
#' Generated using object count_table.filtered.partial and control='heart' as
#' inputs to erssa_edger function. Default parameters used. Contains list of
#' list of vectors. Each vector contains DE genes at a particular replicate
#' level generated by edgeR in a given sample combination.
#' Used for testing purposes and to shorten run time.
#'
#' @name deg.partial
#'
NULL
