% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_ksnull}
\alias{plot_ksnull}
\title{Plot null distribution of permuted ks scores vs. calculated ks
scores.}
\usage{
plot_ksnull(ksobj)
}
\arguments{
\item{ksobj}{An \code{\link{KSomics}} object, typically returned via a call
to \code{\link{calculate_ks}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned. If the value is
not assigned, a plot will be drawn.
}
\description{
The median of the randomly permuted KS scores (i.e. the null
distribution) is plotted on the x-axis, vs. the observed KS scores on the
y-axis. The line \code{y=x} is superimposed.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(10000), nrow=100, ncol=100)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:100, sep="")

# "group A" = first 50, "group B" = second 50
groups <- c(rep("A",50),rep("B",50))
names(groups) <- colnames(dat)

results <- calculate_ks(dat, groups, nperm=10, parallel=FALSE)
plot_ksnull(results)
}
\seealso{
\code{\link{calculate_ks}} \code{\link[ggplot2]{ggplot}}
}

