% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KS.R
\name{KSomics}
\alias{KSomics}
\title{Create an KSomics object}
\usage{
KSomics(data, outcomes, ks, ks.perm, pairwise.ks.score, pairwise.ks.q = NULL)
}
\arguments{
\item{data}{A matrix containing genomics data (e.g. gene expression levels).
The rownames should contain gene identifiers, while the column names should
contain sample identifiers.}

\item{outcomes}{A vector of group labels for each of the sample identifiers. The
names of this vector must correspond to the column names of \code{data}.}

\item{ks}{A matrix containing a row for each gene in \code{data}, and with
the following columns:
\itemize{
\item \code{ks} The calculated KS score.
\item \code{q-value} The calculated q-value (by permutation analysis).
}
The row names should specify the gene identifiers for each row.}

\item{ks.perm}{A matrix containing a row for each gene in \code{data}, and
with a column containing KS scores for each random permutation calculated
via \code{\link{calculate_ks}}.}

\item{pairwise.ks.score}{A table containing the KS scores for each pairwise
comparison for each gene. For a two-class problem, there should be only one column
comparing class 1 and class 2. The row names should be gene identifiers. The column
names should be in the format "<class 1> vs <class 2>" (e.g. "1 vs 2" or "A vs B").}

\item{pairwise.ks.q}{A table of the same dimensions as \code{pairwise.ks.score} with
the q-values for the pairwise comparisons. Q-values are computed by adjusting the p-value
using the Benjamini-Hochberg method within each pairwise comparison.}
}
\value{
The function combines its arguments in a list, which is assigned class
'KSomics'. The resulting object is returned.
}
\description{
This is the constructor for objects of class 'KSomics'. It
is used in \code{\link{calculate_ks}} to construct the return value.
}
\seealso{
\code{\link{calculate_ks}}
}

