% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{gene_cn_heatmaps}
\alias{gene_cn_heatmaps}
\title{Gene Copy Number Heatmap}
\usage{
gene_cn_heatmaps(
  X_raw,
  result,
  gff3_fn,
  gene_ref,
  baseline = 1,
  exclude_genes,
  col_cn = colorRamp2(c(0.5, 1, 1.5), c(muted("blue"), "white", muted("red"))),
  heatmap_height = unit(1.5, "in")
)
}
\arguments{
\item{X_raw}{Raw depth matrix}

\item{result}{Run result}

\item{gff3_fn}{gene annotation file name}

\item{gene_ref}{The name of the gene to set as reference for relative gene dosage heatmap}

\item{baseline}{Vector of state numbers to use as baseline for each sample. If it is single integer, then the given state number is used for all samples. (Default : \code{1})}

\item{exclude_genes}{name of genes to exclude from the annotation track (Default : NULL)}

\item{col_cn}{relative gene dosage color palette. (Default : \code{colorRamp2(c(0.5,1,1.5),c(muted("blue"),"white",muted("red")))})}

\item{heatmap_height}{heatmap height specified using unit function. (Default : \code{unit(1.5,"in")})}
}
\value{
a ComplexHeatmap Heatmap List object
}
\description{
Gene Copy Number Heatmap
}
\examples{



# gff3 gene model file
package_name <- "ELViS"
gff3_fn <- system.file("extdata","HPV16REF_PaVE.gff",package = package_name)

# loading precalculated depth matrix
data(mtrx_samtools_reticulate)

# threshold
th <- 50

# filtered matrix
base_resol_depth <- filt_samples(mtrx_samtools_reticulate,th=th,smry_fun=max)

# viral load data
data(total_aligned_base__host_and_virus)
viral_load <- (10^6)*(apply(base_resol_depth,2,\(x) sum(x)) )/total_aligned_base__host_and_virus

# load ELViS run result
data(ELViS_toy_run_result)
result <- ELViS_toy_run_result

# genes to exclude from plotting
exclude_genes <- c("E6*","E1^E4","E8^E2")

# heatmap of gene dosage
gene_ref<-"E7"

gene_cn <-
  gene_cn_heatmaps(
    X_raw = base_resol_depth,
    result = result,
    gff3_fn = gff3_fn,
    baseline = 1,
    gene_ref = gene_ref,
    exclude_genes = exclude_genes
    )

gene_cn




}
