% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scatter.plot.R
\name{scatter.plot}
\alias{scatter.plot}
\title{scatter.plot to plot scatter plots between gene expression and DNA methylation.}
\usage{
scatter.plot(data, 
             byPair = list(probe = c(), gene = c()),
             byProbe = list(probe = c(), numFlankingGenes = 20), 
             byTF = list(TF = c(), probe = c()),
             category = NULL,
             ylim = NULL,
             dots.size = 0.9,
             correlation = FALSE,
             width = 7,
             height = 6,
             dir.out = "./",
             save = TRUE, ...)
}
\arguments{
\item{data}{A multiAssayExperiment with DNA methylation and Gene Expression data. 
See \code{\link{createMAE}} function.}

\item{byPair}{A list: byPair =list(probe=c(),gene=c()); probe contains a vector 
of probes' name and gene contains a vector of gene ID. The length of probe 
should be the same with length of gene. Output see numFlankingGenes}

\item{byProbe}{A list byProbe =list(probe=c(), geneNum=20); probe contains 
a vector of probes'name and geneNum specify the number of gene near the probes 
will ploted. 20 is default for numFlankingGenes Output see detail.}

\item{byTF}{A list byTF =list(TF=c(), probe=c()); TF contains a vector of TF's 
symbol and probe contains the a vector of probes' name. Output see detail.}

\item{category}{A vector labels subtype of samples or a character which is the 
column name in the colData(data) in the multiAssayExperiment object. Once specified, samples 
will label different color. The color can be customized by using color.value.}

\item{ylim}{y-axis limit i.e. c(0,25)}

\item{dots.size}{Control dots size}

\item{correlation}{Add pearson correlation values to the plot}

\item{width}{PDF width}

\item{height}{PDF height}

\item{dir.out}{A path specify the directory to which the figures will be saved. 
Current directory is default.}

\item{save}{A logic. If true, figure will be saved to dir.out.}

\item{...}{color.value, lm_line in scatter function}
}
\value{
Scatter plots.
}
\description{
scatter.plot is a function to plot various scatter plots between gene expression and 
DNA methylation. When byPair is specified, scatter plot for individual probe-gene pairs
will be generated. When byProbe is specified, scatter plots for one probes with nearby
20 gene pairs will be generated. When byTF is specified, scatter plot for TF expression 
and average DNA methylation at certain motif sites will be generated.
}
\details{
byPair The output will be scatter plot for individual pairs.

byProbe The output will be scatter plot for the probe and nearby genes.

byTF The output will be scatter plot for the TFs and the average 
DNA methylation at the probes set specified in byTF list.
}
\examples{
data <- ELMER:::getdata("elmer.data.example")
scatter.plot(data,
            byProbe=list(probe=c("cg19403323"),numFlankingGenes=20), 
            category="definition", save=FALSE)
scatter.plot(data,byProbe=list(probe=c("cg19403323"),numFlankingGenes=20), 
            category="definition", save=TRUE) ## save to pdf
# b. generate one probe-gene pair
scatter.plot(data,byPair=list(probe=c("cg19403323"),gene=c("ENSG00000143322")),
             category="definition", save=FALSE,lm_line=TRUE) 
}
\author{
Lijing Yao (maintainer: lijingya@usc.edu)
}
