% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif.TF.Plots.R
\name{motif.enrichment.plot}
\alias{motif.enrichment.plot}
\title{motif.enrichment.plot to plot bar plots showing motif enrichment ORs and  95\% confidence interval for ORs}
\usage{
motif.enrichment.plot(motif.enrichment, 
                      significant = NULL, 
                      dir.out ="./", 
                      save = TRUE,
                      label = NULL,
                      title = NULL, 
                      width = 10, 
                      height = NULL,
                      summary = FALSE)
}
\arguments{
\item{motif.enrichment}{A data frame or a file path of get.enriched.motif output
motif.enrichment.csv file.}

\item{significant}{A list to select subset of motif. Default is NULL.}

\item{dir.out}{A path specify the directory to which the figures will be saved. 
Current directory is default.}

\item{save}{A logic. If true (default), figure will be saved to dir.out.}

\item{label}{A character. Labels the outputs figure.}

\item{title}{Plot title. Default: no title}

\item{width}{Plot width}

\item{height}{Plot height. If NULL a default value will be calculated}

\item{summary}{Create a summary table along with the plot, it is necessary 
to add two new columns to object (NumOfProbes and PercentageOfProbes)}
}
\value{
A figure shows the enrichment level for selected motifs.
}
\description{
motif.enrichment.plot to plot bar plots showing motif enrichment ORs and 
95\% confidence interval for ORs. Option motif.enrichment can be a data frame 
generated by \code{\link{get.enriched.motif}} or a path of XX.csv saved by the 
same function.
}
\details{
motif.enrichment If input data.frame object, it should contain "motif",
"OR", "lowerOR", "upperOR" columns. motif specifies name of motif; 
OR specifies Odds Ratio, lowerOR specifies lower boundary of OR (95%) ; 
upperOR specifies upper boundary of OR(95%).

significant A list used to select subset of motif.enrichment by the 
cutoff of OR, lowerOR, upperOR. significant=list(OR=1). More than one cutoff 
can be specified such as significant = list(OR=1, lowerOR=1,upperOR=4)
}
\examples{
motif.enrichment <- data.frame(motif = c("TP53","NR3C1","E2F1","EBF1","RFX5","ZNF143", "CTCF"),
                               OR = c(19.33,4.83,1, 4.18, 3.67,3.03,2.49),
                               lowerOR = c(10,3,1.09,1.9,1.5,1.9, 0.82),
                               upperOR = c(23,5,3,7,6,5,5),
                               stringsAsFactors = FALSE)
motif.enrichment.plot(motif.enrichment = motif.enrichment,
                      significant = list(OR = 3),
                      label = "hypo", save = FALSE)
motif.enrichment.plot(motif.enrichment = motif.enrichment,
                      significant = list(OR = 3),
                      label = "hypo", 
                      title = "OR for paired probes hypomethylated in Mutant vs WT",
                      save = FALSE)
motif.enrichment <- data.frame(motif = c("TP53","NR3C1","E2F1","EBF1","RFX5","ZNF143", "CTCF"),
                               OR = c(19.33,4.83,1, 4.18, 3.67,3.03,2.49),
                               lowerOR = c(10,3,1.09,1.9,1.5,1.5, 0.82),
                               upperOR = c(23,5,3,7,6,5,5),
                               NumOfProbes = c(23,5,3,7,6,5,5),
                               PercentageOfProbes = c(0.23,0.05,0.03,0.07,0.06,0.05,0.05),
                               stringsAsFactors=FALSE)
motif.enrichment.plot(motif.enrichment = motif.enrichment,
                      significant = list(OR = 3),
                      label = "hypo", save = FALSE)
motif.enrichment.plot(motif.enrichment = motif.enrichment,
                      significant = list(OR = 3),
                      label = "hypo", 
                      summary = TRUE,
                      title = "OR for paired probes hypomethylated in Mutant vs WT",
                      save = TRUE)
}
\references{
Yao, Lijing, et al. "Inferring regulatory element landscapes and transcription 
factor networks from cancer methylomes." Genome biology 16.1 (2015): 1.
}
\author{
Lijing Yao (creator: lijingya@usc.edu)
}
