% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{heatmapGene}
\alias{heatmapGene}
\title{Heatmap for correlation between probes DNA methylation and a single gene expression.}
\usage{
heatmapGene(
  data,
  group.col,
  group1,
  group2,
  pairs,
  GeneSymbol,
  scatter.plot = FALSE,
  correlation.method = "pearson",
  correlation.table = FALSE,
  annotation.col = NULL,
  met.metadata = NULL,
  exp.metadata = NULL,
  dir.out = ".",
  filter.by.probe.annotation = TRUE,
  numFlankingGenes = 10,
  width = 10,
  height = 10,
  scatter.plot.width = 10,
  scatter.plot.height = 10,
  filename = NULL
)
}
\arguments{
\item{data}{A MultiAssayExperiment with a DNA methylation SummarizedExperiment (all probes) and a gene Expression SummarizedExperiment.}

\item{group.col}{A column from the sample matrix from the MultiAssayExperiment object. Accessed with colData(mae)}

\item{group1}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{group2}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{pairs}{List of probe and pair genes}

\item{GeneSymbol}{Gene Symbol}

\item{scatter.plot}{Plot scatter plots}

\item{correlation.method}{Correlation method: Pearson or sperman}

\item{correlation.table}{save table with spearman correlation analysis ?}

\item{annotation.col}{A vector of columns from the sample matrix from the MultiAssayExperiment object. Accessed with colData(mae) 
to be added as annotation to the heatmap}

\item{met.metadata}{A vector of metdatada columns available in the DNA methylation GRanges to should be added to the heatmap.}

\item{exp.metadata}{A vector of metdatada columns available in the Gene expression GRanges to should be added to the heatmap.}

\item{dir.out}{Where to save the plots}

\item{filter.by.probe.annotation}{Filter probes to plot based on probes annotation}

\item{numFlankingGenes}{numFlankingGenes to plot.}

\item{width}{Figure width}

\item{height}{Figure height}

\item{scatter.plot.width}{Scatter plot width}

\item{scatter.plot.height}{Scatter plot height}

\item{filename}{File names (.pdf) to save the file (i.e. "plot.pdf"). If NULL return plot.}
}
\value{
A heatmap
}
\description{
This heatmap will sort samples by their gene expression and show the DNA methylation levels of the paired probes to that gene.
If no pairs are given, nearest probes will be selected. 
To use this function you MAE object (input data) will need all probes and not only the distal ones.
This plot can be used to evaluate promoter, and intro, exons regions and closer distal probes of a gene to verify if their
DNA methylation level is affecting the gene expression
}
\examples{
\dontrun{
  data <- ELMER:::getdata("elmer.data.example")
  group.col <- "subtype_Expression.Subtype"
  group1 <- "classical"
  group2 <- "secretory"
  pairs <- data.frame(ID = c("cg15924102","cg19403323", "cg22396959"),
                      GeneID = c("ENSG00000196878", "ENSG00000009790", "ENSG00000009790" ),
                      Symbol = c("TRAF3IP3","LAMB3","LAMB3"),
                      Side = c("R1","L1","R3"),
                      Distance = c(6017,168499,0),
                      stringsAsFactors = FALSE)
 heatmapGene(data = data, 
             group.col = group.col,
             group1 = group1, 
             group2 = group2,
             pairs = pairs, 
             GeneSymbol = "LAMB3",
             height = 5,
             annotation.col = c("ethnicity","vital_status"),
             filename = "heatmap.pdf")
 \dontrun{            
     heatmapGene(data = data, 
                 group.col = group.col,
                 group1 = group1, 
                 group2 = group2,
                 GeneSymbol = "ACP6",
                 annotation.col = c("ethnicity","vital_status"),
                 filename = "heatmap_closer_probes.pdf")
 }
}
}
\author{
Tiago Chedraoui Silva (tiagochst at gmail.com)
}
