% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{createIGVtrack}
\alias{createIGVtrack}
\title{Create a junction track for IGV visualization of interection}
\usage{
createIGVtrack(
  pairs,
  met.platform = "450K",
  genome = "hg38",
  filename = "ELMER_interactions.bed",
  color.track = "black",
  track.name = "junctions",
  gene.symbol = NULL,
  all.tss = TRUE
)
}
\arguments{
\item{pairs}{A data frame output from getPairs function}

\item{met.platform}{DNA methyaltion platform to retrieve data from: EPIC or 450K (default)}

\item{genome}{Which genome build will be used: hg38 (default) or hg19.}

\item{filename}{Filename (".bed")}

\item{color.track}{A color for the track (i.e blue, red,#272E6A)}

\item{track.name}{Track name}

\item{gene.symbol}{Filter pairs to a single gene.}

\item{all.tss}{A logical. If TRUE it will link probes to all TSS  of a gene (transcript level), if FALSE 
it will link to the promoter region of a gene (gene level).}
}
\description{
Create a junction track for IGV visualization of interection
}
\examples{
 \dontrun{            
data <- ELMER:::getdata("elmer.data.example")
nearGenes <-GetNearGenes(TRange=getMet(data)[c("cg00329272","cg10097755"),],
                         geneAnnot=getExp(data))
Hypo.pair <- get.pair(data=data,
                       nearGenes=nearGenes,
                       permu.size=5,
                       group.col = "definition",
                       group1 = "Primary solid Tumor", 
                       group2 = "Solid Tissue Normal",
                       raw.pvalue = 0.2,
                       Pe = 0.2,
                       dir.out="./",
                       label= "hypo")
 createIGVtrack(Hypo.pair,met.platform = "450K", genome = "hg38")
 }
}
\author{
Tiago Chedraoui Silva (tiagochst at gmail.com)
}
