% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc_overlay.R
\name{plot_roc_overlay}
\alias{plot_roc_overlay}
\title{Plot ROC overlay}
\usage{
plot_roc_overlay(scores.mat, labels.mat, nbins = 100)
}
\arguments{
\item{scores.mat}{numeric array}

\item{labels.mat}{numeric array}

\item{nbins}{numeric value}
}
\value{
list of Z(matrix) and roc_sum (average ROC curve)
}
\description{
The function plots a density overlay of ROCs given the scores and labels
}
\examples{
genes.labels <- matrix( c(rep(1, 1000), rep(0,9000)), nrow=1000, byrow=TRUE)
rownames(genes.labels) = paste('gene', 1:1000, sep='')
colnames(genes.labels) = paste('function', 1:10, sep='')

scores <- matrix( rnorm(10000), nrow=1000)
scores <- apply(scores, 2, rank) 
rownames(scores) = paste('gene', 1:1000, sep='')
colnames(scores) = paste('function', 1:10, sep='')

z <- plot_roc_overlay(scores, genes.labels)

}
\keyword{ROC}
\keyword{overlay}
\keyword{plot}
