% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_network.R
\name{extend_network}
\alias{extend_network}
\title{Builds an extended network from a binary network}
\usage{
extend_network(net, max = 6)
}
\arguments{
\item{net}{matrix binary and symmetric}

\item{max}{numeric maximum number of jumps}
}
\value{
ext_net matrix dense and symmetric
}
\description{
The function extends a binary network by using the inverse
of the path length between nodes as a weighted edge
}
\examples{
net <- matrix( sample(c(0,1),36, replace=TRUE), nrow=6,byrow=TRUE)
ext_net <- extend_network(net)


}
\keyword{extended}
\keyword{igraph}
\keyword{length}
\keyword{network}
\keyword{path}
\keyword{shortest}
