% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_multifunc.R
\name{auc_multifunc}
\alias{auc_multifunc}
\title{Calculating AUC for functional groups from ranked lists}
\usage{
auc_multifunc(annotations, optimallist)
}
\arguments{
\item{annotations}{binary matrix indicating which list elements are in which functional groups.}

\item{optimallist}{Ranked list (multifunctionality analysis, see \code{\link{calculate_multifunc}}).}
}
\value{
aucs array of aucs for each group in annotations
}
\description{
The function calculates the AUC for a functional group 
analytically using an optimal ranked list of genes that 
indicates association between genes and groups.
}
\examples{
annotations <- c(rep(0,10))
annotations[c(1,3,5)] <- 1 
optimallist <- 10:1
aurocs_mf <- auc_multifunc(annotations, optimallist)

}
\keyword{AUC}
\keyword{evalutation}
\keyword{multifunctionality}
