% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeGenes.R
\name{visualizeGenes}
\alias{visualizeGenes}
\title{Visualize gene}
\usage{
visualizeGenes(gene, ebsea.out)
}
\arguments{
\item{gene}{Gene name matching the input data.}

\item{ebsea.out}{Plots the mean count and fold-change
the exons of the specified gene.}
}
\value{
Plots the mean count and fold-change across the
exons of the specified gene.
}
\description{
Produces a visualization summarizing the normalized read count
in each sample group and expression difference across the
expressed exons.Top panel contains the log2 fold-change for
each expressed exon. Asterisk denotes the significance
level (*: < 0.05, **: < 0.01). Bottom panel shows the averaged normalized
read count for each sample group. The title of the figure shows
the gene name and the adjusted gene-level p-value (fdr)
}
\examples{
data(exonCounts)
group <- data.frame('group' = as.factor(c('G1', 'G1', 'G1', 'G2', 'G2', 'G2', 'G2')))
row.names(group) <- colnames(exonCounts)
design <- ~group
ebsea.out <- EBSEA(exonCounts, group, design)
visualizeGenes('FBgn0000017', ebsea.out)
}
