% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{.addDGidsForTmpDGs}
\alias{.addDGidsForTmpDGs}
\title{Helper function to add ids to the duplex groups missed during global clustering}
\usage{
.addDGidsForTmpDGs(gi_input)
}
\arguments{
\item{gi_input}{\pkg{GInteractions} with the  \code{dg_id},  \code{duplex_id} and  \code{n_reads} column}
}
\value{
\pkg{GInteractions} object with new \code{dg_id} for rows with  \code{n_reads > 1}
}
\description{
Check if there are a temporary duplex records with \code{duplex_id}, which consist of more than one read  \code{n_reads > 1} , but
does not have assigned any \code{dg_id} as the duplex group (DG) index. Creates new  \code{dg_id} if \code{n_reads > 1}
}
\details{
Meant to be used in the situations when previous collapsing steps merged two or more reads to the temporary DG with \code{duplex_id}, but
global clustering has not identified any overlap between this temporary group and other duplexes, resulting in undefined \code{dg_id}.
This function looks up for these cases and creates new \code{dg_id} for temporary DGs, marking them as the final DGs.
New \code{dg_id} values are unique and allocated sequentially after the  maximum value of \code{dg_id}
}
