% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexDiscovererResults.R
\docType{methods}
\name{dd_get_chimeric_reads_stats}
\alias{dd_get_chimeric_reads_stats}
\alias{dd_get_chimeric_reads_stats,DuplexDiscovererResults-method}
\title{Accessor for \code{chimeric_reads_stats} Slot}
\usage{
dd_get_chimeric_reads_stats(object)

\S4method{dd_get_chimeric_reads_stats}{DuplexDiscovererResults}(object)
}
\arguments{
\item{object}{A \code{DuplexDiscovererResults} object.}
}
\value{
\code{tibble} from the \code{chimeric_reads_stats} slot.
}
\description{
Retrieves the value of the \code{chimeric_reads_stats} slot in a \code{DuplexDiscovererResults} object.
}
\examples{

# load example input
data("RNADuplexesSmallGI")
data("RNADuplexesSampleData")
# run whole pipeline
result <- runDuplexDiscoverer(
    data = SampleSmallGI,
    junctions_gr = SampleSpliceJncGR,
    anno_gr = SampleGeneAnnoGR,
    sample_name = "run_example",
    lib_type = "SE",
    table_type = "STAR"
)
# access results
show(result)
gi_clusters <- dd_get_duplex_groups(result)
gi_reads <- dd_get_chimeric_reads(result)
df_reads <- dd_get_reads_classes(result)
dd_get_reads_classes(result)
dd_get_run_stats(result)
}
