% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whenToStop}
\alias{whenToStop}
\title{When to Stop}
\usage{
whenToStop(merger, p = 1, average_n = NULL)
}
\arguments{
\item{merger}{the result from having run \code{\link{Dune}}
on the dataset}

\item{p}{A value between 0 and 1. We stop when the metric used for merging has
improved by p of the final total improvement. Default to 1 (i.e running the full merging).}

\item{average_n}{Alternatively, you can specify the average number of clusters you
want to have.}
}
\value{
An integer giving the step where to stop.
}
\description{
When to Stop
}
\details{
The \code{\link{Dune}} process improves the metric. This return
the first merging step after which the metric has been improved by p of the
total. Setting p = 1 just return the number of merges.
}
\examples{
data("clusMat", package = "Dune")
merger <- Dune(clusMat = clusMat)
whenToStop(merger, p = .5)
}
