% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Dune.R
\name{Dune}
\alias{Dune}
\alias{Dune,matrix-method}
\alias{Dune,data.frame-method}
\alias{Dune,SummarizedExperiment-method}
\title{Dune}
\usage{
Dune(clusMat, ...)

\S4method{Dune}{matrix}(
  clusMat,
  unclustered = NULL,
  verbose = FALSE,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  metric = "NMI"
)

\S4method{Dune}{data.frame}(
  clusMat,
  unclustered = NULL,
  verbose = FALSE,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  metric = "NMI"
)

\S4method{Dune}{SummarizedExperiment}(
  clusMat,
  cluster_columns,
  unclustered = NULL,
  verbose = FALSE,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  metric = "NMI"
)
}
\arguments{
\item{clusMat}{the matrix of samples by clustering labels.}

\item{...}{parameters including:}

\item{unclustered}{The value assigned to unclustered cells. Default to \code{NULL}}

\item{verbose}{Whether or not the print cluster merging as it happens.}

\item{parallel}{Logical, defaults to FALSE.
Set to TRUE if you want to parallellize the fitting.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations.
See \code{bpparam} in \code{BiocParallel} package for details.
Won't be used if \code{parallel} is FALSE.}

\item{metric}{The metric that is tracked to decide which clusters to merge. For now,
either ARI and NMI are accepted. Default to NMI. See details.}

\item{cluster_columns}{if \code{clusMat} is a \code{\link{SummarizedExperiment}},
then this defines the columns of \code{colData} that are outputs from a clustering algorithm.}
}
\value{
A list with four components: the initial matrix of clustering labels,
the final matrix of clustering labels, the merge info matrix and the Metric
improvement vector.
}
\description{
Compute the Metric between every pair of clustering labels after merging every possible pair of clusters. Find the one that improves the Metric merging the most, merge the pair. Repeat until there is no improvement.
}
\details{
The Dune algorithm merges pairs of clusters in order to improve the
mean adjusted Rand Index or the mean normalized mutual information with other
clustering labels. It returns a list with five components.:
#' \itemize{
\item \code{initialMat}: The initial matrix of cluster labels
\item \code{currentMat}: The final matrix of cluster labels
\item \code{merges}: The step-by-step detail of the merges, recapitulating
which clusters where merged in which cluster label
\item \code{impMetric}: How much each merge improved the mean Metric between the
cluster label that has been merged and the other cluster labels.
\item \code{metric}: The metric that was used to find the merges.
}
}
\examples{
data("clusMat", package = "Dune")
merger <- Dune(clusMat = clusMat)
# clusters 11 to 14 from cluster label 5 and 3 are subset of cluster 2 from
# other cluster labels. Designing cluster 2 as unclustered therefore means we
# do fewer merges.
merger2 <- Dune(clusMat = clusMat, unclustered = 2)
merger$merges
merger2$merges
}
\seealso{
clusterConversion ARIImp
}
