% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_Network.R
\name{weight_Network}
\alias{weight_Network}
\title{Analyze and Visualize a Microbial Network}
\usage{
weight_Network(graph_path = NULL, save_metrics = TRUE)
}
\arguments{
\item{graph_path}{Character. The \strong{GraphML file path}. Default (\code{NULL}) loads \code{"Complete.graphml"} from \strong{DspikeIn}.
Valid internal options: \code{"Complete.graphml"}, \code{"NoHubs.graphml"}, \code{"NoBasid.graphml"}.
If an \strong{external path} is provided, the function loads that instead.}

\item{save_metrics}{Logical. If \code{TRUE}, saves the global metrics as a CSV file (in the working directory or specified by \code{metrics_path}).}
}
\value{
A list containing:
\item{plot}{A \code{ggplot2} object displaying the network.}
\item{metrics}{A \code{data.frame} with global network metrics.}
\item{graph}{The annotated \code{igraph} object.}
}
\description{
Loads a microbial network from the \strong{DspikeIn} package (\code{Complete.graphml}, \code{NoHubs.graphml}, or \code{NoBasid.graphml})
or from a user-provided \strong{GraphML} file. Computes network metrics, assigns modularity-based node colors (\code{cool_MG} from \strong{DspikeIn}),
and visualizes the network using \code{ggraph}. Optionally saves computed \strong{global network metrics} as a CSV file.
}
\examples{

if (requireNamespace("DspikeIn", quietly = TRUE)) {
  Complete <- load_graphml("Complete.graphml")

  # Run network weighting function on the loaded dataset
  # Load a specific GraphML dataset from DspikeIn
  result <- weight_Network(graph_path = "Complete.graphml")

  # Load a custom GraphML file from user directory,
  # for external graphml please use **full address**
  print(result$plot)

  # View network metrics
  result$metrics
  # Optional: Clean up generated metrics file if saved
  unlink("Global_Network_Metrics.csv")
}

}
\seealso{
\code{\link[igraph]{cluster_fast_greedy}}, \code{\link[ggraph]{ggraph}}, \code{\link{load_graphml}}
}
