% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_set.R
\name{remove_zero_negative_count_samples}
\alias{remove_zero_negative_count_samples}
\title{Remove Samples with Zero, Negative Counts, or NA Values and Add Pseudocount}
\usage{
remove_zero_negative_count_samples(obj, pseudocount = 1e-06)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbial data.}

\item{pseudocount}{A numeric value to add to avoid zero counts.}
}
\value{
A phyloseq object with filtered and adjusted OTU table.
}
\description{
Remove Samples with Zero, Negative Counts, or NA Values and Add Pseudocount
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  library(DspikeIn)
  data("physeq_16SOTU", package = "DspikeIn")

  # Remove samples with zero/negative/NA counts and add pseudocount
  cleaned_ps <- remove_zero_negative_count_samples(
    physeq_16SOTU,
    pseudocount = 1e-6
  )
}
}
