% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomsubsample_Trimmed_evenDepth.R
\name{randomsubsample_Trimmed_evenDepth}
\alias{randomsubsample_Trimmed_evenDepth}
\title{Subsampling to an Equal Sequencing Depth}
\usage{
randomsubsample_Trimmed_evenDepth(
  obj,
  smalltrim = 0.001,
  replace = TRUE,
  output_file = NULL
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbiome data.}

\item{smalltrim}{A numeric value specifying the trimming percentage to exclude very low abundant taxa. Default is 0.001.}

\item{replace}{A logical value indicating whether to sample with replacement. Default is TRUE.}

\item{output_file}{A character string specifying the output file name for the subsampled object.
Default is \code{NULL}, meaning the object will not be saved.}
}
\value{
A rarefied \code{phyloseq} or \code{TreeSummarizedExperiment} object with adjusted sequencing depths.
}
\description{
Performs subsampling to an equal sequencing depth, determined by the sample with
the lowest sequencing depth after excluding very low abundant taxa. It rounds down the result
to the nearest integer (\code{floor}). Note: some samples may be lost in this process.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_ITSOTU", package = "DspikeIn")
  tse_ITSOTU <- convert_phyloseq_to_tse(physeq_ITSOTU)
  rarefied <- randomsubsample_Trimmed_evenDepth(tse_ITSOTU, smalltrim = 0.001)
  print(rarefied)
}

}
