% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDoscheda.R
\name{runDoscheda}
\alias{runDoscheda}
\title{Wrapper Function to run the entire Doscheda pipeline}
\usage{
runDoscheda(dataFrame, dataChannels, accessionChannel, chansVal, repsVal,
  dataTypeStr, modelTypeStr, PDBool = TRUE, removePepsBool = NA,
  incPDofPDBool = FALSE, PDofPDname = NA, incGeneFileBool = FALSE,
  organismStr = "h.sapiens", sigmoidConc = NA, pearsonThrshVal = 0.4,
  uniquePeps = NA, sequenceChannel = NA, qualityChannel = NA,
  pdofpdChannel = NA, incGeneID = FALSE, geneIDFile = NA,
  normType = "loess")
}
\arguments{
\item{dataFrame}{data.frame of the input data set}

\item{dataChannels}{column names of dataFrame that correspond to data channels. These should be ordered in the format: rep1_concentration_0, ..., rep1_concentration_n, rep2_concentration_0, ...}

\item{accessionChannel}{string that is the same as the column name for the protein accessions in dataFrame}

\item{chansVal}{number of channels / concentrations in experiment}

\item{repsVal}{number of replicates in experiment}

\item{dataTypeStr}{string describing the data type of input data set. This can be 'LFC' for log fold-changes, 'FC' for fold-changes and 'intensity' for peptide intensities}

\item{modelTypeStr}{string describing the type of model applied. This can be 'linear' for a linear model or 'sigmoid' for a sigmoidal model}

\item{PDBool}{boolean value indicating if the input data is from Proteome Discoverer 2.1 or not}

\item{removePepsBool}{boolean value indicating if peptide removal will take place. Only valid if input data is peptide intensities}

\item{incPDofPDBool}{boolean value indicating if the input data contais a pull-down of pull-down colum}

\item{PDofPDname}{string with the same name as colulmn containing pull-down of pull-down data. NA if this is not applicable}

\item{incGeneFileBool}{boolean value indicating if the data requires a protein accession to gene ID conversion file}

\item{organismStr}{string giving the name of organism. the options are: 'H.sapiens', 'D. melanogaster', 'C. elegans', 'R. norvegicus', 'M. musculus'. This is only needed if PDbool is FALSE}

\item{sigmoidConc}{vector of numerical values for concentrations of channels in the case of a sigmoidal fit}

\item{pearsonThrshVal}{numerial value between -1 and 1 which determines the cut-off used to discard peptides during peptide removal}

\item{uniquePeps}{string that is the same as the column name for the number of unique peptides in dataFrame}

\item{sequenceChannel}{string that is the same as the column name for the peptide sequences in dataFrame}

\item{qualityChannel}{string that is the same as the column name for the peptide quality score in dataFrame}

\item{pdofpdChannel}{string that is the same as the column name for the pull-down of pull-down data in dataFrame}

\item{incGeneID}{boolean value indicating if a protein accession to gene ID file is supplied}

\item{geneIDFile}{data.frame containing a protein accession to gene ID conversion file}

\item{normType}{string indicating the type of normalisation that should take place ('loess', 'median', 'none')}
}
\value{
object of class ChemoProtSet
}
\description{
A wrapper for the whole Doscheda pipeline, if users want to avoid using the separate steps.
}
\examples{
channelNames <- c('Abundance..F1..126..Control..REP_1',
'Abundance..F1..127..Sample..REP_1',  'Abundance..F1..128..Sample..REP_1',
'Abundance..F1..129..Sample..REP_1',  'Abundance..F1..130..Sample..REP_1',
'Abundance..F1..131..Sample..REP_1',  'Abundance..F2..126..Control..REP_2',
'Abundance..F2..127..Sample..REP_2', 'Abundance..F2..128..Sample..REP_2',
'Abundance..F2..129..Sample..REP_2',  'Abundance..F2..130..Sample..REP_2',
'Abundance..F2..131..Sample..REP_2')

ex <- runDoscheda(dataFrame = doschedaData, dataChannels = channelNames,
chansVal = 6, repsVal = 2,dataTypeStr = 'intensity',
modelTypeStr = 'linear',PDBool = FALSE,removePepsBool = FALSE,
accessionChannel = 'Master.Protein.Accessions',
sequenceChannel = 'Sequence',qualityChannel = 'Qvality.PEP',
incPDofPDBool = FALSE, incGeneFileBool = FALSE,
 organismStr = 'H.sapiens', pearsonThrshVal = 0.4)
}
\seealso{
\code{\link{DoschedaSet}}
}
