% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseMeta.R
\name{discoParseMeta}
\alias{discoParseMeta}
\title{Generate Experiment Metadata}
\usage{
discoParseMeta(samplenames, shinySession = NULL)
}
\arguments{
\item{samplenames}{character, a list of sample names following the
DiscoRhythm naming convention (<prefix><Time>_<UniqueID>_<ReplicateID>).}

\item{shinySession}{shiny session object for use only by the DiscoRhythm
shiny app \code{discoApp()} to update the axis labels using the time
value prefix.}
}
\value{
a data.frame containing 3 columns of metadata. ID = unique sample
identity. Time = sample colleciton time. ReplicateID = Identifier where Time
+ ReplicateID indicates a biological sample ID.
}
\description{
Parses the sample metadata from a vector of sample names (often column names
of a Maindata format data.frame).
}
\details{
The regular expression used to obtain metadata is
"^([[:alpha:]]*)(\\-?[0-9]+[\\.]?[0-9]*)\\_?
([[:alnum:]\\.]*)\\_?([[:alnum:]\\.]*)$"

Where each () will be used to construct the final metadata data.frame
}
\examples{

discoParseMeta(c("CT24_AD_1","CT24_AS_1","CT24_AE_2","CT24_AW_2",
"CT26_AB_1","CT26_AC_1","CT26_BB_2","CT26_BC_2"))

}
