% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffSeqLogo.R
\name{diffLogoFromPwm}
\alias{diffLogoFromPwm}
\title{Draw DiffLogo from PWM}
\usage{
diffLogoFromPwm(pwm1, pwm2, ymin = 0, ymax = 0,
  stackHeight = shannonDivergence,
  baseDistribution = normalizedDifferenceOfProbabilities,
  sparse = FALSE, alphabet = DNA, align_pwms = FALSE,
  unaligned_penalty = divergencePenaltyForUnaligned,
  try_reverse_complement = TRUE, base_distribution = NULL,
  length_normalization = FALSE)
}
\arguments{
\item{pwm1}{representation of the first position weight matrix (PWM) of type pwm, data.frame, or matrix}

\item{pwm2}{representation of the second position weight matrix (PWM) of type pwm, data.frame, or matrix}

\item{ymin}{minimum value on the y-axis}

\item{ymax}{maximum value on the y-axis}

\item{stackHeight}{function for the height of a stack at position i}

\item{baseDistribution}{function for the heights of the individual bases}

\item{sparse}{if TRUE margins are reduced and tickmarks are removed from the logo}

\item{alphabet}{of type Alphabet}

\item{align_pwms}{if true, DiffLogo will align pwms before plotting}

\item{unaligned_penalty}{is a function for localPwmAlignment.}

\item{try_reverse_complement}{if True, alignment will try reverse complement pwms}

\item{base_distribution}{is a vector of length nrow(pwm) that is added to unaligned columns of pwms for comparing. If NULL, uniform distribution is used}

\item{length_normalization}{If true, will minimize the average divergence between PWMs. Otherwise will minimize the sum of divergences between positions. In both cases unalignes positions are compared to base_distribution and are counted when computing the alignment length.}
}
\value{
none (draws difference logo)
}
\description{
Draws the difference of two sequence logos.
}
\examples{
motif_folder= "extdata/pwm"
motif_names = c("HepG2","MCF7","HUVEC","ProgFib")
motifs = list()
for (name in motif_names) {
  fileName = paste(motif_folder,"/",name,".pwm",sep="")
  file = system.file(fileName, package = "DiffLogo")
  motifs[[name]] = getPwmFromPwmFile(file)
}

pwm1 = motifs[[motif_names[[1]]]]
pwm2 = motifs[[motif_names[[2]]]]

diffLogoFromPwm(pwm1 = pwm1, pwm2 = pwm2)
}
\author{
Martin Nettling
}
