% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffSeqLogo.R
\name{diffLogo}
\alias{diffLogo}
\title{Draw DiffLogo}
\usage{
diffLogo(diffLogoObj, ymin = 0, ymax = 0, sparse = FALSE,
  diffLogoConfiguration = list())
}
\arguments{
\item{diffLogoObj}{a DiffLogoObject created by the function createDiffLogoObject}

\item{ymin}{minimum value on the y-axis}

\item{ymax}{maximum value on the y-axis}

\item{sparse}{if TRUE margins are reduced and tickmarks are removed from the logo}

\item{diffLogoConfiguration}{list of configuration parameters (see function diffLogoTableConfiguration(...))}
}
\value{
none (draws difference logo)
}
\description{
Draws the difference of two sequence logos.
}
\examples{
motif_folder= "extdata/pwm"
motif_names = c("HepG2","MCF7","HUVEC","ProgFib")
motifs = list()
for (name in motif_names) {
  fileName = paste(motif_folder,"/",name,".pwm",sep="")
  file = system.file(fileName, package = "DiffLogo")
  motifs[[name]] = getPwmFromPwmFile(file)
}

pwm1 = motifs[[motif_names[[1]]]]
pwm2 = motifs[[motif_names[[2]]]]

diffLogoObj = createDiffLogoObject(pwm1 = pwm1, pwm2 = pwm2)
diffLogo(diffLogoObj)
}
\author{
Martin Nettling
}
