% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dViolins.R
\name{dViolins}
\alias{dViolins}
\title{Create violin plots for any variables of choise}
\usage{
dViolins(
  clusterVector,
  inDataFrame,
  plotClusters = unique(clusterVector),
  plotElements = "all",
  colorOrder = plotClusters,
  colorScale = "viridis",
  plotDir = "dViolin_result",
  createOutput = TRUE
)
}
\arguments{
\item{clusterVector}{Vector with the same length as inDataFrame containing
information about the cluster identity of each observation.}

\item{inDataFrame}{The data used to generate the depecheObject}

\item{plotClusters}{This vector of numbers define which cluster(s) to plot
the violins for. Defaults to all.}

\item{plotElements}{This provides information on which features to plot. In
the typical case, this is the essenceElementList from a depeche run. Other
input formats are however accepted: if a vector of column names is provided,
then these features will be plotted for all clusters. A custom list of
features specific for each cluster is also accepted. A final alternative is
to return "all" (default), in which case all markers will be plotted for all
clusters.If more than a 100 markers are provided, however, this will return
an error.}

\item{colorOrder}{The order of the cluster colors. Defaults to the order
that the unique values in clusterVector occurs.}

\item{colorScale}{The color scale. Options identical to dColorVector.}

\item{plotDir}{The name of the created directory.}

\item{createOutput}{For testing purposes. Defaults to TRUE. If FALSE, no
plots are generated.}
}
\value{
One graph is created for each cluster, containing a bean per
specified variable.
}
\description{
Here, assymetrical violin plots for each cluster vs all other clusters are
plotted for variables either retrieved from a depeche analysis or
user-defined.
}
\examples{
# Load some data
data(testData)

# Run the clustering function. For more rapid example execution,
# a depeche clustering of the data is inluded
# testDataDepeche <- depeche(testData[,2:15])
data(testDataDepeche)

# Create the plots of the variables that contribute to creating cluster 3

\dontrun{
dViolins(testDataDepeche$clusterVector,
    inDataFrame = testData,
    plotClusters = 3, plotElements = testDataDepeche$essenceElementList
)
}
}
\seealso{
\code{\link{dDensityPlot}}, \code{\link{dColorPlot}},
\code{\link{dColorVector}}, \code{\link{depeche}}
}
