% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomFArray-class.R
\docType{class}
\name{RandomFArray-class}
\alias{RandomFArray-class}
\alias{RandomFArraySeed-class}
\alias{RandomFMatrix-class}
\alias{sampleDistrParam,RandomFArraySeed-method}
\alias{sampleDistrFun,RandomFArraySeed-method}
\alias{matrixClass,RandomFArray-method}
\alias{extract_array,RandomFArraySeed-method}
\alias{RandomFArraySeed}
\alias{DelayedArray,RandomFArraySeed-method}
\alias{RandomFArray}
\title{DelayedArray of random F-distributed values}
\usage{
RandomFArraySeed(dim, df1, df2, ncp, chunkdim = NULL)

\S4method{DelayedArray}{RandomFArraySeed}(seed)

RandomFArray(dim, df1, df2, ncp, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{df1, df2, ncp}{Numeric vector used as the argument of the same name in \code{\link{qf}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.

If \code{ncp} is missing, a central F distribution is assumed.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomFArraySeed object.}
}
\value{
All constructors return an instance of a RandomFArray object,
containing random draws from a exponential distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of F-distributed values.
}
\examples{
X <- RandomFArraySeed(c(1e5, 1e5), df1=1, df2=10)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomFArraySeed(c(1e5, 1e5), df1=runif(1e5)*10, df2=10)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
ncp <- rsparsematrix(1e5, 1e5, density=0.00001)
ncp <- abs(DelayedArray(ncp)) + 1
X3 <- RandomFArraySeed(c(1e5, 1e5), df1=1, df2=10, ncp=ncp)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
