% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomBinomArray-class.R
\docType{class}
\name{RandomBinomArray-class}
\alias{RandomBinomArray-class}
\alias{RandomBinomArraySeed-class}
\alias{RandomBinomMatrix-class}
\alias{sampleDistrParam,RandomBinomArraySeed-method}
\alias{sampleDistrFun,RandomBinomArraySeed-method}
\alias{matrixClass,RandomBinomArray-method}
\alias{RandomBinomArraySeed}
\alias{DelayedArray,RandomBinomArraySeed-method}
\alias{RandomBinomArray}
\title{DelayedArray of random binomial values}
\usage{
RandomBinomArraySeed(dim, size, prob, chunkdim = NULL, sparse = FALSE)

\S4method{DelayedArray}{RandomBinomArraySeed}(seed)

RandomBinomArray(dim, size, prob, chunkdim = NULL, sparse = FALSE)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{size, prob}{Numeric vector used as the argument of the same name in \code{\link{qbinom}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{sparse}{Logical scalar indicating whether the sampled array should be treated as sparse.}

\item{seed}{A RandomBinomArraySeed object.}
}
\value{
All constructors return an instance of a RandomBinomArray object,
containing random draws from a binomial distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of binomial-distributed values.
}
\examples{
X <- RandomBinomArraySeed(c(1e5, 1e5), size=10, prob=0.5)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomBinomArraySeed(c(1e5, 1e5), size=10, 
    prob=runif(1e5, 0, 0.1), sparse=TRUE)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
size <- rsparsematrix(1e5, 1e5, density=0.00001)
size <- round(abs(DelayedArray(size)) * 10)
X3 <- RandomBinomArraySeed(c(1e5, 1e5), size=size, prob=0.5)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
