% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCrePlotFuns.R
\name{plotDegCreBinHeuristic}
\alias{plotDegCreBinHeuristic}
\title{Plot DegCre Bin Algorithm Statistics}
\usage{
plotDegCreBinHeuristic(degCreResList)
}
\arguments{
\item{degCreResList}{A list of DegCre results.}
}
\value{
Invisibly, the picked optimal bin size.
}
\description{
Plots the DegCre distance bin optimization statistic against different bin
sizes, highlighting the optimal bin size.
}
\details{
This function takes a DegCre results list and plots the bin heuristic
statistics against different bin sizes. It also highlights the optimal bin
size chosen based on the analysis.
The y-axis of the plot is the median KS statistic of all bins versus the
global CRE p-value distribution.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load example data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Plot distance bin median KS statistic curve.

plotDegCreBinHeuristic(degCreResList=degCreResListDexNR3C1)

}
\seealso{
\link{distBinHeuristic} for calculating the DEG-CRE bin heuristic.
}
\author{
Brian S. Roberts
}
