% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreCore.R
\name{calcBinomFDRperBin}
\alias{calcBinomFDRperBin}
\title{Calculate Binomial FDR per Distance Bin}
\usage{
calcBinomFDRperBin(allDistBinsStatsMat, chunkI, alphaVal)
}
\arguments{
\item{allDistBinsStatsMat}{A matrix containing statistics for all distance
bins.}

\item{chunkI}{An integer vector specifying the indices of the current
distance bin.}

\item{alphaVal}{Numeric from 0 to 1 of the DEG significance level.}
}
\value{
A numeric vector of FDR values for the specified distance bin.
}
\description{
Calculates the False Discovery Rate (FDR) for association probabilities
within a given distance bin using a binomial distribution approach.
}
\details{
Not exported. This function calculates the FDR for association probabilities
within a given distance bin. It uses a binomial distribution approach
(via \link[stats]{pbinom}) to estimate the FDR based on the number of
significant associations and the total number of associations in the bin.
Additionally, it adjusts FDR values for associations with low probabilities
or ties in the significance ranks.
It is meant to run within \link{runDegCre}. It will not run well on
unintended inputs.
}
\examples{
\dontrun{
# Get FDR from binomila distribtuion.
binomFDR <- calcBinomFDRperBin(allDistBinsStatsMat = myStatsMatrix,
chunkI = myChunkIndices, alphaVal = 0.05)
}

}
\author{
Brian S. Roberts
}
\keyword{internal}
