% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAssocProbOR.R
\name{calcAssocProbOR}
\alias{calcAssocProbOR}
\title{Calculate Odds-ratio}
\usage{
calcAssocProbOR(degCreResList, type = "adj")
}
\arguments{
\item{degCreResList}{List of DegCre results.}

\item{type}{A character of either \code{"raw"} or \code{"adj"}.
(Default:\code{"adj"}).}
}
\value{
A numeric of the association probability odds-ratios
}
\description{
Given a DegCre results list, this function calculates the odds-ratio of the 
association probability.
}
\details{
This function is similar to \link{calcRawAssocProbOR} and will mimic its 
function when \code{type = "raw"}. When \code{type = "raw"} the 
calculation operates on the \code{"rawAssocProb"} metadata.
When \code{type = "adj"} the calculation operates on the \code{"assocProb"} metadata. 
The OR is calculated relative to the distance bin null association
probability, which would happen if all CRE p-values were identical.
Thus it is a measure of the increase in association probability due to
CRE p-value information content over what would occur by random chance.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load test data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Calculate odds-ratio.

calcOR <- calcAssocProbOR(degCreResListDexNR3C1)

}
\author{
Brian S. Roberts
}
