% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeeDeeExperiment-internal-utils.R
\name{muscat_list_for_dde}
\alias{muscat_list_for_dde}
\title{Convert \code{muscat::pbDS()} results into a flat list of data frames compatible
with \code{DeeDeeExperiment}}
\usage{
muscat_list_for_dde(res, padj_col = c("p_adj.loc", "p_adj.glb"))
}
\arguments{
\item{res}{A list, typically the output of \code{muscat::pbDS()} function,
containing one or more contrasts}

\item{padj_col}{A character string specifying which adjusted p-value column
to extract. It can be either "p_adj.loc" or "p_adj.glb".}
}
\value{
A named list of data frames
}
\description{
This helper function extracts and flattens the nested structure returned
by \code{muscat::pbDS()}, returning one table per contrast–cluster combination.
Each resulting data frame will have standardized column names
(\code{log2FoldChange}, \code{pvalue}, \code{padj}).
}
\details{
The function is intended to simplify the integration of muscat  results into
a \code{DeeDeeExperiment} object. It automatically renames columns
(\code{logFC} to \code{log2FoldChange}, \code{p_val} to \code{pvalue}, and the selected adjusted
p-value column to \code{padj}) and annotates the resulting list with metadata
about the originating package.

The function checks that each contrast entry contains a valid \code{table}
component as expected from \code{pbDS()} output. Invalid or empty contrasts are
skipped with a warning message.
The names of the list elements in \code{res} must match contrast names found in
the \code{table} slot of each entry.
}
\examples{
data("muscat_pbDS_res", package = "DeeDeeExperiment")
new_muscat_list <- muscat_list_for_dde(list(`stim-ctrl` = muscat_res))
}
