% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeeDeeExperiment-methods.R
\name{DeeDeeExperiment-methods}
\alias{DeeDeeExperiment-methods}
\alias{getDEAInfo}
\alias{getDEAInfo<-}
\alias{getDEANames}
\alias{renameDEA}
\alias{addDEA}
\alias{removeDEA}
\alias{getDEA}
\alias{getDEAList}
\alias{addScenarioInfo}
\alias{getFEAInfo}
\alias{getFEAInfo<-}
\alias{getFEANames}
\alias{renameFEA}
\alias{addFEA}
\alias{removeFEA}
\alias{getFEA}
\alias{getFEAList}
\alias{linkDEAandFEA}
\alias{getDEAInfo,DeeDeeExperiment-method}
\alias{getDEAInfo<-,DeeDeeExperiment-method}
\alias{getDEANames,DeeDeeExperiment-method}
\alias{renameDEA,DeeDeeExperiment-method}
\alias{addDEA,DeeDeeExperiment-method}
\alias{removeDEA,DeeDeeExperiment-method}
\alias{getDEA,DeeDeeExperiment-method}
\alias{getDEAList,DeeDeeExperiment-method}
\alias{addScenarioInfo,DeeDeeExperiment-method}
\alias{getFEAInfo,DeeDeeExperiment-method}
\alias{getFEAInfo<-,DeeDeeExperiment-method}
\alias{getFEANames,DeeDeeExperiment-method}
\alias{renameFEA,DeeDeeExperiment-method}
\alias{addFEA,DeeDeeExperiment-method}
\alias{removeFEA,DeeDeeExperiment-method}
\alias{getFEA,DeeDeeExperiment-method}
\alias{getFEAList,DeeDeeExperiment-method}
\alias{linkDEAandFEA,DeeDeeExperiment-method}
\title{Methods for \link{DeeDeeExperiment} objects}
\usage{
\S4method{getDEAInfo}{DeeDeeExperiment}(x)

\S4method{getDEAInfo}{DeeDeeExperiment}(x) <- value

\S4method{getDEANames}{DeeDeeExperiment}(x)

\S4method{renameDEA}{DeeDeeExperiment}(x, old_name, new_name)

\S4method{addDEA}{DeeDeeExperiment}(x, dea, force = FALSE)

\S4method{removeDEA}{DeeDeeExperiment}(x, dea_name, remove_linked_fea = FALSE)

\S4method{getDEA}{DeeDeeExperiment}(
  x,
  dea_name = NULL,
  format = c("minimal", "original"),
  extra_rd = NULL,
  type = c("DFrame", "data.frame"),
  verbose = FALSE
)

\S4method{getDEAList}{DeeDeeExperiment}(x, format = c("minimal", "original"), verbose = FALSE)

\S4method{addScenarioInfo}{DeeDeeExperiment}(x, dea_name, info = NULL, force = FALSE)

\S4method{getFEAInfo}{DeeDeeExperiment}(x)

\S4method{getFEAInfo}{DeeDeeExperiment}(x) <- value

\S4method{getFEANames}{DeeDeeExperiment}(x)

\S4method{renameFEA}{DeeDeeExperiment}(x, old_name, new_name)

\S4method{addFEA}{DeeDeeExperiment}(
  x,
  fea,
  de_name = NA_character_,
  fe_name = NULL,
  fea_tool = "auto",
  force = FALSE,
  verbose = FALSE
)

\S4method{removeFEA}{DeeDeeExperiment}(x, fea_name)

\S4method{getFEA}{DeeDeeExperiment}(x, fea_name = NULL, format = c("minimal", "original"), verbose = FALSE)

\S4method{getFEAList}{DeeDeeExperiment}(
  x,
  dea_name = NULL,
  format = c("minimal", "original"),
  verbose = FALSE
)

\S4method{linkDEAandFEA}{DeeDeeExperiment}(x, dea_name, fea_name, force = FALSE)
}
\arguments{
\item{x}{A \code{\link[=DeeDeeExperiment]{DeeDeeExperiment()}} object}

\item{value}{Replacement value for replacement methods.}

\item{old_name}{A character vector of existing DEA names to be renamed in a
\code{DeeDeeExperiment} object}

\item{new_name}{A character vector with new names to assign to existing DEA
names in a \code{DeeDeeExperiment} object. It must be the same length of
\code{old_name}, and contains unique values that don't overlap with existing DEA
names.}

\item{dea}{A named list of DE results, in any of the formats supported by
the package (currently: results from DESeq2, edgeR, limma).}

\item{force}{A logical, indicating whether to overwrite results when
introducing the same results name. It defaults to FALSE.}

\item{dea_name}{Character value, specifying the name of the DE analysis to
get or remove, or match against (e.g., to fetch associated FEA results), or
to which additional context and information can be attached}

\item{remove_linked_fea}{A logical, specifying whether to remove or not the
linked FEA when a DEA results is removed}

\item{format}{A character string, specifying the DEA/FEAs output format.
It takes either "minimal" to return only essential columns
(e.g. log2FC, p-value, adjusted p-value for DEAs,
or gs_id, gs_description, gs_pvalue, gs_genes... for FEAs), or "original" to
return the full result object. It defaults to "minimal"}

\item{extra_rd}{A character vector of additional columns from rowData(x)
to include. It defaults to c("gene_id", "SYMBOL").}

\item{type}{A character string referring to the type of object returned by
\code{getDEA()}. It defaults to \code{DFrame}, but can also take the value of \code{data.frame}}

\item{verbose}{Logical, whether or not to display warnings. If TRUE,
warnings/messages will be displayed. If FALSE, the function runs silently}

\item{info}{A character vector, containing contextual information about the
specified DE analysis. It defaults to NULL}

\item{fea}{A named list of Functional Enrichment results. Each element can be
either a data.frame (currently supports results from \code{topGO}, \code{enrichR},
\code{gProfiler}, \code{fgsea}, \code{gsea}, \code{DAVID}, and output of \code{GeneTonic} shakers),
or an \code{enrichResult}/\code{gseaResult} objects (currently supports
\code{clusterProfiler})}

\item{de_name}{A character string to explicitly specify the name of the de
result this fea should be linked to. If not provided, the function will
attempt to match fea names to de results automatically.}

\item{fe_name}{A character string giving a name to the FE results.}

\item{fea_tool}{A character string indicating the FEA tool used. It can take
any of the following values : "topGO", "clusterProfiler", "GeneTonic",
"DAVID", "gsea", "fgsea", "enrichr", "gProfiler". When not specified, it
defaults to "auto" and the tool is inferred automatically based on the input.}

\item{fea_name}{Character value, specifying the name of the functional
enrichment result to add or remove}
}
\value{
Return value varies depending on the individual methods, as described
below.
}
\description{
The \code{\link[=DeeDeeExperiment]{DeeDeeExperiment()}} class provides a family of methods to get
and set DE-related information and functional enrichment results in
\link{DeeDeeExperiment} objects.
}
\details{
DEAs
\itemize{
\item \code{getDEAInfo} and \verb{getDEAInfo<-} are the methods to get and set the \code{dea}
information as a whole. These methods return \code{DeeDeeExperiment} objects.
\item \code{getDEANames} returns the names of the available DE contrasts in
\code{DeeDeeExperiment} objects.
\item \code{renameDEA} is the method to rename one or multiple DEAs stored in a
\code{DeeDeeExperiment} object.
\item \code{addDEA} and \code{removeDEA} are used to respectively add or remove
DE-results items. These methods also return \code{DeeDeeExperiment} objects, with
updated content in the \code{dea} slot.
\item \code{getDEA} and \code{getDEAList} retrieve the DEA information, as well as some
extra rowData information and provide this as a \code{DataFrame} object
(for a specific analysis) or as a list, with one element for each reported
analysis.
\item \code{addScenarioInfo} is the method to add user defined contextual
information for a specific DE analysis.
It allows users to attach free-text notes to a specific DEA results that
stored in a \code{DeeDeeExperiment} object. This information can include any other
relevant information to help document that DEA scenario.
This context is stored in the \code{dea} slot under the name \code{addScenarioInfo},
which is not a default element in \code{dea}.
}

FEAs
\itemize{
\item \code{getFEAInfo} and \verb{getFEAInfo<-} are the methods to get and set the \code{fea}
information as a whole. These methods return \code{DeeDeeExperiment} objects.
\item \code{getFEANames} returns the names of the available enrichment results in
\code{DeeDeeExperiment} objects.
\item \code{renameFEA} is the method to rename one or multiple FEAs stored in a
\code{DeeDeeExperiment} object.
\item \code{addFEA} and \code{removeFEA} are used to respectively add or remove
functional enrichment results items. These methods also return
\code{DeeDeeExperiment} objects, with updated content in the \code{fea} slot.
\item \code{getFEA} is the method to retrieve FE results stored in a \code{DeeDeeExperiment}
object for a specific contrast, as a standardized format similar to the
output of \code{GeneTonic} shakers.
\item \code{getFEAList} is the method that retrieves FEA results as a list. if the
\code{dea_name} is indicated, the method will return only FEAs linked to that
\code{dea_name}, otherwise it returns all FEAs in the \code{fea} slot.
\item \code{linkDEAandFEA} is the method that allows the user to manually link a
FEA result to a specific DEA result.
\item \code{show} is the method to nicely print out the information of a
\code{DeeDeeExperiment} object.
\item \code{summary} is the method to print a summary of the available DE and FE
results in a \code{DeeDeeExperiment} object.
}
}
\examples{
data("de_named_list", package = "DeeDeeExperiment")
data("topGO_results_list", package = "DeeDeeExperiment")
library("SummarizedExperiment")

rd_macrophage <- DataFrame(
  gene_id = rownames(de_named_list$ifng_vs_naive)
)
rownames(rd_macrophage) <- rownames(de_named_list$ifng_vs_naive)
se_macrophage_noassays <- SummarizedExperiment(
  assays = SimpleList(),
  rowData = rd_macrophage
)

# creating a `DeeDeeExperiment`
dde <- DeeDeeExperiment(
  se_macrophage_noassays,
  de_results = de_named_list
)
dde

new_del <- list(
  ifng2 = de_named_list$ifng_vs_naive,
  ifngsalmo2 = de_named_list$ifngsalmo_vs_naive
)

# add a new (set of) DE result(s)
dde_new <- addDEA(dde, new_del)
dde_new

# removing DEAs
dde_removed <- removeDEA(dde, "ifng_vs_naive")
dde_removed

# add a new (set of) FE result(s)
dde_new <- addFEA(dde, fea = topGO_results_list)

# removing FEAs
dde_rem <- removeFEA(dde_new, "ifng_vs_naive")

# display available DEAs
getDEANames(dde)

# display available FEAs
getFEANames(dde)

# print a summary of the available DEAs and FEAs
summary(dde, FDR = 0.01)

# rename DEA
dde_new <- renameDEA(dde_new,
  old_name = "salmonella_vs_naive",
  new_name = "Salmo_vs_Naive_renamed"
)

# assign DEA to FEA

dde_new <- linkDEAandFEA(dde_new,
  dea_name = "ifngsalmo_vs_naive",
  fea_name = "ifngsalmo_vs_naive"
)

}
