% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{DaMiR.sampleFilt}
\alias{DaMiR.sampleFilt}
\title{Filter Samples by Mean Correlation Distance Metric}
\usage{
DaMiR.sampleFilt(data, th.corr = 0.9, type = c("spearman", "pearson"))
}
\arguments{
\item{data}{A SummarizedExpression object}

\item{th.corr}{Threshold of mean correlation; default is 0.9}

\item{type}{Type of correlation metric; default is "spearman"}
}
\value{
A \code{SummarizedExperiment} object which contains a normalized
 and filtered
expression matrix (log2 scale) and a filtered data frame with 'class'
and (optionally) variables.
}
\description{
This function implements a sample-per-sample correlation.
 Samples with a mean
correlation lower than a user's defined threshold will be filtered out.
}
\details{
This step introduces a sample quality checkpoint. Global gene
 expression should,
in fact, exhibit a high correlation among biological replicates;
conversely, low correlated
samples may be suspected to bear some technical artifact (e.g. poor RNA
 or library
preparation quality), despite they may have passed sequencing quality
 checks. If not assessed,
these samples may, thus, negatively affect all the downstream analysis.
 This function looks at
the mean absolute correlation of each sample and removes those samples
with a mean correlation
lower than the value set in \code{th.corr} argument. This threshold may
 be specific for
different experimental setting but should be as high as possible.
For sequencing data we
suggest to set \code{th.corr} greater than 0.85.
}
\examples{
# use example data:
data(data_norm)
# filter out samples with Pearson's correlation <0.92:
data_filt<- DaMiR.sampleFilt(data_norm, th.corr=0.92, type ="pearson")

}
\author{
Mattia Chiesa, Luca Piacentini
}
