% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization_TestSet.R
\name{DaMiR.iTSadjust}
\alias{DaMiR.iTSadjust}
\title{Batch correction of normalized Independent Test Set}
\usage{
DaMiR.iTSadjust(adj_Learning_set, norm_Ind_Test_set, iTS_batch)
}
\arguments{
\item{adj_Learning_set}{A SummarizedExperiment object or a
data frame/matrix of adjusted and normalized data, obtained by
the \link{DaMiR.SVadjust} function.}

\item{norm_Ind_Test_set}{A data frame or a matrix of normalized data.
The independent test set is supposed to be already normlaized by
the \link{DaMiR.iTSnorm} function}

\item{iTS_batch}{(Optional). A factor or a data.frame, containing
information regarding experimental batches of the independent test set.
Users can ignore this argument, if the independent test set is deemed
a single experimental batch.}
}
\value{
A matrix containing a normalized and adjusted expression matrix
 (log2 scale).
}
\description{
This function aims to perform a batch correction on
a normalized independent test set, exploiting the \link{ComBat}
function of the sva package.
}
\details{
The function applied a batch correction procedure to the independent test
set, normalized by \link{DaMiR.iTSnorm}.
}
\examples{
# use example data:
data(SE)

}
\references{
Jeffrey T. Leek, W. Evan Johnson, Hilary S. Parker, Elana J.
Fertig, Andrew E. Jaffe and John D. Storey (2016).
sva: Surrogate Variable Analysis. R package version 3.22.0.
}
\seealso{
\code{\link{ComBat}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
