% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enricher_internal.R
\name{enricher_internal}
\alias{enricher_internal}
\title{enrich.internal}
\usage{
enricher_internal(
  gene,
  pvalueCutoff,
  pAdjustMethod = "BH",
  universe = NULL,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  USER_DATA
)
}
\arguments{
\item{gene}{a vector of entrez gene id.}

\item{pvalueCutoff}{Cutoff value of pvalue.}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes, default is the intersection of the 'universe' with genes that have annotations. 
Users can set `options(enrichment_force_universe = TRUE)` to force the 'universe' untouched.}

\item{minGSSize}{minimal size of genes annotated by Ontology term for testing.}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{qvalueCutoff}{cutoff of qvalue}

\item{USER_DATA}{ontology information}
}
\value{
A \code{enrichResult} instance.
}
\description{
interal method for enrichment analysis
}
\details{
using the hypergeometric model
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
\keyword{manip}
