% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{projectName}
\alias{projectName}
\alias{projectName,DNEA-method}
\title{Return the name of the current experiment}
\usage{
projectName(x)

\S4method{projectName}{DNEA}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}
}
\value{
The name of the DNEA experiment.
}
\description{
This function returns the name of the DNEA experiment.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

projectName(dnw)
}
\seealso{
\code{\link{createDNEAobject}}
}
\author{
Christopher Patsalis
}
