% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-exported.R
\name{plotNetworks}
\alias{plotNetworks}
\title{Visualize the biological networks}
\usage{
plotNetworks(
  object,
  type = c("group_networks", "sub_networks"),
  subtype = "All",
  layout_func,
  main = "",
  node_size = 15,
  edge_width = 1,
  label_size = 1,
  label_font = 1
)
}
\arguments{
\item{object}{A \code{\link[=DNEA-class]{DNEA}} object.}

\item{type}{There are two possible arguments to \strong{type}:
\emph{"group_networks"} specifies the whole network or condition networks.
\emph{"sub_networks"} specifies that one of the sub networks should
be plotted.
\emph{Additional input via the \strong{subtype} parameter is required.}}

\item{subtype}{There are several possible arguments to \strong{subtype}.
If \emph{type == "group_networks"}, \strong{subtype} can be \emph{"All"}
to plot the whole network (ie. both conditions in the data returned by
\code{\link{networkGroups}}), or one of the condition network names to
plot the network corresponding to that condition. If
\emph{type == "sub_networks"}, \strong{subtype} should be a single-value
numeric vector corresponding to the sub network to plot.}

\item{layout_func}{The layout in which to plot the specified network.
Please see \code{\link[igraph]{plot.igraph}} for more information.}

\item{main}{A character string to use as the plot title.}

\item{node_size}{The size of the nodes in the plot. The default is 15.
Please see \emph{vertex.size} parameter in
\code{\link[igraph]{tkplot}} for more details.}

\item{edge_width}{The width of the edges in the plot. The default is 1.
Please see \emph{width} parameter in
\code{\link[igraph]{tkplot}} for more details.}

\item{label_size}{The size of the node labels in the plot.
The default is 1. Please see \emph{label.size} in
\code{\link[igraph]{tkplot}} for more details.}

\item{label_font}{Specifies the font type to use in the plot.
1 is normal font, 2 is bold-type, 3 is italic-type, 4 is bold- and
italic-type. Please see the \emph{label.font} parameter in
\code{\link[igraph]{plot.igraph}} for more details.}
}
\value{
A plot of the specified network
}
\description{
This function plots the total network, condition networks, or
sub networks as specified by the user. Purple nodes are differential
features, green indicates edges specific to group 1, and red indicates
edges specific to group 2.
}
\examples{
#dnw is a \code{\link[=DNEA-class]{DNEA}} object with the results
#generated for the example data accessed by running
#data(TEDDY) in the console. The workflow for this data
#can be found in the vignette accessed by running
#browseVignettes("DNEA") in the console.
data(dnw)

#plot the networks
plotNetworks(object=dnw, type="group_networks", subtype="All")
plotNetworks(object=dnw, type="sub_networks", subtype=1)

}
\seealso{
\code{\link{getNetworks}},\code{\link{clusterNet}},
\code{\link{networkGroups}}
}
\author{
Christopher Patsalis
}
