% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-exported.R
\name{addExpressionData}
\alias{addExpressionData}
\title{Include custom normalized data in the DNEA object}
\usage{
addExpressionData(object, dat, assay_name)
}
\arguments{
\item{object}{A \code{\link[=DNEA-class]{DNEA}} object.}

\item{dat}{A list of \emph{m x n} numeric matrices of
custom-normalized expression data, one matrix for each
experimental condition. The list elements should be
labeled for their respective condition. These should
match the labels returned by
\code{\link{networkGroups}}.}

\item{assay_name}{A character string corresponding
to the name the new data will be stored under in the
assays slot of the \code{\link[=DNEA-class]{DNEA}}.}
}
\value{
A \code{\link[=DNEA-class]{DNEA}} object with the added
expression data in the @assays slot
}
\description{
This function allows the user to input custom-normalized data into the
\code{\link[=DNEA-class]{DNEA}} object for use in DNEA analysis.
}
\examples{
#load example data
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                        group_labels = group_labels)

#transpose TEDDY data
TEDDY <- t(log(TEDDY))

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[rownames(TEDDY),]

dat <- list()
for(cond in networkGroups(dnw)){
  dat[[cond]] <- TEDDY[names(group_labels)[group_labels == cond],]
}


#log-transform and median center the expression data without scaling
newdat <- list()
for(cond in networkGroups(dnw)){

  group_dat <- dat[[cond]]
  for(i in seq(1, ncol(group_dat))){
   metab_median=median(group_dat[, i], na.rm=TRUE)
    metab_range=range(group_dat[, i], na.rm=TRUE)
    scale_factor=max(abs(metab_range - metab_median))
    group_dat[, i] <- (group_dat[, i] - metab_median) / scale_factor

    rm(metab_median, metab_range, scale_factor)
  }

  group_dat <- t(group_dat)
  newdat <- append(newdat, list(group_dat))

  rm(i, group_dat)
}

#add names
names(newdat) <- names(dat)

#add data
dnw <- addExpressionData(object=dnw,
                         dat=newdat,
                         assay_name="median_scaled_data")

}
\seealso{
\code{\link{createDNEAobject}},\code{\link[=DNEA-class]{DNEA}},
}
\author{
Christopher Patsalis
}
