% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start-here.R
\docType{package}
\name{DNEA-package}
\alias{DNEA}
\alias{DNEA-package}
\title{DNEA: Differential Network Enrichment Analysis for Biological Data}
\description{
The DNEA R package is the latest implementation of the Differential Network Enrichment Analysis algorithm and is the successor to the Filigree Java-application described in Iyer et al. (2020). The package is designed to take as input an m x n expression matrix for some -omics modality (ie. metabolomics, lipidomics, proteomics, etc.) and jointly estimate the biological network associations of each condition using the DNEA algorithm described in Ma et al. (2019). This approach provides a framework for data-driven enrichment analysis across two experimental conditions that utilizes the underlying correlation structure of the data to determine feature-feature interactions.
}
\section{Primary Components}{


The main workflow contains the following functions:
\enumerate{
\item \strong{\code{\link{createDNEAobject}}}
\item \strong{\code{\link{BICtune}}}
\item \strong{\code{\link{stabilitySelection}}}
\item \strong{\code{\link{getNetworks}}}
\item \strong{\code{\link{clusterNet}}}
\item \strong{\code{\link{runNetGSA}}}}

A more descriptive workflow can be viewed in the package vignette.
This can be accessed by running \code{vignette("DNEA")} in the console.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Karnovsky-Lab/DNEA}
  \item Report bugs at \url{https://github.com/Karnovsky-Lab/DNEA/issues}
}

}
\author{
\strong{Maintainer}: Christopher Patsalis \email{chrispatsalis@gmail.com} (\href{https://orcid.org/0009-0003-4585-0017}{ORCID})

Authors:
\itemize{
  \item Gayatri Iyer \email{griyer@umich.edu}
}

Other contributors:
\itemize{
  \item Alla Karnovsky \email{akarnovs@med.umich.edu} (1U01CA235487) [funder]
  \item George Michailidis \email{gmichail@ufl.edu} (1U01CA235487) [funder]
}

}
