#include "TableCompiler.h"
#include <Rcpp.h>

using namespace Rcpp;

//QueryTable content
const unsigned int sizeQueryTable = 987;
const std::string QueryTable[] ={
  "AAAAA 3.38 0.99 21 12.27 0.45 19 -16.51 3.39 23 -0.97 0.15 23 -0.99 0.14 23 -5.05 2.87 23 -5.09 2.8 23 37.74 1.08 23 38.01 0.92 23 -10.1 1.12 13 4.97 0.03 -0.72 -1.22 7.8 3.42 -5.05 -5.09 0.18 -3.71 3.25 3.25 -0.2 -0.08 -0.22 -16.51 4.62 -0.97 -0.99 37.74 38.01 12.25 9.63 -0.1 -0.1 -11.39 -1.96 -1.96 -0.46 27.67 3.21 3.21 -0.17 36.32 36.32 0.04 0.04 -0.74 -0.74 -0.09 4.24 -14.99 -0.79 -0.79 3.57 0.56 0.56 0.11 2.96 3.31 3.31 0.01 33.46 33.46 -0.11 -0.11 -0.64 -0.64 -0.02 5.04",
  "AAAAC 4.05 0.72 17 12.27 0.28 9 -14.47 1.03 22 -1.01 0.07 22 -1.1 0.06 21 -3.62 2.22 22 -4.8 2.4 21 37.13 0.75 22 36.95 0.63 21 -8.97 0.33 16 4.79 -0.01 -1.19 -1.62 9.07 4.11 -3.62 -4.78 0.15 -1.9 3.21 3.19 -0.11 0.13 -0.06 -14.47 4.87 -1.01 -1.11 37.13 36.92 12.56 -1.25 -0.1 -0.25 -5.16 -1.96 -1.5 -0.225 16.235 3.21 3.26 -0.04 36.32 35.33 0.04 0.01 -0.74 -0.96 -0.055 4.56 -16.49 -0.79 -2.78 5.74 0.56 0.74 0.115 2.935 3.31 3.35 0.01 33.46 36.19 -0.11 -0.2 -0.64 -0.42 -0.02 5.13",
  "AAAAG 3.68 0.6 66 12.66 0.38 56 -14.68 2.41 69 -1.05 0.1 69 -1.23 0.1 67 -4.23 1.61 69 -6.47 2.29 67 37.02 0.8 69 37.18 0.71 67 -10.39 1.2 50 4.76 0.01 -1.1 -1.85 7.39 3.85 -4.23 -6.38 0.17 -2.3 3.23 3.24 -0.11 0.2 -0.13 -14.68 4.81 -1.05 -1.23 37.02 37.17 12.81 10.085 -0.1 0.69 0.915 -1.96 -2.47 -0.395 24.145 3.21 3.2 -0.19 36.32 36.5 0.04 -0.02 -0.74 -0.75 -0.005 4.28 -14.995 -0.79 -2.37 4.96 0.56 1.3 0.115 3.11 3.31 3.25 0.015 33.46 34.29 -0.11 -0.14 -0.64 -0.44 -0.01 5.39",
  "AAAAT 3.63 0.52 39 12.54 0.26 34 -14.89 1.46 53 -1.08 0.07 53 -1.22 0.09 53 -3.56 1.71 53 -5.12 2.38 53 36.93 0.54 53 37.68 0.59 53 -10.8 0.98 54 4.82 -0.01 -1.08 -1.48 7.97 3.74 -3.56 -5.12 0.17 -2.05 3.24 3.31 -0.05 0.11 -0.1 -14.89 5.1 -1.08 -1.22 36.93 37.68 12.58 1.285 -0.1 -0.48 -5.045 -1.96 -1.06 -0.24 17.555 3.21 3.27 -0.095 36.32 35.41 0.04 0.04 -0.74 -0.79 -0.045 4.095 -16.31 -0.79 -2.93 4.195 0.56 0.15 0.12 3.065 3.31 3.34 0.015 33.46 35.57 -0.11 -0.14 -0.64 -0.6 -0.01 5.035",
  "AAACA 4.65 0.62 27 12.34 0.28 26 -13.05 0.56 27 -1.06 0.03 27 -1.54 0.02 27 -2.98 2.5 27 -2.89 1.4 27 36.59 0.69 27 35.22 0.6 27 -8.05 0.42 22 4.54 -0.01 -1.93 0.01 11.53 4.67 -2.98 -2.89 0.15 -1.3 3.14 3.42 0 0.5 0.13 -13.05 6.08 -1.06 -1.54 36.59 35.22 12.42 -10.935 -0.25 0.69 0.975 -1.5 0.7 0.015 4.485 3.26 3.3 0.08 35.33 31.62 0.01 -0.07 -0.96 -1.15 -0.05 5.35 -13.14 -2.78 -0.15 2.625 0.74 -1.3 0.075 2.39 3.35 3.39 0.03 36.19 32.99 -0.2 -0.45 -0.42 -0.69 0.03 5.94",
  "AAACC 4.06 0.27 22 13.12 0.17 8 -12.41 0.58 77 -1.13 0.03 75 -1.61 0.05 26 -3.75 0.88 75 -4.65 1.47 26 36.34 0.49 75 36.2 0.55 26 -9.12 0.45 62 4.55 0 -1.53 0.09 12.05 4.34 -3.7 -4.35 0.16 -0.58 3.17 3.51 0.1 0.48 0.09 -12.41 3.85 -1.13 -1.63 36.35 36.11 13.35 -3.02 -0.25 -0.74 -3.565 -1.5 0.02 -0.165 17.81 3.26 3.23 0.15 35.33 31.1 0.01 -0.01 -0.96 -1.28 -0.115 5.555 -16.755 -2.78 0.68 2.325 0.74 -0.47 0.06 2.12 3.35 3.45 0.02 36.19 33.37 -0.2 -0.13 -0.42 -0.8 0.005 5.16",
  "AAACG 4.43 0.16 21 12.33 0.22 20 -13.15 0.36 26 -1.07 0.03 26 -1.53 0.03 24 -2.94 0.56 26 -3.27 0.58 24 36.57 0.36 26 35.48 0.27 24 -8.27 0.18 22 4.53 -0.01 -1.75 0.42 12.34 4.51 -2.94 -3.3 0.15 -0.89 3.15 3.43 0.02 0.49 0.12 -13.15 5.76 -1.07 -1.53 36.57 35.51 12.59 -10.89 -0.25 -0.8 1.55 -1.5 1.38 0.055 4.615 3.26 3.32 0.08 35.33 32.17 0.01 -0.19 -0.96 -1.04 -0.085 5.315 -12.795 -2.78 0.24 4.275 0.74 -0.87 0.08 2.31 3.35 3.43 0.03 36.19 32.81 -0.2 -0.39 -0.42 -0.66 0.07 6.105",
  "AAACT 3.85 0.1 4 13.09 0.46 3 -12.78 1.88 4 -1.18 0.02 4 -1.73 0.01 4 -4.3 0.88 4 -5.49 0.59 4 35.86 0.46 4 36.86 0.5 4 -9.29 0.14 2 4.63 0 -1.69 -1.02 11.67 3.89 -4.3 -5.49 0.17 -0.79 3.17 3.59 0.1 0.46 0.11 -12.78 5.29 -1.18 -1.73 35.86 36.86 13.17 -8.795 -0.25 0.46 2.445 -1.5 -0.13 0.045 0.92 3.26 3.34 0.085 35.33 32.04 0.01 0.02 -0.96 -1.36 -0.03 4.905 -16.785 -2.78 1.16 4.05 0.74 -1.05 0.07 2.16 3.35 3.49 0.02 36.19 33.51 -0.2 -0.1 -0.42 -0.88 0.11 5.01",
  "AAAGA 4.02 0.41 7 13.18 0.36 7 -10.71 1.04 7 -1.21 0.06 7 -1.76 0.06 7 -4.76 1.11 7 -3.21 1.7 7 36.69 0.73 7 33.18 0.41 7 -8.79 0.37 5 4.65 0 -2.01 -1.69 9.14 4 -4.76 -3.21 0.14 -0.96 3.19 3.53 0.11 0.32 0.1 -10.71 5.34 -1.21 -1.76 36.69 33.18 13.37 10.365 0.69 -0.18 10.185 -2.47 1.41 -0.205 17.65 3.2 3.55 -0.09 36.5 33.81 -0.02 0.02 -0.75 -1.23 0.005 5.065 -15.11 -2.37 -1.04 7.08 1.3 4.57 0.11 3.38 3.25 3.39 0.015 34.29 31.3 -0.14 -0.09 -0.44 -0.75 0.085 5.835",
  "AAAGC 4.03 0.5 43 13.37 0.31 32 -10.58 1.61 59 -1.24 0.07 47 -1.79 0.09 59 -5.07 1.91 47 -3.95 1.8 59 36.56 0.74 47 32.81 0.64 59 -8.76 0.96 44 4.58 0 -1.93 -1.93 8.27 4.02 -4.67 -3.95 0.13 -0.74 3.25 3.47 0.15 0.34 0.08 -10.58 4.28 -1.24 -1.79 36.74 32.81 13.55 20.375 0.69 -0.63 9.005 -2.47 3.27 -0.46 33.035 3.2 3.5 -0.34 36.5 36.01 -0.02 -0.08 -0.75 -0.95 0.03 5.61 -18.38 -2.37 -3.04 8.405 1.3 4.55 0.11 3.27 3.25 3.54 0.015 34.29 35.23 -0.14 -0.25 -0.44 -0.78 0.11 5.465",
  "AAAGG 4.05 0.3 13 13.52 0.35 9 -9.21 0.73 13 -1.25 0.05 13 -1.87 0.04 13 -4.8 1.08 13 -5.06 2 13 35.88 0.37 13 32.79 0.39 13 -8.81 0.55 11 4.56 0.01 -1.98 -2.06 9.94 3.99 -4.8 -5.06 0.13 -0.41 3.16 3.5 0.14 0.44 0.12 -9.21 5.36 -1.25 -1.87 35.88 32.79 13.81 1.77 0.69 0.27 6.8 -2.47 2.63 -0.18 14.105 3.2 3.38 -0.08 36.5 34.14 -0.02 -0.06 -0.75 -0.76 0.045 5.295 -14.39 -2.37 -1.95 6.725 1.3 3.9 0.11 3.255 3.25 3.33 0.015 34.29 32.22 -0.14 -0.18 -0.44 -0.78 0.08 6.125",
  "AAAGT 3.35 0.59 61 13.43 0.39 50 -11.68 1.76 73 -1.24 0.09 61 -1.83 0.12 73 -6.36 2.09 61 -4.78 2.43 73 36.93 0.78 61 33.88 0.72 73 -11.84 3.12 43 4.74 0.02 -1.77 -1.81 8.75 3.41 -5.89 -4.78 0.16 -0.58 3.25 3.62 0.24 0.36 0.07 -11.68 4.5 -1.24 -1.83 37.03 33.88 13.53 1.78 0.69 0 6.535 -2.47 2.19 -0.16 8.73 3.2 3.61 -0.1 36.5 37.83 -0.02 0.02 -0.75 -1.1 0.03 4.44 -17.38 -2.37 -2.53 7.4 1.3 3.43 0.105 3.5 3.25 3.56 0.015 34.29 34.93 -0.14 -0.24 -0.44 -0.92 0.12 5.45",
  "AAATA 3.79 0.74 10 12.73 0.41 9 -12.63 1.67 10 -1.2 0.09 10 -1.52 0.13 10 -3.91 1.78 10 -6.42 2.88 10 37.22 0.83 10 33.85 1.08 10 -8.51 0.25 6 4.7 -0.01 -1.72 0.41 4.93 3.98 -3.91 -6.42 0.15 -1.42 3.28 3.33 -0.03 0.16 -0.01 -12.63 5.74 -1.2 -1.52 37.22 33.85 12.83 -5.955 -0.48 0.34 -1.72 -1.06 -1.57 0.025 3.36 3.27 3.21 -0.005 35.41 32.19 0.04 0.01 -0.79 -0.96 -0.045 4.06 -16.44 -2.93 0.48 3.13 0.15 -1.72 0.125 2.895 3.34 3.25 0.02 35.57 31.21 -0.14 0.25 -0.6 -0.84 0.105 4.995",
  "AAATC 4.12 0.44 508 13.22 0.33 451 -12.27 0.7 510 -1.22 0.05 508 -1.55 0.05 510 -2.43 1.43 508 -5.36 1.53 510 36.55 0.54 508 33.42 0.55 510 -8.76 0.5 398 4.6 -0.02 -1.69 0.9 5.31 4.23 -2.43 -5.36 0.16 -1.32 3.27 3.33 0 0.23 -0.03 -12.27 5.82 -1.22 -1.55 36.55 33.42 13.26 -9.45 -0.48 0.3 0.59 -1.06 0.14 0 6.04 3.27 3.21 0.02 35.41 32.14 0.04 -0.07 -0.79 -1.15 -0.04 4.14 -17.905 -2.93 -0.16 2.685 0.15 -1.55 0.14 2.49 3.34 3.39 0.03 35.57 32.02 -0.14 -0.06 -0.6 -0.83 0.03 4.99",
  "AAATG 3.84 0.46 236 12.99 0.39 189 -11.76 0.94 252 -1.22 0.06 252 -1.56 0.07 252 -4.21 1.98 252 -7 1.67 252 36.86 0.63 252 33.42 0.57 252 -9.42 0.68 191 4.67 -0.01 -1.65 0.96 6.47 3.92 -4.21 -7 0.16 -1.02 3.25 3.34 0.03 0.27 0 -11.76 5.57 -1.22 -1.56 36.86 33.42 13.12 -7.245 -0.48 2.52 -1.54 -1.06 -0.35 -0.02 5.395 3.27 3.29 -0.05 35.41 28.07 0.04 -0.05 -0.79 -1.2 0.01 4.61 -16.62 -2.93 1.09 2.215 0.15 -1.22 0.12 2.77 3.34 3.28 0.02 35.57 31.23 -0.14 0.16 -0.6 -0.79 0.065 5.23",
  "AAATT 2.85 0.59 37 12.95 0.32 21 -14.95 1.88 76 -1.29 0.06 50 -1.64 0.06 76 -5 1.52 50 -8.57 1.23 76 37.52 0.54 50 35.11 0.67 76 -13.59 3.45 56 5 -0.01 -1.02 0.03 3.92 2.55 -4.54 -8.57 0.18 -0.67 3.44 3.48 0.16 0 -0.1 -14.95 3.85 -1.29 -1.64 38.12 35.11 13.25 -5.04 -0.48 -0.06 2.01 -1.06 -0.28 -0.02 11.06 3.27 3.24 -0.02 35.41 31.47 0.04 0 -0.79 -1.12 -0.045 4.025 -17.945 -2.93 0.01 3.055 0.15 -2.03 0.135 2.835 3.34 3.37 0.025 35.57 32.05 -0.14 -0.01 -0.6 -0.91 0.07 4.86",
  "AACAA 4.97 0.37 16 12.21 0.33 14 -10.17 0.66 21 -1.54 0.03 21 -1.25 0.12 21 -2.29 0.88 21 6.26 1.48 21 34.6 0.57 21 35.64 0.51 21 -6.22 0.37 17 4.57 -0.04 -0.21 1.8 8.21 5.13 -2.29 6.26 0.26 0.4 3.39 3.52 0.47 -0.5 0 -10.17 6.17 -1.54 -1.25 34.6 35.64 12.24 -6.795 0.69 1.28 1.965 0.7 5.52 -0.035 5.415 3.3 3.49 0.03 31.62 35.6 -0.07 0.15 -1.15 -0.55 -0.095 5.95 -9.165 -0.15 -1.94 -5.16 -1.3 12.12 -0.02 2.83 3.39 3.2 0.035 32.99 26.37 -0.45 0.15 -0.69 -0.32 -0.04 6.81",
  "AACAC 5.05 0.34 12 12.55 0.53 10 -9.4 0.63 16 -1.52 0.05 16 -1.32 0.09 16 -2.42 1.05 16 4.19 2.49 16 34.68 0.43 16 35.07 0.7 16 -5.66 0.25 12 4.47 -0.03 -0.59 0.39 6.45 5.11 -2.42 4.19 0.26 0.54 3.39 3.39 0.38 -0.34 0.03 -9.4 6.27 -1.52 -1.32 34.68 35.07 12.78 -4.965 0.69 1.38 1.52 0.7 6.67 0 5.56 3.3 3.43 0.04 31.62 36.74 -0.07 0.33 -1.15 -0.22 -0.1 6.14 -9.32 -0.15 0.73 -2.575 -1.3 9.43 -0.035 2.075 3.39 3.36 0.04 32.99 33.76 -0.45 0.31 -0.69 -0.34 0.065 6.77",
  "AACAG 4.95 0.23 22 12.68 0.43 22 -9.26 0.61 28 -1.54 0.04 28 -1.49 0.05 28 -2.4 0.79 28 5.23 1.43 28 34.88 0.37 28 34.91 0.52 28 -5.75 0.25 23 4.33 -0.02 -0.37 0.49 6.85 5.08 -2.4 5.23 0.27 0.73 3.4 3.46 0.4 -0.27 -0.01 -9.26 6.61 -1.54 -1.49 34.88 34.91 12.83 -7.735 0.69 0.41 0.745 0.7 5.58 0 3.045 3.3 3.49 0.055 31.62 35.68 -0.07 0.09 -1.15 -0.67 -0.09 6.385 -9.785 -0.15 -0.5 -3.625 -1.3 9.7 -0.015 2.92 3.39 3.27 0.035 32.99 32.34 -0.45 0.08 -0.69 -0.16 0.07 6.99",
  "AACAT 4.3 0.29 10 12.26 0.31 4 -10.22 1.32 56 -1.55 0.03 48 -1.57 0.08 56 -3.23 1.44 48 5.76 1.93 56 35.12 0.63 48 35.94 0.57 56 -6.1 0.4 38 4.55 -0.03 0.06 0.87 8.82 4.39 -3.3 5.76 0.28 0.86 3.43 3.67 0.5 -0.33 -0.07 -10.22 5.6 -1.55 -1.57 35.34 35.94 12.95 -7.74 0.69 -0.04 0.295 0.7 4.06 -0.02 2.22 3.3 3.57 0.06 31.62 37.31 -0.07 -0.02 -1.15 -0.47 -0.095 5.72 -9.975 -0.15 0.41 0.125 -1.3 8.78 -0.02 2.695 3.39 3.48 0.04 32.99 35.85 -0.45 0.17 -0.69 -0.47 0.055 6.495",
  "AACCA 4.33 0.26 15 13.23 0.25 13 -8.86 0.55 15 -1.58 0.08 15 -1.76 0.05 15 -3.3 0.78 15 -0.59 0.9 15 35.26 1.12 15 34.89 0.32 15 -6.24 0.43 12 4.5 -0.04 -0.61 -1.52 5.76 4.38 -3.3 -0.59 0.26 0.46 3.44 3.49 0.31 -0.06 -0.03 -8.86 6.18 -1.58 -1.76 35.26 34.89 13.32 6.93 -0.74 2.31 -11.5 0.02 4.48 -0.305 25.585 3.23 3.62 0.145 31.1 34.57 -0.01 0.07 -1.28 -0.82 -0.255 6.615 -10.285 0.68 -0.68 2.215 -0.47 3.91 0.01 1.545 3.45 3.58 0.035 33.37 35.51 -0.13 -0.43 -0.8 -0.62 0.08 6.235",
  "AACCC 4.03 0.26 19 14 0.22 15 -7.68 0.74 35 -1.61 0.05 35 -1.84 0.03 23 -4.18 1.39 35 -1.38 0.73 23 35.8 0.69 35 34.89 0.4 23 -6 0.32 21 4.55 -0.03 -0.09 -1.46 6.18 4.03 -4.18 -1.36 0.28 0.82 3.47 3.57 0.44 -0.05 -0.08 -7.68 5 -1.61 -1.89 35.8 34.77 14.19 -0.585 -0.74 1.11 -4.45 0.02 3.17 -0.155 15.365 3.23 3.65 0.095 31.1 35.52 -0.01 -0.03 -1.28 -1.38 -0.17 6.21 -14 0.68 0.43 0.88 -0.47 5.47 0 1.205 3.45 3.68 0.02 33.37 33.67 -0.13 0.01 -0.8 -1.23 0.03 5.465",
  "AACCG 4.36 0.15 20 13.43 0.3 18 -7.97 0.45 20 -1.58 0.03 20 -1.79 0.05 20 -3.13 0.57 20 -0.65 0.51 20 35.23 0.38 20 34.48 0.48 20 -5.76 0.12 15 4.43 -0.03 -0.35 -1.02 5.79 4.52 -3.13 -0.65 0.27 0.54 3.43 3.49 0.39 -0.06 -0.04 -7.97 6.44 -1.58 -1.79 35.23 34.48 13.44 2.295 -0.74 -1.2 -5.865 0.02 0.98 -0.18 22.545 3.23 4.29 0.12 31.1 32.85 -0.01 -0.03 -1.28 -0.75 -0.145 6.645 -9.67 0.68 -0.99 3.31 -0.47 3.53 0.025 1.49 3.45 3.61 0.04 33.37 36.59 -0.13 -0.51 -0.8 -0.44 0.13 6.385",
  "AACCT 3.64 0.27 10 14.04 0.38 10 -8.15 0.75 10 -1.61 0.03 10 -1.93 0.03 10 -4.78 0.76 10 -2.23 0.75 10 35.92 0.37 10 35.61 0.47 10 -6.11 0.17 5 4.62 -0.03 0.2 -2.45 6.2 3.72 -4.78 -2.23 0.29 0.83 3.49 3.66 0.46 -0.04 -0.1 -8.15 5.59 -1.61 -1.93 35.92 35.61 14.21 -1.005 -0.74 -0.43 -8.485 0.02 4.12 -0.245 19.6 3.23 3.6 0.155 31.1 34.54 -0.01 -0.01 -1.28 -1.17 -0.215 6.23 -14.035 0.68 1.01 2.285 -0.47 5.04 0.005 1.19 3.45 3.69 0.025 33.37 34.51 -0.13 -0.03 -0.8 -1.2 0.13 5.36",
  "AACGA 4.8 0.35 24 12.84 0.34 23 -9.62 0.52 24 -1.51 0.03 24 -1.66 0.08 24 -2.49 0.94 24 5.41 1.41 24 34.71 0.51 24 33.66 0.68 24 -5.64 0.22 17 4.38 -0.03 0.21 -0.11 8.01 4.84 -2.49 5.41 0.26 0.76 3.38 3.58 0.44 -0.03 -0.07 -9.62 6.42 -1.51 -1.66 34.71 33.66 12.92 -6.7 -0.8 -1.25 2.005 1.38 5.07 0.075 2.69 3.32 3.37 0.085 32.17 36.26 -0.19 0 -1.04 0.13 -0.07 6.11 -7.555 0.24 1.62 0.235 -0.87 10.27 0 1.705 3.43 3.11 0.05 32.81 27.85 -0.39 0.06 -0.66 -0.09 0.16 6.985",
  "AACGC 4.64 0.14 54 12.66 0.37 9 -9.91 0.48 72 -1.53 0.02 72 -1.71 0.03 70 -2.93 0.43 72 4.64 0.51 70 35.06 0.31 72 33.41 0.26 70 -5.56 0.15 57 4.42 -0.02 0.21 -0.58 7.71 4.68 -2.93 4.65 0.26 0.88 3.4 3.56 0.44 0.03 -0.09 -9.91 5.85 -1.53 -1.71 35.06 33.41 12.96 -8.135 -0.8 -0.81 1.615 1.38 6.61 0.045 2.64 3.32 3.55 0.07 32.17 36.65 -0.19 -0.19 -1.04 -0.3 -0.14 6.475 -8.97 0.24 1.24 0.165 -0.87 8.92 0.025 1.045 3.43 3.4 0.03 32.81 35.4 -0.39 0.21 -0.66 -0.19 0.16 6.65",
  "AACGG 4.62 0.27 11 12.97 0.27 10 -10.04 0.64 18 -1.51 0.03 18 -1.73 0.04 13 -3.07 0.49 18 3.74 0.7 13 35.14 0.44 18 33.45 0.28 13 -5.66 0.28 14 4.37 -0.02 0.39 -0.9 8.65 4.61 -3.07 4.23 0.26 1.06 3.39 3.59 0.45 0.05 -0.1 -10.04 4.72 -1.51 -1.75 35.14 33.49 13.65 -8.55 -0.8 0.88 1.705 1.38 6.79 0.12 2.82 3.32 3.41 0.075 32.17 34.95 -0.19 0.29 -1.04 -0.07 -0.09 6.47 -7.695 0.24 0.15 0.74 -0.87 8.7 0.005 1.58 3.43 3.13 0.05 32.81 31.48 -0.39 -0.03 -0.66 -0.03 0.165 7.055",
  "AACGT 4.21 0.25 17 12.71 0.34 17 -10.39 0.39 17 -1.52 0.03 17 -1.77 0.05 17 -3.43 0.83 17 5.64 0.81 17 35.24 0.41 17 34.53 0.34 17 -5.89 0.3 15 4.53 -0.03 0.54 -0.17 9.16 4.23 -3.43 5.64 0.28 0.99 3.4 3.74 0.48 -0.01 -0.13 -10.39 6.26 -1.52 -1.77 35.24 34.53 12.75 -9.295 -0.8 -1.27 1.07 1.38 8.72 0.055 3.18 3.32 3.66 0.065 32.17 37 -0.19 0.07 -1.04 -0.62 -0.135 6.315 -9.375 0.24 0.03 3.29 -0.87 8.18 0.025 1.62 3.43 3.52 0.045 32.81 38.4 -0.39 0.02 -0.66 -0.19 0.13 6.555",
  "AACTA 4.24 0.55 15 13.87 0.27 12 -6.07 1.56 17 -1.71 0.06 15 -1.75 0.09 17 -4.24 1.98 15 -3.9 3.28 17 35.56 0.66 15 32.1 1.04 17 -6.41 0.34 11 4.56 -0.02 -1.29 1.1 1.66 4.26 -4.61 -3.9 0.22 0.24 3.56 3.44 0.41 -0.28 0.08 -6.07 5.76 -1.71 -1.75 35.91 32.1 13.96 -7.6 0.46 0.26 2.49 -0.13 3.96 0.025 -0.275 3.34 3.39 0.085 32.04 33.51 0.02 0.04 -1.36 -0.72 -0.095 5.72 -13.1 1.16 -3.32 2.615 -1.05 1.53 0.035 3.645 3.49 3.4 0.035 33.51 36.23 -0.1 -0.78 -0.88 -0.41 0.225 5.875",
  "AACTC 3.95 0.2 18 14.09 0.23 15 -5.23 0.46 18 -1.73 0.02 18 -1.8 0.03 18 -4.38 0.64 18 -3.01 0.8 18 36.03 0.35 18 32.41 0.22 18 -6.33 0.17 12 4.63 -0.03 -1.4 1.9 1.89 4.03 -4.38 -3.01 0.24 0.41 3.54 3.46 0.38 -0.19 0.07 -5.23 5.69 -1.73 -1.8 36.03 32.41 14.09 -4.095 0.46 0.16 4.33 -0.13 4.06 -0.005 4.015 3.34 3.48 0.04 32.04 36.4 0.02 0.05 -1.36 -0.96 -0.085 5.74 -17.44 1.16 -2.53 4.175 -1.05 3.33 0.075 1.99 3.49 3.59 0.025 33.51 34.74 -0.1 -0.18 -0.88 -0.88 0.225 5.07",
  "AACTG 4.49 0.38 14 13.51 0.41 11 -5.42 0.83 17 -1.71 0.05 17 -1.72 0.07 17 -3.28 1.43 17 -1.85 1.2 17 35.45 0.59 17 31.73 0.62 17 -5.9 0.31 11 4.4 -0.03 -1.56 2.35 1.58 4.69 -3.28 -1.85 0.24 0.31 3.5 3.38 0.36 -0.22 0.09 -5.42 6.46 -1.71 -1.72 35.45 31.73 13.53 -5.905 0.46 0.62 4.525 -0.13 3.99 0.035 3.54 3.34 3.49 0.04 32.04 33.34 0.02 0.04 -1.36 -0.86 -0.095 5.74 -12.055 1.16 -3.95 4.105 -1.05 0.77 0.03 2.98 3.49 3.44 0.03 33.51 37.04 -0.1 -0.74 -0.88 -0.3 0.205 6.115",
  "AAGAA 4.8 0.13 5 14.01 0.31 4 -3.46 0.35 16 -1.77 0.05 16 -1.51 0.08 16 -1.79 0.97 16 -0.63 1.19 16 32.3 0.32 16 36.52 0.74 16 -6.03 0.19 12 4.49 -0.04 -2.12 2.94 3.89 4.85 -1.79 -0.63 -0.27 0.06 3.4 3.44 0.26 -0.33 0.12 -3.46 5.94 -1.77 -1.51 32.3 36.52 14.1 5.105 -0.18 -0.79 4.78 1.41 0.42 -0.06 8.165 3.55 3.34 0.025 33.81 35.9 0.02 -0.12 -1.23 -0.55 -0.115 5.75 -12.5 -1.04 0.69 6.41 4.57 2.93 0.065 2.32 3.39 3.38 0.02 31.3 34.17 -0.09 -0.12 -0.75 -0.45 0.11 5.92",
  "AAGAC 4.65 0.3 16 13.69 0.29 12 -3.82 0.63 31 -1.75 0.06 31 -1.49 0.11 28 -2.15 1.04 31 -2.37 1.17 28 32.56 0.53 31 36.4 1.49 28 -5.94 0.26 25 4.45 -0.03 -1.97 1.75 3.39 4.73 -2.15 -2.22 -0.28 0.17 3.43 3.34 0.27 -0.17 0.12 -3.82 4.85 -1.75 -1.51 32.56 36.33 14.22 2.72 -0.18 0.5 4.745 1.41 -0.35 -0.015 9.685 3.55 3.31 0.015 33.81 34.57 0.02 0.18 -1.23 -0.47 -0.075 6.14 -12.965 -1.04 -1.64 8.1 4.57 1.08 0.08 2.34 3.39 3.39 0.02 31.3 37.9 -0.09 -0.36 -0.75 -0.18 0.135 6.03",
  "AAGAG 4.68 0.34 7 13.99 0.48 6 -3.22 0.68 7 -1.81 0.04 7 -1.66 0.05 7 -1.76 1.14 7 -1.36 1.27 7 32.31 0.33 7 35.92 0.73 7 -5.82 0.21 5 4.32 -0.03 -2.12 1.96 3.02 4.74 -1.76 -1.36 -0.28 0.32 3.43 3.41 0.26 -0.15 0.09 -3.22 6.4 -1.81 -1.66 32.31 35.92 14.16 8.655 -0.18 0.5 9.095 1.41 3.59 -0.115 14.71 3.55 3.53 0.025 33.81 31.77 0.02 0.09 -1.23 -1.55 -0.135 6.27 -12.335 -1.04 -0.7 5.74 4.57 3.41 0.07 2.2 3.39 3.32 0.02 31.3 33.95 -0.09 -0.08 -0.75 -0.49 0.095 6.425",
  "AAGAT 3.9 0.36 9 13.9 0.27 9 -3.55 0.68 23 -1.8 0.05 10 -1.67 0.05 23 -3.96 1.46 10 -3.29 1.24 23 32.88 0.49 10 37.56 0.55 23 -6.56 0.62 14 4.6 -0.02 -2.13 2.51 2.52 3.97 -2.78 -3.29 -0.28 0.39 3.58 3.52 0.38 -0.21 0.08 -3.55 3.1 -1.84 -1.67 33.11 37.56 14.56 1.005 -0.18 -0.22 3.925 1.41 -1.37 -0.025 9.32 3.55 3.36 0.08 33.81 35.45 0.02 0.08 -1.23 -0.64 -0.125 5.505 -13.02 -1.04 -1.07 4.72 4.57 3.02 0.065 2.27 3.39 3.38 0.015 31.3 34.4 -0.09 -0.07 -0.75 -0.64 0.09 6.32",
  "AAGCA 4.61 0.34 110 13.88 0.3 102 -1.47 0.46 114 -1.76 0.06 114 -1.69 0.04 114 -3.05 1.32 114 -3.31 0.93 114 32.29 0.56 114 37.13 0.39 114 -5.99 0.24 91 4.45 -0.02 -2.19 0.66 4.04 4.62 -3.05 -3.31 -0.26 0.32 3.37 3.46 0.3 0 0.18 -1.47 6.07 -1.76 -1.69 32.29 37.13 13.97 22.985 -0.63 1.31 -2.6 3.27 -0.48 -0.42 32.525 3.5 3.31 -0.315 36.01 31.95 -0.08 -0.11 -0.95 -0.69 0.015 6.525 -18.07 -3.04 1.57 3.67 4.55 -1.42 0.035 1.575 3.54 3.42 0 35.23 36.13 -0.25 0.5 -0.78 -0.34 0.235 5.16",
  "AAGCC 4.17 0.44 22 14.19 0.25 18 -1.55 0.48 36 -1.81 0.06 36 -1.71 0.03 30 -3.7 1.36 36 -4.34 1.41 30 32.49 0.61 36 37.74 0.53 30 -6.1 0.44 25 4.52 -0.02 -1.75 0.91 3.28 4.08 -3.7 -4.25 -0.26 0.43 3.46 3.51 0.35 0 0.14 -1.55 4.74 -1.81 -1.71 32.49 37.73 14.46 15.355 -0.63 -0.03 7.285 3.27 0.71 -0.38 26.85 3.5 3.47 -0.195 36.01 33 -0.08 0.19 -0.95 -1.1 -0.07 6.71 -18.135 -3.04 -0.58 7.04 4.55 -0.12 0.06 1.97 3.54 3.53 0.015 35.23 35.84 -0.25 0.05 -0.78 -0.81 0.175 5.19",
  "AAGCG 4.63 0.19 22 13.61 0.22 21 -1.91 0.36 22 -1.76 0.04 22 -1.65 0.04 22 -2.38 0.59 22 -2.72 0.69 22 32.27 0.37 22 37.15 0.41 22 -5.65 0.11 16 4.36 -0.03 -2.11 1.05 4.12 4.74 -2.38 -2.72 -0.26 0.27 3.38 3.46 0.31 -0.01 0.17 -1.91 6.56 -1.76 -1.65 32.27 37.15 13.56 11.69 -0.63 -0.84 2.065 3.27 1.21 -0.36 23.35 3.5 3.42 -0.2 36.01 32.32 -0.08 0.07 -0.95 -0.75 -0.01 6.835 -17.495 -3.04 1.12 4.73 4.55 -0.06 0.055 1.625 3.54 3.45 0.005 35.23 34.64 -0.25 0.24 -0.78 -0.57 0.225 5.68",
  "AAGCT 4.14 0.33 12 14.32 0.32 12 -1.56 0.34 12 -1.83 0.03 12 -1.8 0.01 12 -3.24 0.93 12 -4.35 1.33 12 32.14 0.3 12 38.05 0.49 12 -6.03 0.19 8 4.5 -0.02 -1.77 -0.07 3.03 4.25 -3.24 -4.35 -0.25 0.37 3.44 3.56 0.36 -0.01 0.12 -1.56 6.04 -1.83 -1.8 32.14 38.05 14.44 9.585 -0.63 1.42 4.99 3.27 1.07 -0.44 23.345 3.5 3.63 -0.18 36.01 34.84 -0.08 0.28 -0.95 -1.09 0.045 6.55 -17.755 -3.04 0 8.05 4.55 -0.63 0.075 2.02 3.54 3.57 0.02 35.23 36.01 -0.25 0.01 -0.78 -0.85 0.25 5.115",
  "AAGGA 4.31 0.24 7 14.13 0.31 6 -1.33 0.29 7 -1.82 0.03 7 -1.86 0.03 7 -3.38 0.35 7 -1.91 0.74 7 32.55 0.37 7 34.9 0.32 7 -6.03 0.14 5 4.46 -0.02 -2.36 2.12 4.75 4.38 -3.38 -1.91 -0.28 0.31 3.41 3.55 0.35 0.01 0.18 -1.33 5.89 -1.82 -1.86 32.55 34.9 14.38 -2.775 0.27 0.38 1.395 2.63 4.06 0 3.295 3.38 3.51 0.1 34.14 33.87 -0.06 0.02 -0.76 -0.87 -0.055 6.16 -11.125 -1.95 2.03 6.56 3.9 6.08 0.05 1.98 3.33 3.49 0.01 32.22 31.5 -0.18 0.11 -0.78 -0.85 0.15 6.52",
  "AAGGC 4.51 0.1 9 14.2 0.46 9 -1.5 0.34 11 -1.82 0.03 9 -1.86 0.03 11 -2.75 0.47 9 -2.62 0.49 11 32.34 0.25 9 34.57 0.29 11 -5.64 0.2 9 4.37 -0.03 -2.37 1.36 3.5 4.5 -2.55 -2.62 -0.28 0.28 3.44 3.46 0.33 0.07 0.14 -1.5 5.43 -1.83 -1.86 32.44 34.57 14.47 -0.7 0.27 -0.99 5.375 2.63 2.03 -0.03 10.97 3.38 3.59 0.085 34.14 31.99 -0.06 0.03 -0.76 -0.33 -0.02 6.795 -13.76 -1.95 0.61 8.325 3.9 5.32 0.075 2.115 3.33 3.64 0.015 32.22 34.58 -0.18 -0.13 -0.78 -1.02 0.225 6.09",
  "AAGGG 4.42 0.27 8 14.48 0.23 6 -0.14 0.41 8 -1.85 0.02 8 -1.94 0.04 8 -3.37 0.94 8 -3.54 1.16 8 31.94 0.21 8 34.22 0.51 8 -5.82 0.24 5 4.36 -0.01 -2.25 1.31 5.26 4.4 -3.37 -3.54 -0.28 0.48 3.37 3.5 0.35 0.12 0.16 -0.14 5.91 -1.85 -1.94 31.94 34.22 14.8 -7.865 0.27 -1.32 3.865 2.63 3.56 -0.155 7.655 3.38 3.49 0.05 34.14 34.59 -0.06 -0.08 -0.76 -0.79 0.025 6.62 -10.21 -1.95 0.76 6.65 3.9 5.78 0.06 1.92 3.33 3.46 0.015 32.22 32.29 -0.18 0.03 -0.78 -0.97 0.125 6.75",
  "AAGGT 3.75 0.38 23 14.22 0.34 17 -1.48 0.85 51 -1.87 0.04 23 -1.93 0.04 51 -4.81 1.65 23 -3.27 1.17 51 32.53 0.47 23 35.68 0.52 51 -6.44 0.35 18 4.53 -0.02 -2.58 2.18 3.8 3.81 -3.49 -3.27 -0.28 0.56 3.55 3.63 0.41 -0.01 0.14 -1.48 3.64 -1.91 -1.93 32.77 35.68 14.85 -7.55 0.27 -0.43 -4.195 2.63 4.12 -0.09 7.985 3.38 3.6 0.075 34.14 34.54 -0.06 -0.01 -0.76 -1.17 -0.105 6.25 -13.165 -1.95 1.01 7.465 3.9 5.04 0.055 2.15 3.33 3.69 0.015 32.22 34.51 -0.18 -0.03 -0.78 -1.2 0.195 6.065",
  "AAGTA 4.03 0.56 66 13.81 0.51 60 -4.26 0.82 67 -1.82 0.06 67 -1.69 0.12 67 -3.52 1.99 67 -4.72 2.22 67 33.24 0.74 67 35.21 0.52 67 -6.34 0.38 49 4.63 -0.02 -2.07 1.33 -0.26 4.07 -3.52 -4.72 -0.26 0.27 3.52 3.43 0.3 -0.25 0.12 -4.26 5.92 -1.82 -1.69 33.24 35.21 13.89 -6.94 0 -0.78 -0.81 2.19 0.4 -0.04 -0.365 3.61 3.28 0.055 37.83 29.92 0.02 -0.09 -1.1 -1.17 -0.08 5.785 -16.81 -2.53 1.81 2.05 3.43 -2.16 0.045 2.24 3.56 3.33 0.01 34.93 33.24 -0.24 0.25 -0.92 -0.57 0.24 5.1",
  "AAGTC 3.74 0.52 106 14.17 0.34 76 -4.07 0.84 106 -1.85 0.1 106 -1.73 0.06 106 -4.01 1.98 106 -5.04 1.37 106 33.16 0.83 106 35.44 0.45 106 -6.55 0.38 65 4.67 -0.02 -1.85 1.74 -0.32 3.81 -4.01 -5.04 -0.25 0.41 3.55 3.5 0.34 -0.26 0.08 -4.07 5.5 -1.85 -1.73 33.16 35.44 14.18 -6.38 0 0.4 2.345 2.19 -0.05 0.045 1.005 3.61 3.22 0.015 37.83 30.4 0.02 0.12 -1.1 -1.09 -0.08 5.38 -18.14 -2.53 1.62 5.08 3.43 -0.65 0.065 2.455 3.56 3.49 0.02 34.93 33.25 -0.24 -0.17 -0.92 -0.82 0.255 5.005",
  "AAGTG 4.14 0.34 18 13.6 0.36 16 -4.48 1.09 18 -1.83 0.04 18 -1.68 0.04 18 -2.79 0.86 18 -4.51 1.19 18 33.1 0.63 18 34.91 0.39 18 -6.18 0.26 14 4.55 -0.03 -2.01 1.91 -0.34 4.22 -2.79 -4.51 -0.26 0.28 3.51 3.45 0.28 -0.24 0.1 -4.48 5.96 -1.83 -1.68 33.1 34.91 13.68 -8.83 0 0.23 1.125 2.19 2.61 -0.005 1.21 3.61 3.37 0.015 37.83 30.45 0.02 0 -1.1 -1.09 -0.045 5.605 -17.7 -2.53 2.38 1.52 3.43 -3.54 0.05 2.09 3.56 3.4 0.01 34.93 34.76 -0.24 0.35 -0.92 -0.48 0.225 5.025",
  "AAGTT 3.34 0.49 18 13.6 0.38 16 -6.26 0.87 18 -1.85 0.06 18 -1.76 0.06 18 -3.62 1.6 18 -5.19 1.21 18 33.58 0.65 18 36.3 0.68 18 -6.51 0.36 8 4.79 -0.03 -1.68 1.12 -1.95 3.48 -3.62 -5.19 -0.24 0.42 3.62 3.57 0.36 -0.45 0.06 -6.26 5.41 -1.85 -1.76 33.58 36.3 13.66 -6.22 0 0.46 1.835 2.19 -0.13 0.045 -3.06 3.61 3.34 0.045 37.83 32.04 0.02 0.02 -1.1 -1.36 -0.03 4.745 -17.67 -2.53 1.16 4.32 3.43 -1.05 0.055 2.575 3.56 3.49 0.02 34.93 33.51 -0.24 -0.1 -0.92 -0.88 0.24 4.98",
  "AATAA 5.53 0.45 154 12.74 0.36 150 -9.65 0.82 154 -1.53 0.04 154 -1.39 0.1 154 -3.91 1.52 154 8.21 2.17 154 32.44 0.6 154 34.83 1.08 154 -7.48 0.28 121 4.32 -0.01 0.2 1.07 7 5.48 -3.91 8.21 -0.11 -0.84 3.25 3.51 0.18 -0.14 -0.08 -9.65 6.67 -1.53 -1.39 32.44 34.83 12.77 -5.685 0.34 -0.11 -1.715 -1.57 0.54 0.025 4.13 3.21 3.42 0.015 32.19 37.82 0.01 0.03 -0.96 -0.27 -0.135 4.84 -13.215 0.48 1.94 3.26 -1.72 10.51 0.035 3.38 3.25 3.27 0.03 31.21 29.6 0.25 0.05 -0.84 -0.34 0.16 5.62",
  "AATAC 5.3 0.39 18 12.74 0.37 12 -10.45 0.8 24 -1.53 0.03 24 -1.41 0.07 24 -4.27 0.84 24 6.24 1.84 24 32.78 0.5 24 34.79 1.33 24 -7.43 0.3 18 4.28 -0.01 0.19 -0.45 5.26 5.26 -4.27 6.24 -0.1 -0.67 3.28 3.38 0.16 0.01 -0.1 -10.45 6.17 -1.53 -1.41 32.78 34.79 13.16 -2.44 0.34 -2.31 -2.44 -1.57 6.23 0.05 2.115 3.21 4.17 0.02 32.19 37.58 0.01 0.21 -0.96 -0.85 -0.1 5.53 -12.815 0.48 0.31 -0.77 -1.72 8.55 0.01 2.745 3.25 3.3 0.025 31.21 33.49 0.25 0.06 -0.84 -0.36 0.165 5.815",
  "AATAG 4.65 1.16 7 12.83 0.44 7 -11.61 3.04 7 -1.48 0.14 7 -1.37 0.34 7 -5.98 3.64 7 3.47 5.7 7 33.54 1.49 7 35.89 2.08 7 -7.51 0.13 4 4.47 0.01 0.38 -0.61 4.51 4.55 -5.98 3.47 -0.13 -1 3.3 3.4 0.13 0.12 -0.14 -11.61 6.22 -1.48 -1.37 33.54 35.89 12.82 -3.135 0.34 0.01 -5.23 -1.57 -1.56 0.09 -2.275 3.21 3.43 0.01 32.19 38.93 0.01 0.14 -0.96 -0.69 -0.06 5.105 -13.77 0.48 0.23 3.245 -1.72 11.11 0.035 3.155 3.25 3.29 0.03 31.21 31.37 0.25 0.1 -0.84 -0.48 0.135 6.105",
  "AATAT 4.8 0.81 9 13.25 0.48 8 -10.43 0.89 9 -1.59 0.07 9 -1.55 0.12 9 -5.48 2.39 9 6.33 4.15 9 33.17 0.82 9 35.25 1.38 9 -7.65 0.49 6 4.43 -0.01 0.43 -0.59 4.93 4.58 -5.48 6.33 -0.1 -0.45 3.31 3.54 0.15 -0.02 -0.17 -10.43 6.32 -1.59 -1.55 33.17 35.25 13.4 -6.555 0.34 -12.15 -1.455 -1.57 1.4 0.045 1.74 3.21 -2.62 0.005 32.19 34.12 0.01 0.24 -0.96 0.21 -0.07 4.595 -13.46 0.48 0.09 2.35 -1.72 8.38 0.025 3.285 3.25 3.39 0.025 31.21 34.51 0.25 0 -0.84 -0.55 0.15 5.645",
  "AATCA 4.46 0.51 1112 13.44 0.42 1016 -9.91 0.87 1112 -1.54 0.04 1112 -1.59 0.06 1112 -4.75 1.49 1112 -1.08 1.82 1112 33.01 0.62 1112 36.14 0.86 1112 -8.06 0.36 859 4.47 -0.02 0.76 -1.4 4.83 4.51 -4.75 -1.08 -0.1 -0.39 3.3 3.42 0.19 0.27 -0.18 -9.91 6.34 -1.54 -1.59 33.01 36.14 13.51 -11.29 0.3 -1.17 -1.375 0.14 0.99 0 3.41 3.21 3.24 0.085 32.14 34.88 -0.07 -0.13 -1.15 -0.25 -0.12 5.11 -12.555 -0.16 -2.26 3.27 -1.55 1.5 0.095 1.825 3.39 3.44 0.04 32.02 38.64 -0.06 -0.62 -0.83 0 0.02 6.08",
  "AATCC 4.19 0.46 41 14.09 0.42 33 -9.67 0.81 60 -1.57 0.04 60 -1.6 0.05 41 -5.81 1.43 60 -0.9 1.27 41 33.31 0.58 60 36.57 0.56 41 -8.4 1.2 45 4.52 -0.02 0.86 -1.48 4.52 4.12 -5.81 -1.06 -0.09 -0.06 3.33 3.46 0.19 0.21 -0.22 -9.67 4.75 -1.57 -1.61 33.31 36.63 14.26 -11.01 0.3 -0.25 -2.13 0.14 0.71 0.045 4.245 3.21 3.36 0.08 32.14 36.74 -0.07 -0.16 -1.15 -0.7 -0.14 5.13 -15.775 -0.16 -1.44 -0.5 -1.55 2.13 0.09 1.485 3.39 3.4 0.03 32.02 36.42 -0.06 -0.09 -0.83 -0.52 -0.035 5.445",
  "AATCG 4.56 0.26 45 13.45 0.34 41 -9.51 0.64 47 -1.54 0.03 47 -1.52 0.05 47 -4.9 0.99 47 -0.8 1.12 47 32.89 0.39 47 36.19 0.51 47 -7.97 0.24 38 4.49 -0.02 0.58 -0.87 4.39 4.51 -4.9 -0.8 -0.11 -0.49 3.29 3.38 0.13 0.22 -0.17 -9.51 6.3 -1.54 -1.52 32.89 36.19 13.59 -9.865 0.3 -0.28 -1.915 0.14 0.86 -0.01 7.16 3.21 3.29 0.09 32.14 34.73 -0.07 0.08 -1.15 -0.36 -0.07 5.555 -12.12 -0.16 -2.17 3.87 -1.55 1.28 0.1 1.73 3.39 3.47 0.04 32.02 38.8 -0.06 -0.62 -0.83 0.04 0.05 6.185",
  "AATCT 3.75 0.8 10 13.85 0.48 6 -10.31 0.89 13 -1.55 0.05 13 -1.71 0.06 13 -6.11 1.85 13 -2.71 3.9 13 33.3 0.61 13 37.53 1.2 13 -9.5 3.15 8 4.61 -0.03 0.96 -3.06 3.88 3.89 -6.11 -2.71 -0.07 0.47 3.33 3.62 0.25 0.19 -0.26 -10.31 5.73 -1.55 -1.71 33.3 37.53 14.12 -10.01 0.3 -0.22 0.29 0.14 -1.37 0.025 4.3 3.21 3.36 0.095 32.14 35.45 -0.07 0.08 -1.15 -0.64 -0.13 4.765 -14.5 -0.16 -1.07 1.09 -1.55 3.02 0.09 1.425 3.39 3.38 0.03 32.02 34.4 -0.06 -0.07 -0.83 -0.64 0.035 5.83",
  "AATGA 4.46 0.53 735 13.34 0.39 655 -9.02 0.98 739 -1.55 0.06 738 -1.59 0.1 737 -6.08 1.68 738 3.8 2.42 737 32.87 0.65 738 34.98 0.83 737 -8.13 0.42 575 4.42 -0.01 0.87 -1.24 6.23 4.55 -6.08 3.8 -0.1 0 3.3 3.58 0.21 0.29 -0.21 -9.02 6.18 -1.55 -1.59 32.87 34.98 13.44 -5.9 2.52 -0.85 -0.5 -0.35 6.07 0.03 0.775 3.29 3.41 0 28.07 36.88 -0.05 0.03 -1.2 -0.15 -0.04 5.925 -13.02 1.09 1.32 0.995 -1.22 11 0.015 2.765 3.28 3.26 0.03 31.23 29.96 0.16 0.33 -0.79 -0.21 0.075 6.12",
  "AATGC 4.89 0.52 10 13.21 0.37 9 -9.59 0.4 11 -1.52 0.04 11 -1.44 0.04 11 -5.22 1.66 11 3.59 1.68 11 32.67 0.62 11 35.25 0.47 11 -7.51 0.46 9 4.37 -0.02 0.78 -1.74 3.91 4.91 -5.22 3.59 -0.1 -0.33 3.3 3.43 0.12 0.33 -0.19 -9.59 6.06 -1.52 -1.44 32.67 35.25 13.32 -4.65 2.52 -1.53 -10.825 -0.35 1.9 -0.1 15.205 3.29 3.45 -0.21 28.07 36.82 -0.05 -0.32 -1.2 0.04 0.01 6.045 -13.715 1.09 -0.31 1.015 -1.22 10.06 0.03 2.9 3.28 3.3 0.025 31.23 32.58 0.16 0.1 -0.79 -0.39 0.08 6.22",
  "AATGG 5.08 0.29 19 13.22 0.39 17 -8.98 0.46 19 -1.5 0.04 19 -1.53 0.06 19 -4.16 0.88 19 3.6 1.15 19 32.12 0.34 19 34.87 0.34 19 -7.27 0.23 15 4.27 -0.02 0.96 -1.9 5.67 5.1 -4.16 3.6 -0.09 -0.35 3.26 3.44 0.16 0.4 -0.2 -8.98 6.66 -1.5 -1.53 32.12 34.87 13.34 -7.635 2.52 0.59 -2.845 -0.35 2.89 -0.045 2.08 3.29 3.43 -0.055 28.07 38.36 -0.05 0.14 -1.2 0.02 -0.045 5.995 -12.415 1.09 0.08 0.38 -1.22 9.76 0.02 2.655 3.28 3.16 0.025 31.23 31.42 0.16 0.25 -0.79 -0.18 0.085 6.39",
  "AATGT 4.27 0.65 15 12.81 0.55 15 -10.82 1.17 38 -1.53 0.08 35 -1.57 0.09 38 -6.17 2.3 35 4.78 2.22 38 33.25 0.83 35 36.13 0.55 38 -8.64 1.65 28 4.54 -0.01 1.13 -1.13 5.89 4.11 -6.22 4.78 -0.09 0.31 3.33 3.66 0.25 0.3 -0.25 -10.82 5.96 -1.53 -1.57 33.33 36.13 12.9 -6.585 2.52 -0.04 -2.335 -0.35 4.06 -0.04 1.81 3.29 3.57 -0.015 28.07 37.31 -0.05 -0.02 -1.2 -0.47 -0.045 5.445 -13.635 1.09 0.41 1.26 -1.22 8.78 0.02 2.945 3.28 3.48 0.025 31.23 35.85 0.16 0.17 -0.79 -0.47 0.08 5.88",
  "AATTA 4.36 0.57 169 13.09 0.36 152 -12.2 0.82 169 -1.58 0.04 169 -1.22 0.05 169 -5.21 1.62 169 -2.38 1.98 169 33.31 0.74 169 35.92 0.63 169 -8.38 0.44 131 4.59 -0.03 -0.02 1.57 -0.87 4.41 -5.21 -2.38 -0.16 -1.44 3.36 3.2 -0.01 0.18 -0.08 -12.2 6.19 -1.58 -1.22 33.31 35.92 13.14 -5.375 -0.06 0.49 -0.77 -0.28 0.11 -0.045 11.685 3.24 3.26 -0.045 31.47 34.83 0 0.01 -1.12 -0.71 -0.145 4.5 -14.76 0.01 -3.34 1.845 -2.03 -0.16 0.12 3.475 3.37 3.3 0.03 32.05 36.99 -0.01 -0.63 -0.91 -0.17 0.045 5.665",
  "AATTC 3.75 0.42 22 13.61 0.32 11 -11.18 0.72 22 -1.64 0.05 22 -1.27 0.06 22 -6.49 1.29 22 -3.59 1.13 22 33.75 0.55 22 36.17 0.44 22 -10.92 1.94 43 4.73 -0.02 0.13 1.92 -1.22 3.75 -6.49 -3.59 -0.16 -0.96 3.39 3.25 0.05 0.12 -0.09 -11.18 5.41 -1.64 -1.27 33.75 36.17 13.53 -0.815 -0.06 -1.59 2.145 -0.28 -1.17 0.055 14.7 3.24 3.26 0.06 31.47 35.73 0 0.02 -1.12 -0.66 -0.135 4.22 -17.35 0.01 -2.71 1.72 -2.03 1.21 0.14 2.575 3.37 3.34 0.03 32.05 34.45 -0.01 -0.13 -0.91 -0.61 0.04 5.215",
  "AATTG 4.24 0.49 91 13 0.31 85 -11.93 0.95 91 -1.59 0.04 91 -1.2 0.05 91 -5.32 1.69 91 -2.97 1.25 91 33.37 0.86 91 35.62 0.55 91 -8.77 0.67 83 4.54 -0.03 0.03 2.2 -1.18 4.47 -5.32 -2.97 -0.16 -1.53 3.36 3.2 0 0.14 -0.08 -11.93 6.05 -1.59 -1.2 33.37 35.62 13 -5.155 -0.06 -1.33 2.285 -0.28 1.93 0.07 7.575 3.24 3.25 0.015 31.47 34.75 0 -0.06 -1.12 -0.57 -0.095 5.005 -13.715 0.01 -3.82 3.845 -2.03 -0.48 0.11 3.1 3.37 3.36 0.025 32.05 38.22 -0.01 -0.74 -0.91 -0.02 0.02 5.935",
  "ACAAA 5.21 0.41 28 12.47 0.41 27 -12.03 0.63 42 -1.16 0.09 42 -1.03 0.07 42 6.09 1.35 42 -2.56 1.74 42 35.41 0.52 42 35.77 0.47 42 -7.86 0.57 34 4.42 -0.03 2.06 -1.61 2.71 5.34 6.09 -2.56 0.09 -1.7 3.44 3.16 -0.5 -0.13 -0.25 -12.03 6.3 -1.16 -1.03 35.41 35.77 12.34 1.85 1.28 -0.39 -7.135 5.52 1.92 -0.255 15.455 3.49 3.28 -0.07 35.6 34.88 0.15 -0.07 -0.55 -0.43 -0.11 5.795 -10.04 -1.94 -2.46 0 12.12 0.84 0 3.79 3.2 3.31 0.02 26.37 35.22 0.15 -0.5 -0.32 -0.09 -0.16 6.96",
  "ACAAC 5.58 0.26 7 12.77 0.22 4 -11.7 0.52 11 -1.16 0.11 11 -1.11 0.03 7 6.2 0.91 11 -3.26 0.9 7 35.22 0.56 11 35.25 0.29 7 -6.99 0.37 9 4.17 -0.03 2.26 -2.03 2.61 5.76 6.2 -2.89 0.09 -1.41 3.4 3.12 -0.47 0.02 -0.23 -11.7 4.53 -1.16 -1.14 35.22 35.04 13.24 -7.13 1.28 0.28 3.2 5.52 2.59 -0.055 5.59 3.49 3.15 0.025 35.6 33.65 0.15 0.16 -0.55 -0.56 -0.06 6.435 -8.665 -1.94 -3.66 0.42 12.12 -1.25 0.01 3.61 3.2 3.3 0.02 26.37 37.43 0.15 -0.68 -0.32 0.02 -0.135 7.2",
  "ACAAG 5.19 0.19 10 12.87 0.39 10 -10.72 0.7 10 -1.28 0.12 10 -1.21 0.03 10 5.65 0.74 10 -3.95 0.97 10 35.43 0.49 10 35.05 0.39 10 -7.49 0.24 8 4.27 -0.03 2 -2.48 0.56 5.03 5.65 -3.95 0.09 -1.08 3.47 3.11 -0.46 0.04 -0.26 -10.72 6.58 -1.28 -1.21 35.43 35.05 13.09 -3.47 1.28 0.99 3.315 5.52 -0.32 -0.14 7.61 3.49 3.14 -0.05 35.6 34.05 0.15 0.04 -0.55 -0.57 -0.05 6.055 -9.115 -1.94 -3.77 1.975 12.12 -0.87 0 3.79 3.2 3.32 0.025 26.37 37.64 0.15 -0.6 -0.32 0.07 -0.115 7.19",
  "ACACA 5.5 0.39 8 12.55 0.32 8 -9.33 0.49 10 -1.17 0.13 8 -1.48 0.03 10 2.96 3.11 8 -2.65 0.85 10 35.28 0.97 8 33.88 0.56 10 -6.78 0.19 8 4.21 -0.03 0.31 -0.56 5.8 5.34 3.5 -2.65 0.1 -0.94 3.33 3.33 -0.38 0.39 0.05 -9.32 5.99 -1.19 -1.48 35.34 33.88 13 -1.265 1.38 -0.02 0.43 6.67 1.43 -0.04 5.69 3.43 3.22 0.015 36.74 28.74 0.33 -0.1 -0.22 -0.73 -0.1 6.53 -9.995 0.73 0.59 -4.4 9.43 0.49 -0.04 1.85 3.36 3.28 0.035 33.76 30.57 0.31 -0.17 -0.34 -0.6 0.045 6.75",
  "ACACC 5.31 0.16 18 13.12 0.3 12 -8.57 0.52 32 -1.27 0.07 32 -1.53 0.03 28 3.95 0.87 32 -2.95 0.52 28 34.83 0.43 32 34.36 0.17 28 -7.06 0.13 24 4.15 -0.03 1.03 -0.85 4.94 5.31 3.95 -2.98 0.11 -0.67 3.3 3.37 -0.29 0.32 -0.02 -8.57 5.68 -1.27 -1.54 34.83 34.37 13.6 4.955 1.38 -0.05 -6.33 6.67 1.73 -0.21 15.045 3.43 3.35 0.02 36.74 32.09 0.33 0.05 -0.22 -1.18 -0.17 6.69 -11.81 0.73 1.04 -7.2 9.43 -1.99 -0.06 1.65 3.36 3.29 0.03 33.76 33.57 0.31 0.12 -0.34 -0.51 -0.01 6.15",
  "ACACG 5.47 0.14 19 12.18 0.33 18 -9.43 0.37 19 -1.22 0.08 19 -1.45 0.03 19 4.66 0.71 19 -2.25 0.43 19 35.35 0.32 19 33.84 0.25 19 -6.83 0.14 15 4.15 -0.03 0.84 -0.67 4.45 5.46 4.66 -2.25 0.1 -0.81 3.32 3.32 -0.34 0.31 -0.01 -9.43 7.25 -1.22 -1.45 35.35 33.84 12.2 -6.11 1.38 0.93 2.53 6.67 0.23 -0.005 4.26 3.43 3.35 0.025 36.74 29.11 0.33 0.14 -0.22 -0.89 -0.015 6.375 -10.91 0.73 0.64 -4.615 9.43 -0.54 -0.04 1.82 3.36 3.31 0.035 33.76 31.32 0.31 -0.01 -0.34 -0.45 0.075 6.655",
  "ACAGA 5.33 0.3 7 13.25 0.56 7 -7 0.53 36 -1.37 0.07 36 -1.68 0.04 36 3.72 1.17 36 -1.93 0.88 36 35 0.46 36 31.6 0.29 36 -7.09 0.15 27 4.2 -0.03 0.9 -2.41 2.68 5.29 3.72 -1.93 0.08 -0.8 3.33 3.33 -0.27 0.23 -0.04 -7 6.41 -1.37 -1.68 35 31.6 13.8 -6.705 0.41 0.5 -0.44 5.58 3.48 -0.025 1.82 3.49 3.35 0.035 35.68 32.26 0.09 -0.15 -0.67 -0.56 -0.09 6.635 -11.28 -0.5 -1.77 0 9.7 5.04 0 3.97 3.27 3.28 0.02 32.34 29.92 0.08 -0.25 -0.16 -0.32 0.06 7.32",
  "ACAGC 5.31 0.22 25 13.01 0.35 24 -7.34 0.62 25 -1.46 0.06 25 -1.68 0.05 25 5.07 0.81 25 -2.1 0.92 25 35.03 0.41 25 31.35 0.24 25 -6.99 0.16 19 4.09 -0.03 0.64 -2.51 0.46 5.25 5.07 -2.1 0.08 -0.51 3.44 3.28 -0.29 0.23 -0.1 -7.34 7.1 -1.46 -1.68 35.03 31.35 13.19 -2.935 0.41 -0.88 -0.005 5.58 2.66 -0.06 5.25 3.49 3.35 0.045 35.68 31.67 0.09 -0.23 -0.67 -0.63 -0.02 7.15 -9.21 -0.5 -3.59 2 9.7 0.33 -0.005 3.685 3.27 3.35 0.025 32.34 35.72 0.08 -0.61 -0.16 -0.23 0.1 7.515",
  "ACAGG 5.29 0.13 8 13.26 0.5 8 -6.78 0.58 20 -1.44 0.09 20 -1.76 0.05 20 4.68 1.46 20 -2.48 1.27 20 34.61 0.53 20 31.34 0.46 20 -6.94 0.2 15 4.08 -0.03 0.61 -2.61 2.15 5.38 4.68 -2.48 0.08 -0.41 3.39 3.3 -0.24 0.27 -0.07 -6.78 7.18 -1.44 -1.76 34.61 31.34 13.37 -4.92 0.41 0.47 0.975 5.58 3.41 -0.02 2.23 3.49 3.26 0.065 35.68 32.49 0.09 0.32 -0.67 -0.58 -0.085 6.895 -8.99 -0.5 -3.47 2.43 9.7 0.92 -0.01 3.94 3.27 3.32 0.025 32.34 35.12 0.08 -0.57 -0.16 -0.28 0.105 7.595",
  "ACAGT 5.2 0.32 12 13.15 0.61 9 -8.12 0.92 19 -1.47 0.06 19 -1.72 0.06 19 4.57 1.32 19 -1.83 1.49 19 34.72 0.81 19 31.75 0.52 19 -7.1 0.27 17 4.17 -0.02 0.93 -2.62 0.62 5.04 4.57 -1.83 0.09 -0.32 3.43 3.39 -0.25 0.22 -0.12 -8.12 6.1 -1.47 -1.72 34.72 31.75 13.74 -6.04 0.41 0.62 2.92 5.58 3.99 -0.015 5.98 3.49 3.49 0.02 35.68 33.34 0.09 0.04 -0.67 -0.86 -0.125 6.75 -9.905 -0.5 -3.95 1.715 9.7 0.77 -0.01 4.26 3.27 3.44 0.025 32.34 37.04 0.08 -0.74 -0.16 -0.3 0.115 7.375",
  "ACATA 5.14 0.17 8 13.33 0.38 8 -8.52 0.82 17 -1.48 0.07 13 -1.49 0.03 15 4.85 1.49 13 -4.73 0.94 15 35.48 0.51 13 32.21 0.33 15 -7.31 0.26 13 4.26 -0.02 0.77 -0.83 -3.28 5.08 5.25 -4.6 0.07 -0.19 3.56 3.22 -0.35 0.01 -0.17 -8.52 5.04 -1.5 -1.49 35.73 32.26 13.78 -7.56 -0.04 1.96 1.28 4.06 2.32 0 2.29 3.57 3.25 0.07 37.31 29.13 -0.02 0.14 -0.47 -0.83 -0.11 5.8 -11.63 0.41 0.41 -0.295 8.78 0.23 0 3.59 3.48 3.22 0.03 35.85 29.21 0.17 -0.01 -0.47 -0.78 0.055 6.49",
  "ACATC 4.82 0.4 70 13.42 0.33 40 -8.65 0.73 103 -1.51 0.09 103 -1.49 0.05 103 5.15 1.49 103 -4.91 1.54 103 35.37 0.65 103 32.37 0.55 103 -7.6 0.24 83 4.28 -0.02 1.01 -0.36 -2.73 4.89 5.15 -4.91 0.09 -0.29 3.53 3.24 -0.34 0.01 -0.19 -8.65 6.35 -1.51 -1.49 35.37 32.37 13.48 -7.755 -0.04 0.06 -0.995 4.06 1.15 -0.05 1.91 3.57 3.23 0.065 37.31 27.88 -0.02 -0.12 -0.47 -1.11 -0.045 5.98 -12.17 0.41 0.38 -1.235 8.78 -0.45 0.015 3.135 3.48 3.21 0.035 35.85 29.55 0.17 0 -0.47 -0.75 0.035 6.12",
  "ACATG 4.99 0.21 47 12.71 0.47 47 -10.15 0.94 110 -1.48 0.08 110 -1.45 0.04 49 5.73 0.99 110 -4.67 0.68 49 35.7 0.44 110 32 0.21 49 -7.2 0.24 87 4.21 -0.01 1.39 -0.16 -3.58 5 5.73 -4.34 0.08 -0.25 3.55 3.25 -0.36 -0.07 -0.24 -10.15 3.96 -1.48 -1.45 35.7 32.18 13.7 -7.63 -0.04 -0.43 -0.38 4.06 0.79 -0.05 2.245 3.57 3.19 -0.005 37.31 26.17 -0.02 0.02 -0.47 -0.87 -0.11 5.835 -11.735 0.41 0.01 0.155 8.78 0.36 -0.01 3.515 3.48 3.25 0.03 35.85 29.75 0.17 -0.03 -0.47 -0.76 0.03 6.65",
  "ACCAA 5.08 0.32 13 12.84 0.51 11 -4.69 0.86 13 -1.74 0.05 13 -1.39 0.06 13 -0.94 1.09 13 4.34 1.82 13 34.7 0.45 13 34.6 0.32 13 -5.8 0.3 10 4.39 -0.04 -1.35 2.71 1.12 4.85 -0.94 4.34 0.25 0.19 3.45 3.44 -0.06 -0.49 0.11 -4.69 6.49 -1.74 -1.39 34.7 34.6 13.1 1.21 2.31 -2.12 -7.59 4.48 4.21 -0.145 12.36 3.62 3.1 0.065 34.57 16.27 0.07 0.02 -0.82 -0.1 -0.22 6.975 -6.17 -0.68 -1.98 -0.405 3.91 11 -0.035 2.595 3.58 2.96 0.03 35.51 23.39 -0.43 0.1 -0.62 -0.14 0.01 7.405",
  "ACCAC 5.38 0.18 15 13.04 0.45 9 -5 0.5 70 -1.71 0.04 70 -1.35 0.05 58 -0.49 0.41 70 3.35 0.59 58 34.37 0.44 70 34.18 0.36 58 -5.43 0.19 58 4.11 -0.05 -0.8 1.43 0.68 5.5 -0.49 3.44 0.25 0.16 3.4 3.29 -0.09 -0.3 0.1 -5 4.08 -1.71 -1.38 34.37 34.13 14.21 1.205 2.31 -1.4 -7.205 4.48 5.18 -0.165 10.98 3.62 3.36 0.05 34.57 35.26 0.07 -0.01 -0.82 -0.18 -0.18 7.325 -4.43 -0.68 -0.29 0.39 3.91 9.42 -0.045 1.87 3.58 2.93 0.035 35.51 25.46 -0.43 0.26 -0.62 -0.17 0.08 7.55",
  "ACCAG 5.19 0.16 13 13.53 0.18 12 -4.44 0.47 15 -1.76 0.04 15 -1.51 0.03 13 -0.64 0.3 15 3.13 0.52 13 34.39 0.35 15 34.21 0.24 13 -5.3 0.12 11 4.12 -0.04 -0.75 1.51 0.67 5.31 -0.64 3.29 0.26 0.24 3.42 3.38 -0.05 -0.3 0.07 -4.44 6.18 -1.76 -1.53 34.39 34.17 13.78 2.09 2.31 -0.96 -7.325 4.48 3.87 -0.15 11.165 3.62 3.4 0.045 34.57 34.03 0.07 -0.23 -0.82 -0.37 -0.2 6.965 -6.095 -0.68 -0.45 -0.45 3.91 9.82 -0.015 2.58 3.58 2.85 0.035 35.51 23.51 -0.43 0.11 -0.62 -0.08 0.135 7.54",
  "ACCCA 4.66 0.24 36 14.11 0.29 28 -3.38 0.57 53 -1.81 0.04 53 -1.81 0.05 39 -1.42 1.21 53 -2 0.87 39 34.63 0.52 53 33.53 0.47 39 -5.67 0.38 42 4.27 -0.04 -0.87 -0.65 -0.71 4.68 -1.42 -1.98 0.28 0.34 3.48 3.39 -0.06 -0.13 0.04 -3.38 5.2 -1.81 -1.82 34.63 33.69 14.39 -4.645 1.11 0.97 0.255 3.17 5.25 0.01 0.05 3.65 3.42 -0.02 35.52 30.63 -0.03 -0.25 -1.38 -0.87 -0.09 6.74 -7.7 0.43 -1 7.36 5.47 3.96 0.015 1.37 3.68 3.45 0.03 33.67 34.1 0.01 -0.36 -1.23 -0.53 0.07 6.86",
  "ACCCC 4.58 0.18 68 14.99 0.34 19 -2.37 0.56 168 -1.84 0.04 168 -1.88 0.05 116 -1.8 0.98 168 -2.4 0.53 116 34.28 0.43 168 33.44 0.48 116 -5.66 0.27 114 4.19 -0.04 -0.62 -0.44 0.38 4.6 -1.8 -2.33 0.29 0.41 3.45 3.42 -0.03 -0.09 -0.01 -2.37 4.3 -1.84 -1.89 34.28 33.46 15.33 -17.445 1.11 -1.81 10.615 3.17 6.69 -0.16 10.685 3.65 3.39 0.025 35.52 33.69 -0.03 -0.39 -1.38 -0.6 -0.17 6.44 -8.065 0.43 0.17 1.65 5.47 5.94 0 0.79 3.68 3.37 0.01 33.67 30.11 0.01 0.05 -1.23 -1.15 -0.115 6.675",
  "ACCCG 4.7 0.17 24 13.89 0.25 21 -3.53 0.57 24 -1.81 0.04 24 -1.79 0.03 24 -0.94 0.61 24 -1.76 0.56 24 34.56 0.47 24 33.51 0.23 24 -5.59 0.26 20 4.24 -0.04 -0.83 -0.29 -0.44 4.76 -0.94 -1.76 0.27 0.27 3.47 3.38 -0.07 -0.13 0.04 -3.53 6.93 -1.81 -1.79 34.56 33.51 13.86 -4.695 1.11 0.39 -0.18 3.17 4.59 0.155 -0.36 3.65 3.53 0.015 35.52 34.7 -0.03 -0.16 -1.38 -0.55 -0.105 6.87 -7.435 0.43 -1.24 8.36 5.47 3.17 0.02 1.325 3.68 3.48 0.035 33.67 35.21 0.01 -0.43 -1.23 -0.32 0.105 6.945",
  "ACCGA 5.02 0.18 9 13.64 0.36 8 -4.29 1.04 10 -1.79 0.06 9 -1.64 0.08 10 -0.94 0.64 9 3.35 0.95 10 34.18 0.32 9 32.64 0.36 10 -5.09 0.17 8 4.15 -0.04 -0.94 0.88 0.94 5.16 -0.79 3.35 0.25 0.33 3.45 3.43 -0.08 -0.1 0.04 -4.29 6.41 -1.78 -1.64 34.23 32.64 13.72 -1.245 -1.2 1.74 -8.885 0.98 3.99 -0.11 12.97 4.29 3.3 0.035 32.85 36.31 -0.03 0.05 -0.75 -0.06 0.01 7.165 -4.41 -0.99 -1.58 -0.145 3.53 10.1 0.01 1.62 3.61 2.86 0.05 36.59 22.38 -0.51 -0.06 -0.44 -0.05 0.15 7.725",
  "ACCGC 5.08 0.11 47 13.35 0.32 6 -4.55 0.45 89 -1.75 0.04 89 -1.66 0.03 85 -0.62 0.38 89 2.79 0.44 85 34.31 0.38 89 32.31 0.29 85 -5.23 0.23 69 4.15 -0.04 -0.54 0.54 0.53 5.08 -0.62 2.79 0.25 0.35 3.43 3.38 -0.06 -0.01 0.03 -4.55 5.47 -1.75 -1.66 34.31 32.31 14 -4.41 -1.2 -0.18 -0.48 0.98 0.81 0.02 7.655 4.29 3.37 0.09 32.85 36.72 -0.03 0.14 -0.75 0.09 -0.04 7.225 -2.695 -0.99 0.43 0.135 3.53 8.69 -0.01 1.405 3.61 2.81 0.05 36.59 23.6 -0.51 0.05 -0.44 -0.12 0.21 7.735",
  "ACCGG 5.16 0.14 13 13.3 0.57 12 -5.03 0.61 19 -1.7 0.04 17 -1.69 0.04 19 -0.44 0.88 17 2.54 1.51 19 34.12 0.31 17 32.44 0.32 19 -5.16 0.2 15 4.11 -0.04 -0.35 -0.17 2.36 5.11 -0.38 2.54 0.25 0.36 3.4 3.41 -0.06 0.01 0 -5.03 6.31 -1.7 -1.69 34.21 32.44 13.72 -1.675 -1.2 2.64 -2.495 0.98 2.17 0.015 7.485 4.29 3.29 0.02 32.85 35.19 -0.03 0.29 -0.75 0.05 -0.025 7.38 -3.705 -0.99 -0.05 -0.69 3.53 8.79 0 1.62 3.61 2.78 0.05 36.59 23.08 -0.51 -0.02 -0.44 -0.06 0.235 7.8",
  "ACCTA 4.68 0.26 7 14.06 0.42 5 -1.54 0.56 9 -1.9 0.05 9 -1.78 0.04 7 -1.78 0.94 9 -2.96 0.91 7 34.99 0.37 9 31.46 0.37 7 -5.64 0.26 7 4.33 -0.02 -1.81 1.98 -4.01 4.6 -1.78 -2.67 0.25 0.34 3.55 3.31 -0.07 -0.27 0.15 -1.54 5.97 -1.9 -1.8 34.99 31.6 14.5 -4.945 -0.43 0.08 -2.33 4.12 4.07 -0.07 5.46 3.6 3.34 0.08 34.54 32.41 -0.01 -0.17 -1.17 -0.56 -0.155 6.445 -10.87 1.01 -2.61 7.56 5.04 2.13 0.04 3.025 3.69 3.3 0.03 34.51 33.56 -0.03 -0.49 -1.2 -0.46 0.215 6.54",
  "ACCTC 4.37 0.29 64 14.58 0.34 19 -0.88 0.47 125 -1.92 0.05 125 -1.82 0.04 112 -2.35 1.22 125 -3.46 1.14 112 34.93 0.58 125 31.49 0.31 112 -6.05 0.25 92 4.32 -0.02 -1.86 2.32 -3.23 4.44 -2.35 -3.29 0.26 0.38 3.56 3.35 -0.05 -0.24 0.13 -0.88 4.88 -1.92 -1.83 34.93 31.51 15.02 -0.765 -0.43 -1.38 -9.38 4.12 2.37 -0.22 10.02 3.6 3.3 0.165 34.54 33.79 -0.01 0.01 -1.17 -0.71 -0.08 6.545 -11.485 1.01 -1.82 5.285 5.04 3.61 0.065 1.965 3.69 3.26 0.025 34.51 30.16 -0.03 -0.12 -1.2 -0.81 0.14 6.415",
  "ACCTG 4.54 0.19 10 13.87 0.28 8 -1.68 0.32 16 -1.92 0.03 16 -1.77 0.02 10 -1.63 0.47 16 -2.97 0.32 10 35.08 0.41 16 31.38 0.34 10 -5.73 0.24 14 4.31 -0.02 -1.88 2.65 -4.09 4.58 -1.63 -2.62 0.25 0.32 3.57 3.36 -0.06 -0.31 0.15 -1.68 4.87 -1.92 -1.79 35.08 31.58 14.45 -6.105 -0.43 0.47 -3.715 4.12 3.41 -0.085 5.46 3.6 3.26 0.095 34.54 32.49 -0.01 0.32 -1.17 -0.58 -0.145 6.535 -9.625 1.01 -3.47 8.64 5.04 0.92 0.025 2.48 3.69 3.32 0.025 34.51 35.12 -0.03 -0.57 -1.2 -0.28 0.19 6.745",
  "ACGAA 5.21 0.26 9 13.16 0.28 9 -6.66 0.49 15 -1.61 0.07 13 -1.36 0.06 11 5.06 0.77 13 -0.84 0.6 11 33.73 0.17 13 36 0.29 11 -5.3 0.18 13 4.29 -0.04 -0.27 1.45 -2.2 5.12 5.34 -0.42 -0.29 0.4 3.54 3.36 -0.05 -0.29 -0.08 -6.66 4.68 -1.62 -1.41 33.77 35.95 13.92 -2.815 -1.25 0.64 1.035 5.07 4.33 0.03 4.795 3.37 3.37 0.075 36.26 33.2 0 0.12 0.13 -0.59 -0.085 6.41 -6.87 1.62 -0.77 4.095 10.27 2.23 -0.02 1.725 3.11 3.42 0.05 27.85 35.44 0.06 -0.48 -0.09 0 0.085 7.075",
  "ACGAC 5.34 0.2 182 13.35 0.36 164 -6.61 0.54 183 -1.51 0.07 183 -1.36 0.07 183 5.01 1.05 183 -2.42 0.87 183 33.73 0.49 183 35.7 0.63 183 -5.43 0.2 145 4.24 -0.04 0.13 0.23 -0.47 5.31 5.01 -2.42 -0.28 0.32 3.42 3.21 -0.06 -0.1 -0.03 -6.61 6.72 -1.51 -1.36 33.73 35.7 13.38 -2.56 -1.25 -1.77 4.085 5.07 0.35 0.09 -1.455 3.37 3.38 0.105 36.26 32.95 0 -0.4 0.13 -0.48 -0.015 6.945 -6.255 1.62 -2.22 5 10.27 0.43 -0.005 1.645 3.11 3.39 0.05 27.85 38.87 0.06 -0.69 -0.09 0.19 0.115 7.38",
  "ACGAG 5.13 0.15 7 13.51 0.22 6 -6.5 0.36 7 -1.59 0.03 7 -1.43 0.03 7 4.47 0.68 7 -2.01 0.99 7 33.69 0.19 7 35.94 0.41 7 -5.41 0.28 6 4.2 -0.05 0.15 0.07 -2.02 5.13 4.47 -2.01 -0.29 0.37 3.48 3.25 -0.06 -0.13 -0.07 -6.5 6.54 -1.59 -1.43 33.69 35.94 13.67 -7.17 -1.25 1.54 1.01 5.07 0.27 -0.03 0.825 3.37 3.19 0.07 36.26 34.26 0 0.08 0.13 -0.3 -0.015 6.81 -7.315 1.62 -2.1 4.05 10.27 1.53 -0.005 1.595 3.11 3.38 0.05 27.85 35.75 0.06 -0.34 -0.09 -0.12 0.095 7.35",
  "ACGCA 5.27 0.2 5 12.68 0.3 4 -4.25 0.31 5 -1.6 0.05 5 -1.5 0.06 5 4.21 0.56 5 -1.26 0.59 5 33.71 0.23 5 35.83 0.15 5 -4.74 0.27 3 4.21 -0.04 -0.69 -0.65 -1.18 5.3 4.21 -1.26 -0.28 0.34 3.46 3.36 -0.04 -0.03 0.04 -4.25 6.99 -1.6 -1.5 33.71 35.83 12.55 -1.88 -0.81 0.01 2.86 6.61 6.42 0.07 -2.06 3.55 3.24 0.105 36.65 28.89 -0.19 0.07 -0.3 -0.7 -0.13 7.405 -9.1 1.24 -0.46 0.815 8.92 -1.45 0.02 0.515 3.4 3.42 0.02 35.4 34.51 0.21 -0.21 -0.19 -0.39 0.145 6.48",
  "ACGCC 5.08 0.12 11 13.3 0.36 10 -3.63 0.47 13 -1.62 0.07 13 -1.55 0.04 11 3.67 0.7 13 -2.09 0.46 11 33.32 0.35 13 36.67 0.17 11 -5.1 0.1 10 4.21 -0.04 -0.48 -0.11 -0.29 5.04 3.67 -2.08 -0.27 0.41 3.44 3.39 0.05 0.03 0.03 -3.63 6.34 -1.62 -1.57 33.32 36.54 13.59 -2.455 -0.81 0.05 1.07 6.61 -1.11 -0.025 5.05 3.55 3.24 0.075 36.65 27.86 -0.19 0.2 -0.3 -0.51 -0.135 7.245 -11.87 1.24 -0.2 -4.24 8.92 -0.95 -0.005 0.26 3.4 3.39 0.01 35.4 35.49 0.21 0.26 -0.19 -0.36 0.095 5.88",
  "ACGCG 5.2 0.14 14 12.42 0.37 14 -4.73 0.3 277 -1.65 0.05 277 -1.51 0.03 14 4.51 0.47 277 -1.39 0.35 14 33.2 0.43 277 35.9 0.19 14 -4.86 0.12 236 4.17 -0.03 -0.33 -0.41 -1.59 5.09 4.51 -1.66 -0.27 0.46 3.47 3.4 0.03 -0.03 0 -4.73 2.3 -1.65 -1.56 33.2 36.35 14.72 -6.48 -0.81 -0.71 0.49 6.61 3.29 -0.025 0.515 3.55 3.34 0.075 36.65 17.88 -0.19 -0.23 -0.3 -1.43 -0.035 6.975 -9.69 1.24 -0.04 1.115 8.92 -3.07 0.025 0.295 3.4 3.49 0.015 35.4 36.07 0.21 0 -0.19 -0.15 0.19 6.45",
  "ACGGA 5.06 0.1 3 13.73 0.13 3 -3.36 0.5 9 -1.63 0.08 9 -1.71 0.05 9 2.56 1.15 9 -2.1 4.02 9 33.01 0.37 9 34.6 1.99 9 -5.19 0.18 5 4.34 -0.04 -0.99 0.82 1.4 4.84 2.56 -2.1 -0.27 0.19 3.4 3.47 0.02 0.04 0.08 -3.36 6.42 -1.63 -1.71 33.01 34.6 14.03 -10.265 0.88 -1.79 0.575 6.79 2.54 0 4.105 3.41 0.77 0.05 34.95 30.08 0.29 -0.19 -0.07 -0.75 -0.05 7.4 -7.34 0.15 0.43 4.21 8.7 5.73 -0.015 1.36 3.13 3.48 0.04 31.48 31.82 -0.03 -0.24 -0.03 -0.41 0.165 7.28",
  "ACGGC 5.08 0.14 16 13.22 0.25 16 -3.97 0.29 18 -1.65 0.06 18 -1.7 0.03 16 3.91 0.6 18 -1.58 0.35 16 33.55 0.3 18 33.79 0.19 16 -5.1 0.12 14 4.16 -0.05 -0.97 0.27 -0.54 5.07 3.91 -1.49 -0.28 0.3 3.48 3.35 0.03 0.09 0.02 -3.97 6.53 -1.65 -1.71 33.55 33.74 13.39 -4.025 0.88 1.28 1.475 6.79 6.56 0.1 4.43 3.41 3.5 0.125 34.95 33.36 0.29 0.08 -0.07 -1 -0.045 7.315 -5.69 0.15 -1.21 6.155 8.7 2.64 0.005 1.525 3.13 3.5 0.05 31.48 36 -0.03 -0.57 -0.03 -0.25 0.205 7.535",
  "ACGGG 4.92 0.12 9 13.69 0.21 9 -2.81 0.34 9 -1.67 0.03 9 -1.77 0.04 9 2.76 0.5 9 -2.05 0.22 9 33.23 0.17 9 33.75 0.21 9 -5.36 0.12 8 4.15 -0.04 -1.07 0.23 0.72 4.91 2.76 -2.05 -0.28 0.34 3.45 3.38 0.05 0.09 0.04 -2.81 6.78 -1.67 -1.77 33.23 33.75 13.89 -4.79 0.88 0.39 0.86 6.79 4.59 0.21 0.29 3.41 3.53 0.065 34.95 34.7 0.29 -0.16 -0.07 -0.55 -0.055 7.37 -5.09 0.15 -1.24 6.27 8.7 3.17 0.005 1.51 3.13 3.48 0.055 31.48 35.21 -0.03 -0.43 -0.03 -0.32 0.175 7.59",
  "ACGGT 4.73 0.24 12 13.33 0.24 11 -4.79 0.45 13 -1.72 0.03 13 -1.74 0.05 12 3.68 0.42 13 -1.2 0.28 12 33.29 0.36 13 34.47 0.31 12 -5.47 0.31 10 4.24 -0.04 -0.94 0.69 -1.69 4.68 3.68 -1.15 -0.27 0.4 3.53 3.45 0.06 0.06 0 -4.79 6.32 -1.72 -1.75 33.29 34.44 13.63 -4.475 0.88 -1.2 -1.075 6.79 0.98 0.06 7.74 3.41 4.29 0.055 34.95 32.85 0.29 -0.03 -0.07 -0.75 -0.055 7.125 -5.805 0.15 -0.99 5.36 8.7 3.53 0.01 1.55 3.13 3.61 0.05 31.48 36.59 -0.03 -0.51 -0.03 -0.44 0.2 7.395",
  "ACGTA 4.84 0.13 13 12.72 0.19 12 -7.92 0.42 16 -1.69 0.05 16 -1.48 0.03 16 5.09 0.72 16 -2.68 0.7 16 34.34 0.37 16 34.3 0.22 16 -5.15 0.15 12 4.29 -0.03 -0.25 -0.19 -6.33 4.99 5.09 -2.68 -0.29 0.64 3.61 3.31 -0.04 -0.27 -0.05 -7.92 6.99 -1.69 -1.48 34.34 34.3 12.66 -5.985 -1.27 0.75 0.475 8.72 3.92 0.07 0.785 3.66 3.13 0.065 37 26.92 0.07 0.03 -0.62 -0.45 -0.07 7.345 -11.005 0.03 0.18 -0.05 8.18 0.77 0 1.525 3.52 3.27 0.04 38.4 30.04 0.02 -0.1 -0.19 -0.56 0.095 6.155",
  "ACGTC 4.7 0.13 17 13.08 0.27 16 -7.92 0.31 20 -1.69 0.04 20 -1.51 0.03 20 5.05 0.64 20 -3.06 0.6 20 34.3 0.26 20 34.58 0.24 20 -5.56 0.14 15 4.38 -0.03 0.02 0.28 -5.94 4.74 5.05 -3.06 -0.28 0.72 3.6 3.36 0.03 -0.27 -0.07 -7.92 6.61 -1.69 -1.51 34.3 34.58 13.07 -4.8 -1.27 0.8 -0.125 8.72 1.69 -0.005 4.645 3.66 3.3 0.065 37 29.13 0.07 -0.14 -0.62 -1.07 -0.095 7.085 -9.47 0.03 0.36 2.55 8.18 0.13 0.02 1.49 3.52 3.33 0.045 38.4 30.66 0.02 -0.34 -0.19 -0.6 0.135 6.62",
  "ACGTG 4.85 0.15 7 12.56 0.32 7 -8.78 0.23 9 -1.69 0.02 7 -1.45 0.03 9 5.64 0.36 7 -3.13 0.37 9 34.48 0.29 7 34.05 0.2 9 -5.15 0.14 6 4.29 -0.03 -0.22 0.13 -7.66 4.98 6.03 -3.13 -0.28 0.64 3.69 3.32 -0.04 -0.33 -0.09 -8.78 5.41 -1.71 -1.45 34.58 34.05 13.08 -10.485 -1.27 0.93 1.505 8.72 0.23 0.01 1.75 3.66 3.35 0.05 37 29.11 0.07 0.14 -0.62 -0.89 -0.015 6.585 -11.31 0.03 0.64 -0.4 8.18 -0.54 0.015 1.445 3.52 3.31 0.04 38.4 31.32 0.02 -0.01 -0.19 -0.45 0.1 6.275",
  "ACTAA 5.73 0.26 18 12.99 0.38 18 -8.1 0.51 18 -1.7 0.05 18 -1.44 0.07 18 -0.98 0.97 18 7.88 1.76 18 31.57 0.4 18 34.45 0.55 18 -6.95 0.3 14 3.97 -0.03 1.84 1.3 2.79 5.79 -0.98 7.88 -0.11 -0.99 3.28 3.47 -0.2 -0.1 -0.05 -8.1 7.24 -1.7 -1.44 31.57 34.45 12.89 -8.485 0.26 0.18 2.075 3.96 1.49 -0.015 5.02 3.39 3.26 0.06 33.51 34.85 0.04 0.04 -0.72 -0.13 -0.16 6.395 -10.125 -3.32 -1.75 -0.37 1.53 11.34 -0.025 4.91 3.4 3.04 0.035 36.23 24.59 -0.78 0.16 -0.41 -0.19 0.085 6.945",
  "ACTAC 5.62 0.4 40 13.43 0.41 28 -8.16 0.98 47 -1.7 0.07 47 -1.42 0.07 47 -1.63 1.93 47 4.89 1.83 47 31.68 0.61 47 34.24 1.1 47 -6.99 0.24 36 3.98 -0.03 1.84 -0.23 1.64 5.63 -1.63 4.89 -0.12 -0.92 3.31 3.28 -0.23 0.02 -0.03 -8.16 6.59 -1.7 -1.42 31.68 34.24 13.71 -7.65 0.26 -1.11 1 3.96 1.1 -0.035 2.1 3.39 3.38 0.07 33.51 36.22 0.04 0.04 -0.72 -0.28 -0.15 6.91 -8.485 -3.32 -0.14 -0.035 1.53 8.66 -0.035 4.17 3.4 2.99 0.035 36.23 27.73 -0.78 0.26 -0.41 -0.13 0.15 7.105",
  "ACTAG 5.13 0.24 5 13.69 0.26 5 -7.44 0.28 5 -1.78 0.04 5 -1.47 0.01 5 -2.86 0.94 5 3.55 1.1 5 32.22 0.43 5 35 0.15 5 -7.36 0.37 2 4.06 -0.02 1.56 0.04 -0.32 5.32 -2.86 3.55 -0.11 -0.52 3.39 3.32 -0.22 -0.04 -0.01 -7.44 6.9 -1.78 -1.47 32.22 35 13.73 -10.555 0.26 0.25 -0.285 3.96 0.7 -0.06 2.115 3.39 3.4 0.04 33.51 36.29 0.04 0.09 -0.72 0.16 -0.12 6.85 -10.045 -3.32 0.06 -0.895 1.53 9.68 -0.01 5.13 3.4 2.96 0.035 36.23 25.48 -0.78 -0.01 -0.41 -0.11 0.2 7.105",
  "ACTCA 4.89 0.38 17 14.17 0.58 15 -7.5 0.63 17 -1.78 0.07 17 -1.54 0.04 17 -2.78 1.44 17 -1.75 1.18 17 32.14 0.43 17 35.29 0.46 17 -7.4 0.25 13 4.29 -0.02 2.14 -0.98 -1.21 4.81 -2.78 -1.75 -0.11 -0.38 3.39 3.28 -0.25 0.13 -0.06 -7.5 6.48 -1.78 -1.54 32.14 35.29 14.29 -7.535 0.16 0.33 1.72 4.06 -0.39 -0.03 5.845 3.48 3.33 0.005 36.4 31.43 0.05 -0.29 -0.96 -0.56 -0.095 5.99 -12.285 -2.53 -2.58 9.325 3.33 0.2 0.09 2.29 3.59 3.39 0.04 34.74 37.67 -0.18 -0.54 -0.88 0.06 0.11 6.335",
  "ACTCC 4.73 0.27 41 14.59 0.29 21 -6.75 0.69 53 -1.78 0.04 53 -1.56 0.06 49 -2.84 1.7 53 -2.04 0.83 49 31.81 0.63 53 35.76 0.55 49 -7.61 0.23 43 4.24 -0.02 2.23 -0.79 -0.03 4.7 -2.84 -2.01 -0.09 -0.09 3.37 3.31 -0.2 0.13 -0.09 -6.75 5.67 -1.78 -1.56 31.81 35.78 14.79 2.015 0.16 0.62 -2.565 4.06 3.94 -0.145 12.74 3.48 3.27 0.12 36.4 35.11 0.05 0.28 -0.96 -0.35 -0.1 6.895 -13.53 -2.53 -1.85 2.645 3.33 3.18 0.08 1.81 3.59 3.21 0.025 34.74 33.48 -0.18 -0.18 -0.88 -0.37 -0.01 6.08",
  "ACTCG 4.93 0.17 26 13.76 0.2 24 -7.78 0.39 29 -1.77 0.03 29 -1.51 0.05 29 -1.9 0.55 29 -1.04 0.64 29 31.96 0.28 29 35.21 0.58 29 -7.3 0.14 22 4.2 -0.02 2.21 -0.48 -0.72 4.98 -1.9 -1.04 -0.11 -0.47 3.37 3.28 -0.22 0.14 -0.08 -7.78 6.93 -1.77 -1.51 31.96 35.21 13.79 -6.66 0.16 1.54 2.44 4.06 0.27 -0.1 5.845 3.48 3.19 0.02 36.4 34.26 0.05 0.08 -0.96 -0.3 -0.085 6.85 -13.21 -2.53 -2.1 8.215 3.33 1.53 0.08 2.03 3.59 3.38 0.035 34.74 35.75 -0.18 -0.34 -0.88 -0.12 0.12 6.53",
  "ACTGA 5.48 0.07 4 13.83 0.15 3 -7.1 0.34 6 -1.74 0.04 6 -1.41 0.02 4 -1.92 0.52 6 4.75 0.61 4 31.46 0.25 6 34.41 0.16 4 -6.81 0.2 4 4.09 -0.03 2.41 -0.55 0.23 5.4 -1.92 5.08 -0.1 -0.51 3.34 3.42 -0.22 0.21 -0.09 -7.1 5.54 -1.74 -1.44 31.46 34.42 14.11 -4.41 0.62 1.23 4.51 3.99 4.71 0.025 9.925 3.49 3.45 -0.02 33.34 36.83 0.04 0.16 -0.86 -0.32 -0.105 6.875 -8.53 -3.95 1.17 0 0.77 11.07 0 4.55 3.44 2.91 0.03 37.04 22.06 -0.74 0.04 -0.3 0 0.17 7.43",
  "ACTGC 5.4 0.26 35 13.4 0.39 31 -7.79 0.78 39 -1.69 0.07 38 -1.49 0.06 39 -1.42 1.21 38 3.67 1.07 39 31.49 0.49 38 33.95 0.55 39 -6.89 0.17 27 4.03 -0.03 2.68 -1.28 1.05 5.37 -1.42 3.67 -0.11 -0.54 3.34 3.36 -0.21 0.32 -0.13 -7.79 6.89 -1.69 -1.49 31.5 33.95 13.55 -4.16 0.62 1.82 4.19 3.99 3.42 -0.005 8.24 3.49 3.42 0.025 33.34 36.9 0.04 0.1 -0.86 0.08 -0.14 6.575 -7.615 -3.95 -0.29 -0.715 0.77 9.67 0 4.23 3.44 2.88 0.03 37.04 23.83 -0.74 0.03 -0.3 -0.16 0.16 7.65",
  "ACTGG 5.32 0.15 13 13.59 0.24 12 -7.24 0.49 15 -1.67 0.04 15 -1.49 0.03 13 -1.82 0.37 15 3.06 0.43 13 31.51 0.34 15 34.39 0.26 13 -6.86 0.19 13 4.06 -0.03 2.63 -1.43 1.78 5.38 -1.82 3.28 -0.11 -0.53 3.31 3.38 -0.2 0.31 -0.13 -7.24 6.37 -1.67 -1.49 31.51 34.42 13.79 -4.97 0.62 -0.96 2.69 3.99 3.87 -0.02 6.01 3.49 3.4 0.005 33.34 34.03 0.04 -0.23 -0.86 -0.37 -0.125 6.74 -7.835 -3.95 -0.45 -0.285 0.77 9.82 -0.005 3.975 3.44 2.85 0.03 37.04 23.51 -0.74 0.11 -0.3 -0.08 0.155 7.57",
  "ACTTA 4.48 0.31 20 13.67 0.23 16 -9.96 0.48 20 -1.81 0.05 20 -1.25 0.02 20 -2.87 1.11 20 -3.58 0.92 20 33.06 0.42 20 35.16 0.31 20 -7.98 0.36 16 4.41 -0.02 1.94 1.54 -6.47 4.62 -2.87 -3.58 -0.16 -0.98 3.51 3.12 -0.33 0.02 0.04 -9.96 6.3 -1.81 -1.25 33.06 35.16 13.71 -0.645 0 -0.17 -2.065 2.19 -1.34 -0.005 5.765 3.61 3.23 0.03 37.83 33.71 0.02 -0.07 -1.1 -0.55 -0.02 5.305 -15.215 -2.53 -3.36 8.36 3.43 -0.07 0.09 4.3 3.56 3.29 0.025 34.93 36.23 -0.24 -0.5 -0.92 -0.09 0.115 6.02",
  "ACTTC 4.31 0.27 37 14.14 0.37 18 -8.83 0.61 98 -1.84 0.05 98 -1.27 0.03 94 -3.34 1.24 98 -4.2 1.03 94 32.77 0.55 98 35.22 0.39 94 -8.32 0.24 77 4.4 -0.01 1.97 2.14 -5.73 4.38 -3.34 -4.15 -0.14 -0.53 3.5 3.14 -0.3 0.02 0.02 -8.83 4.74 -1.84 -1.27 32.77 35.24 14.39 -6.97 0 -1.21 -0.955 2.19 2.49 0.03 -0.49 3.61 3.26 0.02 37.83 34.94 0.02 -0.08 -1.1 -0.71 -0.04 5.585 -16.315 -2.53 -2.45 5.23 3.43 1.66 0.11 3.475 3.56 3.19 0.02 34.93 32.17 -0.24 -0.09 -0.92 -0.48 0.075 5.82",
  "ACTTG 4.52 0.31 18 13.39 0.27 15 -10.21 0.77 18 -1.82 0.04 18 -1.22 0.03 18 -2.35 1.03 18 -3.59 0.87 18 33.13 0.43 18 34.94 0.36 18 -8 0.46 14 4.34 -0.02 2.03 2.17 -6.9 4.78 -2.35 -3.59 -0.15 -1.23 3.51 3.13 -0.34 -0.02 0.03 -10.21 6.29 -1.82 -1.22 33.13 34.94 13.31 -5.035 0 0.99 1.715 2.19 -0.32 -0.09 2.7 3.61 3.14 -0.04 37.83 34.05 0.02 0.04 -1.1 -0.57 -0.005 5.295 -13.975 -2.53 -3.77 10.03 3.43 -0.87 0.08 3.765 3.56 3.32 0.02 34.93 37.64 -0.24 -0.6 -0.92 0.07 0.085 6.29",
  "AGAAA 4.74 0.2 6 13.69 0.16 4 -10.55 0.23 6 -1.54 0.08 6 -1.08 0.07 6 -0.69 1.12 6 -2.61 1.1 6 36.43 0.68 6 36.02 0.59 6 -8.05 0.21 4 4.53 -0.04 3.2 -1.58 0.75 4.69 -0.69 -2.61 0.07 -0.67 3.45 3.18 -0.29 -0.24 -0.28 -10.55 5.89 -1.54 -1.08 36.43 36.02 13.72 -3.09 -0.79 -1.76 2.885 0.42 -1.32 -0.05 6.88 3.34 1.86 -0.025 35.9 36.31 -0.12 0.02 -0.55 -0.55 -0.16 5.15 -11.79 0.69 -1.25 4.35 2.93 1.83 0.045 2.135 3.38 3.27 0.025 34.17 32.4 -0.12 -0.14 -0.45 -0.44 -0.015 5.93",
  "AGAAC 4.85 0.13 7 13.66 0.32 7 -10.59 0.51 47 -1.48 0.08 47 -1.09 0.05 47 -0.56 0.96 47 -3.03 1 47 36.45 0.68 47 35.7 0.39 47 -7.86 0.19 36 4.4 -0.03 2.71 -2.29 1.88 4.92 -0.56 -3.03 0.07 -0.65 3.42 3.1 -0.34 -0.14 -0.24 -10.59 6.4 -1.48 -1.09 36.45 35.7 13.61 -1.345 -0.79 -0.08 4.47 0.42 -0.22 0.025 -1.765 3.34 3.24 -0.01 35.9 34.75 -0.12 0.02 -0.55 -0.62 -0.125 5.36 -13.875 0.69 -2.66 5.485 2.93 1.29 0.085 1.79 3.38 3.35 0.025 34.17 35.61 -0.12 -0.2 -0.45 -0.38 0.015 5.715",
  "AGAAG 4.5 0.43 9 13.97 0.34 5 -10.3 0.43 10 -1.54 0.06 10 -1.25 0.03 10 -1.65 3.03 10 -4.1 1.45 10 36.79 1 10 35.47 0.39 10 -7.97 0.24 8 4.45 -0.03 3.21 -2.31 0.82 4.64 -1.65 -4.1 0.07 -0.32 3.49 3.17 -0.29 -0.02 -0.27 -10.3 5.93 -1.54 -1.25 36.79 35.47 14.12 -3.47 -0.79 -1.21 0.325 0.42 2.49 0.005 1.915 3.34 3.26 0.025 35.9 34.94 -0.12 -0.08 -0.55 -0.71 -0.11 6.15 -11.325 0.69 -2.45 3.51 2.93 1.66 0.08 2.175 3.38 3.19 0.03 34.17 32.17 -0.12 -0.09 -0.45 -0.48 -0.02 6.195",
  "AGACA 4.99 0.21 12 13.63 0.25 11 -8.49 0.28 12 -1.42 0.03 12 -1.55 0.04 12 -1.88 0.71 12 -2.8 0.52 12 36.49 0.4 12 34.36 0.18 12 -7.28 0.18 9 4.29 -0.01 1.37 -0.94 5.34 4.97 -1.88 -2.8 0.08 -0.11 3.28 3.36 -0.18 0.26 0.01 -8.49 6.71 -1.42 -1.55 36.49 34.36 13.52 -7.635 0.5 0.11 3.3 -0.35 0.71 0 4.8 3.31 3.23 0 34.57 29.32 0.18 0.01 -0.47 -1.08 -0.105 6.51 -10.735 -1.64 -0.05 2.02 1.08 -0.33 0.04 1.32 3.39 3.36 0.035 37.9 31.44 -0.36 -0.36 -0.18 -0.69 0.095 6.23",
  "AGACC 4.73 0.23 13 14.25 0.23 11 -8.04 0.36 22 -1.51 0.05 22 -1.59 0.03 13 -1.9 0.82 22 -3.14 0.58 13 36.1 0.54 22 34.74 0.17 13 -7.44 0.2 18 4.25 -0.02 1.91 -1.23 4.49 4.69 -1.9 -3.28 0.09 0.21 3.33 3.41 -0.15 0.21 -0.08 -8.04 4.89 -1.51 -1.63 36.1 34.76 14.58 -5.065 0.5 -1.38 0.71 -0.35 1.27 0.015 2.055 3.31 3.25 0.03 34.57 30.21 0.18 -0.28 -0.47 -1.11 -0.11 6.655 -13.46 -1.64 0.68 3.23 1.08 -0.37 0.03 1.19 3.39 3.43 0.025 37.9 32.74 -0.36 -0.19 -0.18 -0.74 0.1 5.665",
  "AGACG 4.83 0.2 15 13.43 0.28 15 -8.81 0.9 27 -1.46 0.1 27 -1.53 0.02 15 -2.02 0.97 27 -2.95 0.46 15 36.41 1.45 27 34.44 0.17 15 -7.44 0.14 21 4.19 -0.01 1.48 -0.79 5.23 4.79 -2.02 -2.97 0.09 0.11 3.3 3.37 -0.21 0.22 -0.03 -8.81 4.19 -1.46 -1.54 36.41 34.61 14.05 -2.705 0.5 0.8 0.99 -0.35 1.69 0.015 6.025 3.31 3.3 0.035 34.57 29.13 0.18 -0.14 -0.47 -1.07 -0.075 6.88 -9.25 -1.64 0.36 3.775 1.08 0.13 0.045 1.315 3.39 3.33 0.04 37.9 30.66 -0.36 -0.34 -0.18 -0.6 0.135 6.625",
  "AGACT 4.57 0.33 7 14.52 0.19 6 -7.81 0.45 7 -1.58 0.05 7 -1.74 0.02 7 -2 1.5 7 -3.59 0.95 7 36.01 0.66 7 34.89 0.31 7 -7.39 0.21 5 4.32 -0.02 2.24 -2.42 2.81 4.59 -2 -3.59 0.09 0.39 3.37 3.48 -0.09 0.18 -0.11 -7.81 6.48 -1.58 -1.74 36.01 34.89 14.54 -5.265 0.5 0.4 3.59 -0.35 -0.05 0.065 4.93 3.31 3.22 0.01 34.57 30.4 0.18 0.12 -0.47 -1.09 -0.11 6.335 -13.615 -1.64 1.62 5.05 1.08 -0.65 0.05 1.175 3.39 3.49 0.03 37.9 33.25 -0.36 -0.17 -0.18 -0.82 0.185 5.49",
  "AGAGA 5 0.27 11 14.56 0.4 8 -6.62 0.81 11 -1.61 0.05 11 -1.76 0.04 11 -1.55 1.48 11 -1.87 1.12 11 35.8 0.63 11 31.7 0.28 11 -7.34 0.29 9 4.22 -0.02 1.63 -2.46 2.57 4.99 -1.55 -1.87 0.06 0 3.36 3.34 -0.14 0.15 -0.08 -6.62 6.57 -1.61 -1.76 35.8 31.7 14.59 0.735 0.5 -1.04 6.43 3.59 4.02 -0.07 9.73 3.53 3.24 0.045 31.77 31.39 0.09 -0.12 -1.55 -0.62 -0.18 6.525 -11.715 -0.7 -1.15 3.96 3.41 5.12 0.065 2.11 3.32 3.36 0.025 33.95 30.19 -0.08 -0.17 -0.49 -0.74 0.05 7",
  "AGAGC 5.04 0.06 9 14.41 0.37 5 -6.5 0.4 9 -1.61 0.05 9 -1.76 0.04 9 -1.41 0.52 9 -2.48 0.36 9 35.84 0.28 9 31.62 0.24 9 -7.25 0.07 7 4.2 -0.02 1.62 -2.51 1.99 5.03 -1.41 -2.48 0.06 -0.1 3.36 3.31 -0.15 0.19 -0.08 -6.5 6.63 -1.61 -1.76 35.84 31.62 14.41 0.195 0.5 0.48 5.48 3.59 4.13 -0.085 7.975 3.53 3.36 0.04 31.77 31.86 0.09 -0.15 -1.55 -0.68 -0.105 6.85 -14.095 -0.7 -2.57 5.11 3.41 4.35 0.075 1.875 3.32 3.45 0.025 33.95 33.22 -0.08 -0.25 -0.49 -0.73 0.1 6.7",
  "AGAGG 4.97 0.25 18 14.5 0.31 15 -6.38 0.79 20 -1.64 0.06 20 -1.84 0.03 18 -1.11 1.21 20 -2.6 1.28 18 35.39 0.8 20 31.44 0.23 18 -7.16 0.31 16 4.12 -0.02 1.61 -2.65 3.19 4.98 -1.11 -2.5 0.06 0.23 3.35 3.35 -0.12 0.21 -0.09 -6.38 6.41 -1.64 -1.84 35.39 31.47 14.68 6.845 0.5 -1.38 0.525 3.59 2.37 -0.22 13.2 3.53 3.3 0.125 31.77 33.79 0.09 0.01 -1.55 -0.71 -0.07 6.795 -9.935 -0.7 -1.82 3.205 3.41 3.61 0.08 1.89 3.32 3.26 0.03 33.95 30.16 -0.08 -0.12 -0.49 -0.81 0.035 7.065",
  "AGAGT 4.86 0.23 6 14.2 0.49 6 -7.83 0.42 6 -1.69 0.04 6 -1.79 0.05 6 -0.84 1.34 6 -1.51 0.51 6 35.66 0.69 6 31.76 0.29 6 -7.36 0.29 3 4.23 -0.03 2.24 -2.8 0.54 4.75 -0.84 -1.51 0.07 0.06 3.42 3.37 -0.15 0.15 -0.16 -7.83 6.88 -1.69 -1.79 35.66 31.76 14.26 2.195 0.5 0.16 7.94 3.59 4.06 -0.12 12.865 3.53 3.48 0.01 31.77 36.4 0.09 0.05 -1.55 -0.96 -0.165 6.64 -14.375 -0.7 -2.53 5.915 3.41 3.33 0.085 1.735 3.32 3.59 0.025 33.95 34.74 -0.08 -0.18 -0.49 -0.88 0.115 6.13",
  "AGATA 4.72 0.33 9 13.95 0.35 8 -8.23 0.53 12 -1.67 0.12 12 -1.52 0.05 12 -1.03 1.75 12 -4.23 0.63 12 36.52 1.29 12 32.48 0.35 12 -7.46 0.25 10 4.34 -0.02 2.29 -0.67 -2.59 4.85 -1.03 -4.23 0.07 -0.13 3.47 3.24 -0.17 -0.07 -0.16 -8.23 6.83 -1.67 -1.52 36.52 32.48 13.84 -8.795 -0.22 -0.48 -1.415 -1.37 -0.09 -0.02 8.165 3.36 3.28 0.065 35.45 31.38 0.08 -0.1 -0.64 -0.95 -0.08 5.75 -11.89 -1.07 0.19 0.395 3.02 0.42 0.06 2.065 3.38 3.23 0.03 34.4 29.64 -0.07 0.03 -0.64 -0.86 0.06 6.645",
  "AGATC 4.36 0.3 35 14.49 0.28 23 -8.23 0.53 55 -1.67 0.04 53 -1.53 0.04 47 -1.69 1.22 53 -5.53 0.83 47 36.68 0.6 53 32.82 0.28 47 -8.19 0.36 44 4.41 -0.02 2.56 -0.26 -1.95 4.37 -1.68 -5.42 0.08 0.19 3.49 3.27 -0.17 -0.03 -0.21 -8.23 5.37 -1.68 -1.54 36.67 32.84 14.67 -9.495 -0.22 -0.42 0.24 -1.37 1.51 -0.01 3.87 3.36 3.21 0.125 35.45 30.42 0.08 -0.05 -0.64 -0.89 -0.175 5.525 -14.39 -1.07 -0.03 1.65 3.02 -1.65 0.095 1.155 3.38 3.37 0.025 34.4 31.48 -0.07 0.01 -0.64 -0.8 0.045 5.95",
  "AGATG 4.66 0.26 59 14.03 0.24 52 -7.85 0.45 65 -1.63 0.05 65 -1.51 0.04 65 -1.27 1.08 65 -5.19 1.04 65 36.48 0.57 65 32.25 0.35 65 -7.78 0.2 51 4.32 -0.02 2.07 0.01 -0.83 4.77 -1.27 -5.19 0.08 -0.14 3.43 3.24 -0.2 0 -0.16 -7.85 6.63 -1.63 -1.51 36.48 32.25 14.03 -8.975 -0.22 0.06 -0.5 -1.37 1.15 -0.005 3.755 3.36 3.23 0.105 35.45 27.88 0.08 -0.12 -0.64 -1.11 -0.08 5.77 -11.75 -1.07 0.38 -1.875 3.02 -0.45 0.065 1.895 3.38 3.21 0.03 34.4 29.55 -0.07 0 -0.64 -0.75 0.025 6.31",
  "AGCAA 5.08 0.31 122 13.52 0.28 114 -3.36 0.46 122 -1.68 0.04 122 -1.42 0.08 122 -3.02 1.12 122 3.78 1.16 122 36.94 0.55 122 34.41 0.46 122 -5.93 0.23 96 4.38 -0.03 0.67 2.3 1.94 5 -3.02 3.78 0.24 0.31 3.45 3.45 0.01 -0.51 0.08 -3.36 6.29 -1.68 -1.42 36.94 34.41 13.63 9.795 1.31 3.97 -2.11 -0.48 3.56 -0.04 6.32 3.31 3.42 -0.07 31.95 34.96 -0.11 0.38 -0.69 0.18 -0.04 6.41 -11.285 1.57 -1.99 -7.365 -1.42 11.7 -0.05 1.83 3.42 2.91 0.01 36.13 21.48 0.5 0.13 -0.34 -0.16 0.09 6.275",
  "AGCAC 5.43 0.18 8 13.39 0.28 8 -3.79 0.29 13 -1.63 0.03 13 -1.36 0.06 11 -1.72 0.45 13 2.81 0.78 11 36.67 0.29 13 34.03 0.46 11 -5.27 0.21 11 4.17 -0.04 0.57 1.1 1.44 5.47 -1.72 2.98 0.25 0.28 3.43 3.3 -0.04 -0.32 0.09 -3.79 5.15 -1.63 -1.39 36.67 33.97 13.94 10.825 1.31 -0.61 -9.84 -0.48 4.05 -0.275 17.5 3.31 3.3 -0.045 31.95 34.03 -0.11 0.15 -0.69 -0.26 -0.01 6.62 -11.73 1.57 0.15 -3.495 -1.42 9.88 -0.06 1.05 3.42 3.14 0.01 36.13 29.37 0.5 0.21 -0.34 -0.22 0.18 6.17",
  "AGCAG 5.16 0.27 22 13.53 0.4 21 -3.6 0.38 24 -1.68 0.03 24 -1.51 0.04 23 -2.72 1.12 24 3.76 0.89 23 36.97 0.43 24 33.86 0.25 23 -5.7 0.38 19 4.29 -0.03 0.62 1.31 1.1 4.96 -2.72 3.81 0.25 0.36 3.45 3.39 -0.03 -0.36 0.08 -3.6 6.41 -1.68 -1.51 36.97 33.85 13.76 6.895 1.31 1.82 -3.42 -0.48 3.42 -0.125 13.02 3.31 3.42 -0.055 31.95 36.9 -0.11 0.1 -0.69 0.08 -0.04 6.375 -10.54 1.57 -0.29 -6.285 -1.42 9.67 -0.035 1.89 3.42 2.88 0.01 36.13 23.83 0.5 0.03 -0.34 -0.16 0.2 6.5",
  "AGCCA 4.53 0.3 27 14.24 0.33 23 -2.76 0.37 29 -1.69 0.04 29 -1.79 0.05 27 -3.86 1.7 29 -2.44 0.91 27 37.62 0.58 29 33.35 0.36 27 -6.02 0.59 23 4.35 -0.03 0.83 -0.86 -0.29 4.52 -3.86 -2.38 0.27 0.43 3.49 3.38 -0.01 -0.14 0.05 -2.76 5.97 -1.69 -1.8 37.62 33.38 14.3 -2.375 -0.03 0.26 4.405 0.71 3.45 -0.125 4.395 3.47 3.37 0.06 33 32.46 0.19 -0.02 -1.1 -0.47 -0.115 6.71 -9.755 -0.58 -1.53 7.145 -0.12 2.87 0.02 1.23 3.53 3.48 0.035 35.84 35.96 0.05 -0.6 -0.81 -0.29 0.165 6.4",
  "AGCCC 4.61 0.22 14 14.63 0.27 11 -2.48 0.45 19 -1.68 0.04 19 -1.82 0.03 18 -2.95 1.12 19 -1.98 0.55 18 37.3 0.43 19 33.51 0.29 18 -5.43 0.2 14 4.23 -0.04 1.03 -0.67 0.64 4.71 -2.95 -1.95 0.28 0.43 3.47 3.4 0.02 -0.12 0.01 -2.48 5.92 -1.68 -1.82 37.3 33.49 14.85 -1.745 -0.03 0.71 10.545 0.71 5.14 -0.11 8.12 3.47 3.65 0.015 33 33.56 0.19 -0.11 -1.1 -1.15 -0.18 7.015 -14.185 -0.58 -0.03 4.945 -0.12 5.1 0.015 0.815 3.53 3.61 0.015 35.84 34.08 0.05 -0.1 -0.81 -0.98 0.125 5.49",
  "AGCCG 4.83 0.12 19 13.85 0.27 16 -3.04 0.29 21 -1.66 0.03 21 -1.77 0.03 21 -2.14 0.47 21 -1.44 0.37 21 37.23 0.34 21 33.27 0.41 21 -5.53 0.14 17 4.17 -0.04 0.95 -0.5 0.77 4.98 -2.14 -1.44 0.27 0.34 3.46 3.38 0 -0.12 0.02 -3.04 6.64 -1.66 -1.77 37.23 33.27 13.97 -0.05 -0.03 1.28 5.675 0.71 6.56 -0.055 7.95 3.47 3.5 0.125 33 33.36 0.19 0.08 -1.1 -1 -0.09 6.98 -9.05 -0.58 -1.21 7.545 -0.12 2.64 0.03 1.13 3.53 3.5 0.035 35.84 36 0.05 -0.57 -0.81 -0.25 0.185 6.57",
  "AGCGA 5.19 0.21 9 13.63 0.27 9 -3.56 0.68 9 -1.65 0.06 9 -1.59 0.1 9 -2.29 1.26 9 4.15 0.43 9 36.83 0.47 9 32.44 0.89 9 -5.16 0.08 7 4.2 -0.03 1.04 -0.05 1.43 5.24 -2.29 4.15 0.24 0.4 3.45 3.4 0 -0.18 0.02 -3.56 6.81 -1.65 -1.59 36.83 32.44 13.69 -3.275 -0.84 -1.84 3.6 1.21 5.54 0.015 -2.895 3.42 3.48 0.08 32.32 36.68 0.07 -0.45 -0.75 0.32 -0.05 6.985 -9.485 1.12 1.44 -3.095 -0.06 10.88 -0.005 0.43 3.45 3.03 0.015 34.64 26.86 0.24 0.1 -0.57 -0.07 0.2 6.885",
  "AGCGC 5.18 0.13 22 13.82 0.14 7 -3.87 0.37 76 -1.64 0.04 76 -1.66 0.03 76 -1.92 0.57 76 2.89 0.53 76 36.76 0.38 76 32.08 0.31 76 -5.21 0.2 62 4.11 -0.03 1.09 0.01 1.32 5.26 -1.92 2.89 0.25 0.44 3.44 3.37 -0.01 -0.02 0.02 -3.87 4.75 -1.64 -1.66 36.76 32.08 14.45 -4.49 -0.84 -4.78 -0.04 1.21 5.04 -0.065 0.92 3.42 -0.63 0.04 32.32 10.97 0.07 -2.27 -0.75 -0.62 -0.09 6.845 -11.295 1.12 0.09 -1.62 -0.06 9.7 -0.015 0.1 3.45 3.17 0.01 34.64 30.33 0.24 0.01 -0.57 -0.1 0.225 6.395",
  "AGCGG 5.15 0.2 9 13.62 0.19 8 -3.78 0.16 11 -1.63 0.02 11 -1.65 0.03 9 -1.9 0.54 11 2.44 0.43 9 36.72 0.36 11 32.34 0.23 9 -5 0.14 9 4.13 -0.03 1.25 -0.36 2 5.17 -1.9 2.65 0.25 0.47 3.43 3.39 0 -0.05 0 -3.78 6.07 -1.63 -1.67 36.72 32.32 14.01 -7.075 -0.84 -0.18 0.955 1.21 0.81 -0.035 1.145 3.42 3.37 0.11 32.32 36.72 0.07 0.14 -0.75 0.09 0 7.08 -7.4 1.12 0.43 -5.305 -0.06 8.69 -0.03 0.565 3.45 2.81 0.025 34.64 23.6 0.24 0.05 -0.57 -0.12 0.21 6.985",
  "AGCGT 4.86 0.26 9 13.64 0.19 8 -3.93 0.19 9 -1.65 0.04 9 -1.69 0.04 9 -2.63 0.98 9 3.7 0.39 9 37.02 0.51 9 33 0.3 9 -5.17 0.2 7 4.25 -0.03 1.18 0.34 1.77 4.9 -2.63 3.7 0.27 0.5 3.45 3.49 -0.01 -0.08 -0.01 -3.93 6.69 -1.65 -1.69 37.02 33 13.6 -6.725 -0.84 -0.81 0.27 1.21 6.61 -0.07 1.05 3.42 3.55 0.07 32.32 36.65 0.07 -0.19 -0.75 -0.3 -0.065 6.985 -11.785 1.12 1.24 -0.655 -0.06 8.92 0.01 0.175 3.45 3.4 0.005 34.64 35.4 0.24 0.21 -0.57 -0.19 0.195 6.24",
  "AGCTA 4.88 0.16 17 14.2 0.21 15 -1.3 0.25 19 -1.76 0.03 19 -1.77 0.03 19 -2.66 0.63 19 -2.32 0.45 19 37.56 0.29 19 31.13 0.18 19 -5.53 0.19 15 4.24 -0.02 -0.08 1.47 -2.94 5.02 -2.66 -2.32 0.25 0.32 3.52 3.28 -0.02 -0.25 0.14 -1.3 6.67 -1.76 -1.77 37.56 31.13 14.29 -6.765 1.42 0.52 1.57 1.07 1.42 -0.14 0.16 3.63 3.24 0.075 34.84 32.66 0.28 -0.01 -1.09 -0.7 0.03 6.45 -11.71 0 -3.2 6.305 -0.63 1.56 0.06 2.595 3.57 3.32 0.03 36.01 34.92 0.01 -0.62 -0.85 -0.28 0.235 6.155",
  "AGCTC 4.63 0.11 16 14.63 0.22 10 -0.83 0.33 21 -1.77 0.04 21 -1.78 0.02 19 -3.25 0.55 21 -2.86 0.54 19 37.66 0.18 21 31.33 0.15 19 -5.79 0.22 17 4.3 -0.02 0.03 1.97 -2.49 4.72 -3.25 -2.73 0.25 0.35 3.53 3.33 0.01 -0.24 0.12 -0.83 5.62 -1.77 -1.79 37.66 31.34 14.79 -8.885 1.42 0.48 2.555 1.07 4.13 -0.155 1.225 3.63 3.36 0.085 34.84 31.86 0.28 -0.15 -1.09 -0.68 0.05 6.585 -16.245 0 -2.57 6.095 -0.63 4.35 0.08 1.805 3.57 3.45 0.025 36.01 33.22 0.01 -0.25 -0.85 -0.73 0.23 5.76",
  "AGCTG 4.8 0.19 6 14.01 0.23 6 -1.38 0.4 12 -1.76 0.03 10 -1.73 0.04 10 -2.49 0.43 10 -2.54 0.51 10 37.48 0.28 10 31.01 0.3 10 -5.64 0.27 9 4.29 -0.02 0.02 2.25 -2.22 4.83 -2.57 -2.34 0.24 0.28 3.52 3.32 -0.01 -0.27 0.12 -1.38 4.47 -1.76 -1.74 37.52 31.1 14.53 -5.59 1.42 -0.88 2.285 1.07 2.66 -0.195 4.91 3.63 3.35 0.08 34.84 31.67 0.28 -0.23 -1.09 -0.63 0.085 6.775 -10.445 0 -3.59 7.115 -0.63 0.33 0.05 2.08 3.57 3.35 0.03 36.01 35.72 0.01 -0.61 -0.85 -0.23 0.21 6.375",
  "AGGAA 4.76 0.22 11 14.41 0.28 9 -4.88 0.57 19 -1.86 0.05 17 -1.45 0.09 19 -1.44 0.83 17 -1.3 1.05 19 34.39 0.56 17 36.26 0.98 19 -5.71 0.24 15 4.38 -0.05 1.82 1.67 -0.45 4.75 -1.43 -1.3 -0.31 0.31 3.5 3.36 0.06 -0.3 -0.05 -4.88 5.49 -1.86 -1.45 34.41 36.26 14.61 0.17 0.38 -0.78 4.795 4.06 3.61 0.035 -0.535 3.51 3.33 0.095 33.87 33.12 0.02 -0.18 -0.87 -0.66 -0.13 6.165 -8.76 2.03 -0.52 2.935 6.08 3.33 0.01 0.945 3.49 3.27 0.015 31.5 33.83 0.11 -0.21 -0.85 -0.27 -0.015 6.455",
  "AGGAC 4.81 0.11 16 14.36 0.23 11 -5.39 0.68 16 -1.83 0.04 16 -1.42 0.06 16 -0.96 0.44 16 -2.19 0.61 16 34.49 0.37 16 36.03 0.49 16 -5.48 0.18 14 4.31 -0.05 1.76 0.27 -0.59 4.87 -0.96 -2.19 -0.31 0.37 3.49 3.24 0.03 -0.19 -0.05 -5.39 6.56 -1.83 -1.42 34.49 36.03 14.37 -3.82 0.38 -0.67 1.195 4.06 1.91 -0.065 4.35 3.51 3.21 0.105 33.87 33.89 0.02 -0.06 -0.87 -0.63 -0.11 6.46 -10.99 2.03 -2.03 4.005 6.08 1.62 0.015 0.935 3.49 3.36 0.015 31.5 37.52 0.11 -0.31 -0.85 -0.2 0.045 6.205",
  "AGGAG 4.63 0.19 10 14.51 0.17 7 -4.81 0.32 10 -1.88 0.02 10 -1.51 0.04 10 -1.32 0.71 10 -2.62 1.02 10 34.13 0.25 10 36.23 0.43 10 -5.59 0.21 8 4.31 -0.05 1.9 0.47 -0.81 4.61 -1.32 -2.62 -0.31 0.43 3.5 3.3 0.04 -0.12 -0.07 -4.81 6.37 -1.88 -1.51 34.13 36.23 14.61 4.105 0.38 0.62 -3.78 4.06 3.94 -0.085 6.745 3.51 3.27 0.195 33.87 35.11 0.02 0.28 -0.87 -0.35 -0.095 6.645 -8.115 2.03 -1.85 1.575 6.08 3.18 0.015 0.88 3.49 3.21 0.02 31.5 33.48 0.11 -0.18 -0.85 -0.37 -0.045 6.675",
  "AGGCA 4.82 0.14 25 14.34 0.31 19 -2.38 0.39 35 -1.85 0.05 29 -1.64 0.03 35 -2.06 0.96 29 -2.41 0.82 35 34.03 0.54 29 36.26 0.33 35 -5.2 0.19 26 4.23 -0.04 1.19 -0.5 0.41 4.92 -2.04 -2.41 -0.3 0.44 3.43 3.4 0.08 -0.03 0.03 -2.38 5.84 -1.87 -1.64 34.05 36.26 14.45 0.715 -0.99 -1.98 6.67 2.03 1.75 -0.07 8.995 3.59 3.19 0.075 31.99 31 0.03 -0.09 -0.33 -0.63 -0.11 7.095 -13.9 0.61 0.32 1.33 5.32 -0.68 0.01 0.61 3.64 3.37 0.015 34.58 35.57 -0.13 0.31 -1.02 -0.36 0.17 5.505",
  "AGGCC 4.72 0.17 18 14.74 0.29 17 -2.2 0.38 21 -1.9 0.04 21 -1.66 0.04 18 -1.89 0.89 21 -2.34 0.77 18 33.71 0.38 21 36.64 0.35 18 -5.29 0.27 17 4.21 -0.04 1.38 -0.28 0.4 4.74 -1.89 -2.37 -0.3 0.46 3.44 3.43 0.09 -0.04 0 -2.2 5.96 -1.9 -1.67 33.71 36.64 14.85 -0.305 -0.99 -0.12 5.28 2.03 4.74 -0.035 7.415 3.59 3.3 0.125 31.99 30.88 0.03 -0.18 -0.33 -1.21 -0.105 7.455 -14.14 0.61 0.04 7.07 5.32 0 0.04 0.825 3.64 3.48 0.02 34.58 35.5 -0.13 0 -1.02 -0.71 0.22 5.48",
  "AGGCG 4.77 0.1 26 14.13 0.29 24 -2.82 0.27 26 -1.85 0.03 26 -1.59 0.03 26 -2.1 0.68 26 -2.16 0.39 26 34.34 0.37 26 36.31 0.21 26 -5.21 0.11 21 4.2 -0.04 1.3 -0.14 0.23 4.95 -2.1 -2.16 -0.3 0.4 3.44 3.4 0.08 -0.05 0.02 -2.82 6.87 -1.85 -1.6 34.33 36.31 14.03 3.655 -0.99 0.05 5.655 2.03 -1.11 -0.035 11.8 3.59 3.24 0.1 31.99 27.86 0.03 0.2 -0.33 -0.51 -0.095 7.305 -13.57 0.61 -0.2 0.69 5.32 -0.95 0.015 0.56 3.64 3.39 0.015 34.58 35.49 -0.13 0.26 -1.02 -0.36 0.16 5.56",
  "AGGCT 4.33 0.17 7 14.97 0.31 6 -2.34 0.24 9 -1.89 0.04 7 -1.72 0.03 9 -2.71 0.65 7 -3.85 0.78 9 34 0.45 7 37.47 0.46 9 -5.6 0.19 7 4.33 -0.04 1.62 -1.23 -0.24 4.43 -2.59 -3.85 -0.29 0.54 3.49 3.5 0.14 -0.05 -0.01 -2.34 5.12 -1.9 -1.72 34.05 37.47 15.03 3.05 -0.99 -0.03 10.075 2.03 0.71 -0.1 11.3 3.59 3.47 0.1 31.99 33 0.03 0.19 -0.33 -1.1 -0.085 6.92 -14.125 0.61 -0.58 6.585 5.32 -0.12 0.035 0.82 3.64 3.53 0.02 34.58 35.84 -0.13 0.05 -1.02 -0.81 0.21 5.43",
  "AGGGA 4.68 0.17 16 14.83 0.28 13 -1.76 0.57 19 -1.92 0.05 19 -1.86 0.11 19 -2.51 1.19 19 -1.61 1.72 19 33.86 0.46 19 33.6 1.36 19 -5.38 0.33 13 4.22 -0.04 1.05 0.92 1.39 4.67 -2.51 -1.61 -0.3 0.37 3.43 3.47 0.13 0.04 0.02 -1.76 6.51 -1.92 -1.86 33.86 33.6 14.91 -6.825 -1.32 -0.21 5.155 3.56 6.31 -0.1 4.56 3.49 3.44 0.055 34.59 31.55 -0.08 -0.12 -0.79 -0.75 -0.02 7.23 -7.315 0.76 1.03 3.51 5.78 6.53 0.005 0.685 3.46 3.44 0.015 32.29 30.36 0.03 0.02 -0.97 -0.92 -0.005 6.92",
  "AGGGC 4.73 0.06 8 14.88 0.08 5 -1.88 0.48 8 -1.9 0.02 8 -1.84 0.03 8 -2.27 0.48 8 -2.16 0.34 8 34 0.2 8 33.54 0.24 8 -5.05 0.19 6 4.21 -0.05 1.13 0.34 1.06 4.76 -2.27 -2.16 -0.3 0.37 3.45 3.4 0.12 0.06 0.01 -1.88 6.55 -1.9 -1.84 34 33.54 14.89 -6.36 -1.32 0.71 9.33 3.56 5.14 -0.165 7.855 3.49 3.65 0 34.59 33.56 -0.08 -0.11 -0.79 -1.15 -0.1 7.24 -10.25 0.76 -0.03 6.235 5.78 5.1 0.015 0.78 3.46 3.61 0.015 32.29 34.08 0.03 -0.1 -0.97 -0.98 0.105 6.39",
  "AGGGG 4.62 0.09 11 14.99 0.12 10 -1.32 0.24 11 -1.92 0.02 11 -1.88 0.03 11 -2.55 0.39 11 -2.41 0.4 11 33.78 0.24 11 33.61 0.23 11 -5.38 0.15 9 4.18 -0.04 1.07 0.25 1.73 4.68 -2.55 -2.41 -0.31 0.43 3.44 3.42 0.13 0.06 0.01 -1.32 6.62 -1.92 -1.88 33.78 33.61 15.05 -18.18 -1.32 -1.81 14.64 3.56 6.69 -0.315 14.59 3.49 3.39 0.06 34.59 33.69 -0.08 -0.39 -0.79 -0.6 -0.085 6.83 -5.145 0.76 0.17 2.24 5.78 5.94 0.01 0.545 3.46 3.37 0.015 32.29 30.11 0.03 0.05 -0.97 -1.15 -0.085 7.255",
  "AGGGT 4.29 0.19 22 15.01 0.32 20 -2.62 0.48 45 -1.93 0.04 25 -1.85 0.04 45 -3.17 1.02 25 -2.05 0.79 45 34.17 0.41 25 34.42 0.43 45 -5.71 0.33 36 4.29 -0.05 1.26 0.5 0.03 4.36 -2.82 -2.05 -0.3 0.46 3.51 3.48 0.1 0 -0.02 -2.62 4.32 -1.95 -1.85 34.18 34.42 15.21 -7.995 -1.32 1.11 3.325 3.56 3.17 -0.125 3.815 3.49 3.65 0.015 34.59 35.52 -0.08 -0.03 -0.79 -1.38 -0.045 6.58 -9.56 0.76 0.43 5.61 5.78 5.47 0.01 0.835 3.46 3.68 0.015 32.29 33.67 0.03 0.01 -0.97 -1.23 0.06 6.41",
  "AGGTA 4.33 0.4 50 14.45 0.43 30 -5.43 0.6 53 -1.89 0.03 53 -1.56 0.11 53 -2.81 1.74 53 -4.49 2.05 53 35.24 0.67 53 34.69 0.66 53 -5.71 0.29 39 4.4 -0.04 1.7 -0.08 -3.92 4.57 -2.81 -4.49 -0.3 0.56 3.56 3.36 0.03 -0.28 -0.02 -5.43 6.37 -1.89 -1.56 35.24 34.69 14.28 -6.675 -0.43 0.49 -4.175 4.12 0.32 -0.08 5.92 3.6 3.29 0.07 34.54 30.81 -0.01 0.02 -1.17 -1.15 -0.16 6.205 -13.235 1.01 0.77 -0.985 5.04 -1.44 -0.01 1.115 3.69 3.27 0.025 34.51 32.83 -0.03 0.08 -1.2 -0.52 0.12 5.435",
  "AGGTC 4.18 0.22 109 14.54 0.3 73 -5.67 0.6 128 -1.94 0.04 128 -1.59 0.04 128 -2.46 1.03 128 -3.96 0.68 128 35.04 0.62 128 34.84 0.26 128 -6 0.27 98 4.44 -0.04 2 0.4 -4.5 4.25 -2.46 -3.96 -0.3 0.61 3.58 3.4 0.04 -0.3 -0.07 -5.67 5.88 -1.94 -1.59 35.04 34.84 14.56 -6.74 -0.43 -1.38 -4.845 4.12 1.27 -0.085 3.9 3.6 3.25 0.08 34.54 30.21 -0.01 -0.28 -1.17 -1.11 -0.18 6.535 -14.38 1.01 0.68 2.95 5.04 -0.37 0.005 1.125 3.69 3.43 0.02 34.51 32.74 -0.03 -0.19 -1.2 -0.74 0.165 5.41",
  "AGGTG 4.42 0.14 10 13.98 0.22 9 -6.64 0.54 10 -1.92 0.03 10 -1.53 0.02 10 -1.65 0.45 10 -3.26 0.35 10 35.25 0.31 10 34.31 0.18 10 -5.6 0.14 8 4.41 -0.03 1.91 0.48 -5.17 4.44 -1.65 -3.26 -0.3 0.58 3.58 3.37 0 -0.34 -0.07 -6.64 6.2 -1.92 -1.53 35.25 34.31 14.17 1 -0.43 -0.05 -11.795 4.12 1.73 -0.275 15.76 3.6 3.35 0.065 34.54 32.09 -0.01 0.05 -1.17 -1.18 -0.22 6.575 -12.91 1.01 1.04 -2.04 5.04 -1.99 -0.005 1.035 3.69 3.29 0.025 34.51 33.57 -0.03 0.12 -1.2 -0.51 0.08 5.52",
  "AGTAA 5.37 0.65 79 13.28 0.46 75 -7.55 1.48 82 -1.66 0.12 82 -1.35 0.16 82 -3.91 2.67 82 5.33 2.59 82 34.75 0.62 82 34.55 0.94 82 -7.46 0.39 62 4.25 -0.02 1.35 1.36 0.12 5.19 -3.91 5.33 -0.13 -0.75 3.41 3.36 -0.23 -0.16 0.06 -7.55 6.67 -1.66 -1.35 34.75 34.55 13.44 -4.8 -0.78 -0.16 2.735 0.4 5.23 0.025 -0.42 3.28 3.46 0.045 29.92 36.67 -0.09 -0.11 -1.17 -0.24 -0.145 6.875 -10.08 1.81 1.75 -3.165 -2.16 10.32 -0.045 1.84 3.33 3.06 0.02 33.24 26.12 0.25 0.12 -0.57 -0.16 0.19 5.99",
  "AGTAC 5.54 0.4 16 13.12 0.45 12 -8.16 1.03 37 -1.63 0.05 36 -1.39 0.06 37 -2.73 1.75 36 4.94 1.07 37 34.74 0.53 36 33.82 0.83 37 -6.89 0.25 31 4 -0.03 1.52 -0.11 -0.49 5.67 -2.74 4.94 -0.12 -0.96 3.4 3.23 -0.23 -0.04 0.05 -8.16 5.22 -1.63 -1.39 34.76 33.82 14.03 -6.08 -0.78 -0.38 -1.175 0.4 2.63 -0.045 3.18 3.28 3.4 0.04 29.92 28.05 -0.09 -0.1 -1.17 -0.03 -0.1 6.655 -12.27 1.81 0.05 -2.98 -2.16 8.27 -0.05 1.74 3.33 3.2 0.02 33.24 32.49 0.25 0.04 -0.57 -0.15 0.195 6.005",
  "AGTAG 5.2 0.34 20 13.42 0.38 19 -8.16 0.8 21 -1.71 0.05 21 -1.43 0.09 20 -4.12 1.66 21 4.64 2.3 20 35.18 0.44 21 34.13 1.15 20 -7.43 0.35 17 4.3 -0.02 1.49 0.14 -2.32 4.78 -4.12 4.77 -0.12 -0.46 3.44 3.3 -0.24 -0.06 0.03 -8.16 6.45 -1.71 -1.43 35.18 34.11 13.7 -6.23 -0.78 -1.11 -0.315 0.4 1.1 -0.065 2.11 3.28 3.38 0.075 29.92 36.22 -0.09 0.04 -1.17 -0.28 -0.145 7.16 -10.105 1.81 -0.14 -4.73 -2.16 8.66 -0.06 1.6 3.33 2.99 0.02 33.24 27.73 0.25 0.26 -0.57 -0.13 0.165 6.15",
  "AGTCA 4.89 0.47 78 13.84 0.41 73 -8.11 0.48 78 -1.68 0.08 78 -1.47 0.06 78 -3.69 2.08 78 -1.77 1.41 78 35.06 0.64 78 35.14 0.63 78 -7.61 0.55 58 4.34 -0.02 1.88 -0.87 -2.75 4.72 -3.69 -1.77 -0.11 -0.23 3.46 3.25 -0.24 0.13 -0.02 -8.11 6.64 -1.68 -1.47 35.06 35.14 13.97 -6.96 0.4 1.57 2.11 -0.05 1.92 0.03 4 3.22 3.25 0.035 30.4 35.01 0.12 0.14 -1.09 -0.09 -0.12 6.5 -11.56 1.62 -2.37 5.335 -0.65 0.51 0.035 1.43 3.49 3.39 0.035 33.25 38.79 -0.17 -0.65 -0.82 0.16 0.15 6.035",
  "AGTCC 4.51 0.26 10 14.42 0.27 5 -7.34 0.29 17 -1.72 0.03 15 -1.48 0.04 15 -4.26 1.11 15 -2.46 0.66 15 34.97 0.38 15 35.78 0.42 15 -7.68 0.25 15 4.29 -0.01 2.09 -0.84 -2.6 4.53 -4.22 -2.4 -0.1 0.29 3.48 3.28 -0.2 0.09 -0.05 -7.34 4.93 -1.73 -1.49 34.99 35.75 14.86 -7.435 0.4 -0.67 2.41 -0.05 1.91 -0.04 7.435 3.22 3.21 0.04 30.4 33.89 0.12 -0.06 -1.09 -0.63 -0.12 6.535 -15.015 1.62 -2.03 1.85 -0.65 1.62 0.035 1.165 3.49 3.36 0.025 33.25 37.52 -0.17 -0.31 -0.82 -0.2 0.11 5.365",
  "AGTCG 4.59 0.3 82 13.76 0.39 76 -8.15 0.7 82 -1.72 0.05 82 -1.41 0.06 82 -4.46 1.38 82 -2.31 1.09 82 35.27 0.43 82 35.38 0.71 82 -7.96 0.44 65 4.38 -0.02 1.82 -0.42 -3.72 4.51 -4.46 -2.31 -0.12 -0.12 3.48 3.23 -0.26 0.07 -0.01 -8.15 6.35 -1.72 -1.41 35.27 35.38 13.95 -3.575 0.4 -1.77 5.515 -0.05 0.35 0.105 0.655 3.22 3.38 0.065 30.4 32.95 0.12 -0.4 -1.09 -0.48 -0.09 6.81 -10.76 1.62 -2.22 5.94 -0.65 0.43 0.035 1.38 3.49 3.39 0.04 33.25 38.87 -0.17 -0.69 -0.82 0.19 0.17 6.315",
  "AGTGA 5.22 0.32 29 13.67 0.55 26 -7.1 1.21 29 -1.67 0.1 29 -1.47 0.1 29 -3.58 1.48 29 3.56 1.45 29 34.23 1.09 29 33.87 0.98 29 -7.2 0.3 23 4.12 -0.03 1.91 -0.82 -0.15 5.26 -3.58 3.56 -0.12 -0.38 3.42 3.36 -0.24 0.24 -0.04 -7.1 6.94 -1.67 -1.47 34.23 33.87 13.56 -8.92 0.23 -1.2 1.55 2.61 4.14 -0.005 3.94 3.37 3.28 0.01 30.45 34.75 0 -0.12 -1.09 0.34 -0.065 6.81 -10.12 2.38 1 -5.54 -3.54 10.63 -0.04 1.335 3.4 2.95 0.02 34.76 23.47 0.35 0.19 -0.48 -0.09 0.145 6.08",
  "AGTGC 5.3 0.23 13 13.35 0.26 11 -7.68 0.34 13 -1.66 0.04 13 -1.36 0.08 13 -3.54 1.2 13 2.74 0.8 13 34.58 0.36 13 33.99 0.39 13 -7.05 0.25 11 4.17 -0.03 1.99 -1.33 -2.51 5.18 -3.54 2.74 -0.12 -0.4 3.44 3.25 -0.26 0.22 -0.03 -7.68 6.91 -1.66 -1.36 34.58 33.99 13.45 -2.395 0.23 -0.61 -3.645 2.61 4.05 -0.16 10.49 3.37 3.3 0.045 30.45 34.03 0 0.15 -1.09 -0.26 -0.07 6.87 -12.36 2.38 0.15 -4.64 -3.54 9.88 -0.04 1.335 3.4 3.14 0.02 34.76 29.37 0.35 0.21 -0.48 -0.22 0.16 6.05",
  "AGTGG 5.31 0.17 10 13.51 0.3 10 -7.4 0.5 12 -1.62 0.05 12 -1.42 0.04 10 -2.95 0.52 12 2.64 0.85 10 34.38 0.28 12 34.11 0.28 10 -6.85 0.24 10 4.09 -0.03 2.21 -1.39 -0.51 5.33 -2.95 2.92 -0.11 -0.36 3.41 3.32 -0.21 0.25 -0.06 -7.4 6.07 -1.62 -1.43 34.38 34.1 13.83 -8.02 0.23 -1.4 1.395 2.61 5.18 -0.04 3.595 3.37 3.36 0.02 30.45 35.26 0 -0.01 -1.09 -0.18 -0.065 7.15 -9.725 2.38 -0.29 -6.16 -3.54 9.42 -0.05 1.21 3.4 2.93 0.02 34.76 25.46 0.35 0.26 -0.48 -0.17 0.12 6.31",
  "AGTGT 5.1 0.32 8 13.48 0.34 7 -8.48 1 9 -1.68 0.04 8 -1.38 0.09 9 -3.51 0.83 8 3.69 1.75 9 34.67 0.43 8 34.61 0.66 9 -7.06 0.17 6 4.21 -0.03 1.86 -1.03 -3.09 4.98 -3.59 3.69 -0.11 -0.3 3.44 3.37 -0.33 0.22 -0.06 -8.48 6.32 -1.72 -1.38 34.27 34.61 13.57 -5.435 0.23 1.38 2.28 2.61 6.67 -0.02 6.265 3.37 3.43 0.015 30.45 36.74 0 0.33 -1.09 -0.22 -0.095 6.555 -12.995 2.38 0.73 -3.95 -3.54 9.43 -0.045 1.36 3.4 3.36 0.02 34.76 33.76 0.35 0.31 -0.48 -0.34 0.13 5.885",
  "AGTTA 4.67 0.32 33 13.55 0.45 26 -10.74 0.65 36 -1.72 0.06 36 -1.21 0.05 36 -3.98 1.76 36 -3.3 0.99 36 35.6 0.67 36 34.85 0.59 36 -7.89 0.35 27 4.48 -0.03 1.35 1.19 -7.51 4.53 -3.98 -3.3 -0.16 -1.05 3.52 3.1 -0.39 0.04 0.06 -10.74 6.43 -1.72 -1.21 35.6 34.85 13.71 -4.315 0.46 0.25 3.055 -0.13 3.24 0.015 1.5 3.34 3.12 0.06 32.04 31.75 0.02 0.14 -1.36 -0.64 -0.085 5.36 -12.605 1.16 -3.39 2.985 -1.05 -0.75 0.06 2.675 3.49 3.27 0.03 33.51 36.43 -0.1 -0.57 -0.88 -0.08 0.1 5.87",
  "AGTTC 4.25 0.21 16 13.67 0.37 11 -10.45 0.86 19 -1.74 0.05 19 -1.19 0.04 19 -4.54 1.19 19 -3.79 0.58 19 35.93 0.37 19 35.24 0.34 19 -8.35 0.21 14 4.55 -0.01 1.5 1.72 -8.02 4.11 -4.54 -3.79 -0.16 -0.64 3.54 3.12 -0.36 0.01 0.04 -10.45 5.56 -1.74 -1.19 35.93 35.24 13.98 -4.085 0.46 -0.08 5.175 -0.13 -0.22 0.085 -4.07 3.34 3.24 0.02 32.04 34.75 0.02 0.02 -1.36 -0.62 -0.065 4.98 -16.775 1.16 -2.66 3.075 -1.05 1.29 0.08 1.925 3.49 3.35 0.025 33.51 35.61 -0.1 -0.2 -0.88 -0.38 0.11 5.16",
  "AGTTG 4.38 0.32 9 13.39 0.36 8 -11.29 1.2 9 -1.74 0.02 9 -1.17 0.05 9 -4.47 0.91 9 -3.88 0.85 9 36.24 0.63 9 34.76 0.46 9 -8.34 0.69 8 4.35 -0.02 1.37 1.88 -9.26 4.84 -4.47 -3.88 -0.16 -1.03 3.55 3.11 -0.41 -0.07 0.06 -11.29 6.04 -1.74 -1.17 36.24 34.76 13.27 -7.935 0.46 0.28 3.585 -0.13 2.59 0.03 0.78 3.34 3.15 0.07 32.04 33.65 0.02 0.16 -1.36 -0.56 -0.025 5.86 -11.435 1.16 -3.66 4.345 -1.05 -1.25 0.055 2.42 3.49 3.3 0.025 33.51 37.43 -0.1 -0.68 -0.88 0.02 0.065 6.12",
  "ATAAA 5.66 0.43 353 12.32 0.38 346 -12.37 1.36 353 -1.35 0.11 353 -1.05 0.05 353 8.13 2.21 353 -0.95 1.36 353 34.6 1.14 353 35.94 0.44 353 -7.46 0.33 280 4.24 -0.02 1.32 -1.16 0.84 5.66 8.13 -0.95 0.08 -1.11 3.46 3.19 -0.13 -0.26 -0.25 -12.37 6.71 -1.35 -1.05 34.6 35.94 12.38 -5.855 -0.11 -0.07 2.05 0.54 2.76 -0.01 2.475 3.42 3.06 0.05 37.82 32.53 0.03 -0.03 -0.27 -0.49 -0.175 5.455 -11.895 1.94 -2.08 5.18 10.51 0.98 0.025 4.265 3.27 3.32 0.03 29.6 35.05 0.05 -0.44 -0.34 -0.22 0.01 6.29",
  "ATAAC 5.62 0.37 14 13.31 0.17 6 -10.51 0.49 14 -1.31 0.08 14 -1.13 0.04 14 6.14 2.67 14 -3.5 0.58 14 34.54 1.95 14 35.5 0.38 14 -7.36 0.42 12 4.23 -0.03 1.34 -1.51 2.01 5.67 6.14 -3.5 0.1 -1.34 3.37 3.09 -0.1 -0.07 -0.15 -10.51 6.49 -1.31 -1.13 34.54 35.5 13.11 -4.845 -0.11 0.25 1.8 0.54 3.24 -0.035 7.47 3.42 3.12 0.03 37.82 31.75 0.03 0.14 -0.27 -0.64 -0.155 5.65 -10.405 1.94 -3.39 5.43 10.51 -0.75 0.025 4.04 3.27 3.27 0.035 29.6 36.43 0.05 -0.57 -0.34 -0.08 0.035 6.61",
  "ATAAG 5.48 0.06 5 13.38 0.15 5 -10.54 0.52 19 -1.41 0.08 19 -1.28 0.12 19 6.31 1.39 19 -3.47 0.78 19 35.15 0.75 19 35.03 1.29 19 -7.46 0.27 16 4.26 -0.03 1.34 -1.81 -1 5.18 6.31 -3.47 0.1 -1.08 3.46 3.11 -0.11 -0.01 -0.23 -10.54 6.1 -1.41 -1.28 35.15 35.03 13.78 -0.415 -0.11 -0.17 -1.335 0.54 -1.34 -0.02 11.835 3.42 3.23 0.035 37.82 33.71 0.03 -0.07 -0.27 -0.55 -0.1 5.78 -10.925 1.94 -3.36 6.675 10.51 -0.07 0.02 4.5 3.27 3.29 0.04 29.6 36.23 0.05 -0.5 -0.34 -0.09 0.05 6.58",
  "ATAAT 5.28 0.28 27 13.2 0.34 23 -11.27 0.92 30 -1.41 0.06 30 -1.22 0.06 30 6.41 1.71 30 -2.76 1.28 30 35.02 0.65 30 35.9 0.39 30 -7.69 0.32 24 4.34 -0.02 1.54 -1.86 -1.21 5.18 6.41 -2.76 0.1 -1 3.45 3.18 -0.09 -0.14 -0.23 -11.27 6.45 -1.41 -1.22 35.02 35.9 13.15 -7.125 -0.11 0.49 -1.475 0.54 0.11 -0.045 8.835 3.42 3.26 -0.025 37.82 34.83 0.03 0.01 -0.27 -0.71 -0.19 5.205 -11.22 1.94 -3.34 3.74 10.51 -0.16 0.025 4.295 3.27 3.3 0.035 29.6 36.99 0.05 -0.63 -0.34 -0.17 0.03 6.46",
  "ATACA 5.82 0.27 23 12.57 0.53 21 -8.93 1.27 24 -1.35 0.07 23 -1.53 0.04 24 5.89 2.07 23 -2.07 1.01 24 34.63 1.26 23 34.26 0.29 24 -6.9 0.29 20 4.06 -0.03 -0.3 -0.61 3.64 5.73 5.96 -2.07 0.11 -0.93 3.29 3.33 -0.03 0.27 0.05 -8.93 7.06 -1.35 -1.53 34.63 34.26 12.74 -0.465 -2.31 0.3 1.775 6.23 3.68 0.05 4.05 4.17 3.19 0.03 37.58 28.75 0.21 -0.1 -0.85 -0.85 -0.155 6.81 -10.44 0.31 0.33 -4.965 8.55 0.51 -0.055 2.21 3.3 3.28 0.035 33.49 30.55 0.06 -0.09 -0.36 -0.66 0.085 6.425",
  "ATACC 5.46 0.23 14 13.26 0.37 11 -8.36 0.3 24 -1.4 0.05 24 -1.56 0.03 15 5.39 0.94 24 -2.59 0.56 15 34.56 0.46 24 34.69 0.18 15 -7.03 0.19 20 4.06 -0.03 0.05 -0.69 3.27 5.48 5.39 -2.61 0.11 -0.57 3.31 3.37 0.02 0.24 0 -8.36 5 -1.4 -1.59 34.56 34.7 14 -2.64 -2.31 0.49 0.14 6.23 0.32 0.01 4.205 4.17 3.29 0.035 37.58 30.81 0.21 0.02 -0.85 -1.15 -0.105 6.535 -12.15 0.31 0.77 -6.39 8.55 -1.44 -0.065 2.025 3.3 3.27 0.03 33.49 32.83 0.06 0.08 -0.36 -0.52 0.065 5.96",
  "ATACG 5.53 0.19 10 12.38 0.48 9 -9.05 0.35 68 -1.38 0.05 68 -1.51 0.04 11 5.89 0.86 68 -2.22 0.46 11 34.59 0.54 68 34.16 0.31 11 -6.78 0.14 54 3.99 -0.02 0.07 -0.54 3.3 5.65 5.89 -2.28 0.11 -0.6 3.32 3.34 0 0.23 0 -9.05 2.8 -1.38 -1.54 34.59 34.55 14.51 -1.53 -2.31 0.75 0.35 6.23 3.92 0.08 2.295 4.17 3.13 0.05 37.58 26.92 0.21 0.03 -0.85 -0.45 -0.065 7.35 -10.62 0.31 0.18 -4.51 8.55 0.77 -0.055 2.195 3.3 3.27 0.035 33.49 30.04 0.06 -0.1 -0.36 -0.56 0.105 6.43",
  "ATACT 5.37 0.3 12 13.57 0.36 5 -8.21 0.81 12 -1.48 0.06 12 -1.69 0.04 12 6.22 1.31 12 -2.71 0.89 12 34.44 0.47 12 34.73 0.39 12 -7.14 0.15 9 4.2 -0.03 -0.09 -1.97 0.64 5.13 6.22 -2.71 0.11 -0.35 3.41 3.42 0.05 0.16 -0.03 -8.21 6.94 -1.48 -1.69 34.44 34.73 13.49 -3.465 -2.31 -0.78 -0.805 6.23 0.4 -0.03 3.69 4.17 3.28 0.065 37.58 29.92 0.21 -0.09 -0.85 -1.17 -0.125 6.95 -12.12 0.31 1.81 -3.665 8.55 -2.16 -0.05 1.805 3.3 3.33 0.02 33.49 33.24 0.06 0.25 -0.36 -0.57 0.18 5.855",
  "ATAGA 5.69 0.19 14 13.3 0.37 12 -7.03 1.06 17 -1.47 0.08 17 -1.74 0.06 17 6.34 1.92 17 -1.51 1.02 17 34.25 1.56 17 31.88 0.36 17 -6.96 0.2 13 4.01 -0.03 -0.1 -1.89 1.55 5.67 6.34 -1.51 0.09 -0.83 3.34 3.31 0.06 0.18 0 -7.03 7.24 -1.47 -1.74 34.25 31.88 13.39 -4.395 0.01 -0.2 -2.55 -1.56 4.8 0.06 -0.915 3.43 3.39 0.04 38.93 32.53 0.14 -0.04 -0.69 -0.48 -0.07 6.045 -12.98 0.23 -1.49 4.135 11.11 5.14 0 4.16 3.29 3.37 0.035 31.37 31.06 0.1 -0.36 -0.48 -0.69 0.07 7.3",
  "ATAGC 5.37 0.13 4 13.59 0.26 4 -6.84 0.33 6 -1.51 0.04 4 -1.8 0.02 6 4.96 0.74 4 -2.59 0.38 6 34.96 0.4 4 31.21 0.11 6 -7 0.2 4 4.04 -0.02 -0.72 -1.68 0.65 5.24 5.55 -2.59 0.09 -0.45 3.43 3.3 0.04 0.22 -0.02 -6.84 5.62 -1.52 -1.8 34.72 31.21 14.25 -1.955 0.01 0.52 -3.885 -1.56 1.42 0.06 -2.375 3.43 3.24 0.025 38.93 32.66 0.14 -0.01 -0.69 -0.7 -0.04 6.37 -10.98 0.23 -3.2 6.01 11.11 1.56 0.01 4.06 3.29 3.32 0.035 31.37 34.92 0.1 -0.62 -0.48 -0.28 0.125 7.26",
  "ATAGG 5.6 0.23 8 13.52 0.24 7 -6.87 0.48 8 -1.45 0.03 8 -1.78 0.03 8 5.54 1.39 8 -2.45 0.76 8 34.5 0.5 8 31.71 0.24 8 -6.95 0.23 6 4.02 -0.03 -0.29 -2.19 2.26 5.5 5.54 -2.45 0.09 -0.64 3.33 3.29 0.03 0.23 0 -6.87 7.2 -1.45 -1.79 34.5 31.71 13.62 -1.605 0.01 0.08 -0.805 -1.56 4.07 0.06 -0.645 3.43 3.34 0.035 38.93 32.41 0.14 -0.17 -0.69 -0.56 -0.06 6.35 -10.74 0.23 -2.61 6.17 11.11 2.13 0.01 4.345 3.29 3.3 0.04 31.37 33.56 0.1 -0.49 -0.48 -0.46 0.13 7.355",
  "ATAGT 4.86 1.3 9 13.61 0.61 6 -8.26 2.06 9 -1.37 0.29 9 -1.73 0.09 9 3.79 5.15 9 -3.25 3.63 9 35.53 1.94 9 31.86 1.22 9 -7.21 0.3 6 4.17 0 0.07 -1.85 -0.48 4.87 3.79 -3.25 0.13 -0.91 3.38 3.39 0.05 0.26 -0.06 -8.26 6.44 -1.37 -1.73 35.53 31.86 13.42 -5.58 0.01 0.26 -2.28 -1.56 3.96 0.04 -0.71 3.43 3.39 0.05 38.93 33.51 0.14 0.04 -0.69 -0.72 -0.09 6.275 -11.455 0.23 -3.32 5.045 11.11 1.53 0 4.785 3.29 3.4 0.04 31.37 36.23 0.1 -0.78 -0.48 -0.41 0.135 7.1",
  "ATATA 5.76 0.51 37 12.43 0.8 34 -8.95 0.99 37 -1.5 0.06 37 -1.5 0.03 37 8.32 3.05 37 -2.62 1.9 37 34.46 1.18 37 32.12 0.39 37 -6.79 0.35 29 4.03 -0.01 -0.17 -0.1 -3.09 5.73 8.32 -2.62 0.08 -0.52 3.48 3.2 -0.01 0 -0.09 -8.95 7.77 -1.5 -1.5 34.46 32.12 12.52 -5.54 -12.15 -1.96 0.58 1.4 1.07 0.02 3.655 -2.62 1.58 0 34.12 30.46 0.24 0.03 0.21 -1 -0.065 5.375 -11.64 0.09 -0.03 -0.015 8.38 0.25 -0.015 3.915 3.39 3.21 0.03 34.51 29.5 0 0 -0.55 -0.85 0.085 6.325",
  "ATATC 5.4 0.41 16 13.34 0.56 14 -8.3 0.32 22 -1.51 0.05 22 -1.52 0.03 22 6.33 1.73 22 -3.98 1.12 22 35.01 0.69 22 32.32 0.43 22 -7.44 0.41 18 4.17 -0.02 0.08 0.2 -3.09 5.32 6.33 -3.98 0.09 -0.48 3.46 3.22 0.01 -0.02 -0.1 -8.3 6.28 -1.51 -1.52 35.02 32.32 13.68 -8.835 -12.15 -0.48 -0.85 1.4 -0.09 -0.025 8.285 -2.62 3.28 0 34.12 31.38 0.24 -0.1 0.21 -0.95 -0.015 5.66 -12.315 0.09 0.19 1.21 8.38 0.42 0.01 3.52 3.39 3.23 0.035 34.51 29.64 0 0.03 -0.55 -0.86 0.1 6.455",
  "ATATG 5.32 0.15 8 13 0.16 5 -8.33 0.56 8 -1.49 0.04 8 -1.5 0.03 8 5.85 0.55 8 -4.26 0.43 8 35.37 0.34 8 32.04 0.2 8 -7.38 0.07 6 4.18 -0.02 -0.11 0.45 -2.85 5.36 5.85 -4.26 0.09 -0.63 3.45 3.21 -0.02 -0.04 -0.08 -8.33 7.15 -1.49 -1.5 35.37 32.04 12.93 -8.82 -12.15 1.96 2.34 1.4 2.32 0.04 4.255 -2.62 3.25 0.045 34.12 29.13 0.24 0.14 0.21 -0.83 -0.08 5.5 -11.635 0.09 0.41 -0.12 8.38 0.23 0 3.805 3.39 3.22 0.03 34.51 29.21 0 -0.01 -0.55 -0.78 0.085 6.49",
  "ATCAA 5.52 0.3 290 12.94 0.36 281 -7.12 0.77 290 -1.57 0.06 290 -1.34 0.08 290 0.04 1.15 290 6.62 1.61 290 35.38 0.71 290 34.6 0.59 290 -5.64 0.21 228 4.28 -0.04 -1.19 2.01 3.54 5.45 0.04 6.62 0.27 0.29 3.35 3.5 0.25 -0.46 -0.02 -7.12 6.67 -1.57 -1.34 35.38 34.6 13.05 -11.07 -1.17 0.6 -4.445 0.99 5.68 -0.045 3.455 3.24 3.98 0.105 34.88 35.18 -0.13 -0.04 -0.25 0.4 -0.205 6.275 -8.05 -2.26 -0.64 -0.205 1.5 12.51 -0.02 2.77 3.44 3.05 0.03 38.64 22.3 -0.62 0.08 0 -0.12 -0.06 7.195",
  "ATCAC 5.35 0.35 50 13.42 0.34 43 -6.53 0.88 61 -1.55 0.06 61 -1.39 0.12 61 -0.51 1.27 61 3.72 1.24 61 35.64 0.85 61 34.03 0.74 61 -5.68 0.34 48 4.28 -0.04 -1.24 0.77 1.81 5.27 -0.51 3.72 0.27 0.3 3.36 3.33 0.21 -0.26 0.02 -6.53 6.12 -1.55 -1.39 35.64 34.03 13.59 -8.95 -1.17 -1.2 -0.965 0.99 4.14 -0.005 2.24 3.24 3.28 0.055 34.88 34.75 -0.13 -0.12 -0.25 0.34 -0.11 6.43 -5.765 -2.26 1 0.16 1.5 10.63 -0.025 2.035 3.44 2.95 0.035 38.64 23.47 -0.62 0.19 0 -0.09 0.03 7.24",
  "ATCAG 5.34 0.28 17 13.45 0.22 17 -6.55 0.66 31 -1.53 0.07 31 -1.43 0.07 29 -0.36 0.97 31 4.36 1.39 29 35.8 0.66 31 34.24 0.45 29 -5.47 0.28 25 4.28 -0.04 -0.9 0.63 2.15 5.3 -0.36 4.45 0.27 0.39 3.35 3.38 0.25 -0.27 -0.01 -6.55 6.59 -1.53 -1.44 35.8 34.24 13.51 -6.605 -1.17 1.23 0.58 0.99 4.71 0.02 5.995 3.24 3.45 0.035 34.88 36.83 -0.13 0.16 -0.25 -0.32 -0.11 6.545 -7.73 -2.26 1.17 -1.015 1.5 11.07 0 3.195 3.44 2.91 0.035 38.64 22.06 -0.62 0.04 0 0 0.075 7.32",
  "ATCCA 4.94 0.23 258 13.85 0.33 193 -5.7 0.51 260 -1.53 0.07 260 -1.78 0.05 258 -0.96 1.51 260 -0.54 0.84 258 36.24 0.68 260 33.69 0.44 258 -5.61 0.21 202 4.29 -0.04 -0.93 -1.26 1.34 4.97 -0.96 -0.54 0.28 0.29 3.36 3.42 0.19 -0.07 -0.04 -5.7 6.65 -1.53 -1.78 36.24 33.7 13.88 -7.875 -0.25 6.86 -0.285 0.71 5.93 -0.02 6.045 3.36 2.48 0.025 36.74 27.51 -0.16 0.13 -0.7 -0.58 -0.145 6.365 -10.24 -1.44 0.56 2.41 2.13 5.9 0.015 1.225 3.4 3.52 0.025 36.42 31.9 -0.09 -0.23 -0.52 -0.69 -0.015 6.57",
  "ATCCC 4.81 0.22 83 14.49 0.37 48 -4.91 0.52 127 -1.55 0.06 127 -1.85 0.05 101 -1.49 0.86 127 -1.06 1.1 101 36.09 0.69 127 33.66 0.63 101 -5.67 0.22 95 4.28 -0.05 -0.69 -1.16 2.45 4.77 -1.49 -1.04 0.3 0.37 3.34 3.47 0.2 -0.04 -0.09 -4.91 5.18 -1.55 -1.86 36.09 33.7 14.89 -7.55 -0.25 -0.21 -0.59 0.71 6.31 0.075 2.625 3.36 3.44 0.08 36.74 31.55 -0.16 -0.12 -0.7 -0.75 -0.14 6.71 -10.68 -1.44 1.03 -0.365 2.13 6.53 0.01 0.97 3.4 3.44 0.015 36.42 30.36 -0.09 0.02 -0.52 -0.92 -0.115 6.395",
  "ATCCG 4.47 1.04 6 14.03 0.14 4 -4.49 2.68 9 -1.56 0.07 9 -1.8 0.11 9 -2.07 3.48 9 -2.34 4.58 9 36.59 1.3 9 32.93 1.95 9 -5.43 0.21 6 4.35 -0.03 -1.25 -0.75 0.21 4.63 -2.07 -2.34 0.28 0.34 3.44 3.44 0.21 -0.19 -0.03 -4.49 5.73 -1.56 -1.8 36.59 32.93 14.44 -11.63 -0.25 -1.79 -2.185 0.71 2.54 -0.035 5.425 3.36 0.77 0.06 36.74 30.08 -0.16 -0.19 -0.7 -0.75 -0.135 6.77 -10.13 -1.44 0.43 3.015 2.13 5.73 0.015 1.215 3.4 3.48 0.025 36.42 31.82 -0.09 -0.24 -0.52 -0.41 0.015 6.69",
  "ATCCT 4.51 0.13 10 14.7 0.34 9 -5.29 0.63 13 -1.56 0.05 13 -1.92 0.04 13 -1.25 0.94 13 -1.41 0.79 13 36.16 0.5 13 34.37 0.52 13 -5.71 0.21 11 4.34 -0.05 -0.5 -2.04 2.17 4.63 -1.25 -1.41 0.3 0.42 3.36 3.54 0.24 -0.06 -0.1 -5.29 6.47 -1.56 -1.92 36.16 34.37 14.6 -4.365 -0.25 0.38 -0.865 0.71 4.06 0.05 1.425 3.36 3.51 0.125 36.74 33.87 -0.16 0.02 -0.7 -0.87 -0.16 5.99 -10.92 -1.44 2.03 2.235 2.13 6.08 0.015 0.935 3.4 3.49 0.015 36.42 31.5 -0.09 0.11 -0.52 -0.85 0.005 6.235",
  "ATCGA 5.23 0.31 74 13.14 0.42 70 -7.08 0.77 88 -1.5 0.05 86 -1.64 0.05 88 -0.54 1.24 86 5.51 1.7 88 35.76 0.68 86 32.77 0.38 88 -5.43 0.29 70 4.2 -0.04 -0.6 0.02 3.62 5.16 -0.52 5.51 0.27 0.5 3.33 3.51 0.21 0 -0.09 -7.08 6.61 -1.51 -1.64 35.76 32.77 13.37 -8.64 -0.28 -15.36 -2.375 0.86 7.72 -0.045 5.665 3.29 -16.86 0.14 34.73 9.75 0.08 -0.16 -0.36 1.56 -0.11 6.995 -6.055 -2.17 0.06 0.095 1.28 11.51 0 1.655 3.47 3 0.045 38.8 22.93 -0.62 0 0.04 -0.06 0.04 7.43",
  "ATCGC 5.28 0.16 33 13.3 0.16 7 -6.96 0.51 41 -1.49 0.04 41 -1.62 0.04 41 -0.66 0.66 41 4.15 0.85 41 35.82 0.48 41 32.49 0.39 41 -5.24 0.21 33 4.2 -0.03 -0.45 -0.52 2.84 5.22 -0.66 4.15 0.26 0.44 3.32 3.42 0.21 0.05 -0.08 -6.96 6.21 -1.49 -1.62 35.82 32.49 13.64 -3.805 -0.28 -1.84 2.075 0.86 5.54 0.06 1.32 3.29 3.48 0.105 34.73 36.68 0.08 -0.45 -0.36 0.32 -0.08 6.99 -5.9 -2.17 1.44 1 1.28 10.88 0.015 1.27 3.47 3.03 0.035 38.8 26.86 -0.62 0.1 0.04 -0.07 0.105 7.51",
  "ATCGG 5.25 0.13 8 13.53 0.31 6 -7.15 0.56 10 -1.49 0.05 10 -1.68 0.07 8 -0.66 0.74 10 3.63 0.77 8 35.6 0.6 10 32.57 0.41 8 -5.15 0.24 8 4.15 -0.03 -0.2 -0.94 4.16 5.23 -0.66 3.93 0.26 0.49 3.3 3.47 0.2 0.07 -0.11 -7.15 5.94 -1.49 -1.68 35.6 32.59 13.86 -4.44 -0.28 1.74 -8.975 0.86 3.99 -0.12 10.675 3.29 3.3 0.08 34.73 36.31 0.08 0.05 -0.36 -0.06 0.02 7.025 -5.53 -2.17 -1.58 -1.49 1.28 10.1 0.01 1.62 3.47 2.86 0.045 38.8 22.38 -0.62 -0.06 0.04 -0.05 0.055 7.6",
  "ATCGT 4.8 0.28 17 13.34 0.29 15 -6.85 0.45 17 -1.5 0.05 17 -1.68 0.07 17 -1.68 1.08 17 4.65 0.86 17 36.22 0.81 17 33.64 0.31 17 -5.77 0.17 13 4.34 -0.04 -0.49 -0.12 3.42 4.74 -1.68 4.65 0.28 0.5 3.34 3.58 0.21 -0.02 -0.1 -6.85 6.5 -1.5 -1.68 36.22 33.64 13.54 -5.82 -0.28 -1.25 -0.865 0.86 5.07 0.005 5.315 3.29 3.37 0.11 34.73 36.26 0.08 0 -0.36 0.13 -0.025 6.625 -6.785 -2.17 1.62 3.51 1.28 10.27 0.005 1.675 3.47 3.11 0.045 38.8 27.85 -0.62 0.06 0.04 -0.09 0.1 7.2",
  "ATCTA 4.74 0.78 11 13.57 0.29 9 -3.2 2.21 11 -1.65 0.06 11 -1.73 0.06 11 -1.24 3.77 11 -2.21 3.79 11 36.79 1.36 11 31.29 1.54 11 -5.6 0.13 8 4.34 -0.02 -2.52 1.93 -3.39 4.82 -1.24 -2.21 0.26 0.27 3.53 3.31 0.2 -0.26 0.11 -3.2 6.84 -1.65 -1.73 36.79 31.29 13.78 -7.775 -0.22 -0.2 0.66 -1.37 4.8 0.02 2.98 3.36 3.39 0.1 35.45 32.53 0.08 -0.04 -0.64 -0.48 -0.145 5.625 -12.245 -1.07 -1.49 2.425 3.02 5.14 0.04 2.835 3.38 3.37 0.025 34.4 31.06 -0.07 -0.36 -0.64 -0.69 0.045 7.03",
  "ATCTC 4.74 0.24 49 14.45 0.34 8 -2.78 0.56 83 -1.65 0.06 83 -1.76 0.04 83 -1.46 1.02 83 -2.16 0.6 83 36.47 0.59 83 31.47 0.32 83 -5.95 0.2 66 4.34 -0.03 -2.23 2.06 -1.98 4.76 -1.46 -2.16 0.26 0.26 3.45 3.34 0.19 -0.17 0.08 -2.78 5.2 -1.65 -1.76 36.47 31.47 14.76 -6.915 -0.22 -1.04 1.26 -1.37 4.02 0.02 4.34 3.36 3.24 0.1 35.45 31.39 0.08 -0.12 -0.64 -0.62 -0.17 5.76 -12.4 -1.07 -1.15 2.94 3.02 5.12 0.06 2.18 3.38 3.36 0.02 34.4 30.19 -0.07 -0.17 -0.64 -0.74 0.045 6.895",
  "ATCTG 4.98 0.16 14 13.74 0.16 5 -2.7 1.05 43 -1.67 0.07 26 -1.72 0.05 43 -0.33 0.99 26 -2.27 0.88 43 36.37 0.61 26 31.12 0.27 43 -5.82 0.21 31 4.19 -0.02 -3.09 2.23 -3.75 5.15 -0.21 -2.27 0.24 0.23 3.56 3.3 0.11 -0.28 0.12 -2.7 5.3 -1.74 -1.72 35.86 31.12 14.29 -7.93 -0.22 0.5 -0.395 -1.37 3.48 0 2.84 3.36 3.35 0.08 35.45 32.26 0.08 -0.15 -0.64 -0.56 -0.13 5.76 -11.05 -1.07 -1.77 3.11 3.02 5.04 0.045 2.505 3.38 3.28 0.02 34.4 29.92 -0.07 -0.25 -0.64 -0.32 0.035 7.015",
  "ATGAA 5.5 0.16 24 13.11 0.41 11 -6.07 0.36 26 -1.4 0.05 26 -1.46 0.06 26 5.73 0.74 26 0.04 0.85 26 35.03 0.4 26 35.39 0.47 26 -5.57 0.14 20 4.33 -0.05 -1.46 1.98 -0.52 5.42 5.73 0.04 -0.29 0.24 3.44 3.35 0.31 -0.3 0.03 -6.07 6.36 -1.4 -1.46 35.03 35.39 13.19 -4.87 -0.85 -2.15 4.07 6.07 3.57 0.08 -1.81 3.41 1.72 0.07 36.88 35.09 0.03 -0.98 -0.15 -1.41 -0.115 6.58 -9.12 1.32 -0.97 3.335 11 2.44 -0.03 2.445 3.26 3.4 0.04 29.96 34.98 0.33 -0.42 -0.21 -0.2 -0.02 6.79",
  "ATGAC 5.45 0.3 230 13.49 0.29 181 -6.37 0.54 237 -1.37 0.1 237 -1.41 0.06 237 5.16 1.82 237 -2.06 0.92 237 35.1 0.52 237 35.47 0.46 237 -5.56 0.21 188 4.28 -0.04 -0.86 0.62 -0.82 5.41 5.16 -2.06 -0.29 0.26 3.42 3.22 0.3 -0.16 0.02 -6.37 6.48 -1.37 -1.41 35.1 35.47 13.52 -6.255 -0.85 1.57 1.38 6.07 1.92 0.03 0.515 3.41 3.25 0.065 36.88 35.01 0.03 0.14 -0.15 -0.09 -0.1 6.69 -8.515 1.32 -2.37 5.67 11 0.51 -0.025 2.425 3.26 3.39 0.04 29.96 38.79 0.33 -0.65 -0.21 0.16 0.025 7.015",
  "ATGAG 5.23 0.19 26 13.63 0.27 11 -6.05 0.39 35 -1.47 0.05 35 -1.54 0.03 35 5.69 0.86 35 -1.52 0.91 35 34.93 0.27 35 35.1 0.43 35 -5.38 0.23 27 4.21 -0.05 -1.17 0.69 -2.42 5.29 5.69 -1.52 -0.28 0.26 3.5 3.26 0.33 -0.16 -0.03 -6.05 6.04 -1.47 -1.54 34.93 35.1 13.84 -8.355 -0.85 0.33 0.99 6.07 -0.39 0.055 -0.55 3.41 3.33 0.045 36.88 31.43 0.03 -0.29 -0.15 -0.56 -0.08 6.005 -7.85 1.32 -2.58 6.435 11 0.2 -0.015 2.585 3.26 3.39 0.05 29.96 37.67 0.33 -0.54 -0.21 0.06 0.015 7.07",
  "ATGAT 4.79 0.43 1141 13.43 0.39 1039 -6.15 1.18 1141 -1.57 0.09 1141 -1.58 0.07 1141 3.79 2.22 1141 -1.32 1.76 1141 34.82 0.78 1141 36.14 0.85 1141 -6.07 0.29 883 4.39 -0.04 -1.18 1.26 -2.73 4.76 3.79 -1.32 -0.29 0.4 3.54 3.41 0.31 -0.27 -0.03 -6.15 6.33 -1.57 -1.58 34.82 36.14 13.53 -7.555 -0.85 -1.17 0.375 6.07 0.99 0.03 0.19 3.41 3.24 0.095 36.88 34.88 0.03 -0.13 -0.15 -0.25 -0.13 6.235 -8.68 1.32 -2.26 4.185 11 1.5 -0.02 2.5 3.26 3.44 0.04 29.96 38.64 0.33 -0.62 -0.21 0 0 7.01",
  "ATGCA 5.55 0.24 36 12.96 0.33 23 -3.73 0.34 46 -1.39 0.05 46 -1.56 0.04 46 4.66 1.12 46 -1.2 0.6 46 35.12 0.49 46 35.6 0.39 46 -5.1 0.15 38 4.21 -0.04 -1.7 -0.16 -0.51 5.58 4.66 -1.2 -0.27 0.24 3.39 3.37 0.34 -0.03 0.11 -3.73 6.2 -1.39 -1.56 35.12 35.6 13.12 -2.92 -1.53 1.59 -6.355 1.9 3.4 -0.065 14.49 3.45 3.09 -0.13 36.82 27.05 -0.32 -0.03 0.04 -0.41 -0.035 7.03 -9.63 -0.31 0.02 1.69 10.06 0.1 -0.02 2.07 3.3 3.38 0.03 32.58 33.11 0.1 0.01 -0.39 -0.56 0.065 6.895",
  "ATGCC 5.33 0.14 18 13.57 0.18 5 -3.12 0.4 65 -1.46 0.04 65 -1.61 0.04 60 4.26 0.86 65 -1.93 0.42 60 34.66 0.35 65 36.28 0.29 60 -5.23 0.14 51 4.2 -0.04 -1.67 0.28 0.1 5.3 4.26 -1.94 -0.26 0.33 3.4 3.39 0.36 0.01 0.09 -3.12 4.69 -1.46 -1.61 34.66 36.29 14.26 -3.02 -1.53 -1.98 -7.15 1.9 1.75 -0.145 15.35 3.45 3.19 -0.155 36.82 31 -0.32 -0.09 0.04 -0.63 -0.085 6.845 -12.94 -0.31 0.32 -2.235 10.06 -0.68 -0.04 1.835 3.3 3.37 0.02 32.58 35.57 0.1 0.31 -0.39 -0.36 0.04 6.175",
  "ATGCG 5.6 0.2 20 12.61 0.53 16 -4.03 0.54 21 -1.37 0.05 21 -1.54 0.04 20 5.09 0.96 21 -0.76 1.02 20 35 0.36 21 35.58 0.39 20 -4.96 0.25 17 4.15 -0.04 -1.47 0.34 0.12 5.6 5.09 -0.77 -0.27 0.25 3.37 3.37 0.35 -0.01 0.1 -4.03 7.01 -1.37 -1.54 35 35.59 12.7 0.495 -1.53 0.01 -6.375 1.9 6.42 -0.015 11.045 3.45 3.24 -0.1 36.82 28.89 -0.32 0.07 0.04 -0.7 -0.065 7.215 -9.84 -0.31 -0.46 2.18 10.06 -1.45 -0.01 2.04 3.3 3.42 0.03 32.58 34.51 0.1 -0.21 -0.39 -0.39 0.08 6.83",
  "ATGCT 5.23 0.28 9 13.21 0.63 5 -3.68 0.28 29 -1.52 0.04 29 -1.66 0.03 29 4.59 0.67 29 -2.2 0.88 29 34.56 0.33 29 36.89 0.35 29 -5.39 0.28 23 4.24 -0.04 -1.61 -0.87 -1.96 5.13 4.59 -2.2 -0.26 0.33 3.48 3.44 0.39 -0.03 0.04 -3.68 4.86 -1.52 -1.66 34.56 36.89 14.16 6.945 -1.53 1.31 -13.63 1.9 -0.48 -0.215 23.33 3.45 3.31 -0.25 36.82 31.95 -0.32 -0.11 0.04 -0.69 0.025 6.485 -13.1 -0.31 1.57 -0.35 10.06 -1.42 -0.04 1.65 3.3 3.42 0.01 32.58 36.13 0.1 0.5 -0.39 -0.34 0.14 6.07",
  "ATGGA 5.34 0.33 79 13.42 0.31 75 -3.37 0.88 87 -1.48 0.08 87 -1.79 0.05 87 4.34 1.48 87 -0.26 1.27 87 34.46 0.72 87 33.69 0.51 87 -5.3 0.18 69 4.16 -0.04 -1.91 1.17 1.31 5.28 4.34 -0.26 -0.27 0.22 3.37 3.42 0.37 0.07 0.11 -3.37 6.92 -1.48 -1.79 34.46 33.69 13.5 -6.705 0.59 6.86 1.13 2.89 5.93 -0.09 4.525 3.43 2.48 -0.04 38.36 27.51 0.14 0.13 0.02 -0.58 -0.1 6.76 -8.165 0.08 0.56 3.76 9.76 5.9 -0.035 2.115 3.16 3.52 0.03 31.42 31.9 0.25 -0.23 -0.18 -0.69 0.07 7.275",
  "ATGGC 5.23 0.17 39 13.81 0.37 29 -3.12 0.56 52 -1.47 0.07 52 -1.78 0.05 52 3.68 0.9 52 -2.18 0.76 52 34.93 0.33 52 33.39 0.37 52 -5.43 0.21 42 4.22 -0.04 -1.69 0.75 0.53 5.14 3.68 -2.18 -0.27 0.22 3.4 3.36 0.38 0.12 0.09 -3.12 6.04 -1.47 -1.78 34.93 33.39 14.02 -6.545 0.59 0.26 -1.14 2.89 3.45 -0.075 0.675 3.43 3.37 0.005 38.36 32.46 0.14 -0.02 0.02 -0.47 -0.11 6.81 -7.11 0.08 -1.53 5.91 9.76 2.87 -0.025 2.37 3.16 3.48 0.04 31.42 35.96 0.25 -0.6 -0.18 -0.29 0.12 7.48",
  "ATGGG 5.19 0.22 26 13.89 0.33 18 -2.37 0.74 36 -1.49 0.06 36 -1.82 0.04 36 3.38 1.5 36 -2.51 1.36 36 34.56 0.58 36 33.45 0.55 36 -5.37 0.2 30 4.19 -0.04 -1.86 0.58 1.55 5.15 3.38 -2.51 -0.27 0.28 3.38 3.38 0.39 0.13 0.1 -2.37 5.96 -1.49 -1.82 34.56 33.45 14.14 -4.935 0.59 0.97 -0.05 2.89 5.25 -0.04 0.5 3.43 3.42 -0.025 38.36 30.63 0.14 -0.25 0.02 -0.87 -0.08 7.005 -6.07 0.08 -1 5.425 9.76 3.96 -0.02 2.3 3.16 3.45 0.04 31.42 34.1 0.25 -0.36 -0.18 -0.53 0.075 7.62",
  "ATGGT 4.97 0.21 10 13.37 0.34 7 -4.33 0.57 18 -1.52 0.04 14 -1.78 0.04 18 4.04 0.87 14 -1.22 0.59 18 34.88 0.32 14 34.55 0.35 18 -5.41 0.22 14 4.28 -0.05 -1.94 0.94 -0.8 4.91 4.17 -1.22 -0.27 0.26 3.49 3.44 0.39 0.03 0.06 -4.33 5 -1.54 -1.78 34.87 34.55 14.04 -0.035 0.59 2.31 -8.055 2.89 4.48 -0.17 10.58 3.43 3.62 0.025 38.36 34.57 0.14 0.07 0.02 -0.82 -0.205 6.86 -7.135 0.08 -0.68 4.42 9.76 3.91 -0.025 2.35 3.16 3.58 0.035 31.42 35.51 0.25 -0.43 -0.18 -0.62 0.085 7.36",
  "ATGTA 5.27 0.27 36 12.6 0.49 26 -7.4 0.79 49 -1.44 0.07 49 -1.5 0.04 47 5.57 1.2 49 -2.14 0.98 47 35.76 0.44 49 34.06 0.32 47 -5.43 0.23 39 4.33 -0.04 -1.39 0.32 -5.57 5.33 5.57 -2.13 -0.28 0.44 3.5 3.31 0.35 -0.28 0.04 -7.4 6.67 -1.44 -1.5 35.76 34.1 12.79 -3.32 -0.04 0.3 1.7 4.06 3.68 0.005 1.71 3.57 3.19 0.04 37.31 28.75 -0.02 -0.1 -0.47 -0.85 -0.155 6.175 -11.08 0.41 0.33 -2.02 8.78 0.51 -0.04 2.535 3.48 3.28 0.035 35.85 30.55 0.17 -0.09 -0.47 -0.66 0.04 6.255",
  "ATGTC 5.02 0.27 86 13.37 0.36 56 -7.1 0.71 141 -1.5 0.08 141 -1.54 0.04 137 4.9 1.27 141 -2.83 0.69 137 35.42 0.61 141 34.24 0.6 137 -5.65 0.19 112 4.37 -0.04 -1.26 0.69 -5.5 5.01 4.9 -2.82 -0.28 0.54 3.53 3.35 0.34 -0.28 0.01 -7.1 5.64 -1.5 -1.54 35.42 34.25 13.67 -8.13 -0.04 0.11 1.985 4.06 0.71 -0.055 2.59 3.57 3.23 0.025 37.31 29.32 -0.02 0.01 -0.47 -1.08 -0.12 6.085 -11.21 0.41 -0.05 -0.72 8.78 -0.33 -0.025 2.49 3.48 3.36 0.035 35.85 31.44 0.17 -0.36 -0.47 -0.69 0.06 6.33",
  "ATGTG 5.15 0.16 13 12.74 0.39 4 -8.83 1.15 18 -1.5 0.04 18 -1.48 0.03 14 6.57 0.76 18 -2.22 0.67 14 35.86 0.52 18 33.53 0.47 14 -5.49 0.21 14 4.32 -0.03 -1.05 0.67 -7.69 5.2 6.57 -2.29 -0.28 0.54 3.59 3.33 0.36 -0.37 -0.03 -8.84 5.97 -1.5 -1.49 35.86 33.81 12.91 -4.04 -0.04 -0.02 -0.795 4.06 1.43 -0.06 2.35 3.57 3.22 0.035 37.31 28.74 -0.02 -0.1 -0.47 -0.73 -0.095 6.11 -10.65 0.41 0.59 -1.7 8.78 0.49 -0.025 2.47 3.48 3.28 0.035 35.85 30.57 0.17 -0.17 -0.47 -0.6 0.035 6.475",
  "ATTAA 5.58 0.5 457 12.73 0.39 441 -11.32 1.06 457 -1.22 0.05 457 -1.36 0.14 457 -2.12 1.83 457 8.64 2.8 457 35.37 0.65 457 34.44 1.21 457 -7.47 0.33 352 4.25 -0.02 1.59 -0.03 3.61 5.53 -2.12 8.64 -0.1 -1.05 3.16 3.53 0.17 0 -0.23 -11.32 6.66 -1.22 -1.36 35.37 34.44 12.75 -3.28 0.49 -0.89 -6.005 0.11 4.13 -0.135 13.005 3.26 3.49 -0.02 34.83 37.51 0.01 -0.08 -0.71 0.51 -0.17 5.23 -11.18 -3.34 0.05 -0.015 -0.16 12.18 0.005 4.45 3.3 3.2 0.03 36.99 25.22 -0.63 0 -0.17 -0.2 -0.05 6.645",
  "ATTAC 5.44 0.5 310 13.29 0.35 255 -11.34 1.18 314 -1.21 0.05 314 -1.34 0.13 314 -2.51 1.78 314 5.03 2.3 314 35.53 0.8 314 34.68 1.14 314 -7.55 0.25 251 4.28 -0.02 1.79 -1.55 2.23 5.39 -2.51 5.03 -0.11 -1.02 3.16 3.34 0.15 0.12 -0.2 -11.34 6.4 -1.21 -1.34 35.53 34.68 13.35 -5.215 0.49 -0.16 1.34 0.11 5.23 0.035 2.71 3.26 3.46 -0.04 34.83 36.67 0.01 -0.11 -0.71 -0.24 -0.175 5.82 -8.78 -3.34 1.75 0.21 -0.16 10.32 0.005 3.695 3.3 3.06 0.03 36.99 26.12 -0.63 0.12 -0.17 -0.16 0.045 6.79",
  "ATTAG 5.57 0.31 19 12.89 0.44 19 -11.58 0.51 19 -1.21 0.05 19 -1.45 0.04 19 -1.62 1.09 19 7.71 1.86 19 35.33 0.63 19 34.46 0.56 19 -7.23 0.32 15 4.2 -0.02 1.84 -1.43 3.27 5.46 -1.62 7.71 -0.09 -0.87 3.16 3.46 0.17 0.1 -0.26 -11.58 6.97 -1.21 -1.45 35.33 34.46 12.97 -7.48 0.49 0.18 -0.635 0.11 1.49 -0.035 8.16 3.26 3.26 -0.02 34.83 34.85 0.01 0.04 -0.71 -0.13 -0.185 5.59 -10.445 -3.34 -1.75 -1.69 -0.16 11.34 0 4.195 3.3 3.04 0.03 36.99 24.59 -0.63 0.16 -0.17 -0.19 -0.045 6.79",
  "ATTCA 5.22 0.22 26 13.43 0.23 20 -10.83 0.44 26 -1.19 0.05 26 -1.48 0.07 26 -2.45 1.06 26 0.21 0.81 26 36.06 0.42 26 35.03 0.57 26 -7.69 0.22 20 4.42 -0.03 2.07 -2.2 -0.16 4.99 -2.45 0.21 -0.11 -1.13 3.18 3.36 0.13 0.29 -0.24 -10.83 6.3 -1.19 -1.48 36.06 35.03 13.47 -1.99 -1.59 -2.15 3.165 -1.17 3.57 0.105 6.45 3.26 1.72 0.1 35.73 35.09 0.02 -0.98 -0.66 -1.41 -0.155 5.46 -12.125 -2.71 -0.97 3.22 1.21 2.44 0.08 2.19 3.34 3.4 0.035 34.45 34.98 -0.13 -0.42 -0.61 -0.2 -0.06 6.255",
  "ATTCC 4.69 0.17 265 14.06 0.2 69 -9.61 0.54 367 -1.23 0.05 367 -1.51 0.05 334 -3.73 1.07 367 -0.88 0.81 334 35.6 0.46 367 35.99 0.56 334 -8.21 0.32 319 4.42 -0.03 2.03 -2.02 1.64 4.63 -3.73 -0.86 -0.09 -0.69 3.16 3.4 0.12 0.28 -0.27 -9.61 5.26 -1.23 -1.51 35.6 36.03 14.26 0.14 -1.59 -0.78 4.375 -1.17 3.61 0.085 7.325 3.26 3.33 0.09 35.73 33.12 0.02 -0.18 -0.66 -0.66 -0.16 5.31 -12.745 -2.71 -0.52 1 1.21 3.33 0.08 1.915 3.34 3.27 0.025 34.45 33.83 -0.13 -0.21 -0.61 -0.27 -0.115 6.06",
  "ATTCG 4.88 0.21 30 13.43 0.28 25 -10.56 0.45 32 -1.21 0.05 32 -1.45 0.05 32 -2.98 0.96 32 -0.24 0.72 32 35.86 0.42 32 35.52 0.5 32 -7.92 0.21 26 4.46 -0.03 2.03 -1.78 0.84 4.75 -2.98 -0.24 -0.1 -1.03 3.17 3.36 0.12 0.26 -0.25 -10.56 6.3 -1.21 -1.45 35.86 35.52 13.53 -0.245 -1.59 0.64 0.83 -1.17 4.33 0.07 11.68 3.26 3.37 0.095 35.73 33.2 0.02 0.12 -0.66 -0.59 -0.18 5.345 -11.335 -2.71 -0.77 5.255 1.21 2.23 0.07 2.2 3.34 3.42 0.04 34.45 35.44 -0.13 -0.48 -0.61 0 -0.025 6.455",
  "ATTCT 4.43 0.18 19 14.08 0.2 14 -10.15 0.5 19 -1.21 0.04 19 -1.59 0.05 19 -3.86 0.84 19 -1.42 0.74 19 36.11 0.37 19 36.6 0.32 19 -8.34 0.22 14 4.52 -0.03 2.31 -3.35 0.42 4.42 -3.86 -1.42 -0.08 -0.39 3.2 3.49 0.15 0.26 -0.29 -10.15 5.82 -1.21 -1.59 36.11 36.6 14.09 0.705 -1.59 -0.79 1.99 -1.17 0.42 0.045 8.185 3.26 3.34 0.08 35.73 35.9 0.02 -0.12 -0.66 -0.55 -0.17 5.015 -13.11 -2.71 0.69 3.58 1.21 2.93 0.085 1.895 3.34 3.38 0.03 34.45 34.17 -0.13 -0.12 -0.61 -0.45 -0.005 5.825",
  "ATTGA 5.46 0.26 281 12.87 0.33 275 -10.92 0.72 285 -1.2 0.04 284 -1.34 0.07 285 -2.1 1.06 284 7.05 1.25 285 34.93 0.43 284 34.6 0.51 285 -7.28 0.2 225 4.19 -0.03 2.33 -2.06 2.54 5.49 -2.1 7.05 -0.09 -1.04 3.16 3.5 0.1 0.45 -0.32 -10.92 6.87 -1.2 -1.34 34.93 34.6 12.9 -9.345 -1.33 0.6 -2.205 1.93 5.68 0.045 2.6 3.25 3.98 0.075 34.75 35.18 -0.06 -0.04 -0.57 0.4 -0.175 6.285 -9.17 -3.82 -0.64 0 -0.48 12.51 0 3.7 3.36 3.05 0.02 38.22 22.3 -0.74 0.08 -0.02 -0.12 -0.1 7.18",
  "ATTGC 5.15 0.27 161 13.22 0.34 143 -10.6 0.69 165 -1.19 0.04 165 -1.41 0.08 165 -2.92 1.11 165 3.9 1.18 165 35.34 0.54 165 34.49 0.48 165 -7.61 0.27 144 4.28 -0.03 2.36 -2.36 2.51 5.18 -2.92 3.9 -0.1 -0.93 3.17 3.44 0.13 0.49 -0.3 -10.6 6.33 -1.19 -1.41 35.34 34.49 13.34 -1.73 -1.33 3.97 3.81 1.93 3.56 0.165 -3.245 3.25 3.42 0.035 34.75 34.96 -0.06 0.38 -0.57 0.18 -0.115 6.29 -8.68 -3.82 -1.99 -2.605 -0.48 11.7 0.005 3.745 3.36 2.91 0.025 38.22 21.48 -0.74 0.13 -0.02 -0.16 -0.085 7.3",
  "ATTGG 5.3 0.21 15 12.74 0.41 15 -10.72 0.67 18 -1.19 0.03 18 -1.4 0.06 18 -2.07 0.64 18 5.06 1.14 18 34.93 0.39 18 34.4 0.4 18 -7.32 0.22 14 4.18 -0.03 2.28 -2.88 3.46 5.4 -2.07 5.06 -0.1 -0.94 3.15 3.42 0.13 0.48 -0.32 -10.72 6.99 -1.19 -1.4 34.93 34.4 12.81 -6.32 -1.33 -2.12 0.735 1.93 4.21 0.07 2.42 3.25 3.1 0.05 34.75 16.27 -0.06 0.02 -0.57 -0.1 -0.12 6.43 -8.23 -3.82 -1.98 -1.05 -0.48 11 -0.005 3.565 3.36 2.96 0.02 38.22 23.39 -0.74 0.1 -0.02 -0.14 -0.105 7.31",
  "ATTGT 5.03 0.34 8 12.67 0.45 8 -11.94 1.16 10 -1.2 0.06 8 -1.39 0.11 10 -2.43 0.9 8 6.33 0.75 10 35.45 0.67 8 35.55 0.66 10 -7.49 0.16 8 4.38 -0.03 2.42 -2.15 2.6 4.96 -2.44 6.33 -0.09 -0.52 3.2 3.57 0.14 0.43 -0.33 -11.94 6.01 -1.2 -1.39 35.43 35.55 12.9 -5.57 -1.33 1.28 2.45 1.93 5.52 0.035 3.565 3.25 3.49 0.02 34.75 35.6 -0.06 0.15 -0.57 -0.55 -0.105 5.995 -9.605 -3.82 -1.94 -0.63 -0.48 12.12 0.005 3.745 3.36 3.2 0.02 38.22 26.37 -0.74 0.15 -0.02 -0.32 -0.13 7.07",
  "ATTTA 4.75 0.38 528 12.7 0.35 508 -13.87 0.92 530 -1.22 0.05 530 -1.06 0.05 530 -2.36 1.42 530 -0.94 1.3 530 36.55 0.56 530 35.79 0.49 530 -8.29 0.47 433 4.49 -0.03 1.7 1.08 -5.49 4.88 -2.36 -0.94 -0.16 -1.71 3.27 3.18 0 0.25 -0.16 -13.87 6.29 -1.22 -1.06 36.55 35.79 12.72 -6.125 -0.48 -0.07 2.045 -1.06 2.76 -0.01 1.705 3.27 3.06 0.03 35.41 32.53 0.04 -0.03 -0.79 -0.49 -0.085 4.675 -15.12 -2.93 -2.08 5.05 0.15 0.98 0.115 3.78 3.34 3.32 0.02 35.57 35.05 -0.14 -0.44 -0.6 -0.22 -0.045 5.665",
  "ATTTC 4.27 0.25 113 13.35 0.24 20 -12.09 0.6 175 -1.23 0.05 175 -1.1 0.05 175 -4.4 1.5 175 -3.13 0.72 175 36.7 0.46 175 35.77 0.4 175 -9.42 0.72 174 4.64 -0.02 1.65 1.3 -5.08 4.27 -4.4 -3.13 -0.15 -1.57 3.24 3.17 -0.01 0.22 -0.13 -12.09 4.89 -1.23 -1.1 36.7 35.77 13.44 -6.63 -0.48 -1.76 2.33 -1.06 -1.32 -0.04 9.775 3.27 1.86 -0.045 35.41 36.31 0.04 0.02 -0.79 -0.55 -0.08 4.28 -15.715 -2.93 -1.25 4.255 0.15 1.83 0.095 3.15 3.34 3.27 0.02 35.57 32.4 -0.14 -0.14 -0.6 -0.44 -0.04 5.49",
  "ATTTG 4.12 0.47 62 12.76 0.38 59 -13.36 0.92 62 -1.26 0.06 62 -1.09 0.06 62 -4.68 1.68 62 -3.54 1.44 62 37.28 0.56 62 35.49 0.76 62 -9.88 1.11 56 4.65 -0.02 1.24 1.4 -6.95 4.28 -4.68 -3.54 -0.17 -2.09 3.32 3.16 -0.09 0.09 -0.09 -13.36 5.61 -1.26 -1.09 37.28 35.49 12.84 0.245 -0.48 -0.39 -8.01 -1.06 1.92 -0.22 15.845 3.27 3.28 -0.075 35.41 34.88 0.04 -0.07 -0.79 -0.43 -0.055 4.73 -13.835 -2.93 -2.46 6.24 0.15 0.84 0.1 3.48 3.34 3.31 0.02 35.57 35.22 -0.14 -0.5 -0.6 -0.09 -0.08 5.995",
  "CAAAG 4.52 0.17 4 13.04 0.09 3 -12.85 1.03 4 -1.06 0.05 4 -1.27 0.04 4 -2.8 1.08 4 -4.84 1.06 4 35.41 0.4 4 36.3 0.29 4 -8.76 0.33 3 4.42 -0.03 -1.5 -1.9 6.77 4.84 -2.8 -4.84 0.15 -1.91 3.16 3.2 -0.17 0.19 -0.11 -12.85 5.83 -1.06 -1.27 35.41 36.3 13 9.045 -0.39 0.69 -2.05 1.92 -2.47 -0.375 22.435 3.28 3.2 -0.17 34.88 36.5 -0.07 -0.02 -0.43 -0.75 -0.015 4.915 -12.52 -2.46 -2.37 7.005 0.84 1.3 0.095 3.525 3.31 3.25 0.02 35.22 34.29 -0.5 -0.14 -0.09 -0.44 -0.08 6.35",
  "CAACG 4.98 0.11 20 12.53 0.17 18 -11.71 0.45 23 -1.08 0.03 23 -1.52 0.02 21 -2.97 0.35 23 -2.83 0.35 21 35.01 0.29 23 35.1 0.29 21 -7.6 0.1 19 4.31 -0.03 -2.23 0.25 10.17 5.19 -2.97 -2.84 0.16 -1.48 3.06 3.4 -0.09 0.45 0.09 -11.71 6.35 -1.08 -1.53 35.01 35.14 12.77 -10.03 0.28 -0.8 2.69 2.59 1.38 0.04 4.475 3.15 3.32 0.065 33.65 32.17 0.16 -0.19 -0.56 -1.04 -0.08 6.27 -7.445 -3.66 0.24 4.57 -1.25 -0.87 0.065 2.57 3.3 3.43 0.035 37.43 32.81 -0.68 -0.39 0.02 -0.66 0.025 7.215",
  "CAAGG 4.65 0.26 9 13.29 0.12 7 -9.16 0.24 9 -1.23 0.07 9 -1.82 0.03 9 -3.66 0.9 9 -2.93 0.76 9 34.98 0.47 9 32.51 0.21 9 -7.76 0.22 8 4.41 -0.02 -2.19 -2.22 7.66 4.5 -3.66 -2.93 0.13 -0.93 3.13 3.44 0.03 0.35 0.05 -9.16 5.99 -1.23 -1.82 34.98 32.51 13.8 -5.045 0.99 0.27 1.98 -0.32 2.63 -0.11 8.075 3.14 3.38 -0.02 34.05 34.14 0.04 -0.06 -0.57 -0.76 0.01 6.15 -10.985 -3.77 -1.95 9.355 -0.87 3.9 0.085 3.52 3.32 3.33 0.02 37.64 32.22 -0.6 -0.18 0.07 -0.78 0.045 6.965",
  "CAATG 4.69 0.37 17 12.77 0.35 17 -10.42 0.43 20 -1.19 0.04 20 -1.53 0.04 20 -2.63 0.92 20 -4.37 1.03 20 35.08 0.51 20 32.41 0.52 20 -7.96 0.27 16 4.38 -0.02 -2.32 0.87 3.33 4.91 -2.63 -4.37 0.14 -1.37 3.15 3.28 -0.12 0.11 -0.05 -10.42 6.81 -1.19 -1.53 35.08 32.41 12.85 -7.36 -1.33 2.52 -1.265 1.93 -0.35 0.07 1.91 3.25 3.29 -0.015 34.75 28.07 -0.06 -0.05 -0.57 -1.2 -0.04 5.59 -12.39 -3.82 1.09 3.005 -0.48 -1.22 0.095 3.035 3.36 3.28 0.02 38.22 31.23 -0.74 0.16 -0.02 -0.79 0.015 6.305",
  "CACAG 5.32 0.27 9 12.64 0.32 9 -8.12 0.83 9 -1.46 0.04 9 -1.44 0.08 9 -2.15 0.54 9 4.99 0.62 9 33.74 0.31 9 35.2 0.26 9 -5.48 0.14 8 4.26 -0.03 -0.75 0.71 6.1 5.37 -2.15 4.99 0.27 0.5 3.33 3.44 0.33 -0.27 0.02 -8.12 6.83 -1.46 -1.44 33.74 35.2 12.78 -4.035 -0.02 0.41 -0.345 1.43 5.58 -0.04 3.175 3.22 3.49 0.03 28.74 35.68 -0.1 0.09 -0.73 -0.67 -0.09 6.775 -10.46 0.59 -0.5 -5.45 0.49 9.7 -0.02 2.695 3.28 3.27 0.03 30.57 32.34 -0.17 0.08 -0.6 -0.16 0.05 6.97",
  "CACCG 4.92 0.17 31 13.03 0.25 30 -6.56 0.45 31 -1.5 0.03 31 -1.72 0.04 31 -2.48 0.44 31 -0.28 0.52 31 34.05 0.29 31 34.36 0.41 31 -5.25 0.2 25 4.27 -0.03 -1.06 -0.47 4.2 5.1 -2.48 -0.28 0.27 0.34 3.34 3.42 0.24 -0.06 0 -6.56 7.09 -1.5 -1.72 34.05 34.36 13.06 4.3 -0.05 -1.2 -9.175 1.73 0.98 -0.21 18.705 3.35 4.29 0.03 32.09 32.85 0.05 -0.03 -1.18 -0.75 -0.15 6.99 -8.545 1.04 -0.99 -1.015 -1.99 3.53 0.015 1.335 3.29 3.61 0.04 33.57 36.59 0.12 -0.51 -0.51 -0.44 0.08 6.545",
  "CACGG 5.1 0.18 9 12.7 0.11 9 -8.46 0.51 10 -1.44 0.02 10 -1.65 0.04 9 -2.43 0.32 10 4.06 0.34 9 33.81 0.23 10 33.7 0.17 9 -5.12 0.18 8 4.25 -0.02 -0.25 -0.91 7.05 5.14 -2.43 4.08 0.26 0.67 3.32 3.5 0.33 0.04 -0.06 -8.46 6.19 -1.44 -1.67 33.81 33.7 12.98 -9.74 0.93 0.88 2.14 0.23 6.79 0.075 1.39 3.35 3.41 0.06 29.11 34.95 0.14 0.29 -0.89 -0.07 0.03 6.74 -9.63 0.64 0.15 -2.95 -0.54 8.7 -0.005 1.405 3.31 3.13 0.045 31.32 31.48 -0.01 -0.03 -0.45 -0.03 0.135 6.775",
  "CAGAG 5.14 0.17 15 13.83 0.32 15 -3.06 0.35 15 -1.69 0.03 15 -1.63 0.05 15 -1.81 1.12 15 -1 1.04 15 31.18 0.23 15 35.6 0.49 15 -5.67 0.28 12 4.23 -0.03 -2.2 1.75 2.74 5.18 -1.81 -1 -0.26 0.2 3.3 3.37 0.21 -0.14 0.1 -3.06 6.93 -1.69 -1.63 31.18 35.6 13.9 -0.28 0.5 0.5 4.775 3.48 3.59 -0.09 8.23 3.35 3.53 0.025 32.26 31.77 -0.15 0.09 -0.56 -1.55 -0.14 6.525 -10.365 -1.77 -0.7 4.13 5.04 3.41 0.05 2.435 3.28 3.32 0.025 29.92 33.95 -0.25 -0.08 -0.32 -0.49 0.04 7.12",
  "CAGCG 5.13 0.11 31 13.29 0.29 27 -1.72 0.31 32 -1.67 0.04 32 -1.63 0.03 32 -1.93 0.44 32 -1.69 0.44 32 31.2 0.26 32 36.67 0.33 32 -5.29 0.14 26 4.22 -0.03 -2.46 1.13 3.57 5.21 -1.93 -1.69 -0.24 0.19 3.26 3.43 0.23 0 0.17 -1.72 7.04 -1.67 -1.63 31.2 36.67 13.33 -3.485 -0.88 -0.84 -0.64 2.66 1.21 -0.115 4.915 3.35 3.42 0.06 31.67 32.32 -0.23 0.07 -0.63 -0.75 0.03 7.06 -10.185 -3.59 1.12 3.795 0.33 -0.06 0.03 1.685 3.35 3.45 0.015 35.72 34.64 -0.61 0.24 -0.23 -0.57 0.185 6.94",
  "CAGGG 4.85 0.15 7 14.38 0.16 6 -0.14 0.43 13 -1.77 0.02 13 -1.92 0.05 13 -3.39 0.75 13 -2.88 1.37 13 31.11 0.39 13 34.07 0.46 13 -5.52 0.22 11 4.25 -0.01 -2.29 1.17 4.67 4.8 -3.39 -2.88 -0.26 0.35 3.27 3.47 0.3 0.12 0.16 -0.14 6.59 -1.77 -1.92 31.11 34.07 14.42 -6.42 0.47 -1.32 4.345 3.41 3.56 -0.15 5.13 3.26 3.49 0.07 32.49 34.59 0.32 -0.08 -0.58 -0.79 -0.015 6.905 -6.67 -3.47 0.76 7.825 0.92 5.78 0.03 2.25 3.32 3.46 0.025 35.12 32.29 -0.57 0.03 -0.28 -0.97 0.12 7.43",
  "CAGTG 4.98 0.5 6 12.81 0.69 6 -4.52 0.6 6 -1.67 0.07 6 -1.61 0.08 6 -1.18 2.31 6 -2.39 1.75 6 31.61 0.37 6 34.3 0.34 6 -5.29 0.14 4 4.28 -0.03 -2.82 2.3 -0.08 5.15 -1.18 -2.39 -0.24 0.18 3.35 3.42 0.22 -0.22 0.13 -4.52 7.19 -1.67 -1.61 31.61 34.3 12.88 -8.515 0.62 0.23 3.815 3.99 2.61 -0.015 7.81 3.49 3.37 0.01 33.34 30.45 0.04 0 -0.86 -1.09 -0.11 6.6 -12.085 -3.95 2.38 1.305 0.77 -3.54 0.025 2.495 3.44 3.4 0.02 37.04 34.76 -0.74 0.35 -0.3 -0.48 0.19 6.16",
  "CATAG 5.53 0.12 5 12.91 0.13 5 -8.2 0.54 6 -1.47 0.02 6 -1.47 0.04 5 -3.65 0.58 6 5.41 0.89 5 31.84 0.18 6 35.03 0.28 5 -7.21 0.11 4 4.11 -0.01 -0.49 0.06 3.06 5.58 -3.65 5.8 -0.09 -0.51 3.2 3.39 0.06 0.03 -0.07 -8.2 6.26 -1.47 -1.48 31.84 34.92 13.21 -5.4 1.96 0.01 -1.435 2.32 -1.56 0.085 0.24 3.25 3.43 0.05 29.13 38.93 0.14 0.14 -0.83 -0.69 -0.07 6.01 -11.945 0.41 0.23 0.775 0.23 11.11 0.01 3.675 3.22 3.29 0.035 29.21 31.37 -0.01 0.1 -0.78 -0.48 0.07 6.95",
  "CATCG 4.94 0.24 20 13.24 0.26 18 -8.32 0.66 32 -1.47 0.03 32 -1.48 0.05 32 -4.47 1.03 32 -0.95 1.04 32 32.14 0.29 32 35.83 0.7 32 -7.67 0.24 26 4.28 -0.02 -0.42 -0.36 1.54 5.01 -4.47 -0.95 -0.1 -0.64 3.23 3.31 -0.01 0.23 -0.1 -8.32 6.98 -1.47 -1.48 32.14 35.83 13.24 -8.83 0.06 -0.28 -2.705 1.15 0.86 -0.04 6.615 3.23 3.29 0.1 27.88 34.73 -0.12 0.08 -1.11 -0.36 -0.02 6.56 -9.37 0.38 -2.17 0.905 -0.45 1.28 0.075 2.2 3.21 3.47 0.04 29.55 38.8 0 -0.62 -0.75 0.04 0.04 6.665",
  "CATGG 5.34 0.14 9 12.82 0.33 8 -9.01 0.77 49 -1.43 0.03 11 -1.52 0.08 47 -4.03 0.39 11 3.95 1.81 47 31.61 0.22 11 34.66 0.97 47 -6.81 0.13 39 4.08 0 0.14 -1.98 4.88 5.25 -3.7 4 -0.09 -0.27 3.23 3.45 0.11 0.4 -0.22 -9.01 2.32 -1.44 -1.51 31.79 34.67 14.33 -8.68 -0.43 0.59 -0.89 0.79 2.89 -0.055 2.515 3.19 3.43 -0.045 26.17 38.36 0.02 0.14 -0.87 0.02 -0.11 6.385 -10.515 0.01 0.08 -0.725 0.36 9.76 -0.01 3.225 3.25 3.16 0.03 29.75 31.42 -0.03 0.25 -0.76 -0.18 0.035 7.16",
  "CCAGG 5.4 0.09 8 13.74 0.13 7 -5.54 0.65 13 -1.46 0.05 10 -1.76 0.05 11 2.39 0.68 10 -2.87 0.8 11 34.05 0.42 10 31.17 0.19 11 -6.72 0.24 11 3.99 -0.02 0.98 -2.36 0.99 5.41 2.9 -2.76 0.09 -0.38 3.31 3.29 -0.24 0.24 -0.05 -5.54 4.86 -1.47 -1.75 34.01 31.19 14.36 -3.85 -0.96 0.47 0.745 3.87 3.41 -0.025 2.26 3.4 3.26 0.05 34.03 32.49 -0.23 0.32 -0.37 -0.58 -0.085 6.885 -6.92 -0.45 -3.47 0.43 9.82 0.92 -0.005 3.655 2.85 3.32 0.03 23.51 35.12 0.11 -0.57 -0.08 -0.28 0.145 7.79",
  "CCGGG 5.19 0.14 9 13.69 0.19 8 -3.26 1.3 9 -1.64 0.05 9 -1.78 0.06 9 1.93 0.96 9 -1.59 0.57 9 32.53 0.17 9 33.24 0.56 9 -5.12 0.15 8 4.09 -0.04 -0.48 0.44 0.17 5.12 1.93 -1.59 -0.25 0.24 3.33 3.35 -0.01 0.15 0.05 -3.26 6.99 -1.64 -1.78 32.53 33.24 13.84 -1.99 2.64 0.39 -0.56 2.17 4.59 0.165 0.035 3.29 3.53 0.03 35.19 34.7 0.29 -0.16 0.05 -0.55 -0.025 7.625 -2.99 -0.05 -1.24 0.22 8.79 3.17 -0.005 1.58 2.78 3.48 0.055 23.08 35.21 -0.02 -0.43 -0.06 -0.32 0.21 7.995",
  "CGACG 5.19 0.15 65 12.87 0.23 59 -8.49 0.38 72 -1.33 0.04 72 -1.49 0.03 72 -1.47 0.59 72 -2.51 0.54 72 35.57 0.49 72 34.26 0.25 72 -7.18 0.11 57 4.21 -0.02 -0.04 -0.36 4.23 5.2 -1.47 -2.51 0.11 -0.67 3.19 3.34 -0.21 0.26 0.03 -8.49 7.12 -1.33 -1.49 35.57 34.26 12.99 -1.015 -1.77 0.8 2.915 0.35 1.69 0.055 1.75 3.38 3.3 0.09 32.95 29.13 -0.4 -0.14 -0.48 -1.07 -0.055 7.355 -6.395 -2.22 0.36 4.665 0.43 0.13 0.03 1.52 3.39 3.33 0.05 38.87 30.66 -0.69 -0.34 0.19 -0.6 0.12 7.45",
  "CGAGG 5.18 0.14 32 13.86 0.21 29 -6.32 0.35 45 -1.48 0.05 41 -1.79 0.04 45 -1.26 0.69 41 -2.8 0.73 45 34.97 0.48 41 31.5 0.31 45 -7.19 0.17 37 4.13 -0.02 0.09 -2.18 2.32 5.14 -1.28 -2.8 0.09 -0.45 3.23 3.3 -0.12 0.27 -0.02 -6.32 6.67 -1.48 -1.79 35.04 31.5 14.04 -2.01 1.54 -1.38 -4.975 0.27 2.37 -0.2 6.18 3.19 3.3 0.135 34.26 33.79 0.08 0.01 -0.3 -0.71 0.01 7.005 -8.77 -2.1 -1.82 5.505 1.53 3.61 0.075 2.185 3.38 3.26 0.04 35.75 30.16 -0.34 -0.12 -0.12 -0.81 0.04 7.465",
  "CGCGG 5.51 0.11 23 12.97 0.28 22 -4.25 0.31 244 -1.51 0.03 23 -1.62 0.05 244 -1.05 0.35 23 2.68 0.56 244 35.54 0.3 23 32.35 0.41 244 -4.76 0.11 238 4.07 -0.03 0.37 -0.63 1.65 5.36 -1.21 2.68 0.24 0.44 3.38 3.33 0.02 0 0.02 -4.25 2.16 -1.54 -1.62 35.97 32.35 14.87 -6.83 -0.71 -0.18 1.175 3.29 0.81 0.01 0.61 3.34 3.37 0.115 17.88 36.72 -0.23 0.14 -1.43 0.09 0.03 7.07 -5.305 -0.04 0.43 -3.535 -3.07 8.69 -0.015 0.685 3.49 2.81 0.035 36.07 23.6 0 0.05 -0.15 -0.12 0.205 7.195",
  "CGGCG 5.09 0.1 49 13.28 0.24 44 -3.17 0.26 51 -1.7 0.04 51 -1.55 0.03 51 -1.33 0.42 51 -1.46 0.4 51 33.59 0.34 51 36.24 0.37 51 -5.17 0.11 41 4.17 -0.04 0.13 0.16 0.28 5.19 -1.33 -1.46 -0.27 0.24 3.33 3.38 0.09 -0.01 0.07 -3.17 7.04 -1.7 -1.55 33.59 36.24 13.35 0.555 1.28 0.05 1.255 6.56 -1.11 0.01 8.45 3.5 3.24 0.125 33.36 27.86 0.08 0.2 -1 -0.51 -0.1 7.365 -8.495 -1.21 -0.2 1.65 2.64 -0.95 0.01 0.87 3.5 3.39 0.03 36 35.49 -0.57 0.26 -0.25 -0.36 0.135 6.7",
  "CGGGG 4.94 0.09 10 14.09 0.2 7 -1.95 0.32 10 -1.79 0.03 10 -1.84 0.04 10 -1.77 0.33 10 -1.76 0.44 10 33.22 0.19 10 33.62 0.35 10 -5.31 0.2 8 4.15 -0.04 0.08 0.34 1.72 4.91 -1.77 -1.76 -0.28 0.27 3.35 3.38 0.14 0.1 0.05 -1.96 6.9 -1.79 -1.84 33.22 33.61 14.38 -14.88 0.39 -1.81 11.135 4.59 6.69 -0.035 10.415 3.53 3.39 0.06 34.7 33.69 -0.16 -0.39 -0.55 -0.6 -0.145 7.12 -3.02 -1.24 0.17 4.99 3.17 5.94 0.02 1.035 3.48 3.37 0.035 35.21 30.11 -0.43 0.05 -0.32 -1.15 -0.04 7.79",
  "CGTGG 5.64 0.06 8 12.36 0.45 7 -7.87 0.4 107 -1.44 0.02 10 -1.33 0.05 107 -2.34 0.67 10 3.23 0.57 107 33.53 0.33 10 34.18 0.47 107 -6.67 0.08 79 3.91 -0.03 0.79 -1.39 -2.43 5.49 -2.37 3.23 -0.11 -0.65 3.32 3.24 -0.24 0.31 -0.03 -7.87 1.26 -1.48 -1.33 33.89 34.18 14.52 -8.695 0.93 -1.4 1.645 0.23 5.18 -0.025 1.59 3.35 3.36 0.03 29.11 35.26 0.14 -0.01 -0.89 -0.18 0.015 6.97 -7.64 0.64 -0.29 -6.825 -0.54 9.42 -0.045 1.67 3.31 2.93 0.035 31.32 25.46 -0.01 0.26 -0.45 -0.17 0.065 7.08",
  "CTAAG 5.49 0.12 9 13.32 0.22 8 -10.31 0.53 10 -1.39 0.05 9 -1.24 0.03 10 6.02 1 9 -3.25 0.7 10 34.71 0.36 9 35.04 0.27 10 -7.36 0.11 8 4.22 -0.03 1.31 -1.86 -1.08 5.33 6.27 -3.25 0.1 -1.07 3.4 3.09 -0.12 -0.05 -0.21 -10.31 5.96 -1.39 -1.24 34.66 35.04 13.62 -0.77 0.18 -0.17 -0.495 1.49 -1.34 -0.01 11.16 3.26 3.23 0.04 34.85 33.71 0.04 -0.07 -0.13 -0.55 -0.095 6.165 -10.15 -1.75 -3.36 1.245 11.34 -0.07 -0.005 4.4 3.04 3.29 0.035 24.59 36.23 0.16 -0.5 -0.19 -0.09 -0.025 6.91",
  "CTACG 5.77 0.12 27 12.72 0.21 24 -8.43 0.49 61 -1.37 0.05 61 -1.49 0.02 27 4.93 0.87 61 -2.16 0.57 27 34.25 0.53 61 34.02 0.47 27 -6.73 0.11 49 3.93 -0.03 0.09 -0.37 2.39 5.78 4.93 -2.15 0.11 -0.68 3.24 3.32 -0.02 0.21 0.03 -8.43 4.22 -1.37 -1.51 34.25 34.21 14.02 -4.295 -1.11 0.75 0.84 1.1 3.92 0.045 0.715 3.38 3.13 0.06 36.22 26.92 0.04 0.03 -0.28 -0.45 -0.085 7.56 -8.605 -0.14 0.18 -5.575 8.66 0.77 -0.065 1.99 2.99 3.27 0.035 27.73 30.04 0.26 -0.1 -0.13 -0.56 0.09 6.725",
  "CTAGG 5.69 0.17 7 13.63 0.15 7 -6.51 0.22 7 -1.46 0.02 7 -1.76 0.04 7 4.92 0.82 7 -2.23 0.55 7 34.19 0.33 7 31.47 0.24 7 -6.9 0.11 5 3.99 -0.03 -0.04 -1.93 0.58 5.59 4.92 -2.23 0.1 -0.83 3.28 3.27 0 0.23 0 -6.51 7.28 -1.46 -1.76 34.19 31.47 13.74 -6.58 0.25 0.08 1.19 0.7 4.07 -0.04 2.18 3.4 3.34 0.025 36.29 32.41 0.09 -0.17 0.16 -0.56 -0.09 6.925 -9.33 0.06 -2.61 0.23 9.68 2.13 0 4.69 2.96 3.3 0.035 25.48 33.56 -0.01 -0.49 -0.11 -0.46 0.195 7.36",
  "CTCCG 5.01 0.11 21 13.92 0.17 20 -5.07 0.31 21 -1.51 0.04 21 -1.75 0.03 21 -1.83 0.68 21 -0.61 0.42 21 35.79 0.4 21 33.51 0.27 21 -5.41 0.14 16 4.2 -0.04 -0.6 -0.75 0.7 5.09 -1.83 -0.61 0.28 0.24 3.28 3.4 0.11 -0.07 -0.03 -5.07 6.89 -1.51 -1.75 35.79 33.51 13.96 -3.16 0.62 -1.79 -5.1 3.94 2.54 -0.17 10.745 3.27 0.77 0.13 35.11 30.08 0.28 -0.19 -0.35 -0.75 -0.07 7.425 -7.325 -1.85 0.43 2.355 3.18 5.73 0.015 1.16 3.21 3.48 0.03 33.48 31.82 -0.18 -0.24 -0.37 -0.41 -0.035 7.13",
  "CTCGG 5.65 0.24 4 13.34 0.43 4 -6.12 0.29 6 -1.52 0.06 6 -1.6 0.08 4 -0.49 1.07 6 4.6 0.66 4 34.73 0.67 6 32.31 0.44 4 -4.85 0.34 4 4.01 -0.03 -0.3 -0.46 2.27 5.52 -0.49 4.74 0.27 0.47 3.26 3.41 0.14 0.05 -0.07 -6.12 5.75 -1.52 -1.63 34.73 32.45 14 -5.79 1.54 1.74 -7.1 0.27 3.99 -0.155 6.185 3.19 3.3 0.04 34.26 36.31 0.08 0.05 -0.3 -0.06 0.03 7.21 -6.06 -2.1 -1.58 -0.95 1.53 10.1 0 1.54 3.38 2.86 0.05 35.75 22.38 -0.34 -0.06 -0.12 -0.05 0.05 7.75",
  "CTGAG 5.56 0.14 6 13.62 0.31 6 -6.08 0.61 6 -1.41 0.05 6 -1.54 0.06 6 4.27 0.72 6 -0.89 1.16 6 34.47 0.26 6 34.84 0.72 6 -5.09 0.25 4 4.13 -0.04 -0.6 0.8 -1.97 5.59 4.27 -0.89 -0.27 0.28 3.36 3.27 0.26 -0.15 0 -6.08 6.95 -1.41 -1.54 34.47 34.84 13.73 -7.405 1.23 0.33 1.195 4.71 -0.39 0.045 5.255 3.45 3.33 -0.015 36.83 31.43 0.16 -0.29 -0.32 -0.56 -0.06 6.315 -6.9 1.17 -2.58 1.235 11.07 0.2 0.005 3.28 2.91 3.39 0.045 22.06 37.67 0.04 -0.54 0 0.06 0.09 7.38",
  "CTGCG 5.67 0.12 18 12.77 0.24 17 -3.85 0.34 20 -1.39 0.03 20 -1.52 0.03 19 3.64 0.71 20 -0.89 0.37 19 34.24 0.42 20 35.64 0.27 19 -5.01 0.13 18 4.1 -0.04 -1 0.3 -0.59 5.7 3.64 -0.89 -0.26 0.24 3.29 3.36 0.27 -0.01 0.1 -3.85 6.83 -1.39 -1.52 34.24 35.66 13.01 0.445 1.82 0.01 3.835 3.42 6.42 0.075 0.735 3.42 3.24 0.095 36.9 28.89 0.1 0.07 0.08 -0.7 -0.13 7.105 -7.28 -0.29 -0.46 -3.755 9.67 -1.45 -0.005 2.28 2.88 3.42 0.03 23.83 34.51 0.03 -0.21 -0.16 -0.39 0.14 7.26",
  "CTGGG 5.39 0.1 8 13.83 0.23 6 -2.47 0.4 41 -1.47 0.04 12 -1.81 0.03 41 2.42 0.52 12 -1.97 0.44 41 33.88 0.3 12 33.54 0.26 41 -5.02 0.25 33 4.07 -0.04 -2.17 0.41 1.62 5.24 3.61 -1.97 -0.27 0.3 3.37 3.36 0.33 0.12 0.1 -2.47 3.36 -1.54 -1.81 33.97 33.54 15.03 -2.81 -0.96 0.97 0.68 3.87 5.25 -0.02 1.085 3.4 3.42 -0.005 34.03 30.63 -0.23 -0.25 -0.37 -0.87 -0.075 7.11 -5.03 -0.45 -1 0.555 9.82 3.96 -0.01 2.53 2.85 3.45 0.04 23.51 34.1 0.11 -0.36 -0.08 -0.53 0.125 7.8",
  "CTTCG 4.92 0.24 16 13.59 0.22 14 -9.8 0.55 27 -1.27 0.04 27 -1.45 0.06 27 -3.7 1.23 27 -0.16 0.83 27 35.11 0.5 27 35.23 0.64 27 -7.77 0.21 21 4.31 -0.03 1.98 -1.45 0.1 4.96 -3.7 -0.16 -0.1 -1.02 3.13 3.33 0.01 0.28 -0.22 -9.8 6.54 -1.27 -1.45 35.11 35.23 13.7 -4.42 -1.21 0.64 -0.835 2.49 4.33 0.03 5.41 3.26 3.37 0.04 34.94 33.2 -0.08 0.12 -0.71 -0.59 -0.12 6.48 -9.55 -2.45 -0.77 5.185 1.66 2.23 0.065 2.48 3.19 3.42 0.04 32.17 35.44 -0.09 -0.48 -0.48 0 -0.04 6.825",
  "CTTGG 5.31 0.14 8 13.18 0.32 6 -9.71 0.44 10 -1.23 0.03 10 -1.38 0.02 8 -3.4 0.56 10 4.48 0.86 8 34.56 0.31 10 34.61 0.27 8 -7.06 0.2 8 4.16 -0.03 2.3 -2.38 1.92 5.36 -3.4 4.74 -0.09 -1 3.1 3.43 0.03 0.45 -0.28 -9.71 5.76 -1.23 -1.38 34.56 34.65 13.57 -4.22 0.99 -2.12 1.6 -0.32 4.21 -0.105 6.465 3.14 3.1 -0.02 34.05 16.27 0.04 0.02 -0.57 -0.1 -0.065 6.49 -7.74 -3.77 -1.98 1.555 -0.87 11 -0.01 3.61 3.32 2.96 0.025 37.64 23.39 -0.6 0.1 0.07 -0.14 -0.09 7.43",
  "GAAAC 4.74 0.26 14 13.09 0.26 12 -12.76 0.51 18 -1.02 0.04 18 -1.11 0.04 18 -2.18 0.81 18 -3.35 1.06 18 36.01 0.33 18 36.17 0.3 18 -8.38 0.31 13 4.55 -0.03 -1.47 -1.77 6.57 4.83 -2.18 -3.35 0.14 -1.63 3.15 3.15 -0.29 0 -0.11 -12.76 5.41 -1.02 -1.11 36.01 36.17 13.32 -9.165 -1.76 -0.25 2.215 -1.32 -1.5 -0.025 8.455 1.86 3.26 0.01 36.31 35.33 0.02 0.01 -0.55 -0.96 -0.09 4.745 -15.895 -1.25 -2.78 5.8 1.83 0.74 0.09 3.02 3.27 3.35 0.015 32.4 36.19 -0.14 -0.2 -0.44 -0.42 -0.05 5.585",
  "GAAAG 4.36 0.24 39 13.3 0.24 22 -11.93 0.79 45 -1.08 0.05 45 -1.26 0.05 45 -3 0.8 45 -4.95 1.08 45 35.91 0.41 45 36.1 0.44 45 -8.88 0.51 37 4.56 -0.02 -1.31 -1.87 5.43 4.4 -3 -4.95 0.15 -1.54 3.17 3.19 -0.23 0.13 -0.13 -11.93 5.25 -1.08 -1.26 35.91 36.1 13.53 2.17 -1.76 0.69 8.29 -1.32 -2.47 -0.195 16.365 1.86 3.2 -0.14 36.31 36.5 0.02 -0.02 -0.55 -0.75 -0.04 4.465 -14.4 -1.25 -2.37 5.02 1.83 1.3 0.09 3.195 3.27 3.25 0.02 32.4 34.29 -0.14 -0.14 -0.44 -0.44 -0.04 5.845",
  "GAACC 4.46 0.34 23 13.71 0.26 13 -10.08 0.83 30 -1.16 0.09 30 -1.6 0.06 30 -3.83 1.14 30 -3.59 0.87 30 35.45 0.4 30 35.19 0.79 30 -8.2 0.23 24 4.43 -0.02 -1.83 -0.53 8.53 4.48 -3.83 -3.59 0.15 -0.91 3.11 3.44 -0.08 0.33 0.06 -10.08 5.71 -1.16 -1.6 35.45 35.19 13.99 1.69 -0.08 -0.74 -0.835 -0.22 0.02 -0.125 12.82 3.24 3.23 0.085 34.75 31.1 0.02 -0.01 -0.62 -1.28 -0.15 5.63 -16.745 -2.66 0.68 1.35 1.29 -0.47 0.07 1.885 3.35 3.45 0.025 35.61 33.37 -0.2 -0.13 -0.38 -0.8 0.005 5.31",
  "GAACG 4.74 0.15 33 13.04 0.19 30 -11.06 0.32 33 -1.09 0.02 33 -1.53 0.02 33 -2.93 0.62 33 -2.93 0.47 33 35.71 0.25 33 34.9 0.28 33 -7.82 0.14 25 4.39 -0.02 -1.93 0.04 9.67 4.77 -2.93 -2.93 0.15 -1.02 3.08 3.4 -0.12 0.4 0.08 -11.06 6.53 -1.09 -1.53 35.71 34.9 13.09 -6.18 -0.08 -0.8 4.28 -0.22 1.38 0.095 -0.375 3.24 3.32 0.015 34.75 32.17 0.02 -0.19 -0.62 -1.04 -0.12 5.39 -12.785 -2.66 0.24 3.3 1.29 -0.87 0.09 2.075 3.35 3.43 0.035 35.61 32.81 -0.2 -0.39 -0.38 -0.66 0.07 6.255",
  "GAAGC 4.82 0.14 22 14.07 0.19 13 -8.01 0.4 94 -1.26 0.03 94 -1.77 0.03 93 -3.36 0.56 94 -2.79 0.62 93 34.96 0.34 94 32.06 0.25 93 -7.86 0.14 73 4.29 -0.02 -2.2 -2.17 4.95 4.84 -3.36 -2.78 0.13 -0.94 3.13 3.35 -0.07 0.29 0.02 -8.01 4.62 -1.26 -1.77 34.96 32.06 14.39 11.625 -1.21 -0.63 1.515 2.49 3.27 -0.27 23.815 3.26 3.5 -0.22 34.94 36.01 -0.08 -0.08 -0.71 -0.95 -0.04 6.755 -17.315 -2.45 -3.04 6.235 1.66 4.55 0.115 3.245 3.19 3.54 0.02 32.17 35.23 -0.09 -0.25 -0.48 -0.78 0.065 5.835",
  "GAAGG 4.63 0.16 13 14.3 0.19 5 -7.38 0.37 15 -1.28 0.03 15 -1.86 0.04 15 -3.82 0.57 15 -3.57 0.77 15 34.75 0.36 15 32.02 0.31 15 -7.89 0.14 11 4.35 -0.01 -2.16 -2.24 6.61 4.61 -3.82 -3.57 0.12 -0.56 3.1 3.4 -0.02 0.34 0.04 -7.38 5.72 -1.28 -1.86 34.75 32.02 14.53 -6.98 -1.21 0.27 -0.69 2.49 2.63 0.01 4.885 3.26 3.38 0.04 34.94 34.14 -0.08 -0.06 -0.71 -0.76 -0.025 6.44 -13.325 -2.45 -1.95 4.555 1.66 3.9 0.115 3.23 3.19 3.33 0.02 32.17 32.22 -0.09 -0.18 -0.48 -0.78 0.035 6.495",
  "GAATC 4.36 0.47 5 13.81 0.34 4 -9.46 0.5 18 -1.24 0.04 18 -1.57 0.04 18 -3.18 0.88 18 -5.55 0.86 18 35.53 0.29 18 32.93 0.29 18 -8.53 0.15 14 4.45 -0.02 -2.04 0.68 3.24 4.49 -3.18 -5.55 0.15 -1.04 3.18 3.3 -0.11 0.16 -0.05 -9.46 4.6 -1.24 -1.57 35.53 32.93 14.26 -5.225 -1.59 0.3 0.725 -1.17 0.14 0.075 9.68 3.26 3.21 0.1 35.73 32.14 0.02 -0.07 -0.66 -1.15 -0.13 4.335 -17.31 -2.71 -0.16 1.35 1.21 -1.55 0.145 2.23 3.34 3.39 0.035 34.45 32.02 -0.13 -0.06 -0.61 -0.83 0 5.345",
  "GAATG 4.39 0.31 379 13.69 0.31 297 -9.43 0.53 391 -1.22 0.05 391 -1.56 0.06 391 -3.64 1.11 391 -5.91 1.35 391 35.63 0.47 391 32.69 0.44 391 -8.53 0.24 308 4.48 -0.02 -2.04 0.8 4.13 4.47 -3.64 -5.91 0.15 -1 3.16 3.29 -0.12 0.18 -0.03 -9.43 6.1 -1.22 -1.56 35.63 32.69 13.75 -3.02 -1.59 2.52 -1.405 -1.17 -0.35 0.055 9.035 3.26 3.29 0.03 35.73 28.07 0.02 -0.05 -0.66 -1.2 -0.08 4.805 -16.025 -2.71 1.09 0.88 1.21 -1.22 0.125 2.51 3.34 3.28 0.025 34.45 31.23 -0.13 0.16 -0.61 -0.79 0.035 5.585",
  "GACAC 5.49 0.14 22 12.99 0.28 16 -7.25 0.39 22 -1.48 0.02 22 -1.27 0.08 22 -2.01 0.4 22 4.23 0.63 22 34.03 0.26 22 34.92 0.61 22 -5.39 0.21 17 4.3 -0.03 -0.99 0.94 4.45 5.54 -2.01 4.23 0.26 0.41 3.33 3.32 0.22 -0.32 0.08 -7.25 6.86 -1.48 -1.27 34.03 34.92 12.92 -5.355 0.11 1.38 3.21 0.71 6.67 -0.035 5.93 3.23 3.43 0.005 29.32 36.74 0.01 0.33 -1.08 -0.22 -0.125 6.505 -10.555 -0.05 0.73 -3.42 -0.33 9.43 -0.04 1.87 3.36 3.36 0.035 31.44 33.76 -0.36 0.31 -0.69 -0.34 0.07 6.605",
  "GACAG 5.26 0.07 7 13.35 0.12 7 -6.88 0.24 7 -1.51 0.02 7 -1.44 0.02 7 -2.46 0.21 7 3.98 0.55 7 34.25 0.15 7 34.79 0.34 7 -5.58 0.06 5 4.28 -0.03 -0.68 0.66 4.78 5.34 -2.46 3.98 0.27 0.52 3.34 3.38 0.29 -0.27 0.04 -6.88 6.75 -1.51 -1.44 34.25 34.79 13.47 -8.125 0.11 0.41 2.435 0.71 5.58 -0.035 3.415 3.23 3.49 0.02 29.32 35.68 0.01 0.09 -1.08 -0.67 -0.115 6.75 -11.02 -0.05 -0.5 -4.47 -0.33 9.7 -0.02 2.715 3.36 3.27 0.03 31.44 32.34 -0.36 0.08 -0.69 -0.16 0.075 6.825",
  "GACCC 4.45 0.14 63 14.66 0.29 45 -5.33 0.51 79 -1.58 0.03 79 -1.86 0.04 79 -3.44 0.53 79 -1.78 0.76 79 34.81 0.2 79 34.36 0.36 79 -5.79 0.23 65 4.35 -0.03 -0.63 -0.85 4.27 4.52 -3.44 -1.78 0.29 0.55 3.38 3.48 0.27 -0.04 -0.03 -5.33 5.83 -1.58 -1.86 34.81 34.36 14.81 -6.32 -1.38 1.11 -0.81 1.27 3.17 0.005 -0.335 3.25 3.65 0.02 30.21 35.52 -0.28 -0.03 -1.11 -1.38 -0.135 6.515 -14.345 0.68 0.43 1.545 -0.37 5.47 0 1.14 3.43 3.68 0.015 32.74 33.67 -0.19 0.01 -0.74 -1.23 0.065 5.515",
  "GACCG 4.69 0.13 39 13.72 0.22 32 -5.99 0.36 39 -1.55 0.03 39 -1.76 0.03 39 -2.77 0.49 39 -0.84 0.41 39 34.65 0.21 39 34.17 0.25 39 -5.5 0.13 31 4.31 -0.03 -0.97 -0.59 3.77 4.83 -2.77 -0.84 0.28 0.44 3.37 3.43 0.22 -0.07 0 -5.99 6.8 -1.55 -1.76 34.65 34.17 13.71 -3.44 -1.38 -1.2 -2.225 1.27 0.98 -0.02 6.845 3.25 4.29 0.045 30.21 32.85 -0.28 -0.03 -1.11 -0.75 -0.11 6.95 -10.015 0.68 -0.99 3.975 -0.37 3.53 0.025 1.425 3.43 3.61 0.035 32.74 36.59 -0.19 -0.51 -0.74 -0.44 0.165 6.435",
  "GACGC 5.09 0.11 53 13.21 0.23 15 -7.38 0.41 106 -1.5 0.03 106 -1.66 0.04 106 -2.45 0.44 106 4.23 0.52 106 34.21 0.36 106 33.02 0.28 106 -5.25 0.11 82 4.23 -0.02 -0.47 -0.26 5.02 5.14 -2.45 4.23 0.26 0.64 3.34 3.46 0.25 0.03 -0.03 -7.38 5.51 -1.5 -1.66 34.21 33.02 13.74 -3.64 0.8 -0.81 0.42 1.69 6.61 -0.015 4.105 3.3 3.55 0.07 29.13 36.65 -0.14 -0.19 -1.07 -0.3 -0.1 7.245 -9.065 0.36 1.24 -0.575 0.13 8.92 0.02 0.915 3.33 3.4 0.03 30.66 35.4 -0.34 0.21 -0.6 -0.19 0.165 6.715",
  "GACGG 5.1 0.07 14 13.37 0.18 13 -7.15 0.31 21 -1.5 0.03 21 -1.68 0.04 19 -2.46 0.4 21 3.11 0.64 19 34.1 0.24 21 33.08 0.25 19 -5.29 0.15 17 4.25 -0.02 -0.3 -0.78 5.66 5.08 -2.46 3.28 0.27 0.72 3.33 3.46 0.27 0.03 -0.04 -7.15 6.17 -1.5 -1.68 34.1 33.1 13.72 -4.055 0.8 0.88 0.51 1.69 6.79 0.06 4.285 3.3 3.41 0.075 29.13 34.95 -0.14 0.29 -1.07 -0.07 -0.05 7.24 -7.79 0.36 0.15 0 0.13 8.7 0 1.45 3.33 3.13 0.05 30.66 31.48 -0.34 -0.03 -0.6 -0.03 0.17 7.12",
  "GACTG 5 0.26 18 13.61 0.43 15 -3.96 0.4 20 -1.64 0.04 18 -1.7 0.06 20 -2.08 0.84 18 -1.4 0.85 20 34.65 0.28 18 31.46 0.32 20 -5.57 0.22 14 4.27 -0.02 -2.18 2.63 0.06 5.09 -2.15 -1.4 0.25 0.33 3.43 3.33 0.22 -0.21 0.12 -3.96 6.4 -1.65 -1.7 34.71 31.46 13.85 -6.065 0.4 0.62 5.035 -0.05 3.99 0.035 7.605 3.22 3.49 0.01 30.4 33.34 0.12 0.04 -1.09 -0.86 -0.145 6.375 -12.525 1.62 -3.95 4.865 -0.65 0.77 0.04 2.86 3.49 3.44 0.03 33.25 37.04 -0.17 -0.74 -0.82 -0.3 0.22 6.14",
  "GAGAC 5.04 0.17 17 14.17 0.2 14 -3.46 0.61 21 -1.69 0.04 21 -1.5 0.07 21 -1.45 0.84 21 -1.85 0.64 21 31.76 0.18 21 36.17 0.5 21 -5.7 0.13 16 4.32 -0.03 -2.15 1.74 2.75 4.99 -1.45 -1.85 -0.27 0.16 3.32 3.32 0.16 -0.16 0.1 -3.46 6.05 -1.69 -1.5 31.76 36.17 14.4 -5.2 -1.04 0.5 2.08 4.02 -0.35 0.03 4.705 3.24 3.31 0.035 31.39 34.57 -0.12 0.18 -0.62 -0.47 -0.12 6.395 -12.345 -1.15 -1.64 6.32 5.12 1.08 0.075 2.25 3.36 3.39 0.025 30.19 37.9 -0.17 -0.36 -0.74 -0.18 0.09 6.605",
  "GAGAG 4.93 0.15 12 14.9 0.16 4 -2.54 0.37 17 -1.75 0.03 17 -1.64 0.04 15 -1.93 0.68 17 -1.9 0.93 15 31.39 0.23 17 35.65 0.47 15 -5.81 0.45 13 4.26 -0.03 -1.97 1.73 2.1 5 -1.93 -1.65 -0.27 0.25 3.32 3.37 0.19 -0.13 0.08 -2.54 5.24 -1.75 -1.65 31.39 35.62 15.03 0.735 -1.04 0.5 6.43 4.02 3.59 -0.07 9.73 3.24 3.53 0.045 31.39 31.77 -0.12 0.09 -0.62 -1.55 -0.18 6.525 -11.715 -1.15 -0.7 3.96 5.12 3.41 0.065 2.11 3.36 3.32 0.025 30.19 33.95 -0.17 -0.08 -0.74 -0.49 0.05 7",
  "GAGCC 4.67 0.2 4 14.72 0.22 3 -0.53 0.23 13 -1.76 0.03 13 -1.72 0.04 7 -2.76 0.57 13 -3.07 0.87 7 31.39 0.29 13 37.09 0.31 7 -5.58 0.34 11 4.25 -0.01 -2.07 1.13 3.79 4.83 -2.76 -2.83 -0.25 0.39 3.3 3.48 0.24 0.03 0.14 -0.53 3.97 -1.76 -1.73 31.39 37.06 15.11 -3.115 0.48 -0.03 4.85 4.13 0.71 -0.095 4.73 3.36 3.47 0.07 31.86 33 -0.15 0.19 -0.68 -1.1 -0.065 6.745 -16.625 -2.57 -0.58 5.085 4.35 -0.12 0.065 1.755 3.45 3.53 0.02 33.22 35.84 -0.25 0.05 -0.73 -0.81 0.155 5.835",
  "GAGCG 5.02 0.15 39 13.92 0.24 37 -1.32 0.26 39 -1.72 0.03 39 -1.64 0.04 39 -1.89 0.57 39 -1.98 0.72 39 31.47 0.33 39 36.68 0.38 39 -5.41 0.12 31 4.25 -0.02 -2.26 1.1 3.69 5.09 -1.89 -1.98 -0.25 0.25 3.27 3.44 0.21 -0.01 0.16 -1.32 6.97 -1.72 -1.64 31.47 36.68 13.91 -6.78 0.48 -0.84 -0.37 4.13 1.21 -0.075 1.23 3.36 3.42 0.065 31.86 32.32 -0.15 0.07 -0.68 -0.75 -0.005 6.87 -15.985 -2.57 1.12 2.775 4.35 -0.06 0.06 1.41 3.45 3.45 0.01 33.22 34.64 -0.25 0.24 -0.73 -0.57 0.205 6.325",
  "GAGGC 4.85 0.17 29 14.66 0.3 19 -0.7 0.5 40 -1.8 0.04 40 -1.88 0.05 40 -2.42 0.72 40 -2.18 0.85 40 31.38 0.42 40 33.92 0.41 40 -5.62 0.2 31 4.22 -0.02 -2.32 1.3 3.1 4.86 -2.42 -2.18 -0.26 0.26 3.3 3.43 0.22 0.08 0.13 -0.7 5.81 -1.8 -1.88 31.38 33.92 14.9 6.085 -1.38 -0.99 0.19 2.37 2.03 -0.16 13.005 3.3 3.59 0.175 33.79 31.99 0.01 0.03 -0.71 -0.33 0.005 7.09 -12.08 -1.82 0.61 6.145 3.61 5.32 0.085 1.93 3.26 3.64 0.025 30.16 34.58 -0.12 -0.13 -0.81 -1.02 0.17 6.44",
  "GAGGG 4.78 0.16 34 14.72 0.26 26 -0.03 0.38 34 -1.8 0.02 34 -1.92 0.03 34 -2.73 0.74 34 -2.62 0.78 34 31.33 0.17 34 33.87 0.34 34 -5.55 0.11 26 4.23 -0.02 -2.35 1.15 4.25 4.73 -2.73 -2.62 -0.27 0.35 3.29 3.45 0.24 0.12 0.14 -0.03 6.53 -1.8 -1.92 31.33 33.87 14.92 -1.08 -1.38 -1.32 -1.32 2.37 3.56 -0.285 9.69 3.3 3.49 0.14 33.79 34.59 0.01 -0.08 -0.71 -0.79 0.05 6.915 -8.53 -1.82 0.76 4.47 3.61 5.78 0.07 1.735 3.26 3.46 0.025 30.16 32.29 -0.12 0.03 -0.81 -0.97 0.07 7.1",
  "GAGTC 4.53 0.24 30 14.5 0.27 25 -3.11 0.44 34 -1.79 0.03 30 -1.71 0.03 34 -2.44 0.88 30 -3.57 0.96 34 31.83 0.31 30 34.87 0.31 34 -5.82 0.19 28 4.39 -0.02 -2.27 2.04 0.05 4.6 -2.3 -3.57 -0.26 0.4 3.38 3.46 0.22 -0.22 0.1 -3.11 5.87 -1.8 -1.71 31.85 34.87 14.68 -4.255 0.16 0.4 4.84 4.06 -0.05 -0.005 8.08 3.48 3.22 0.01 36.4 30.4 0.05 0.12 -0.96 -1.09 -0.135 6.375 -17.91 -2.53 1.62 4.935 3.33 -0.65 0.085 1.87 3.59 3.49 0.025 34.74 33.25 -0.18 -0.17 -0.88 -0.82 0.24 5.095",
  "GAGTG 4.78 0.22 27 14.09 0.44 26 -3.31 0.77 29 -1.77 0.06 29 -1.67 0.1 29 -1.98 0.91 29 -3.21 0.67 29 31.79 0.33 29 34.12 1 29 -5.66 0.2 22 4.32 -0.02 -2.39 1.92 0 4.94 -1.98 -3.21 -0.25 0.33 3.35 3.41 0.21 -0.26 0.11 -3.31 6.63 -1.77 -1.67 31.79 34.12 14.08 -6.705 0.16 0.23 3.62 4.06 2.61 -0.055 8.285 3.48 3.37 0.01 36.4 30.45 0.05 0 -0.96 -1.09 -0.1 6.6 -17.47 -2.53 2.38 1.375 3.33 -3.54 0.07 1.505 3.59 3.4 0.015 34.74 34.76 -0.18 0.35 -0.88 -0.48 0.21 5.115",
  "GATAC 5.65 0.27 21 13.39 0.56 11 -8.06 0.5 43 -1.49 0.03 43 -1.4 0.05 43 -3.62 0.66 43 5.72 0.98 43 32.1 0.26 43 34.46 0.45 43 -7.1 0.15 35 4.07 -0.02 -0.4 0.01 3.37 5.75 -3.62 5.72 -0.1 -0.77 3.21 3.31 -0.01 0 -0.03 -8.06 5.56 -1.49 -1.4 32.1 34.46 13.92 -4.72 -0.48 -2.31 -1.835 -0.09 6.23 -0.02 8.66 3.28 4.17 0.015 31.38 37.58 -0.1 0.21 -0.95 -0.85 -0.045 6.595 -11.67 0.19 0.31 -1.91 0.42 8.55 -0.005 2.98 3.23 3.3 0.035 29.64 33.49 0.03 0.06 -0.86 -0.36 0.115 6.625",
  "GATAG 5.54 0.73 5 13.18 0.27 4 -8.88 1.88 13 -1.55 0.08 13 -1.49 0.08 12 -4.19 1.5 13 6.28 2.46 12 32.43 0.62 13 33.89 1.76 12 -7.11 0.46 11 4.11 -0.01 -0.45 0.03 1.96 5.33 -4.19 6.37 -0.11 -0.36 3.25 3.36 -0.05 0.04 -0.08 -8.88 5.89 -1.55 -1.5 32.43 33.94 14.07 -5.415 -0.48 0.01 -4.625 -0.09 -1.56 0.02 4.27 3.28 3.43 0.005 31.38 38.93 -0.1 0.14 -0.95 -0.69 -0.005 6.17 -12.625 0.19 0.23 2.105 0.42 11.11 0.02 3.39 3.23 3.29 0.04 29.64 31.37 0.03 0.1 -0.86 -0.48 0.085 6.915",
  "GATCC 4.63 0.37 19 14.61 0.38 15 -7.56 0.63 41 -1.52 0.04 38 -1.57 0.05 24 -4.63 0.73 38 -1.67 2.21 24 32.41 0.24 38 36.29 0.85 24 -7.65 0.23 33 4.3 -0.02 0.23 -0.97 3.13 4.63 -4.64 -1.29 -0.08 -0.1 3.24 3.41 0.05 0.22 -0.16 -7.56 3.55 -1.52 -1.59 32.44 36.25 14.96 -10.495 -0.42 -0.25 -2.18 1.51 0.71 0.01 3.815 3.21 3.36 0.11 30.42 36.74 -0.05 -0.16 -0.89 -0.7 -0.185 5.89 -15.665 -0.03 -1.44 0.06 -1.65 2.13 0.095 1.215 3.37 3.4 0.025 31.48 36.42 0.01 -0.09 -0.8 -0.52 -0.025 5.565",
  "GATCG 4.96 0.35 56 13.7 0.44 50 -7.79 0.45 59 -1.5 0.04 59 -1.5 0.04 57 -4.15 1.04 59 -0.57 1.24 57 32.29 0.35 59 35.54 0.66 57 -7.6 0.3 46 4.26 -0.02 -0.11 -0.47 2.49 5.02 -4.15 -0.57 -0.1 -0.61 3.23 3.31 -0.02 0.19 -0.11 -7.79 6.79 -1.5 -1.5 32.29 35.57 13.8 -9.35 -0.42 -0.28 -1.965 1.51 0.86 -0.045 6.73 3.21 3.29 0.12 30.42 34.73 -0.05 0.08 -0.89 -0.36 -0.115 6.315 -12.01 -0.03 -2.17 4.43 -1.65 1.28 0.105 1.46 3.37 3.47 0.035 31.48 38.8 0.01 -0.62 -0.8 0.04 0.06 6.305",
  "GATGC 5.38 0.25 15 13.57 0.35 13 -7.6 0.57 20 -1.48 0.03 20 -1.44 0.07 20 -4.24 0.84 20 3.67 1.06 20 31.96 0.28 20 34.59 0.38 20 -7.24 0.27 16 4.16 -0.02 0.22 -1.41 2.26 5.45 -4.24 3.67 -0.09 -0.48 3.23 3.36 -0.02 0.33 -0.13 -7.6 6.22 -1.48 -1.44 31.96 34.59 13.86 -5.82 0.06 -1.53 -9.485 1.15 1.9 -0.11 15.305 3.23 3.45 -0.13 27.88 36.82 -0.12 -0.32 -1.11 0.04 0.01 6.58 -12.25 0.38 -0.31 -1.48 -0.45 10.06 0.025 3.09 3.21 3.3 0.035 29.55 32.58 0 0.1 -0.75 -0.39 0.035 6.46",
  "GATGG 5.53 0.2 100 13.39 0.36 94 -7.48 0.54 106 -1.46 0.04 106 -1.47 0.06 106 -3.42 0.76 106 4.13 1.15 106 31.66 0.29 106 34.54 0.45 106 -6.99 0.17 85 4.11 -0.02 0.37 -1.82 3.75 5.54 -3.42 4.13 -0.09 -0.47 3.2 3.37 0.01 0.36 -0.15 -7.48 7.3 -1.46 -1.47 31.66 34.54 13.44 -8.805 0.06 0.59 -1.505 1.15 2.89 -0.055 2.18 3.23 3.43 0.025 27.88 38.36 -0.12 0.14 -1.11 0.02 -0.045 6.53 -10.95 0.38 0.08 -2.115 -0.45 9.76 0.015 2.845 3.21 3.16 0.035 29.55 31.42 0 0.25 -0.75 -0.18 0.04 6.63",
  "GATTG 4.81 0.29 310 13.24 0.37 293 -10.33 0.59 313 -1.54 0.04 313 -1.2 0.04 313 -4.28 1.1 313 -2.12 1.03 313 32.75 0.4 313 34.92 0.41 313 -7.97 0.23 247 4.37 -0.03 -0.67 2.34 -2.85 4.96 -4.28 -2.12 -0.15 -1.49 3.28 3.15 -0.17 0.1 -0.05 -10.33 6.68 -1.54 -1.2 32.75 34.92 13.25 -9.565 0.3 -1.33 0.865 0.14 1.93 0.09 2.555 3.21 3.25 0.055 32.14 34.75 -0.07 -0.06 -1.15 -0.57 -0.09 5.12 -13.675 -0.16 -3.82 3.475 -1.55 -0.48 0.115 2.755 3.39 3.36 0.03 32.02 38.22 -0.06 -0.74 -0.83 -0.02 -0.02 6.065",
  "GCAAG 5.45 0.22 18 13.01 0.26 15 -9.9 0.58 18 -1.29 0.09 18 -1.21 0.05 18 4.47 0.87 18 -3.39 0.76 18 34.37 0.97 18 34.89 0.31 18 -7.19 0.17 16 4.21 -0.03 2.32 -2.25 0.29 5.47 4.47 -3.39 0.09 -1.05 3.35 3.12 -0.42 -0.01 -0.24 -9.9 6.63 -1.29 -1.21 34.37 34.89 13.18 0.37 3.97 0.99 4.675 3.56 -0.32 -0.01 0.8 3.42 3.14 -0.035 34.96 34.05 0.38 0.04 0.18 -0.57 -0.06 6.35 -8.19 -1.99 -3.77 0 11.7 -0.87 0 3.79 2.91 3.32 0.03 21.48 37.64 0.13 -0.6 -0.16 0.07 -0.07 7.42",
  "GCACG 5.74 0.13 35 12.46 0.29 33 -8.4 0.33 35 -1.19 0.05 35 -1.45 0.04 35 3.22 0.65 35 -2.27 0.4 35 34.75 0.33 35 33.78 0.21 35 -6.68 0.1 29 4.09 -0.04 1.05 -0.5 4.21 5.79 3.22 -2.27 0.11 -0.85 3.2 3.32 -0.32 0.29 0.02 -8.4 7.37 -1.19 -1.45 34.75 33.78 12.48 -3.07 -0.61 0.93 -3.395 4.05 0.23 -0.145 8.485 3.3 3.35 0.055 34.03 29.11 0.15 0.14 -0.26 -0.89 0.01 6.69 -10.275 0.15 0.64 -5.305 9.88 -0.54 -0.035 1.795 3.14 3.31 0.035 29.37 31.32 0.21 -0.01 -0.22 -0.45 0.105 6.82",
  "GCAGC 5.67 0.1 13 13.48 0.25 13 -6.76 0.35 13 -1.37 0.06 13 -1.67 0.04 13 3.55 0.59 13 -2.09 0.37 13 34.49 0.42 13 31.29 0.33 13 -6.71 0.08 11 4.06 -0.03 1.1 -2.43 1.06 5.55 3.55 -2.09 0.09 -0.7 3.28 3.27 -0.27 0.24 -0.05 -6.76 6.99 -1.37 -1.67 34.49 31.29 13.49 -1.055 1.82 -0.88 1.265 3.42 2.66 -0.05 7.51 3.42 3.35 0.05 36.9 31.67 0.1 -0.23 0.08 -0.63 -0.035 6.975 -6.92 -0.29 -3.59 -0.43 9.67 0.33 0.005 3.655 2.88 3.35 0.03 23.83 35.72 0.03 -0.61 -0.16 -0.23 0.145 7.79",
  "GCAGG 5.52 0.1 11 13.45 0.14 5 -5.92 0.94 13 -1.4 0.05 13 -1.77 0.01 11 2.96 0.71 13 -3.15 0.44 11 33.94 0.44 13 31.18 0.3 11 -6.71 0.27 11 4.01 -0.02 0.7 -2.28 2.46 5.45 2.96 -2.88 0.1 -0.52 3.25 3.31 -0.27 0.31 -0.02 -5.92 6.22 -1.4 -1.78 33.94 31.08 13.88 -3.04 1.82 0.47 2.245 3.42 3.41 -0.01 4.49 3.42 3.26 0.07 36.9 32.49 0.1 0.32 0.08 -0.58 -0.1 6.72 -6.7 -0.29 -3.47 0 9.67 0.92 0 3.91 2.88 3.32 0.03 23.83 35.12 0.03 -0.57 -0.16 -0.28 0.15 7.87",
  "GCATG 5.5 0.14 28 12.74 0.28 26 -9.43 0.86 114 -1.45 0.07 114 -1.42 0.02 29 4.69 0.64 114 -3.87 0.49 29 34.82 0.45 114 31.54 0.24 29 -6.8 0.11 92 4.06 -0.01 1.71 -0.04 -3.68 5.41 4.69 -3.62 0.09 -0.36 3.42 3.24 -0.37 -0.07 -0.21 -9.43 2.62 -1.45 -1.44 34.82 31.86 14.16 -5.695 -1.53 -0.43 -8.87 1.9 0.79 -0.11 15.64 3.45 3.19 -0.2 36.82 26.17 -0.32 0.02 0.04 -0.87 -0.055 6.435 -11.815 -0.31 0.01 -0.09 10.06 0.36 0 3.47 3.3 3.25 0.03 32.58 29.75 0.1 -0.03 -0.39 -0.76 0.03 6.99",
  "GCCAG 5.43 0.16 18 13.62 0.15 18 -3.34 0.42 30 -1.74 0.04 30 -1.45 0.05 24 -1.52 0.44 30 2.79 0.63 24 33.53 0.32 30 34.28 0.38 24 -5.19 0.18 26 4.13 -0.04 -0.52 1.45 -0.08 5.4 -1.52 3.13 0.27 0.2 3.33 3.34 -0.1 -0.3 0.09 -3.34 5.56 -1.74 -1.47 33.53 34.29 14.17 -4.42 0.26 -0.96 -0.41 3.45 3.87 -0.055 1.26 3.37 3.4 0.025 32.46 34.03 -0.02 -0.23 -0.47 -0.37 -0.105 6.915 -6.07 -1.53 -0.45 1.04 2.87 9.82 -0.015 2.6 3.48 2.85 0.04 35.96 23.51 -0.6 0.11 -0.29 -0.08 0.17 7.66",
  "GCCCG 4.95 0.11 42 14.03 0.17 36 -2.73 0.34 46 -1.77 0.04 46 -1.77 0.04 42 -1.71 0.52 46 -1.7 0.44 42 33.78 0.35 46 33.44 0.39 42 -5.55 0.25 37 4.16 -0.04 -0.45 -0.23 -0.59 4.99 -1.71 -1.69 0.28 0.23 3.37 3.36 -0.09 -0.12 0.05 -2.73 6.46 -1.77 -1.78 33.78 33.48 14.13 -3.06 0.71 0.39 5.825 5.14 4.59 0.115 3.68 3.65 3.53 0 33.56 34.7 -0.11 -0.16 -1.15 -0.55 -0.16 7.53 -8.125 -0.03 -1.24 8.985 5.1 3.17 0.025 1.27 3.61 3.48 0.035 34.08 35.21 -0.1 -0.43 -0.98 -0.32 0.15 6.925",
  "GCCGG 5.36 0.14 13 13.57 0.2 9 -3.58 0.27 16 -1.71 0.03 16 -1.61 0.04 14 -1.33 0.34 16 2.08 0.77 14 33.41 0.31 16 32.61 0.18 14 -5.02 0.11 14 4.06 -0.04 -0.13 -0.08 0.7 5.35 -1.33 2.24 0.25 0.28 3.33 3.34 -0.1 -0.01 0.03 -3.58 6.32 -1.71 -1.62 33.41 32.62 13.84 -1.225 1.28 2.64 0.055 6.56 2.17 0.055 4.175 3.5 3.29 0.09 33.36 35.19 0.08 0.29 -1 0.05 -0.015 7.57 -3.59 -1.21 -0.05 0.105 2.64 8.79 -0.005 1.595 3.5 2.78 0.05 36 23.08 -0.57 -0.02 -0.25 -0.06 0.24 7.94",
  "GCCTG 4.94 0.13 11 14.03 0.2 10 -1.28 0.52 15 -1.85 0.05 15 -1.75 0.05 15 -1.61 1.03 15 -2.26 1.16 15 33.99 0.7 15 31.14 0.54 15 -5.63 0.22 10 4.23 -0.03 -1.19 2.41 -3.2 4.97 -1.61 -2.26 0.25 0.18 3.42 3.29 -0.09 -0.24 0.14 -1.28 6.77 -1.85 -1.75 33.99 31.14 14.09 0.745 -0.99 0.47 5.855 2.03 3.41 -0.025 8.445 3.59 3.26 0.105 31.99 32.49 0.03 0.32 -0.33 -0.58 -0.06 7.08 -10.22 0.61 -3.47 9.5 5.32 0.92 0.045 2.445 3.64 3.32 0.025 34.58 35.12 -0.13 -0.57 -1.02 -0.28 0.22 6.77",
  "GCGAG 5.46 0.09 62 13.25 0.22 3 -6.31 0.37 97 -1.58 0.03 96 -1.48 0.04 97 4.38 0.37 96 -1.17 0.52 97 32.59 0.19 96 35.13 0.36 97 -5.13 0.11 78 4.09 -0.03 0.3 0.23 -1.79 5.46 4.39 -1.17 -0.26 0.37 3.39 3.25 -0.07 -0.13 -0.05 -6.31 5.99 -1.58 -1.48 32.59 35.13 13.86 -5.155 -1.84 1.54 3.95 5.54 0.27 0.025 -3.17 3.48 3.19 0.065 36.68 34.26 -0.45 0.08 0.32 -0.3 -0.07 7.175 -6.43 1.44 -2.1 1.54 10.88 1.53 0.005 1.19 3.03 3.38 0.04 26.86 35.75 0.1 -0.34 -0.07 -0.12 0.1 7.66",
  "GCGCG 5.54 0.09 17 12.88 0.26 9 -4.22 0.37 365 -1.57 0.06 365 -1.51 0.03 64 3.12 0.51 365 -1.15 0.39 64 32.44 0.43 365 35.7 0.29 64 -4.81 0.12 314 4.06 -0.03 0.11 -0.12 -0.36 5.45 3.12 -1.2 -0.25 0.4 3.31 3.39 0.01 0 0.04 -4.22 1.77 -1.57 -1.55 32.44 36.06 14.9 -4.245 -4.78 -0.71 0.18 5.04 3.29 -0.02 0.385 -0.63 3.34 0.045 10.97 17.88 -2.27 -0.23 -0.62 -1.43 -0.06 6.835 -9.2 0.09 -0.04 0.15 9.7 -3.07 0 0.22 3.17 3.49 0.02 30.33 36.07 0.01 0 -0.1 -0.15 0.22 6.605",
  "GCGGC 5.37 0.1 41 13.52 0.22 21 -3.73 0.44 91 -1.61 0.05 91 -1.72 0.05 89 2.78 0.57 91 -1.31 0.4 89 32.46 0.48 91 33.44 0.38 89 -5.1 0.16 70 4.06 -0.04 -0.55 0.22 0.16 5.38 2.78 -1.3 -0.26 0.28 3.33 3.34 -0.02 0.1 0.05 -3.73 5.42 -1.61 -1.72 32.46 33.44 14.12 -3.96 -0.18 1.28 2.07 0.81 6.56 0.06 4.345 3.37 3.5 0.16 36.72 33.36 0.14 0.08 0.09 -1 -0.03 7.415 -2.58 0.43 -1.21 0.93 8.69 2.64 -0.015 1.38 2.81 3.5 0.05 23.6 36 0.05 -0.57 -0.12 -0.25 0.215 7.875",
  "GCGGG 5.3 0.1 30 13.6 0.28 12 -2.75 0.39 57 -1.6 0.05 57 -1.78 0.04 57 2.34 0.56 57 -1.73 0.45 57 32.3 0.47 57 33.41 0.29 57 -5.14 0.16 43 4.06 -0.03 -0.77 0.14 1.59 5.34 2.34 -1.73 -0.26 0.31 3.3 3.36 0.01 0.13 0.08 -2.75 5.61 -1.6 -1.78 32.3 33.41 14.22 -4.725 -0.18 0.39 1.455 0.81 4.59 0.17 0.205 3.37 3.53 0.1 36.72 34.7 0.14 -0.16 0.09 -0.55 -0.04 7.47 -1.98 0.43 -1.24 1.045 8.69 3.17 -0.015 1.365 2.81 3.48 0.055 23.6 35.21 0.05 -0.43 -0.12 -0.32 0.185 7.93",
  "GCGTG 5.25 0.1 50 12.33 0.19 9 -7.98 0.5 67 -1.62 0.05 67 -1.45 0.03 67 4.71 0.47 67 -2.23 0.38 67 33.34 0.49 67 33.73 0.24 67 -5.03 0.1 51 4.19 -0.02 0.36 0.61 -5.31 5.38 4.71 -2.23 -0.26 0.57 3.45 3.32 -0.04 -0.28 -0.03 -7.98 6.29 -1.62 -1.45 33.34 33.73 12.85 -9.325 -0.81 0.93 2.05 6.61 0.23 0 1.21 3.55 3.35 0.055 36.65 29.11 -0.19 0.14 -0.3 -0.89 -0.02 6.745 -10.905 1.24 0.64 -3.525 8.92 -0.54 0.015 0.87 3.4 3.31 0.025 35.4 31.32 0.21 -0.01 -0.19 -0.45 0.13 6.37",
  "GCTAG 5.67 0.16 9 13.65 0.23 8 -6.54 0.35 9 -1.7 0.02 9 -1.46 0.02 9 -2.24 0.5 9 4.03 1.17 9 31.36 0.19 9 34.66 0.36 9 -6.87 0.15 6 4 -0.03 1.82 -0.07 0.72 5.68 -2.24 4.03 -0.11 -0.88 3.23 3.29 -0.21 0.02 0 -6.54 7.27 -1.7 -1.46 31.36 34.66 13.65 -6.93 0.52 0.25 -1.89 1.42 0.7 -0.04 0.45 3.24 3.4 0.015 32.66 36.29 -0.01 0.09 -0.7 0.16 -0.07 6.945 -9.57 -3.2 0.06 0.07 1.56 9.68 0 4.405 3.32 2.96 0.03 34.92 25.48 -0.62 -0.01 -0.28 -0.11 0.19 7.265",
  "GCTCG 5.2 0.17 38 13.81 0.21 34 -6.78 0.32 39 -1.73 0.04 39 -1.47 0.04 39 -2.22 0.77 39 -1.22 0.63 39 31.41 0.33 39 35.31 0.42 39 -7.17 0.14 31 4.14 -0.03 2.14 -0.17 -1.11 5.22 -2.22 -1.22 -0.1 -0.64 3.28 3.25 -0.23 0.15 -0.04 -6.78 6.9 -1.73 -1.47 31.41 35.31 13.86 -8.66 0.48 1.54 -0.02 4.13 0.27 -0.065 0.955 3.36 3.19 0.05 31.86 34.26 -0.15 0.08 -0.68 -0.3 -0.025 7.06 -12.93 -2.57 -2.1 7.41 4.35 1.53 0.07 2.17 3.45 3.38 0.035 33.22 35.75 -0.25 -0.34 -0.73 -0.12 0.105 7.1",
  "GCTGG 5.53 0.15 16 13.56 0.21 16 -5.87 0.39 66 -1.69 0.05 22 -1.49 0.05 64 -2.45 0.57 22 2.75 0.58 64 30.94 0.22 22 34.09 0.28 64 -6.56 0.18 53 3.87 -0.03 2.17 -1.49 0.94 5.54 -1.96 2.82 -0.1 -0.47 3.28 3.32 -0.24 0.28 -0.09 -5.87 2.44 -1.72 -1.49 30.79 34.09 14.67 -1.865 -0.88 -0.96 -0.235 2.66 3.87 -0.065 5.28 3.35 3.4 0.03 31.67 34.03 -0.23 -0.23 -0.63 -0.37 -0.02 7.14 -7.14 -3.59 -0.45 0 0.33 9.82 0 3.4 3.35 2.85 0.03 35.72 23.51 -0.61 0.11 -0.23 -0.08 0.14 7.71",
  "GCTTG 4.94 0.15 10 13.52 0.24 8 -8.63 0.27 11 -1.77 0.03 11 -1.23 0.02 11 -2.39 0.44 11 -3.44 0.55 11 32.11 0.2 11 34.57 0.26 11 -7.56 0.13 9 4.3 -0.03 2.09 2.4 -5.71 4.98 -2.39 -3.44 -0.14 -1.23 3.37 3.1 -0.32 0.03 0.03 -8.63 6.35 -1.77 -1.23 32.11 34.57 13.62 13.56 -0.63 0.99 4.185 3.27 -0.32 -0.39 27.005 3.5 3.14 -0.28 36.01 34.05 -0.08 0.04 -0.95 -0.57 -0.005 6.465 -14.975 -3.04 -3.77 11.035 4.55 -0.87 0.085 3.535 3.54 3.32 0.02 35.23 37.64 -0.25 -0.6 -0.78 0.07 0.075 6.305",
  "GGAAG 4.63 0.25 4 14.29 0.15 4 -9.44 0.38 171 -1.55 0.1 8 -1.26 0.03 171 -0.61 1.03 8 -3.81 0.81 171 35.39 1.27 8 35.02 0.35 171 -7.65 0.14 133 4.24 -0.03 1.84 -2.17 -1.46 4.74 -0.34 -3.81 0.08 -0.52 3.42 3.13 -0.33 -0.05 -0.29 -9.44 1.35 -1.52 -1.26 36.09 35.02 14.98 -4.035 -0.78 -1.21 2.71 3.61 2.49 0.045 1.055 3.33 3.26 0.035 33.12 34.94 -0.18 -0.08 -0.66 -0.71 -0.1 6.445 -10.96 -0.52 -2.45 0.93 3.33 1.66 0.075 2.195 3.27 3.19 0.025 33.83 32.17 -0.21 -0.09 -0.27 -0.48 -0.13 6.43",
  "GGACC 4.8 0.15 4 14.24 0.26 4 -7.55 0.62 10 -1.44 0.07 8 -1.56 0.04 7 -2.12 0.58 8 -3.32 0.69 7 35.8 0.56 8 34.71 0.24 7 -7.46 0.18 8 4.23 -0.02 0.45 -0.96 3.58 4.77 -2.11 -3.33 0.1 -0.05 3.25 3.39 -0.17 0.22 -0.03 -7.55 4.64 -1.44 -1.59 35.87 34.68 14.79 -7.235 -0.67 -1.38 -0.47 1.91 1.27 -0.09 4.56 3.21 3.25 0.06 33.89 30.21 -0.06 -0.28 -0.63 -1.11 -0.12 6.855 -14.86 -2.03 0.68 0.03 1.62 -0.37 0.015 1.18 3.36 3.43 0.02 37.52 32.74 -0.31 -0.19 -0.2 -0.74 0.025 5.54",
  "GGACG 5.02 0.09 30 13.58 0.21 26 -8.11 0.66 34 -1.38 0.04 30 -1.51 0.04 34 -1.8 0.4 30 -2.49 0.49 34 36.13 0.36 30 34.01 0.53 34 -7.29 0.12 27 4.19 -0.02 0.31 -0.54 3.23 5.05 -1.78 -2.49 0.1 -0.3 3.23 3.33 -0.22 0.23 -0.01 -8.11 6.18 -1.38 -1.51 36.14 34.01 13.76 -4.875 -0.67 0.8 -0.19 1.91 1.69 -0.09 8.53 3.21 3.3 0.065 33.89 29.13 -0.06 -0.14 -0.63 -1.07 -0.085 7.08 -10.65 -2.03 0.36 0.575 1.62 0.13 0.03 1.305 3.36 3.33 0.035 37.52 30.66 -0.31 -0.34 -0.2 -0.6 0.06 6.5",
  "GGAGC 5.05 0.16 15 14.52 0.32 10 -6.07 0.38 31 -1.53 0.05 23 -1.73 0.04 31 -1.59 0.73 23 -2.75 0.58 31 35.75 0.55 23 31.38 0.24 31 -7.34 0.16 26 4.13 -0.02 0.58 -2.24 0.19 5.03 -1.59 -2.75 0.08 -0.25 3.3 3.26 -0.17 0.2 -0.07 -6.07 4.7 -1.54 -1.73 35.82 31.38 14.97 0.015 0.62 0.48 -5.025 3.94 4.13 -0.11 7.85 3.27 3.36 0.15 35.11 31.86 0.28 -0.15 -0.35 -0.68 -0.04 7.105 -13.25 -1.85 -2.57 1.84 3.18 4.35 0.07 1.95 3.21 3.45 0.025 33.48 33.22 -0.18 -0.25 -0.37 -0.73 -0.025 6.65",
  "GGAGG 4.93 0.17 22 14.6 0.36 17 -5.75 0.66 134 -1.51 0.04 24 -1.81 0.04 134 -1.91 0.7 24 -3.27 1.09 134 35.57 0.39 24 31.42 0.32 134 -7.22 0.14 105 4.09 -0.01 0.25 -2.25 2.08 4.83 -1.66 -3.27 0.08 0.11 3.27 3.32 -0.15 0.23 -0.05 -5.75 2.68 -1.54 -1.81 35.55 31.42 15.26 6.665 0.62 -1.38 -9.98 3.94 2.37 -0.245 13.075 3.27 3.3 0.235 35.11 33.79 0.28 0.01 -0.35 -0.71 -0.005 7.05 -9.09 -1.85 -1.82 -0.065 3.18 3.61 0.075 1.965 3.21 3.26 0.03 33.48 30.16 -0.18 -0.12 -0.37 -0.81 -0.09 7.015",
  "GGATG 4.84 0.26 291 13.96 0.41 253 -7.65 0.68 400 -1.53 0.06 314 -1.5 0.04 400 -1.14 1.31 314 -4.71 0.87 400 36.16 0.68 314 32.03 0.36 400 -7.69 0.2 311 4.27 -0.02 0.74 0.22 -1.59 4.9 -1.07 -4.71 0.09 -0.4 3.35 3.22 -0.21 0.01 -0.12 -7.65 5.41 -1.53 -1.5 36.19 32.03 14.26 -9.975 -0.25 0.06 -2.92 0.71 1.15 0.015 3.7 3.36 3.23 0.09 36.74 27.88 -0.16 -0.12 -0.7 -1.11 -0.09 6.135 -13.025 -1.44 0.38 -3.465 2.13 -0.45 0.065 1.955 3.4 3.21 0.03 36.42 29.55 -0.09 0 -0.52 -0.75 -0.045 5.925",
  "GGCAG 5.41 0.16 11 13.65 0.29 9 -3.2 0.54 18 -1.59 0.05 14 -1.47 0.06 18 -1.34 0.41 14 3.38 1.41 18 36.22 0.4 14 33.75 0.66 18 -5.08 0.24 10 4.11 -0.03 -0.17 1.01 0.44 5.51 -1.4 3.38 0.26 0.33 3.39 3.31 -0.01 -0.29 0.09 -3.2 6.17 -1.6 -1.47 36.23 33.75 14.02 -3.07 -1.98 1.82 3.06 1.75 3.42 -0.055 5.04 3.19 3.42 0.04 31 36.9 -0.09 0.1 -0.63 0.08 -0.15 6.735 -10.38 0.32 -0.29 -8.17 -0.68 9.67 -0.035 2.075 3.37 2.88 0.02 35.57 23.83 0.31 0.03 -0.36 -0.16 0.1 6.605",
  "GGCCG 4.96 0.13 32 13.99 0.27 30 -2.72 0.35 32 -1.6 0.05 32 -1.74 0.04 32 -2 0.48 32 -1.3 0.5 32 36.85 0.43 32 33.23 0.39 32 -5.37 0.24 25 4.15 -0.04 -0.11 -0.21 -0.77 5.08 -2 -1.3 0.27 0.32 3.41 3.33 -0.02 -0.11 0.06 -2.72 6.96 -1.6 -1.74 36.85 33.23 13.93 -3.405 -0.12 1.28 0.88 4.74 6.56 0.01 4.065 3.3 3.5 0.15 30.88 33.36 -0.18 0.08 -1.21 -1 -0.11 7.515 -9.065 0.04 -1.21 8.03 0 2.64 0.035 1.135 3.48 3.5 0.035 35.5 36 0 -0.57 -0.71 -0.25 0.195 6.62",
  "GGCGC 5.41 0.09 28 13.49 0.22 9 -3.39 0.39 115 -1.57 0.05 114 -1.58 0.04 115 -1.71 1.36 114 2.85 0.5 115 36.24 0.66 114 32.32 0.33 115 -5.12 0.17 90 4.08 -0.03 0.09 0.21 -0.35 5.45 -1.71 2.85 0.25 0.39 3.39 3.31 -0.02 0 0.06 -3.39 4.78 -1.57 -1.58 36.24 32.32 14.35 -0.22 0.05 -4.78 0.76 -1.11 5.04 -0.02 4.92 3.24 -0.63 0.045 27.86 10.97 0.2 -2.27 -0.51 -0.62 -0.16 7.105 -11.38 -0.2 0.09 -5.205 -0.95 9.7 -0.03 0.185 3.39 3.17 0.015 35.49 30.33 0.26 0.01 -0.36 -0.1 0.125 6.035",
  "GGCGG 5.29 0.12 8 13.64 0.28 8 -3.13 0.29 15 -1.57 0.04 12 -1.62 0.04 13 -2.02 0.55 12 1.79 0.52 13 36.31 0.24 12 32.31 0.27 13 -5.09 0.21 11 4.07 -0.03 0.14 -0.19 0.43 5.32 -1.94 2.04 0.25 0.42 3.39 3.33 -0.03 -0.01 0.04 -3.13 4.77 -1.58 -1.63 36.27 32.35 14.33 -2.805 0.05 -0.18 1.755 -1.11 0.81 0.01 5.145 3.24 3.37 0.115 27.86 36.72 0.2 0.14 -0.51 0.09 -0.07 7.34 -7.485 -0.2 0.43 -8.89 -0.95 8.69 -0.045 0.65 3.39 2.81 0.03 35.49 23.6 0.26 0.05 -0.36 -0.12 0.11 6.625",
  "GGCTG 4.95 0.15 17 13.85 0.3 17 -1.2 0.36 24 -1.66 0.04 21 -1.69 0.03 20 -2.29 0.54 21 -2.64 0.65 20 37.17 0.36 21 31.16 0.34 20 -5.43 0.25 20 4.27 -0.02 -0.98 2.36 -3.57 4.96 -2.28 -2.4 0.24 0.27 3.46 3.28 -0.01 -0.24 0.16 -1.2 5.01 -1.68 -1.71 37.15 31.22 14.23 0.18 -0.03 -0.88 4.58 0.71 2.66 -0.135 8.415 3.47 3.35 0.065 33 31.67 0.19 -0.23 -1.1 -0.63 -0.03 6.935 -10.825 -0.58 -3.59 6.105 -0.12 0.33 0.035 2.03 3.53 3.35 0.025 35.84 35.72 0.05 -0.61 -0.81 -0.23 0.135 6.45",
  "GGGAG 4.85 0.15 15 14.78 0.15 8 -4.6 0.56 58 -1.83 0.04 17 -1.56 0.05 58 -1 0.53 17 -1.87 0.75 58 33.49 0.68 17 35.58 0.49 58 -5.23 0.27 47 4.14 -0.05 0.87 0.7 -2.36 4.86 -0.82 -1.87 -0.3 0.37 3.47 3.29 0 -0.14 -0.09 -4.6 3.39 -1.88 -1.56 33.61 35.58 15.31 0.92 -0.21 0.62 -3.505 6.31 3.94 -0.06 7.945 3.44 3.27 0.15 31.55 35.11 -0.12 0.28 -0.75 -0.35 -0.075 7.365 -7.875 1.03 -1.85 -1.025 6.53 3.18 0.01 0.915 3.44 3.21 0.02 30.36 33.48 0.02 -0.18 -0.92 -0.37 -0.165 6.835",
  "GGGCC 4.77 0.13 16 14.75 0.26 13 -1.93 0.41 21 -1.82 0.03 21 -1.62 0.03 18 -2.36 0.95 21 -2.4 0.4 18 33.57 0.53 21 36.61 0.28 18 -5.45 0.21 17 4.21 -0.04 0.48 -0.11 0.05 4.77 -2.36 -2.39 -0.29 0.41 3.39 3.41 0.08 -0.01 0.02 -1.93 5.96 -1.82 -1.63 33.57 36.62 15.05 -5.1 0.71 -0.12 5.75 5.14 4.74 -0.045 4.235 3.65 3.3 0.04 33.56 30.88 -0.11 -0.18 -1.15 -1.21 -0.2 7.55 -14.2 -0.03 0.04 5.43 5.1 0 0.02 0.82 3.61 3.48 0.015 34.08 35.5 -0.1 0 -0.98 -0.71 0.135 5.54",
  "GGGCG 4.96 0.12 39 13.97 0.22 37 -2.89 0.49 39 -1.76 0.04 39 -1.57 0.06 39 -1.63 0.62 39 -1.66 0.52 39 33.85 0.42 39 36.18 0.69 39 -5.14 0.11 31 4.17 -0.04 0.41 0.1 -0.09 5.12 -1.63 -1.66 -0.28 0.32 3.36 3.39 0.08 -0.02 0.05 -2.89 6.97 -1.76 -1.57 33.85 36.18 13.89 -1.14 0.71 0.05 6.125 5.14 -1.11 -0.045 8.62 3.65 3.24 0.015 33.56 27.86 -0.11 0.2 -1.15 -0.51 -0.19 7.4 -13.63 -0.03 -0.2 -0.95 5.1 -0.95 -0.005 0.555 3.61 3.39 0.01 34.08 35.49 -0.1 0.26 -0.98 -0.36 0.075 5.62",
  "GGGGC 4.82 0.1 20 14.68 0.2 19 -2.13 0.45 29 -1.85 0.04 26 -1.8 0.04 29 -2.02 0.59 26 -1.96 0.43 29 33.56 0.42 26 33.68 0.34 29 -5.39 0.33 25 4.15 -0.05 0.34 0.34 -0.07 4.87 -2 -1.96 -0.29 0.3 3.39 3.36 0.08 0.06 0.01 -2.13 5.76 -1.86 -1.8 33.55 33.68 14.93 -15.81 -1.81 0.71 16.62 6.69 5.14 -0.2 14.725 3.39 3.65 0.01 33.69 33.56 -0.39 -0.11 -0.6 -1.15 -0.225 7.1 -8.755 0.17 -0.03 2.275 5.94 5.1 0.005 0.735 3.37 3.61 0.01 30.11 34.08 0.05 -0.1 -1.15 -0.98 -0.07 6.655",
  "GGGGG 4.75 0.18 9 14.81 0.23 4 -1.03 0.34 114 -1.86 0.02 9 -1.88 0.04 114 -2.24 0.41 9 -2.41 0.5 114 33.25 0.25 9 33.41 0.46 114 -5.25 0.25 66 4.07 -0.04 0 0.42 0.95 4.71 -2.04 -2.41 -0.31 0.43 3.39 3.4 0.07 0.09 0.01 -1.03 2.32 -1.9 -1.88 33.35 33.41 15.59 -27.63 -1.81 -1.81 21.93 6.69 6.69 -0.35 21.46 3.39 3.39 0.07 33.69 33.69 -0.39 -0.39 -0.6 -0.6 -0.21 6.69 -3.65 0.17 0.17 -1.72 5.94 5.94 0 0.5 3.37 3.37 0.01 30.11 30.11 0.05 0.05 -1.15 -1.15 -0.26 7.52",
  "GGGTG 4.77 0.18 17 14.02 0.63 16 -5.89 0.71 41 -1.82 0.04 23 -1.54 0.04 41 -1.08 0.84 23 -2.99 0.69 41 34.41 0.39 23 34.14 0.22 41 -5.32 0.25 31 4.28 -0.04 0.65 0.77 -4.72 4.82 -0.92 -2.99 -0.29 0.48 3.48 3.36 0 -0.3 -0.04 -5.89 4.1 -1.86 -1.54 34.41 34.14 14.51 1.42 1.11 -0.05 -7.76 3.17 1.73 -0.185 11.525 3.65 3.35 0.005 35.52 32.09 -0.03 0.05 -1.38 -1.18 -0.175 6.555 -12.875 0.43 1.04 -3.445 5.47 -1.99 -0.01 1.05 3.68 3.29 0.02 33.67 33.57 0.01 0.12 -1.23 -0.51 -0.02 5.625",
  "GGTAG 5.55 0.13 20 13.45 0.23 15 -8.07 1.1 31 -1.53 0.03 21 -1.4 0.06 31 -2.63 0.49 21 4.24 1.71 31 34.52 0.26 21 34.3 1.03 31 -7.09 0.19 25 4 -0.03 0.6 0.07 -2.17 5.61 -2.68 4.24 -0.12 -0.66 3.35 3.25 -0.22 0.03 0.03 -8.07 5.44 -1.56 -1.4 34.55 34.3 14.03 -5.405 0.49 -1.11 0.63 0.32 1.1 -0.025 2.625 3.29 3.38 0.045 30.81 36.22 0.02 0.04 -1.15 -0.28 -0.125 6.745 -10.135 0.77 -0.14 -7.455 -1.44 8.66 -0.075 1.82 3.27 2.99 0.03 32.83 27.73 0.08 0.26 -0.52 -0.13 0.05 6.255",
  "GGTCG 4.82 0.2 134 13.68 0.26 122 -8.09 0.37 136 -1.57 0.04 134 -1.35 0.05 136 -3.5 0.82 134 -2.17 0.8 136 34.74 0.25 134 35.73 0.53 136 -7.74 0.22 109 4.27 -0.02 0.55 -0.17 -4.43 4.85 -3.49 -2.17 -0.11 -0.43 3.38 3.2 -0.28 0.13 0.02 -8.09 6.54 -1.57 -1.35 34.74 35.73 13.79 -3.375 -1.38 -1.77 2.635 1.27 0.35 0.055 -2.22 3.25 3.38 0.085 30.21 32.95 -0.28 -0.4 -1.11 -0.48 -0.09 7.13 -10.605 0.68 -2.22 4.12 -0.37 0.43 0.015 1.395 3.43 3.39 0.035 32.74 38.87 -0.19 -0.69 -0.74 0.19 0.085 6.49",
  "GGTGC 5.56 0.13 28 13.18 0.23 27 -7.89 0.6 35 -1.51 0.04 32 -1.27 0.07 35 -2.69 0.54 32 2.97 0.67 35 34.16 0.19 32 34.26 0.65 35 -6.87 0.09 27 4.08 -0.03 0.81 -1.06 -3.78 5.45 -2.71 2.97 -0.11 -0.73 3.35 3.21 -0.28 0.31 0 -7.89 6.19 -1.52 -1.27 34.17 34.26 13.52 7.995 -0.05 -0.61 -12.255 1.73 4.05 -0.35 19.27 3.35 3.3 0.05 32.09 34.03 0.05 0.15 -1.18 -0.26 -0.145 7.005 -11.175 1.04 0.15 -7.89 -1.99 9.88 -0.055 1.625 3.29 3.14 0.03 33.57 29.37 0.12 0.21 -0.51 -0.22 0.02 6.315",
  "GGTGG 5.56 0.11 19 13.41 0.27 18 -7.11 0.71 27 -1.49 0.03 19 -1.33 0.07 27 -2.55 0.51 19 2.46 0.49 27 33.92 0.25 19 34.27 0.41 27 -6.85 0.11 22 4.04 -0.03 0.99 -1.26 -2.33 5.56 -2.67 2.46 -0.11 -0.64 3.33 3.23 -0.25 0.31 -0.01 -7.11 5.69 -1.52 -1.33 33.95 34.27 13.92 2.37 -0.05 -1.4 -7.215 1.73 5.18 -0.23 12.375 3.35 3.36 0.025 32.09 35.26 0.05 -0.01 -1.18 -0.18 -0.14 7.285 -8.54 1.04 -0.29 -9.41 -1.99 9.42 -0.065 1.5 3.29 2.93 0.03 33.57 25.46 0.12 0.26 -0.51 -0.17 -0.02 6.575",
  "GGTTG 4.82 0.16 8 13.02 0.12 7 -4.14 7.08 32 -1.58 0.01 8 -1.34 0.24 32 -3.18 0.55 8 -2.06 1.7 32 35.52 0.31 8 31.89 3.25 32 -7.82 0.26 19 4.48 -0.01 5.45 2.85 -4.79 4.89 -4.57 -2.06 -0.14 -0.26 3.65 3.08 0.08 -0.21 0.08 -4.14 2.55 -1.15 -1.34 34.3 31.89 14.65 -2.16 -0.74 0.28 -2.425 0.02 2.59 -0.18 17.67 3.23 3.15 0.135 31.1 33.65 -0.01 0.16 -1.28 -0.56 -0.11 6.51 -11.405 0.68 -3.66 2.62 -0.47 -1.25 0.045 2.38 3.45 3.3 0.025 33.37 37.43 -0.13 -0.68 -0.8 0.02 -0.04 6.27",
  "GTAAC 5.86 0.22 36 12.96 0.22 7 -10.83 0.85 43 -1.28 0.07 43 -1.14 0.06 43 5.89 1.08 43 -2.71 0.75 43 34.23 0.95 43 35.06 0.4 43 -7.05 0.21 34 4.21 -0.02 1.01 -1.43 0.49 5.67 5.89 -2.71 0.1 -1.14 3.29 3.08 -0.14 -0.11 -0.14 -10.83 6.5 -1.28 -1.14 34.23 35.06 13.11 -2.935 -0.16 0.25 4.615 5.23 3.24 0.045 1.345 3.46 3.12 0.015 36.67 31.75 -0.11 0.14 -0.24 -0.64 -0.14 6.265 -7.965 1.75 -3.39 1.9 10.32 -0.75 0.005 3.44 3.06 3.27 0.03 26.12 36.43 0.12 -0.57 -0.16 -0.08 0.05 6.94",
  "GTAAG 5.62 0.21 30 13.08 0.19 13 -10.31 0.55 43 -1.33 0.04 43 -1.26 0.03 42 5.9 0.92 43 -3.24 1 42 34.34 0.53 43 34.87 0.49 42 -7.23 0.22 33 4.15 -0.02 1.31 -1.66 -0.91 5.65 5.9 -3.21 0.1 -1.14 3.32 3.1 -0.1 -0.04 -0.17 -10.31 5.89 -1.33 -1.26 34.34 34.87 13.57 1.495 -0.16 -0.17 1.48 5.23 -1.34 0.06 5.71 3.46 3.23 0.02 36.67 33.71 -0.11 -0.07 -0.24 -0.55 -0.085 6.395 -8.485 1.75 -3.36 3.145 10.32 -0.07 0 3.9 3.06 3.29 0.035 26.12 36.23 0.12 -0.5 -0.16 -0.09 0.065 6.91",
  "GTACC 5.84 0.2 10 13.19 0.27 7 -8.12 0.53 83 -1.32 0.05 83 -1.51 0.03 47 4.32 1.14 83 -2.37 0.79 47 34.23 0.58 83 34.34 0.3 47 -6.84 0.18 66 3.96 -0.03 0.04 -0.35 2.68 5.86 4.32 -2.46 0.12 -0.86 3.18 3.35 0.01 0.27 0.07 -8.12 3.88 -1.32 -1.54 34.23 34.45 14.37 -5.255 -0.38 0.49 -0.23 2.63 0.32 -0.005 3.695 3.4 3.29 0.01 28.05 30.81 -0.1 0.02 -0.03 -1.15 -0.08 6.24 -12.3 0.05 0.77 -5.705 8.27 -1.44 -0.065 1.96 3.2 3.27 0.03 32.49 32.83 0.04 0.08 -0.15 -0.52 0.08 6.11",
  "GTACG 5.93 0.15 36 12.47 0.31 31 -8.84 0.55 125 -1.3 0.07 125 -1.47 0.04 42 4.68 0.86 125 -2.11 0.66 42 34.2 0.63 125 33.97 0.32 42 -6.61 0.12 101 3.96 -0.03 0.11 -0.11 2.91 5.8 4.68 -2.07 0.12 -0.84 3.18 3.32 0 0.26 0.07 -8.84 3.37 -1.3 -1.5 34.2 34.24 14.14 -4.145 -0.38 0.75 -0.02 2.63 3.92 0.065 1.785 3.4 3.13 0.025 28.05 26.92 -0.1 0.03 -0.03 -0.45 -0.04 7.055 -10.77 0.05 0.18 -3.825 8.27 0.77 -0.055 2.13 3.2 3.27 0.035 32.49 30.04 0.04 -0.1 -0.15 -0.56 0.12 6.58",
  "GTAGC 5.88 0.16 27 13.34 0.28 18 -6.96 0.43 38 -1.36 0.07 38 -1.71 0.05 38 4.45 1.61 38 -2.28 1.12 38 34.48 0.66 38 31.25 0.35 38 -6.83 0.11 29 4.03 -0.03 -0.11 -1.53 0.14 5.68 4.45 -2.28 0.11 -0.94 3.23 3.25 0.03 0.26 0.04 -6.96 6.27 -1.36 -1.71 34.48 31.25 13.88 -4.025 -1.11 0.52 -0.605 1.1 1.42 -0.015 0.435 3.38 3.24 0.045 36.22 32.66 0.04 -0.01 -0.28 -0.7 -0.1 7.005 -8.01 -0.14 -3.2 0.93 8.66 1.56 -0.025 3.445 2.99 3.32 0.03 27.73 34.92 0.26 -0.62 -0.13 -0.28 0.14 7.265",
  "GTAGG 5.76 0.11 16 13.46 0.18 8 -6.19 0.42 24 -1.38 0.05 24 -1.76 0.03 24 4.46 1.16 24 -2.71 0.6 24 34.06 0.69 24 31.41 0.28 24 -6.82 0.17 20 4.01 -0.03 -0.27 -1.66 1.08 5.65 4.46 -2.71 0.1 -0.84 3.21 3.26 0.04 0.27 0.06 -6.19 5.85 -1.38 -1.76 34.06 31.41 14.21 -3.675 -1.11 0.08 2.475 1.1 4.07 -0.015 2.165 3.38 3.34 0.055 36.22 32.41 0.04 -0.17 -0.28 -0.56 -0.12 6.985 -7.77 -0.14 -2.61 1.09 8.66 2.13 -0.025 3.73 2.99 3.3 0.035 27.73 33.56 0.26 -0.49 -0.13 -0.46 0.145 7.36",
  "GTATG 5.93 0.17 20 12.64 0.41 8 -8.42 0.62 20 -1.38 0.04 20 -1.45 0.03 20 6.01 0.8 20 -2.99 0.62 20 34.49 0.37 20 31.46 0.23 20 -6.74 0.2 16 4.08 -0.02 0.02 0.64 -3.69 5.9 6.01 -2.99 0.1 -0.89 3.31 3.19 -0.01 -0.03 -0.03 -8.42 7.21 -1.38 -1.45 34.49 31.46 12.8 -4.705 -2.31 1.96 1.355 6.23 2.32 0.045 4.63 4.17 3.25 0.06 37.58 29.13 0.21 0.14 -0.85 -0.83 -0.11 6.435 -10.99 0.31 0.41 -3.24 8.55 0.23 -0.015 3.265 3.3 3.22 0.03 33.49 29.21 0.06 -0.01 -0.36 -0.78 0.1 6.66",
  "GTCAG 5.67 0.17 15 13.39 0.15 14 -6.43 0.23 15 -1.4 0.06 15 -1.38 0.04 15 -1.29 0.65 15 4.57 0.62 15 35.2 0.57 15 34.37 0.31 15 -5.23 0.1 11 4.16 -0.04 -0.47 0.65 1.24 5.73 -1.29 4.57 0.28 0.27 3.21 3.34 0.22 -0.22 0.02 -6.43 6.97 -1.4 -1.38 35.2 34.37 13.37 -5.305 1.57 1.23 1.585 1.92 4.71 0.02 6.32 3.25 3.45 0.005 35.01 36.83 0.14 0.16 -0.09 -0.32 -0.08 7 -7.565 -2.37 1.17 0.47 0.51 11.07 -0.005 3.12 3.39 2.91 0.035 38.79 22.06 -0.65 0.04 0.16 0 0.1 7.325",
  "GTCCC 4.9 0.08 19 14.37 0.24 14 -5.28 0.29 26 -1.41 0.08 26 -1.78 0.04 22 -2.34 0.73 26 -0.93 0.37 22 35.97 0.45 26 33.99 0.27 22 -5.5 0.14 21 4.25 -0.05 -0.32 -0.9 1.5 4.92 -2.34 -0.9 0.31 0.34 3.22 3.44 0.17 0.01 -0.05 -5.28 5.47 -1.41 -1.79 35.97 33.98 14.6 -7.005 -0.67 -0.21 1.47 1.91 6.31 -0.04 5.55 3.21 3.44 0.06 33.89 31.55 -0.06 -0.12 -0.63 -0.75 -0.09 7.18 -10.75 -2.03 1.03 1.405 1.62 6.53 0.01 0.97 3.36 3.44 0.015 37.52 30.36 -0.31 0.02 -0.2 -0.92 -0.075 6.365",
  "GTCCG 5.08 0.13 12 13.66 0.2 10 -6.07 0.36 22 -1.37 0.04 22 -1.7 0.04 18 -1.73 0.58 22 -0.51 0.54 18 36.17 0.47 22 33.8 0.37 18 -5.36 0.2 18 4.27 -0.05 -0.26 -0.77 1.42 5.14 -1.73 -0.38 0.29 0.25 3.22 3.41 0.22 -0.02 -0.03 -6.07 5.86 -1.36 -1.7 36.17 33.84 13.96 -11.085 -0.67 -1.79 -0.125 1.91 2.54 -0.15 8.35 3.21 0.77 0.04 33.89 30.08 -0.06 -0.19 -0.63 -0.75 -0.085 7.24 -10.2 -2.03 0.43 4.785 1.62 5.73 0.015 1.215 3.36 3.48 0.025 37.52 31.82 -0.31 -0.24 -0.2 -0.41 0.055 6.66",
  "GTCGC 5.56 0.12 87 13.19 0.21 15 -6.9 0.51 100 -1.36 0.06 100 -1.52 0.06 100 -1.39 0.48 100 4.64 0.53 100 35.46 0.51 100 32.7 0.63 100 -5.06 0.13 79 4.14 -0.04 -0.1 -0.13 1.25 5.5 -1.39 4.64 0.27 0.34 3.2 3.36 0.18 0.13 -0.03 -6.9 6.58 -1.36 -1.52 35.46 32.7 13.32 -0.545 -1.77 -1.84 7.025 0.35 5.54 0.145 -5.45 3.38 3.48 0.1 32.95 36.68 -0.4 -0.45 -0.48 0.32 -0.07 7.31 -5.37 -2.22 1.44 2.49 0.43 10.88 0.005 1.24 3.39 3.03 0.04 38.87 26.86 -0.69 0.1 0.19 -0.07 0.12 7.69",
  "GTCGG 5.54 0.1 17 13.3 0.25 16 -6.74 0.21 17 -1.34 0.05 17 -1.55 0.05 17 -1.52 0.31 17 3.41 0.41 17 35.42 0.34 17 32.81 0.26 17 -5.11 0.09 13 4.16 -0.04 0.18 -0.79 2.19 5.54 -1.52 3.41 0.27 0.35 3.18 3.36 0.21 0.12 -0.05 -6.74 6.96 -1.34 -1.55 35.42 32.81 13.37 -1.18 -1.77 1.74 -4.025 0.35 3.99 -0.035 3.905 3.38 3.3 0.075 32.95 36.31 -0.4 0.05 -0.48 -0.06 0.03 7.345 -5 -2.22 -1.58 0 0.43 10.1 0 1.59 3.39 2.86 0.05 38.87 22.38 -0.69 -0.06 0.19 -0.05 0.07 7.78",
  "GTCTG 5.22 0.12 4 13.37 0.12 3 -3.97 0.26 5 -1.41 0.03 5 -1.63 0.02 5 -1.52 0.61 5 -1.18 0.34 5 36.44 0.33 5 31.42 0.16 5 -5.38 0.17 3 4.32 -0.04 -1.46 2.46 -2.9 5.23 -1.52 -1.18 0.26 0.1 3.28 3.3 0.2 -0.16 0.11 -3.97 6.26 -1.41 -1.63 36.44 31.42 13.55 -6.215 0.5 0.5 0.425 -0.35 3.48 0.01 3.205 3.31 3.35 0.015 34.57 32.26 0.18 -0.15 -0.47 -0.56 -0.08 6.395 -10.995 -1.64 -1.77 6.49 1.08 5.04 0.06 2.575 3.39 3.28 0.025 37.9 29.92 -0.36 -0.25 -0.18 -0.32 0.08 6.725",
  "GTGAC 6.01 0.21 12 13.03 0.34 12 -6.82 0.33 16 -1.12 0.08 12 -1.34 0.03 16 4.03 0.6 12 -1.42 0.64 16 34.6 0.25 12 35.33 0.58 16 -5.13 0.2 13 4.24 -0.04 -0.75 0.31 -0.8 5.86 4.26 -1.42 -0.28 0.26 3.26 3.18 0.24 -0.21 0.05 -6.82 5.83 -1.17 -1.34 34.56 35.33 13.49 -7.65 -1.2 1.57 0.04 4.14 1.92 -0.005 2.565 3.28 3.25 0.025 34.75 35.01 -0.12 0.14 0.34 -0.09 -0.08 6.885 -5.6 1 -2.37 1.645 10.63 0.51 -0.03 1.96 2.95 3.39 0.035 23.47 38.79 0.19 -0.65 -0.09 0.16 0.055 7.245",
  "GTGAG 5.8 0.1 11 13.16 0.13 10 -6.5 0.38 14 -1.26 0.1 14 -1.5 0.04 12 4.33 0.78 14 -0.77 0.39 12 34.48 0.33 14 34.92 0.41 12 -5.12 0.18 12 4.16 -0.04 -0.67 0.84 -1.63 5.72 4.33 -0.57 -0.27 0.25 3.3 3.28 0.28 -0.16 0.02 -6.5 6.13 -1.26 -1.51 34.48 34.95 13.63 -9.75 -1.2 0.33 -0.35 4.14 -0.39 0.02 1.5 3.28 3.33 0.005 34.75 31.43 -0.12 -0.29 0.34 -0.56 -0.06 6.2 -4.935 1 -2.58 2.41 10.63 0.2 -0.02 2.12 2.95 3.39 0.045 23.47 37.67 0.19 -0.54 -0.09 0.06 0.045 7.3",
  "GTGCC 5.66 0.13 17 13.4 0.38 17 -3.41 0.4 18 -1.29 0.09 18 -1.54 0.04 17 3.05 0.65 18 -1.35 0.37 17 34.22 0.89 18 36.31 0.28 17 -5.18 0.2 14 4.15 -0.04 -0.97 0.54 0.67 5.66 3.05 -1.33 -0.25 0.21 3.21 3.38 0.34 0.07 0.14 -3.41 6.62 -1.29 -1.54 34.22 36.3 13.53 0.86 -0.61 -1.98 -3.36 4.05 1.75 -0.205 9.52 3.3 3.19 0.05 34.03 31 0.15 -0.09 -0.26 -0.63 -0.12 6.98 -11.57 0.15 0.32 -5.38 9.88 -0.68 -0.06 1.235 3.14 3.37 0.02 29.37 35.57 0.21 0.31 -0.22 -0.36 0.08 6.275",
  "GTGCG 5.88 0.16 48 12.5 0.22 44 -4.13 0.29 48 -1.2 0.06 48 -1.48 0.03 48 3.27 0.6 48 -0.64 0.42 48 34.69 0.41 48 35.54 0.36 48 -4.96 0.12 38 4.15 -0.04 -1.08 0.6 0.12 5.86 3.27 -0.64 -0.25 0.16 3.2 3.36 0.3 0.04 0.15 -4.13 7.24 -1.2 -1.48 34.69 35.54 12.55 4.375 -0.61 0.01 -2.585 4.05 6.42 -0.075 5.215 3.3 3.24 0.105 34.03 28.89 0.15 0.07 -0.26 -0.7 -0.1 7.35 -8.47 0.15 -0.46 -0.965 9.88 -1.45 -0.03 1.44 3.14 3.42 0.03 29.37 34.51 0.21 -0.21 -0.22 -0.39 0.12 6.93",
  "GTGGC 5.46 0.3 12 13.56 0.31 12 -4.03 0.35 30 -1.33 0.07 30 -1.7 0.06 30 3.09 0.58 30 -1.52 1.98 30 34.2 0.42 30 33.11 1.3 30 -5.23 0.14 17 4.11 -0.04 -1.32 0.44 -0.18 5.61 3.09 -1.52 -0.26 0.05 3.25 3.3 0.29 0.15 0.12 -4.03 5.08 -1.33 -1.7 34.2 33.11 14.16 -5.305 -1.4 0.26 -0.29 5.18 3.45 -0.07 1.075 3.36 3.37 0.03 35.26 32.46 -0.01 -0.02 -0.18 -0.47 -0.085 7.275 -4.405 -0.29 -1.53 1.88 9.42 2.87 -0.045 1.89 2.93 3.48 0.04 25.46 35.96 0.26 -0.6 -0.17 -0.29 0.115 7.67",
  "GTGGG 5.41 0.26 9 13.48 0.3 4 -2.94 0.52 38 -1.33 0.06 18 -1.76 0.05 38 2.54 0.84 18 -1.85 0.41 38 34.09 0.64 18 33.55 0.42 38 -5.13 0.3 32 4.04 -0.04 -1.86 0.52 1.54 5.57 3.04 -1.85 -0.26 0.23 3.28 3.34 0.3 0.15 0.13 -2.94 2.75 -1.4 -1.76 33.99 33.55 14.6 -3.695 -1.4 0.97 0.8 5.18 5.25 -0.035 0.9 3.36 3.42 0 35.26 30.63 -0.01 -0.25 -0.18 -0.87 -0.055 7.47 -3.365 -0.29 -1 1.395 9.42 3.96 -0.04 1.82 2.93 3.45 0.04 25.46 34.1 0.26 -0.36 -0.17 -0.53 0.07 7.81",
  "GTGTG 5.73 0.16 6 12.22 0.34 6 -8.16 0.15 6 -1.21 0.06 6 -1.43 0.01 6 5.01 0.56 6 -1.37 0.28 6 35.12 0.3 6 33.35 0.18 6 -5 0.09 5 4.23 -0.04 -1.01 1.11 -5.13 5.9 5.01 -1.37 -0.27 0.35 3.31 3.3 0.32 -0.27 0.08 -8.16 7.05 -1.21 -1.43 35.12 33.35 12.22 -1.265 1.38 -0.02 0.43 6.67 1.43 -0.04 5.69 3.43 3.22 0.015 36.74 28.74 0.33 -0.1 -0.22 -0.73 -0.1 6.53 -9.995 0.73 0.59 -4.4 9.43 0.49 -0.04 1.85 3.36 3.28 0.035 33.76 30.57 0.31 -0.17 -0.34 -0.6 0.045 6.75",
  "GTTAG 5.8 0.08 13 13.02 0.17 12 -10.65 0.32 14 -1.12 0.06 14 -1.3 0.05 13 -2.89 0.62 14 5.73 0.88 13 35.18 0.45 14 34.54 0.33 13 -7.07 0.17 10 4.08 -0.03 1.52 -1.22 -1.01 6.04 -2.89 5.9 -0.1 -1.16 3.06 3.32 0.1 0.13 -0.15 -10.65 6.34 -1.12 -1.31 35.18 34.52 13.31 -5.2 0.25 0.18 2.64 3.24 1.49 -0.025 6.795 3.12 3.26 0.035 31.75 34.85 0.14 0.04 -0.64 -0.13 -0.15 6.035 -9.63 -3.39 -1.75 0 -0.75 11.34 0 3.94 3.27 3.04 0.03 36.43 24.59 -0.57 0.16 -0.08 -0.19 -0.04 6.94",
  "GTTCC 4.84 0.18 15 13.82 0.26 14 -9.91 0.6 42 -1.13 0.05 42 -1.4 0.05 24 -3.78 0.87 42 -1.77 3.94 24 35.48 0.44 42 36.02 1.2 24 -7.81 0.19 33 4.35 -0.03 1.94 -1.29 -0.99 4.78 -3.78 -1.24 -0.08 -0.73 3.09 3.36 0.1 0.37 -0.21 -9.91 4.13 -1.13 -1.41 35.48 36.15 14.32 -1.91 -0.08 -0.78 6.855 -0.22 3.61 0.065 -2.625 3.24 3.33 0 34.75 33.12 0.02 -0.18 -0.62 -0.66 -0.115 5.655 -13.51 -2.66 -0.52 2.905 1.29 3.33 0.08 1.81 3.35 3.27 0.02 35.61 33.83 -0.2 -0.21 -0.38 -0.27 -0.095 5.95",
  "GTTCG 5.1 0.2 43 13.22 0.33 36 -10.48 0.3 43 -1.13 0.09 43 -1.35 0.04 43 -3.31 1.12 43 -0.26 0.6 43 35.58 0.31 43 35.61 0.39 43 -7.64 0.15 34 4.39 -0.02 1.83 -1.18 -1.63 5.03 -3.31 -0.26 -0.1 -1.08 3.1 3.3 0.08 0.3 -0.18 -10.48 6.47 -1.13 -1.35 35.58 35.61 13.33 -2.295 -0.08 0.64 3.31 -0.22 4.33 0.05 1.73 3.24 3.37 0.005 34.75 33.2 0.02 0.12 -0.62 -0.59 -0.135 5.69 -12.1 -2.66 -0.77 7.16 1.29 2.23 0.07 2.095 3.35 3.42 0.035 35.61 35.44 -0.2 -0.48 -0.38 0 -0.005 6.345",
  "GTTGC 5.7 0.11 16 12.73 0.19 16 -10.75 0.31 16 -1.1 0.06 16 -1.13 0.07 16 -2.98 0.41 16 4.66 0.47 16 35.02 0.44 16 34.8 0.32 16 -6.99 0.11 11 4.23 -0.03 2.16 -2.18 -2.23 5.8 -2.98 4.66 -0.1 -1.35 3.09 3.3 0.05 0.47 -0.2 -10.75 6.8 -1.1 -1.13 35.02 34.8 12.67 -3.29 0.28 3.97 4.56 2.59 3.56 0.075 -1.22 3.15 3.42 0.04 33.65 34.96 0.16 0.38 -0.56 0.18 -0.07 6.73 -7.74 -3.66 -1.99 -1.555 -1.25 11.7 0.01 3.61 3.3 2.91 0.025 37.43 21.48 -0.68 0.13 0.02 -0.16 -0.09 7.43",
  "GTTGG 5.42 0.45 29 12.88 0.22 10 -9.8 1.02 31 -1.33 0.25 31 -1.48 0.23 29 -1.94 1.65 31 6.57 3.07 29 31.76 3.22 31 34.44 0.86 29 -7 0.18 17 4.02 0.04 2.97 -3.11 5.83 5.57 -1.94 6.53 -0.04 0.48 3.06 3.53 -0.19 0.44 -0.42 -9.8 5.1 -1.33 -1.47 31.76 34.46 14.37 -7.88 0.28 -2.12 1.485 2.59 4.21 -0.02 4.445 3.15 3.1 0.055 33.65 16.27 0.16 0.02 -0.56 -0.1 -0.075 6.87 -7.29 -3.66 -1.98 0 -1.25 11 0 3.43 3.3 2.96 0.02 37.43 23.39 -0.68 0.1 0.02 -0.14 -0.11 7.44",
  "GTTTG 4.95 0.22 70 12.47 0.31 24 -13.1 0.82 70 -1.12 0.05 70 -1.01 0.04 70 -3.27 0.87 70 -2.42 0.93 70 36.33 0.51 70 35.28 0.34 70 -8.27 0.21 56 4.49 -0.03 1.58 1.55 -8.07 5.23 -3.27 -2.42 -0.15 -2.02 3.16 3.13 -0.07 0.21 -0.08 -13.1 5.95 -1.12 -1.01 36.33 35.28 12.69 -2.29 -0.25 -0.39 -8.125 -1.5 1.92 -0.205 14.525 3.26 3.28 -0.02 35.33 34.88 0.01 -0.07 -0.96 -0.43 -0.065 5.195 -14.015 -2.78 -2.46 7.785 0.74 0.84 0.095 3.35 3.35 3.31 0.015 36.19 35.22 -0.2 -0.5 -0.42 -0.09 -0.09 6.09",
  "TAAAA 4.89 0.3 13 12.82 0.18 13 -13.29 0.54 13 -1.05 0.03 13 -1.05 0.06 13 -2.46 1.21 13 -2.75 1.19 13 35.6 0.28 13 36.72 0.45 13 -8.39 0.44 11 4.65 -0.02 -0.69 -1.02 7.24 4.88 -2.46 -2.75 0.15 -2.26 3.13 3.22 -0.26 -0.1 -0.11 -13.29 5.67 -1.05 -1.05 35.6 36.72 12.83 2.22 -0.07 -0.1 -4.3 2.76 -1.96 -0.23 11.82 3.06 3.21 -0.045 32.53 36.32 -0.03 0.04 -0.49 -0.74 -0.13 4.82 -13.8 -2.08 -0.79 4.425 0.98 0.56 0.105 3.675 3.32 3.31 0.015 35.05 33.46 -0.44 -0.11 -0.22 -0.64 -0.055 5.67",
  "TAAAC 5.1 0.12 22 12.64 0.24 19 -13.54 0.47 23 -0.99 0.04 23 -1.07 0.04 23 -1.29 0.81 23 -2.84 0.85 23 35.72 0.29 23 36.4 0.29 23 -7.85 0.19 19 4.49 -0.03 -1.09 -1.74 8.3 5.21 -1.29 -2.84 0.15 -1.99 3.14 3.15 -0.3 0.04 -0.09 -13.54 6.13 -0.99 -1.07 35.72 36.4 12.73 -8.66 -0.07 -0.25 1.93 2.76 -1.5 0.005 0.385 3.06 3.26 0.085 32.53 35.33 -0.03 0.01 -0.49 -0.96 -0.095 5.14 -15.3 -2.08 -2.78 6.595 0.98 0.74 0.11 3.65 3.32 3.35 0.015 35.05 36.19 -0.44 -0.2 -0.22 -0.42 -0.055 5.76",
  "TAAAG 4.7 0.16 11 13.04 0.22 11 -12.85 0.43 12 -1.07 0.04 12 -1.25 0.04 12 -1.56 0.72 12 -3.87 0.7 12 35.7 0.32 12 36.11 0.22 12 -8.13 0.13 8 4.51 -0.03 -0.98 -1.82 6.34 4.57 -1.56 -3.87 0.15 -1.72 3.17 3.2 -0.23 0.13 -0.11 -12.85 5.81 -1.07 -1.25 35.7 36.11 13.26 2.675 -0.07 0.69 8.005 2.76 -2.47 -0.165 8.295 3.06 3.2 -0.065 32.53 36.5 -0.03 -0.02 -0.49 -0.75 -0.045 4.86 -13.805 -2.08 -2.37 5.815 0.98 1.3 0.11 3.825 3.32 3.25 0.02 35.05 34.29 -0.44 -0.14 -0.22 -0.44 -0.045 6.02",
  "TAACA 5.17 0.25 9 12.47 0.35 9 -11.35 0.53 10 -1.09 0.06 10 -1.51 0.04 9 -2.39 1.14 10 -2.47 1.01 9 35.32 0.61 10 34.78 0.29 9 -7.45 0.18 8 4.31 -0.02 -1.57 -0.13 9.43 5.23 -2.39 -2.6 0.15 -1.43 3.06 3.39 -0.17 0.45 0.09 -11.35 6.6 -1.09 -1.52 35.32 34.87 12.8 -6.455 0.25 0.69 1.585 3.24 0.7 -0.015 5.065 3.12 3.3 0.055 31.75 31.62 0.14 -0.07 -0.64 -1.15 -0.105 5.805 -8.96 -3.39 -0.15 1.56 -0.75 -1.3 0.065 2.905 3.27 3.39 0.04 36.43 32.99 -0.57 -0.45 -0.08 -0.69 0.02 6.8",
  "TAACC 4.87 0.26 15 13.43 0.22 14 -10.83 0.37 28 -1.15 0.03 28 -1.58 0.04 16 -3.03 0.57 28 -3.26 0.73 16 35.08 0.36 28 35.3 0.42 16 -7.76 0.19 22 4.34 -0.02 -1.43 -0.17 9.38 4.85 -3.03 -3.36 0.16 -1.12 3.08 3.44 -0.09 0.42 0.07 -10.83 4.8 -1.15 -1.59 35.08 35.35 13.83 1.46 0.25 -0.74 -2.955 3.24 0.02 -0.195 18.39 3.12 3.23 0.125 31.75 31.1 0.14 -0.01 -0.64 -1.28 -0.17 6.01 -12.575 -3.39 0.68 1.26 -0.75 -0.47 0.05 2.635 3.27 3.45 0.03 36.43 33.37 -0.57 -0.13 -0.08 -0.8 -0.005 6.02",
  "TAACG 5.15 0.25 51 12.62 0.39 46 -11.31 0.48 55 -1.09 0.03 55 -1.51 0.03 53 -2.63 0.93 55 -2.83 0.84 53 35.27 0.3 55 34.89 0.43 53 -7.51 0.23 43 4.35 -0.02 -1.52 0.36 10.2 5.06 -2.63 -2.86 0.15 -1.24 3.05 3.38 -0.15 0.45 0.1 -11.31 6.65 -1.09 -1.51 35.27 34.91 12.87 -6.41 0.25 -0.8 2.16 3.24 1.38 0.025 5.195 3.12 3.32 0.055 31.75 32.17 0.14 -0.19 -0.64 -1.04 -0.14 5.77 -8.615 -3.39 0.24 3.21 -0.75 -0.87 0.07 2.825 3.27 3.43 0.04 36.43 32.81 -0.57 -0.39 -0.08 -0.66 0.06 6.965",
  "TAAGA 4.93 0.27 10 13.73 0.28 9 -8.51 1.07 25 -1.28 0.11 25 -1.78 0.06 23 -3.37 0.95 25 -2.51 1.32 23 34.89 1.18 25 32.43 0.56 23 -7.75 0.3 21 4.39 -0.02 -1.81 -1.96 6.61 4.82 -3.37 -2.42 0.14 -1.05 3.1 3.43 -0.02 0.29 0.06 -8.51 5.6 -1.28 -1.79 34.89 32.43 14.12 7.94 -0.17 -0.18 1.585 -1.34 1.41 -0.05 14.685 3.23 3.55 0.04 33.71 33.81 -0.07 0.02 -0.55 -1.23 -0.045 5.93 -12.945 -3.36 -1.04 8.04 -0.07 4.57 0.095 4.18 3.29 3.39 0.025 36.23 31.3 -0.5 -0.09 -0.09 -0.75 0.08 6.405",
  "TAAGC 5.01 0.23 21 13.68 0.19 20 -8.92 0.35 21 -1.26 0.03 21 -1.77 0.04 21 -2.87 0.72 21 -2.56 0.77 21 34.85 0.46 21 32.17 0.35 21 -7.49 0.15 17 4.34 -0.03 -1.8 -1.99 6.15 4.88 -2.87 -2.56 0.14 -1.23 3.11 3.38 -0.07 0.34 0.05 -8.92 6.63 -1.26 -1.77 34.85 32.17 13.87 17.95 -0.17 -0.63 0.405 -1.34 3.27 -0.305 30.07 3.23 3.5 -0.21 33.71 36.01 -0.07 -0.08 -0.55 -0.95 -0.02 6.475 -16.215 -3.36 -3.04 9.365 -0.07 4.55 0.095 4.07 3.29 3.54 0.025 36.23 35.23 -0.5 -0.25 -0.09 -0.78 0.105 6.035",
  "TAAGG 4.81 0.26 10 13.93 0.35 10 -8.13 0.45 10 -1.27 0.04 10 -1.84 0.04 10 -3.71 1 10 -4.02 1.28 10 34.66 0.33 10 32.34 0.32 10 -7.66 0.27 8 4.33 -0.01 -1.64 -2.15 7.88 4.89 -3.71 -4.02 0.14 -0.98 3.07 3.41 -0.01 0.4 0.1 -8.13 6.51 -1.27 -1.84 34.66 32.34 14.04 -0.655 -0.17 0.27 -1.8 -1.34 2.63 -0.025 11.14 3.23 3.38 0.05 33.71 34.14 -0.07 -0.06 -0.55 -0.76 -0.005 6.16 -12.225 -3.36 -1.95 7.685 -0.07 3.9 0.095 4.055 3.29 3.33 0.025 36.23 32.22 -0.5 -0.18 -0.09 -0.78 0.075 6.695",
  "TAATA 5.11 0.46 120 13.09 0.37 112 -9.98 0.56 120 -1.19 0.04 120 -1.53 0.04 120 -2.19 1.59 120 -3.92 1.63 120 35.37 0.53 120 32.48 0.59 120 -7.61 0.23 95 4.37 -0.02 -2.02 0.23 3.57 5.25 -2.19 -3.92 0.14 -1.45 3.13 3.26 -0.16 0.18 0.02 -9.98 6.88 -1.19 -1.53 35.37 32.48 13.15 -6.29 0.49 0.34 -4.5 0.11 -1.57 0 3.985 3.26 3.21 -0.03 34.83 32.19 0.01 0.01 -0.71 -0.96 -0.145 4.535 -13.255 -3.34 0.48 1.92 -0.16 -1.72 0.11 3.535 3.3 3.25 0.025 36.99 31.21 -0.63 0.25 -0.17 -0.84 0.08 5.8",
  "TAATC 4.81 0.48 388 13.5 0.42 344 -10.25 0.82 391 -1.23 0.05 391 -1.53 0.04 391 -2.32 1.9 391 -4.51 1.51 391 35.28 0.77 391 32.72 0.56 391 -7.95 0.3 301 4.4 -0.02 -1.66 0.66 2.76 4.96 -2.32 -4.51 0.15 -1.36 3.15 3.28 -0.15 0.15 -0.03 -10.25 6.61 -1.23 -1.53 35.28 32.72 13.51 -9.785 0.49 0.3 -2.19 0.11 0.14 -0.025 6.665 3.26 3.21 -0.005 34.83 32.14 0.01 -0.07 -0.71 -1.15 -0.14 4.615 -14.72 -3.34 -0.16 1.475 -0.16 -1.55 0.125 3.13 3.3 3.39 0.035 36.99 32.02 -0.63 -0.06 -0.17 -0.83 0.005 5.795",
  "TAATG 4.9 0.36 135 12.92 0.42 124 -10.52 0.7 140 -1.2 0.05 140 -1.51 0.06 140 -2.15 1.37 140 -4.86 1.85 140 35.43 0.52 140 32.4 0.69 140 -7.85 0.31 111 4.39 -0.02 -1.61 0.96 3.3 4.96 -2.15 -4.86 0.15 -1.43 3.14 3.28 -0.17 0.2 -0.02 -10.52 6.78 -1.2 -1.51 35.43 32.4 13.05 -7.58 0.49 2.52 -4.32 0.11 -0.35 -0.045 6.02 3.26 3.29 -0.075 34.83 28.07 0.01 -0.05 -0.71 -1.2 -0.09 5.085 -13.435 -3.34 1.09 1.005 -0.16 -1.22 0.105 3.41 3.3 3.28 0.025 36.99 31.23 -0.63 0.16 -0.17 -0.79 0.04 6.035",
  "TACAA 5.89 0.29 19 12.57 0.35 19 -7.17 0.49 23 -1.47 0.05 23 -1.14 0.11 23 -1.49 0.82 23 5.8 1.08 23 33.4 0.42 23 35.27 0.47 23 -5.23 0.27 19 4.32 -0.04 -0.4 2.41 5.25 5.99 -1.49 5.8 0.27 0.28 3.28 3.39 0.29 -0.46 0.09 -7.17 6.66 -1.47 -1.14 33.4 35.27 12.56 -2.375 0.3 1.28 3.37 3.68 5.52 -0.01 4.905 3.19 3.49 0.01 28.75 35.6 -0.1 0.15 -0.85 -0.55 -0.155 6.405 -10.27 0.33 -1.94 -7.305 0.51 12.12 -0.04 2.67 3.28 3.2 0.03 30.55 26.37 -0.09 0.15 -0.66 -0.32 -0.055 6.57",
  "TACAC 5.74 0.46 24 12.82 0.34 22 -6.58 0.4 24 -1.45 0.07 24 -1.21 0.11 24 -2.01 1.71 24 3.4 1.01 24 33.6 0.4 24 34.99 0.55 24 -5.08 0.21 18 4.27 -0.04 -0.52 1.16 3.97 5.75 -2.01 3.4 0.26 0.36 3.29 3.26 0.22 -0.27 0.13 -6.58 7.07 -1.45 -1.21 33.6 34.99 12.85 -0.545 0.3 1.38 2.925 3.68 6.67 0.025 5.05 3.19 3.43 0.02 28.75 36.74 -0.1 0.33 -0.85 -0.22 -0.16 6.595 -10.425 0.33 0.73 -4.72 0.51 9.43 -0.055 1.915 3.28 3.36 0.035 30.55 33.76 -0.09 0.31 -0.66 -0.34 0.05 6.53",
  "TACAG 5.41 0.26 21 12.88 0.42 19 -6.49 0.53 56 -1.49 0.04 56 -1.39 0.08 56 -1.95 0.65 56 3.96 1.14 56 33.82 0.35 56 34.82 0.63 56 -5.31 0.18 45 4.24 -0.03 -0.46 0.96 4.11 5.61 -1.95 3.96 0.28 0.46 3.3 3.34 0.26 -0.26 0.09 -6.49 7.07 -1.49 -1.39 33.82 34.82 13.21 -3.315 0.3 0.41 2.15 3.68 5.58 0.025 2.535 3.19 3.49 0.035 28.75 35.68 -0.1 0.09 -0.85 -0.67 -0.15 6.84 -10.89 0.33 -0.5 -5.77 0.51 9.7 -0.035 2.76 3.28 3.27 0.03 30.55 32.34 -0.09 0.08 -0.66 -0.16 0.055 6.75",
  "TACCA 5.13 0.13 38 13.36 0.19 33 -5.96 0.28 39 -1.51 0.03 39 -1.69 0.04 38 -2.45 0.56 39 -0.68 0.56 38 34.38 0.23 39 34.3 0.37 38 -5.4 0.22 31 4.29 -0.04 -0.65 -0.57 2.66 5.26 -2.45 -0.7 0.27 0.27 3.32 3.37 0.17 -0.08 0.07 -5.96 6.78 -1.51 -1.69 34.38 34.32 13.4 1.26 0.49 2.31 -7.19 0.32 4.48 -0.14 11.905 3.29 3.62 0.06 30.81 34.57 0.02 0.07 -1.15 -0.82 -0.2 6.59 -9.485 0.77 -0.68 -1.055 -1.44 3.91 -0.005 1.47 3.27 3.58 0.035 32.83 35.51 0.08 -0.43 -0.52 -0.62 0.07 6.31",
  "TACCC 4.71 0.27 136 14.31 0.23 96 -5.01 0.49 168 -1.56 0.09 168 -1.82 0.04 165 -3.44 1.69 168 -1.79 1.13 165 34.53 0.4 168 34.33 0.5 165 -5.5 0.19 133 4.3 -0.03 -0.23 -0.5 3.8 4.82 -3.44 -1.78 0.29 0.52 3.34 3.45 0.23 -0.03 0.01 -5.01 6.09 -1.56 -1.83 34.53 34.33 14.41 -6.255 0.49 1.11 -0.14 0.32 3.17 0.01 1.685 3.29 3.65 0.01 30.81 35.52 0.02 -0.03 -1.15 -1.38 -0.115 6.185 -13.2 0.77 0.43 -2.39 -1.44 5.47 -0.015 1.13 3.27 3.68 0.02 32.83 33.67 0.08 0.01 -0.52 -1.23 0.02 5.54",
  "TACCG 4.96 0.14 34 13.28 0.23 29 -5.99 0.27 37 -1.52 0.04 37 -1.71 0.04 37 -2.35 0.57 37 -0.83 0.49 37 34.43 0.25 37 34.27 0.32 37 -5.28 0.18 29 4.27 -0.03 -0.52 -0.24 3.77 5.14 -2.35 -0.83 0.28 0.37 3.33 3.4 0.21 -0.06 0.04 -5.99 7.16 -1.52 -1.71 34.43 34.27 13.31 -3.375 0.49 -1.2 -1.555 0.32 0.98 -0.015 8.865 3.29 4.29 0.035 30.81 32.85 0.02 -0.03 -1.15 -0.75 -0.09 6.62 -8.87 0.77 -0.99 0.04 -1.44 3.53 0.01 1.415 3.27 3.61 0.04 32.83 36.59 0.08 -0.51 -0.52 -0.44 0.12 6.46",
  "TACGA 5.61 0.22 169 12.84 0.39 164 -6.48 0.46 171 -1.47 0.03 171 -1.5 0.06 171 -1.92 0.81 171 4.91 0.96 171 33.57 0.32 171 33.73 0.43 171 -4.99 0.16 136 4.21 -0.03 0.06 0.18 4.37 5.67 -1.92 4.91 0.26 0.53 3.28 3.41 0.23 -0.05 0.04 -6.48 7.01 -1.47 -1.5 33.57 33.73 12.89 -3.39 0.75 -1.25 1.41 3.92 5.07 0.09 0.295 3.13 3.37 0.085 26.92 36.26 0.03 0 -0.45 0.13 -0.005 7.14 -9.185 0.18 1.62 -3.105 0.77 10.27 -0.025 1.61 3.27 3.11 0.045 30.04 27.85 -0.1 0.06 -0.56 -0.09 0.125 6.585",
  "TACGC 5.32 0.16 35 12.71 0.21 5 -7.22 0.49 63 -1.49 0.04 63 -1.61 0.05 61 -2.07 0.53 63 4.31 0.41 61 33.93 0.39 63 33.14 0.56 61 -5.03 0.12 70 4.18 -0.03 -0.19 -0.16 4.59 5.42 -2.07 4.32 0.27 0.56 3.3 3.43 0.23 0.04 0 -7.22 5.58 -1.49 -1.62 33.93 33.13 13.49 -4.825 0.75 -0.81 1.02 3.92 6.61 0.06 0.245 3.13 3.55 0.07 26.92 36.65 0.03 -0.19 -0.45 -0.3 -0.075 7.505 -10.6 0.18 1.24 -3.175 0.77 8.92 0 0.95 3.27 3.4 0.025 30.04 35.4 -0.1 0.21 -0.56 -0.19 0.125 6.25",
  "TACGG 5.33 0.16 5 12.98 0.32 5 -6.7 0.64 8 -1.46 0.04 8 -1.59 0.08 8 -2.19 0.66 8 2.74 1.29 8 33.73 0.28 8 33.27 0.44 8 -5.15 0.27 6 4.26 -0.02 0.13 -0.82 5.04 5.32 -2.19 2.74 0.26 0.54 3.29 3.39 0.27 0.04 0.01 -6.7 6.75 -1.46 -1.59 33.73 33.27 13.48 -5.24 0.75 0.88 1.11 3.92 6.79 0.135 0.425 3.13 3.41 0.075 26.92 34.95 0.03 0.29 -0.45 -0.07 -0.025 7.5 -9.325 0.18 0.15 -2.6 0.77 8.7 -0.02 1.485 3.27 3.13 0.045 30.04 31.48 -0.1 -0.03 -0.56 -0.03 0.13 6.655",
  "TACTC 4.69 0.58 25 14.19 0.29 21 -3.05 0.52 28 -1.69 0.09 28 -1.76 0.05 28 -3.67 2.84 28 -2.76 2.33 28 34.56 0.31 28 31.76 0.76 28 -5.63 0.26 23 4.37 -0.02 -1.34 2.39 -0.27 4.84 -3.67 -2.76 0.26 0.32 3.42 3.34 0.23 -0.21 0.14 -3.05 6.8 -1.69 -1.76 34.56 31.76 14.26 -4.815 -0.78 0.16 1.685 0.4 4.06 -0.09 6.71 3.28 3.48 0.05 29.92 36.4 -0.09 0.05 -1.17 -0.96 -0.135 6.78 -16.58 1.81 -2.53 1.905 -2.16 3.33 0.065 1.655 3.33 3.59 0.015 33.24 34.74 0.25 -0.18 -0.57 -0.88 0.225 5.19",
  "TACTG 5.13 0.32 28 13.21 0.32 25 -4.2 0.79 35 -1.63 0.05 29 -1.69 0.06 35 -2.15 0.99 29 -1.74 1 35 34.47 0.42 29 31.52 0.46 35 -5.36 0.23 27 4.29 -0.02 -1.76 2.77 0.11 5.14 -2.3 -1.74 0.25 0.3 3.42 3.33 0.23 -0.21 0.14 -4.2 5.95 -1.64 -1.69 34.76 31.52 13.71 -6.625 -0.78 0.62 1.88 0.4 3.99 -0.05 6.235 3.28 3.49 0.05 29.92 33.34 -0.09 0.04 -1.17 -0.86 -0.145 6.78 -11.195 1.81 -3.95 1.835 -2.16 0.77 0.02 2.645 3.33 3.44 0.02 33.24 37.04 0.25 -0.74 -0.57 -0.3 0.205 6.235",
  "TAGAA 5.33 0.07 4 13.69 0.26 4 -3.73 0.29 4 -1.64 0.05 4 -1.41 0.09 4 -1.4 0.37 4 -0.49 0.35 4 31.57 0.28 4 36.55 0.64 4 -5.52 0.07 2 4.35 -0.04 -1.64 2.67 4.23 5.48 -1.4 -0.49 -0.26 0 3.27 3.39 0.2 -0.32 0.14 -3.73 6.47 -1.64 -1.41 31.57 36.55 13.61 -3.675 -0.2 -0.79 1.515 4.8 0.42 -0.015 1.825 3.39 3.34 0.045 32.53 35.9 -0.04 -0.12 -0.48 -0.55 -0.135 5.87 -11.725 -1.49 0.69 4.115 5.14 2.93 0.04 2.885 3.37 3.38 0.03 31.06 34.17 -0.36 -0.12 -0.69 -0.45 0.065 6.63",
  "TAGAC 5.32 0.2 14 13.82 0.16 10 -3.62 0.52 17 -1.67 0.07 17 -1.46 0.05 14 -1.45 0.89 17 -1.45 0.39 14 31.64 0.46 17 36.16 0.25 14 -5.33 0.2 15 4.26 -0.03 -1.65 1.91 3.6 5.32 -1.45 -1.24 -0.26 0.11 3.27 3.33 0.17 -0.15 0.13 -3.62 6.25 -1.67 -1.5 31.64 36 14.19 -6.06 -0.2 0.5 1.48 4.8 -0.35 0.03 3.345 3.39 3.31 0.035 32.53 34.57 -0.04 0.18 -0.48 -0.47 -0.095 6.26 -12.19 -1.49 -1.64 5.805 5.14 1.08 0.055 2.905 3.37 3.39 0.03 31.06 37.9 -0.36 -0.36 -0.69 -0.18 0.09 6.74",
  "TAGAG 5.41 0.25 8 13.78 0.28 6 -3.22 0.43 13 -1.72 0.06 13 -1.61 0.09 9 -1.35 0.72 13 -0.44 1.3 9 31.4 0.3 13 35.31 1.11 9 -5.27 0.19 11 4.17 -0.03 -1.61 1.79 2.92 5.38 -1.35 -0.29 -0.26 0.19 3.29 3.38 0.21 -0.15 0.1 -3.22 5.78 -1.72 -1.64 31.4 35.43 14.42 -0.125 -0.2 0.5 5.83 4.8 3.59 -0.07 8.37 3.39 3.53 0.045 32.53 31.77 -0.04 0.09 -0.48 -1.55 -0.155 6.39 -11.56 -1.49 -0.7 3.445 5.14 3.41 0.045 2.765 3.37 3.32 0.03 31.06 33.95 -0.36 -0.08 -0.69 -0.49 0.05 7.135",
  "TAGCA 5.36 0.2 15 13.61 0.32 14 -1.6 0.34 15 -1.67 0.04 15 -1.64 0.04 15 -2.09 0.69 15 -1.5 0.64 15 31.39 0.24 15 36.48 0.31 15 -5.25 0.23 12 4.23 -0.02 -1.73 0.83 4.14 5.41 -2.09 -1.5 -0.24 0.17 3.22 3.43 0.22 0.02 0.2 -1.6 7.04 -1.67 -1.64 31.39 36.48 13.6 6.635 0.52 1.31 -6.02 1.42 -0.48 -0.12 9.34 3.24 3.31 -0.06 32.66 31.95 -0.01 -0.11 -0.7 -0.69 0 6.425 -12.025 -3.2 1.57 1.925 1.56 -1.42 0.02 2.15 3.32 3.42 0.01 34.92 36.13 -0.62 0.5 -0.28 -0.34 0.22 6.2",
  "TAGCC 5 0.24 20 14.22 0.25 15 -1.22 0.33 23 -1.71 0.03 23 -1.65 0.03 20 -2.77 1.29 23 -2.39 0.93 20 31.35 0.4 23 37.31 0.34 20 -5.49 0.17 16 4.32 -0.02 -1.44 1.1 4.28 4.85 -2.77 -2.45 -0.24 0.28 3.25 3.47 0.27 0.03 0.17 -1.22 6 -1.71 -1.66 31.35 37.3 14.52 -0.995 0.52 -0.03 3.865 1.42 0.71 -0.08 3.665 3.24 3.47 0.06 32.66 33 -0.01 0.19 -0.7 -1.1 -0.085 6.61 -12.09 -3.2 -0.58 5.295 1.56 -0.12 0.045 2.545 3.32 3.53 0.025 34.92 35.84 -0.62 0.05 -0.28 -0.81 0.16 6.23",
  "TAGCG 5.22 0.13 11 13.43 0.2 10 -1.63 0.28 12 -1.69 0.03 12 -1.62 0.03 12 -2.2 0.57 12 -1.71 0.35 12 31.38 0.27 12 36.72 0.18 12 -5.26 0.16 10 4.22 -0.02 -1.66 1.23 4.15 5.29 -2.2 -1.71 -0.25 0.22 3.23 3.44 0.22 0.01 0.18 -1.63 6.92 -1.69 -1.62 31.38 36.72 13.6 -4.66 0.52 -0.84 -1.355 1.42 1.21 -0.06 0.165 3.24 3.42 0.055 32.66 32.32 -0.01 0.07 -0.7 -0.75 -0.025 6.735 -11.45 -3.2 1.12 2.985 1.56 -0.06 0.04 2.2 3.32 3.45 0.015 34.92 34.64 -0.62 0.24 -0.28 -0.57 0.21 6.72",
  "TAGGA 4.98 0.22 11 14.08 0.18 11 -1.39 0.15 11 -1.74 0.04 11 -1.81 0.04 11 -2.51 0.5 11 -0.97 0.34 11 31.66 0.17 11 34.64 0.28 11 -5.67 0.12 9 4.3 -0.02 -1.93 1.87 4.88 4.98 -2.51 -0.97 -0.26 0.17 3.25 3.5 0.26 0.06 0.19 -1.39 6.6 -1.74 -1.81 31.66 34.64 14.18 -0.17 0.08 0.38 3.26 4.07 4.06 0.02 0.77 3.34 3.51 0.105 32.41 33.87 -0.17 0.02 -0.56 -0.87 -0.105 6.355 -8.83 -2.61 2.03 6.655 2.13 6.08 0.035 2.855 3.3 3.49 0.025 33.56 31.5 -0.49 0.11 -0.46 -0.85 0.17 6.995",
  "TAGGC 4.97 0.14 14 14.21 0.22 13 -1.23 0.34 17 -1.76 0.03 17 -1.86 0.04 17 -2.47 0.58 17 -1.96 0.62 17 31.51 0.2 17 34.04 0.38 17 -5.65 0.23 13 4.22 -0.03 -1.84 1.34 4 5.02 -2.47 -1.96 -0.25 0.19 3.27 3.44 0.24 0.11 0.16 -1.23 6.5 -1.76 -1.86 31.51 34.04 14.38 1.905 0.08 -0.99 7.24 4.07 2.03 -0.01 8.445 3.34 3.59 0.09 32.41 31.99 -0.17 0.03 -0.56 -0.33 -0.07 6.99 -11.465 -2.61 0.61 8.42 2.13 5.32 0.06 2.99 3.3 3.64 0.03 33.56 34.58 -0.49 -0.13 -0.46 -1.02 0.245 6.565",
  "TAGGG 4.99 0.18 8 14.29 0.2 8 -0.56 0.22 8 -1.76 0.03 8 -1.89 0.03 8 -2.67 0.61 8 -2.27 0.5 8 31.16 0.2 8 34.12 0.38 8 -5.42 0.07 6 4.22 -0.02 -1.67 1.14 5.24 4.9 -2.67 -2.27 -0.26 0.32 3.23 3.46 0.27 0.14 0.17 -0.56 6.86 -1.76 -1.89 31.16 34.12 14.52 -5.26 0.08 -1.32 5.73 4.07 3.56 -0.135 5.13 3.34 3.49 0.055 32.41 34.59 -0.17 -0.08 -0.56 -0.79 -0.025 6.815 -7.915 -2.61 0.76 6.745 2.13 5.78 0.045 2.795 3.3 3.46 0.03 33.56 32.29 -0.49 0.03 -0.46 -0.97 0.145 7.225",
  "TAGTA 5.33 0.3 27 13.35 0.43 26 -3.97 0.28 27 -1.67 0.05 27 -1.6 0.03 27 -1.21 0.84 27 -2.12 0.96 27 31.63 0.38 27 34.42 0.4 27 -5.28 0.23 23 4.25 -0.03 -2.14 1.63 0.49 5.47 -1.21 -2.12 -0.25 0.25 3.26 3.37 0.21 -0.19 0.18 -3.97 7.21 -1.67 -1.6 31.63 34.42 13.38 -8.32 0.26 -0.78 -0.155 3.96 0.4 -0.06 2.42 3.39 3.28 0.095 33.51 29.92 0.04 -0.09 -0.72 -1.17 -0.145 6.76 -12.24 -3.32 1.81 0.345 1.53 -2.16 0.025 3.31 3.4 3.33 0.025 36.23 33.24 -0.78 0.25 -0.41 -0.57 0.225 5.995",
  "TAGTC 5.08 0.3 24 13.64 0.58 24 -3.9 0.51 24 -1.72 0.05 24 -1.64 0.05 24 -1 1.14 24 -2.07 0.91 24 31.53 0.44 24 34.57 0.34 24 -5.5 0.25 18 4.23 -0.02 -2.03 2.16 0.18 5.3 -1 -2.07 -0.25 0.32 3.3 3.41 0.22 -0.21 0.13 -3.9 7.12 -1.72 -1.64 31.53 34.57 13.58 -7.76 0.26 0.4 3 3.96 -0.05 0.025 3.79 3.39 3.22 0.055 33.51 30.4 0.04 0.12 -0.72 -1.09 -0.145 6.355 -13.57 -3.32 1.62 3.375 1.53 -0.65 0.045 3.525 3.4 3.49 0.035 36.23 33.25 -0.78 -0.17 -0.41 -0.82 0.24 5.9",
  "TAGTG 5.11 0.21 8 13.48 0.53 7 -4.24 0.88 11 -1.73 0.06 11 -1.62 0.06 9 -1.38 1.11 11 -2.73 0.73 9 31.7 0.75 11 34.28 0.22 9 -5.23 0.19 9 4.29 -0.03 -1.7 2.32 0.24 5.16 -1.38 -2.63 -0.25 0.28 3.3 3.42 0.23 -0.22 0.13 -4.24 5.98 -1.73 -1.63 31.7 34.4 13.89 -10.21 0.26 0.23 1.78 3.96 2.61 -0.025 3.995 3.39 3.37 0.055 33.51 30.45 0.04 0 -0.72 -1.09 -0.11 6.58 -13.13 -3.32 2.38 -0.185 1.53 -3.54 0.03 3.16 3.4 3.4 0.025 36.23 34.76 -0.78 0.35 -0.41 -0.48 0.21 5.92",
  "TATAA 6.07 0.49 43 12.54 0.47 40 -7.14 0.63 45 -1.49 0.02 45 -1.34 0.08 43 -3.01 1.55 45 7.31 2.17 43 31.78 0.43 45 34.57 0.82 43 -6.76 0.35 37 4.1 -0.02 -0.06 1.78 4.35 6.02 -3.01 7.37 -0.09 -0.87 3.18 3.42 0.01 -0.12 0.03 -7.14 6.88 -1.49 -1.34 31.78 34.59 12.8 -4.67 -1.96 -0.11 0.32 1.07 0.54 0 6.045 1.58 3.42 0.01 30.46 37.82 0.03 0.03 -1 -0.27 -0.13 5.62 -11.395 -0.03 1.94 0.895 0.25 10.51 -0.005 4.01 3.21 3.27 0.035 29.5 29.6 0 0.05 -0.85 -0.34 0.095 6.3",
  "TATAC 6.01 0.24 32 12.87 0.43 18 -7.88 1.03 40 -1.47 0.03 34 -1.36 0.09 40 -2.8 0.75 34 5.6 1.16 40 31.78 0.29 34 34.63 0.46 40 -6.72 0.25 32 4.05 -0.02 -0.07 0.23 3.57 5.96 -2.77 5.6 -0.09 -0.7 3.19 3.3 0 0.01 0 -7.88 6.44 -1.48 -1.36 31.88 34.63 13.33 -1.425 -1.96 -2.31 -0.405 1.07 6.23 0.025 4.03 1.58 4.17 0.015 30.46 37.58 0.03 0.21 -1 -0.85 -0.095 6.31 -10.995 -0.03 0.31 -3.135 0.25 8.55 -0.03 3.375 3.21 3.3 0.03 29.5 33.49 0 0.06 -0.85 -0.36 0.1 6.495",
  "TATAG 5.79 0.25 13 13.23 0.28 11 -7.69 0.47 14 -1.5 0.03 14 -1.44 0.04 14 -3.1 0.8 14 5.66 1.4 14 31.96 0.28 14 34.63 0.46 14 -6.87 0.26 12 4.04 -0.02 0.08 -0.12 3.51 5.84 -3.1 5.66 -0.1 -0.67 3.19 3.33 0.01 0.02 -0.03 -7.69 7.32 -1.5 -1.44 31.97 34.63 13.26 -2.12 -1.96 0.01 -3.195 1.07 -1.56 0.065 -0.36 1.58 3.43 0.005 30.46 38.93 0.03 0.14 -1 -0.69 -0.055 5.885 -11.95 -0.03 0.23 0.88 0.25 11.11 -0.005 3.785 3.21 3.29 0.035 29.5 31.37 0 0.1 -0.85 -0.48 0.07 6.785",
  "TATCA 5.38 0.31 69 13.43 0.33 67 -7.32 0.6 82 -1.48 0.03 82 -1.5 0.05 82 -3.4 1.12 82 -1.13 1.14 82 31.94 0.49 82 35.75 0.59 82 -7.24 0.21 66 4.22 -0.02 0.33 -0.35 2.37 5.46 -3.4 -1.13 -0.09 -0.68 3.19 3.3 -0.03 0.27 -0.05 -7.32 7.02 -1.48 -1.5 31.94 35.75 13.44 -10.075 -0.48 -1.17 -3.08 -0.09 0.99 -0.045 7.275 3.28 3.24 0.055 31.38 34.88 -0.1 -0.13 -0.95 -0.25 -0.07 6.095 -9.945 0.19 -2.26 2.575 0.42 1.5 0.065 2.465 3.23 3.44 0.04 29.64 38.64 0.03 -0.62 -0.86 0 0.045 6.895",
  "TATCC 4.98 0.24 28 13.94 0.31 24 -7.47 0.55 44 -1.52 0.05 44 -1.54 0.07 30 -4.17 1.05 44 -1.31 1.84 30 32.31 0.4 44 36.04 0.83 30 -7.48 0.17 35 4.26 -0.01 0.42 -0.62 2.48 4.94 -4.17 -1.19 -0.08 -0.29 3.22 3.36 0.01 0.21 -0.11 -7.47 4.82 -1.52 -1.55 32.31 36.1 14.41 -9.795 -0.48 -0.25 -3.835 -0.09 0.71 0 8.11 3.28 3.36 0.05 31.38 36.74 -0.1 -0.16 -0.95 -0.7 -0.09 6.115 -13.165 0.19 -1.44 -1.195 0.42 2.13 0.06 2.125 3.23 3.4 0.03 29.64 36.42 0.03 -0.09 -0.86 -0.52 -0.01 6.26",
  "TATCG 5.32 0.22 17 13.18 0.26 13 -7.63 0.55 18 -1.49 0.02 18 -1.47 0.03 18 -3.35 0.59 18 -0.47 0.66 18 31.89 0.36 18 35.68 0.46 18 -7.12 0.12 14 4.21 -0.02 0.19 -0.02 2.58 5.43 -3.35 -0.47 -0.1 -0.73 3.2 3.29 -0.04 0.22 -0.06 -7.63 7.12 -1.49 -1.47 31.89 35.68 13.33 -8.65 -0.48 -0.28 -3.62 -0.09 0.86 -0.055 11.025 3.28 3.29 0.06 31.38 34.73 -0.1 0.08 -0.95 -0.36 -0.02 6.54 -9.51 0.19 -2.17 3.175 0.42 1.28 0.07 2.37 3.23 3.47 0.04 29.64 38.8 0.03 -0.62 -0.86 0.04 0.075 7",
  "TATGA 5.84 0.38 125 12.86 0.41 116 -7 0.54 128 -1.45 0.04 126 -1.33 0.08 128 -3.24 1.43 126 4.95 1.27 128 31.46 0.4 126 35.1 0.36 128 -6.76 0.25 102 4.13 -0.02 0.61 -0.57 2.25 5.85 -3.24 4.95 -0.09 -0.78 3.19 3.37 -0.04 0.32 -0.06 -7 7.04 -1.45 -1.33 31.46 35.1 12.97 -6.875 1.96 -0.85 3.115 2.32 6.07 0.07 1.255 3.25 3.41 0.085 29.13 36.88 0.14 0.03 -0.83 -0.15 -0.105 6.28 -11.015 0.41 1.32 -0.56 0.23 11 -0.005 3.41 3.22 3.26 0.035 29.21 29.96 -0.01 0.33 -0.78 -0.21 0.05 6.73",
  "TATGC 5.76 0.17 16 12.74 0.45 13 -8.11 0.44 17 -1.46 0.03 17 -1.39 0.06 16 -2.97 0.66 17 5.2 1.08 16 31.62 0.32 17 34.78 0.37 16 -6.64 0.17 13 4.08 -0.02 0.56 -1.34 2.44 5.76 -2.97 5.21 -0.09 -0.68 3.2 3.37 -0.04 0.35 -0.12 -8.11 7.37 -1.46 -1.39 31.62 34.79 12.82 -5.625 1.96 -1.53 -7.21 2.32 1.9 -0.06 15.685 3.25 3.45 -0.125 29.13 36.82 0.14 -0.32 -0.83 0.04 -0.055 6.4 -11.71 0.41 -0.31 -0.54 0.23 10.06 0.01 3.545 3.22 3.3 0.03 29.21 32.58 -0.01 0.1 -0.78 -0.39 0.055 6.83",
  "TATGG 5.88 0.21 17 12.86 0.39 16 -6.69 0.39 17 -1.44 0.02 17 -1.4 0.06 17 -2.84 0.76 17 3.24 1.11 17 31.26 0.24 17 34.97 0.33 17 -6.63 0.16 13 4.09 -0.02 0.75 -1.29 2.86 5.83 -2.84 3.24 -0.09 -0.6 3.17 3.32 -0.03 0.4 -0.07 -6.69 7.31 -1.44 -1.4 31.26 34.97 13.11 -8.61 1.96 0.59 0.77 2.32 2.89 -0.005 2.56 3.25 3.43 0.03 29.13 38.36 0.14 0.14 -0.83 0.02 -0.11 6.35 -10.41 0.41 0.08 -1.175 0.23 9.76 0 3.3 3.22 3.16 0.03 29.21 31.42 -0.01 0.25 -0.78 -0.18 0.06 7",
  "TATTC 4.51 0.42 13 13.55 0.32 11 -10.01 0.55 13 -1.54 0.05 13 -1.19 0.05 13 -4.85 1.59 13 -3.1 1.11 13 32.92 0.51 13 35.93 0.46 13 -8.08 0.3 11 4.47 -0.02 -0.22 2.21 -2.95 4.66 -4.85 -3.1 -0.14 -1.21 3.28 3.17 -0.13 0.16 -0.03 -10.01 6.33 -1.54 -1.19 32.92 35.93 13.65 -1.73 0.34 -1.59 -1.585 -1.57 -1.17 0.1 7 3.21 3.26 0.075 32.19 35.73 0.01 0.02 -0.96 -0.66 -0.135 4.255 -15.845 0.48 -2.71 1.795 -1.72 1.21 0.13 2.635 3.25 3.34 0.025 31.21 34.45 0.25 -0.13 -0.84 -0.61 0.075 5.35",
  "TATTG 5.02 0.29 51 13.04 0.37 48 -9.7 0.48 51 -1.54 0.04 51 -1.18 0.03 51 -3.9 1.03 51 -2.87 1 51 32.4 0.58 51 35.12 0.39 51 -7.75 0.23 40 4.37 -0.03 -0.15 2.59 -3.03 5.13 -3.9 -2.87 -0.14 -1.5 3.25 3.13 -0.16 0.14 -0.01 -9.7 6.72 -1.54 -1.18 32.4 35.12 13.18 -6.07 0.34 -1.33 -1.445 -1.57 1.93 0.115 -0.125 3.21 3.25 0.03 32.19 34.75 0.01 -0.06 -0.96 -0.57 -0.095 5.04 -12.21 0.48 -3.82 3.92 -1.72 -0.48 0.1 3.16 3.25 3.36 0.02 31.21 38.22 0.25 -0.74 -0.84 -0.02 0.055 6.07",
  "TCAAC 5.65 0.25 13 12.92 0.35 13 -10.22 0.47 19 -1.1 0.11 19 -1.12 0.05 19 5.39 0.51 19 -3.34 0.7 19 34.69 0.23 19 34.93 0.29 19 -7.09 0.23 17 4.27 -0.03 1.78 -2.06 2.31 5.65 5.39 -3.34 0.1 -1.54 3.35 3.08 -0.43 -0.04 -0.18 -10.22 5.78 -1.1 -1.12 34.69 34.93 13.23 -10.905 0.6 0.28 -1.455 5.68 2.59 -0.045 4.625 3.98 3.15 0.08 35.18 33.65 -0.04 0.16 0.4 -0.56 -0.13 6.725 -8.23 -0.64 -3.66 1.05 12.51 -1.25 0.005 3.565 3.05 3.3 0.02 22.3 37.43 0.08 -0.68 -0.12 0.02 -0.105 7.31",
  "TCAAG 5.4 0.17 15 13.1 0.24 15 -9.98 0.72 15 -1.26 0.14 15 -1.23 0.03 15 5.51 1.77 15 -3.44 0.55 15 34.53 0.76 15 34.76 0.31 15 -7.32 0.14 12 4.23 -0.03 1.67 -2.16 0.06 5.59 5.51 -3.44 0.1 -1.46 3.42 3.12 -0.46 0.01 -0.24 -9.98 6.68 -1.26 -1.23 34.53 34.76 13.12 -7.245 0.6 0.99 -1.34 5.68 -0.32 -0.13 6.645 3.98 3.14 0.005 35.18 34.05 -0.04 0.04 0.4 -0.57 -0.12 6.345 -8.68 -0.64 -3.77 2.605 12.51 -0.87 -0.005 3.745 3.05 3.32 0.025 22.3 37.64 0.08 -0.6 -0.12 0.07 -0.085 7.3",
  "TCACC 5.4 0.2 14 13.63 0.45 13 -7.04 0.56 31 -1.34 0.06 31 -1.54 0.04 17 3.82 1.1 31 -3.21 0.83 17 34.15 0.34 31 34.04 0.21 17 -6.98 0.2 24 4.03 -0.03 0.74 -0.85 2.6 5.44 3.82 -3.11 0.11 -0.59 3.31 3.35 -0.25 0.27 -0.02 -7.04 4.08 -1.34 -1.56 34.15 34.12 14.2 1.47 -1.2 -0.05 -7.06 4.14 1.73 -0.195 12.72 3.28 3.35 0.015 34.75 32.09 -0.12 0.05 0.34 -1.18 -0.14 6.945 -8.935 1 1.04 -8.79 10.63 -1.99 -0.055 1.625 2.95 3.29 0.03 23.47 33.57 0.19 0.12 -0.09 -0.51 0.005 6.345",
  "TCACG 5.71 0.12 25 12.58 0.24 24 -8.08 0.29 27 -1.17 0.06 27 -1.45 0.03 26 4.27 0.43 27 -2.49 0.45 26 34.66 0.33 27 33.8 0.22 26 -6.73 0.11 22 4.11 -0.03 0.72 -0.45 4.05 5.81 4.27 -2.49 0.11 -0.98 3.25 3.31 -0.29 0.29 0.03 -8.08 7.01 -1.17 -1.45 34.66 33.8 12.8 -9.595 -1.2 0.93 1.8 4.14 0.23 0.01 1.935 3.28 3.35 0.02 34.75 29.11 -0.12 0.14 0.34 -0.89 0.015 6.63 -8.035 1 0.64 -6.205 10.63 -0.54 -0.035 1.795 2.95 3.31 0.035 23.47 31.32 0.19 -0.01 -0.09 -0.45 0.09 6.85",
  "TCAGA 5.47 0.18 10 13.54 0.35 10 -6.32 0.64 23 -1.41 0.06 22 -1.68 0.04 23 4.43 1.41 22 -1.76 0.84 23 34.38 0.43 22 31.28 0.23 23 -6.97 0.21 19 4.06 -0.03 0.41 -2.19 0.55 5.57 4.51 -1.76 0.1 -0.72 3.38 3.31 -0.27 0.22 -0.05 -6.32 6.95 -1.41 -1.68 34.39 31.28 13.49 -5.075 1.23 0.5 1.15 4.71 3.48 0.015 5.765 3.45 3.35 -0.005 36.83 32.26 0.16 -0.15 -0.32 -0.56 -0.07 6.76 -9.905 1.17 -1.77 -1.715 11.07 5.04 0.01 4.26 2.91 3.28 0.025 22.06 29.92 0.04 -0.25 0 -0.32 0.115 7.375",
  "TCAGC 5.74 0.18 20 13.43 0.21 19 -6.36 0.45 20 -1.38 0.06 20 -1.67 0.04 20 4.93 0.9 20 -2 0.68 20 34.29 0.44 20 31.14 0.28 20 -6.7 0.11 16 4.03 -0.04 0.77 -2.37 0.03 5.69 4.93 -2 0.09 -0.89 3.35 3.24 -0.26 0.23 -0.06 -6.36 7.24 -1.38 -1.67 34.29 31.14 13.45 -1.305 1.23 -0.88 1.585 4.71 2.66 -0.02 9.195 3.45 3.35 0.005 36.83 31.67 0.16 -0.23 -0.32 -0.63 0 7.275 -7.835 1.17 -3.59 0.285 11.07 0.33 0.005 3.975 2.91 3.35 0.03 22.06 35.72 0.04 -0.61 0 -0.23 0.155 7.57",
  "TCAGG 5.47 0.1 9 13.86 0.2 8 -5.31 0.65 9 -1.46 0.06 9 -1.76 0.03 9 3.63 0.84 9 -3.12 0.6 9 34.07 0.33 9 30.94 0.47 9 -6.99 0.17 7 4.05 -0.03 0.68 -2.08 0.15 5.45 3.63 -3.12 0.1 -0.68 3.34 3.26 -0.23 0.28 -0.03 -5.31 7.01 -1.46 -1.76 34.07 30.94 13.83 -3.29 1.23 0.47 2.565 4.71 3.41 0.02 6.175 3.45 3.26 0.025 36.83 32.49 0.16 0.32 -0.32 -0.58 -0.065 7.02 -7.615 1.17 -3.47 0.715 11.07 0.92 0 4.23 2.91 3.32 0.03 22.06 35.12 0.04 -0.57 0 -0.28 0.16 7.65",
  "TCATC 5.08 0.32 431 13.63 0.38 389 -7.37 0.74 491 -1.52 0.08 491 -1.49 0.04 491 4.02 2.02 491 -4.68 0.96 491 34.64 0.64 491 32.03 0.36 491 -7.57 0.22 384 4.23 -0.02 1.08 -0.23 -3.91 5.1 4.02 -4.68 0.09 -0.35 3.47 3.22 -0.32 -0.02 -0.15 -7.37 6.44 -1.52 -1.49 34.64 32.03 13.77 -7.07 -0.85 0.06 0.84 6.07 1.15 0.02 0.875 3.41 3.23 0.08 36.88 27.88 0.03 -0.12 -0.15 -1.11 -0.04 6.46 -11.555 1.32 0.38 -1.5 11 -0.45 0.01 2.955 3.26 3.21 0.04 29.96 29.55 0.33 0 -0.21 -0.75 0.03 6.36",
  "TCATG 5.27 0.23 13 12.9 0.42 12 -9.26 0.57 83 -1.43 0.05 83 -1.46 0.03 13 5.91 0.64 83 -4.44 0.66 13 35 0.31 83 31.75 0.32 13 -6.82 0.1 67 4.18 0 1.39 -0.04 -4.34 5.37 5.91 -3.74 0.09 -0.39 3.48 3.24 -0.31 -0.1 -0.21 -9.26 3.07 -1.43 -1.45 35 31.92 14.29 -6.945 -0.85 -0.43 1.455 6.07 0.79 0.02 1.21 3.41 3.19 0.01 36.88 26.17 0.03 0.02 -0.15 -0.87 -0.105 6.315 -11.12 1.32 0.01 -0.11 11 0.36 -0.015 3.335 3.26 3.25 0.035 29.96 29.75 0.33 -0.03 -0.21 -0.76 0.025 6.89",
  "TCCAC 5.58 0.12 16 13.44 0.26 14 -3.48 0.38 66 -1.73 0.04 66 -1.31 0.05 45 -0.49 0.39 66 2.75 0.5 45 33.75 0.32 66 34.34 0.52 45 -5.25 0.19 54 4.08 -0.04 -1.22 1.66 -1.24 5.64 -0.49 2.98 0.26 0.16 3.4 3.25 -0.09 -0.31 0.14 -3.48 3.62 -1.73 -1.36 33.75 34.24 14.37 -5.465 6.86 -1.4 1.98 5.93 5.18 -0.085 4.925 2.48 3.36 -0.015 27.51 35.26 0.13 -0.01 -0.58 -0.18 -0.075 7.225 -5.46 0.56 -0.29 -0.27 5.9 9.42 -0.055 1.635 3.52 2.93 0.03 31.9 25.46 -0.23 0.26 -0.69 -0.17 0.065 7.465",
  "TCCAG 5.31 0.15 62 13.89 0.35 24 -2.98 0.51 182 -1.79 0.05 182 -1.5 0.05 104 -0.76 0.63 182 2.8 0.97 104 33.74 0.48 182 33.98 0.51 104 -5.28 0.19 143 4.14 -0.04 -1.21 1.98 -1.12 5.24 -0.76 3.37 0.27 0.24 3.42 3.36 -0.06 -0.32 0.1 -2.98 4.36 -1.79 -1.53 33.74 34.03 14.65 -4.58 6.86 -0.96 1.86 5.93 3.87 -0.07 5.11 2.48 3.4 -0.02 27.51 34.03 0.13 -0.23 -0.58 -0.37 -0.095 6.865 -7.125 0.56 -0.45 -1.11 5.9 9.82 -0.025 2.345 3.52 2.85 0.03 31.9 23.51 -0.23 0.11 -0.69 -0.08 0.12 7.455",
  "TCCCC 4.76 0.11 8 14.87 0.19 6 -1.44 0.28 65 -1.85 0.04 65 -1.86 0.03 8 -1.23 0.31 65 -2.33 0.21 8 33.65 0.24 65 33.55 0.18 8 -5.29 0.22 43 4.13 -0.04 -1.08 -0.02 -0.66 4.75 -1.23 -2.13 0.31 0.39 3.45 3.4 -0.02 -0.06 0.01 -1.44 2.78 -1.85 -1.9 33.65 33.51 15.55 -16.275 -0.21 -1.81 12.445 6.31 6.69 -0.135 11.43 3.44 3.39 0.065 31.55 33.69 -0.12 -0.39 -0.75 -0.6 -0.145 7.09 -5.82 1.03 0.17 -0.45 6.53 5.94 -0.005 0.64 3.44 3.37 0.01 30.36 30.11 0.02 0.05 -0.92 -1.15 -0.18 7.185",
  "TCCCG 4.95 0.1 8 13.92 0.21 7 -2.56 0.22 8 -1.75 0.03 8 -1.73 0.03 8 -0.91 0.51 8 -1.93 0.49 8 34.12 0.24 8 33.56 0.31 8 -5.44 0.23 7 4.16 -0.04 -0.94 0.07 -1.9 5.12 -0.91 -1.93 0.28 0.18 3.42 3.33 -0.05 -0.13 0.09 -2.56 6.79 -1.75 -1.73 34.12 33.56 13.84 -3.525 -0.21 0.39 1.65 6.31 4.59 0.18 0.385 3.44 3.53 0.055 31.55 34.7 -0.12 -0.16 -0.75 -0.55 -0.08 7.52 -5.19 1.03 -1.24 6.26 6.53 3.17 0.015 1.175 3.44 3.48 0.035 30.36 35.21 0.02 -0.43 -0.92 -0.32 0.04 7.455",
  "TCCGC 5.27 0.29 29 13.47 0.16 8 -3.15 0.59 42 -1.74 0.07 42 -1.6 0.05 42 -0.89 2.18 42 2.4 0.7 42 33.51 0.96 42 32.42 0.41 42 -5.2 0.14 81 4.1 -0.04 -0.72 0.68 -1.29 5.35 -0.89 2.4 0.25 0.27 3.41 3.3 -0.09 -0.01 0.08 -3.15 5.96 -1.74 -1.6 33.51 32.42 13.95 -10.2 -1.79 -0.18 1.17 2.54 0.81 -0.04 4.02 0.77 3.37 0.085 30.08 36.72 -0.19 0.14 -0.75 0.09 -0.035 7.5 -4.23 0.43 0.43 -1.015 5.73 8.69 -0.035 1.215 3.48 2.81 0.04 31.82 23.6 -0.24 0.05 -0.41 -0.12 0.175 7.62",
  "TCCGG 5.39 0.06 3 13.67 0.09 2 -3.19 0.54 6 -1.7 0.03 6 -1.62 0.05 6 -0.62 0.86 6 1.31 1.16 6 33.6 0.29 6 32.84 0.39 6 -4.9 0.12 4 4.16 -0.04 -0.67 0.37 -0.16 5.24 -0.62 1.31 0.25 0.26 3.4 3.34 -0.03 0 0.06 -3.19 6.7 -1.7 -1.62 33.6 32.84 13.8 -7.465 -1.79 2.64 -0.845 2.54 2.17 -0.045 3.85 0.77 3.29 0.015 30.08 35.19 -0.19 0.29 -0.75 0.05 -0.02 7.655 -5.24 0.43 -0.05 -1.84 5.73 8.79 -0.025 1.43 3.48 2.78 0.04 31.82 23.08 -0.24 -0.02 -0.41 -0.06 0.2 7.685",
  "TCCTC 4.8 0.14 11 14.49 0.17 11 -0.44 0.33 23 -1.88 0.04 23 -1.78 0.03 20 -1.37 0.7 23 -2.86 0.6 20 34.17 0.41 23 31.53 0.21 20 -5.52 0.23 19 4.23 -0.02 -1.85 2.46 -4.34 4.92 -1.37 -2.72 0.27 0.28 3.5 3.29 -0.05 -0.24 0.16 -0.44 5.98 -1.88 -1.79 34.17 31.56 14.69 4.01 0.38 -1.38 -3.79 4.06 2.37 -0.13 5.33 3.51 3.3 0.19 33.87 33.79 0.02 0.01 -0.87 -0.71 -0.03 6.455 -9.445 2.03 -1.82 4.38 6.08 3.61 0.06 1.795 3.49 3.26 0.02 31.5 30.16 0.11 -0.12 -0.85 -0.81 0.095 6.87",
  "TCCTG 4.92 0.22 10 14.13 0.47 8 -0.9 0.54 15 -1.89 0.05 15 -1.76 0.05 13 -1.05 0.77 15 -2.79 0.94 13 34.22 0.43 15 31.21 0.24 13 -5.52 0.2 11 4.17 -0.02 -1.77 2.61 -4.22 5.05 -1.05 -2.61 0.26 0.24 3.5 3.29 -0.05 -0.27 0.16 -0.9 6.45 -1.89 -1.77 34.22 31.24 14.24 -1.33 0.38 0.47 1.875 4.06 3.41 0.005 0.77 3.51 3.26 0.12 33.87 32.49 0.02 0.32 -0.87 -0.58 -0.095 6.445 -7.585 2.03 -3.47 7.735 6.08 0.92 0.02 2.31 3.49 3.32 0.02 31.5 35.12 0.11 -0.57 -0.85 -0.28 0.145 7.2",
  "TCGAC 5.64 0.19 11 13.14 0.2 8 -6.68 0.36 20 -1.51 0.09 20 -1.34 0.04 17 5.38 0.72 20 -1.63 0.78 17 33.06 0.45 20 35.51 0.36 17 -5.03 0.11 16 4.16 -0.04 -0.01 0.04 -1.89 5.57 5.38 -1.51 -0.27 0.34 3.43 3.2 -0.06 -0.2 -0.04 -6.68 5.57 -1.51 -1.36 33.06 35.44 13.91 -5.38 -15.36 -1.77 2.575 7.72 0.35 0.04 -1.105 -16.86 3.38 0.135 9.75 32.95 -0.16 -0.4 1.56 -0.48 -0.1 7.315 -5.525 0.06 -2.22 1.585 11.51 0.43 -0.01 1.625 3 3.39 0.05 22.93 38.87 0 -0.69 -0.06 0.19 0.055 7.61",
  "TCGAG 5.42 0.12 8 13.34 0.11 8 -6.72 0.58 55 -1.6 0.07 55 -1.48 0.08 20 5.47 0.59 55 -1.2 0.81 20 33.01 0.31 55 35.17 0.73 20 -4.91 0.23 41 4.06 -0.03 0.16 0.53 -3.64 5.46 5.47 -0.31 -0.26 0.48 3.49 3.3 0.02 -0.2 -0.09 -6.72 2.32 -1.6 -1.54 33.01 34.94 14.77 -9.99 -15.36 1.54 -0.5 7.72 0.27 -0.08 1.175 -16.86 3.19 0.1 9.75 34.26 -0.16 0.08 1.56 -0.3 -0.1 7.18 -6.585 0.06 -2.1 0.635 11.51 1.53 -0.01 1.575 3 3.38 0.05 22.93 35.75 0 -0.34 -0.06 -0.12 0.035 7.58",
  "TCGCC 5.4 0.08 27 13.42 0.19 9 -2.99 0.29 57 -1.56 0.05 57 -1.56 0.03 27 3.27 0.5 57 -1.65 0.29 27 32.6 0.32 57 36.2 0.25 27 -5.06 0.26 43 4.11 -0.03 -0.38 0.05 -0.17 5.45 3.27 -1.66 -0.25 0.42 3.35 3.39 0.09 0.05 0.05 -2.99 4.43 -1.56 -1.6 32.6 36.16 14.29 0.995 -1.84 0.05 4.4 5.54 -1.11 0.06 1.105 3.48 3.24 0.085 36.68 27.86 -0.45 0.2 0.32 -0.51 -0.12 7.245 -9.57 1.44 -0.2 -6.68 10.88 -0.95 -0.02 0.515 3.03 3.39 0.02 26.86 35.49 0.1 0.26 -0.07 -0.36 0.1 6.525",
  "TCGCG 5.42 0.13 9 12.81 0.26 9 -4.27 0.27 254 -1.55 0.05 254 -1.53 0.03 9 4.5 0.46 254 -1.33 0.56 9 32.65 0.41 254 35.66 0.33 9 -4.75 0.11 231 4.11 -0.03 -0.21 -0.24 -1.22 5.51 4.5 -1.2 -0.25 0.4 3.38 3.39 0.09 -0.02 0.03 -4.27 2.65 -1.55 -1.56 32.65 36.04 14.84 -3.03 -1.84 -0.71 3.82 5.54 3.29 0.06 -3.43 3.48 3.34 0.085 36.68 17.88 -0.45 -0.23 0.32 -1.43 -0.02 6.975 -7.39 1.44 -0.04 -1.325 10.88 -3.07 0.01 0.55 3.03 3.49 0.025 26.86 36.07 0.1 0 -0.07 -0.15 0.195 7.095",
  "TCGGA 5.36 0.1 6 13.69 0.22 6 -3.04 0.65 7 -1.53 0.06 7 -1.72 0.06 6 3.14 0.85 7 -0.81 0.58 6 32.77 0.25 7 33.64 0.29 6 -5.1 0.06 6 4.17 -0.04 -0.85 0.74 0.69 5.28 3.14 -0.69 -0.25 0.23 3.33 3.4 0.1 0.07 0.08 -3.04 5.83 -1.53 -1.73 32.77 33.69 14.05 -7.035 1.74 -1.79 -7.235 3.99 2.54 -0.17 9.335 3.3 0.77 0.03 36.31 30.08 0.05 -0.19 -0.06 -0.75 0.015 7.44 -5.945 -1.58 0.43 -1.295 10.1 5.73 -0.015 1.43 2.86 3.48 0.04 22.38 31.82 -0.06 -0.24 -0.05 -0.41 0.115 7.61",
  "TCGGC 5.43 0.17 9 13.55 0.14 9 -3.4 0.29 10 -1.61 0.07 10 -1.77 0.06 9 3.91 0.76 10 -0.99 0.6 9 32.47 0.35 10 32.95 0.55 9 -5.23 0.31 8 4.05 -0.04 -0.78 0.33 -0.37 5.37 3.91 -0.95 -0.25 0.28 3.38 3.33 0.06 0.12 0.04 -3.4 6.97 -1.61 -1.77 32.47 32.98 13.72 -0.795 1.74 1.28 -6.335 3.99 6.56 -0.07 9.66 3.3 3.5 0.105 36.31 33.36 0.05 0.08 -0.06 -1 0.02 7.355 -4.295 -1.58 -1.21 0.65 10.1 2.64 0.005 1.595 2.86 3.5 0.05 22.38 36 -0.06 -0.57 -0.05 -0.25 0.155 7.865",
  "TCGGG 5.22 0.11 9 13.61 0.18 8 -2.92 0.34 9 -1.55 0.05 9 -1.76 0.02 9 3.35 0.45 9 -1.75 0.55 9 32.86 0.24 9 33.58 0.22 9 -5.22 0.09 8 4.14 -0.04 -1 0.31 0.73 5.14 3.35 -1.75 -0.26 0.26 3.37 3.36 0.11 0.1 0.07 -2.92 6.79 -1.55 -1.76 32.86 33.58 13.85 -1.56 1.74 0.39 -6.95 3.99 4.59 0.04 5.52 3.3 3.53 0.045 36.31 34.7 0.05 -0.16 -0.06 -0.55 0.01 7.41 -3.695 -1.58 -1.24 0.765 10.1 3.17 0.005 1.58 2.86 3.48 0.055 22.38 35.21 -0.06 -0.43 -0.05 -0.32 0.125 7.92",
  "TCGTC 5.16 0.19 20 13.38 0.47 17 -7.11 0.36 21 -1.59 0.06 21 -1.49 0.04 21 4.81 0.82 21 -2.39 0.73 21 33.65 0.34 21 34.18 0.24 21 -5.3 0.21 17 4.3 -0.03 0.13 0.34 -5.46 5.21 4.81 -2.39 -0.26 0.58 3.48 3.33 0.07 -0.26 -0.02 -7.11 6.55 -1.59 -1.49 33.65 34.18 13.42 -2.205 -1.25 0.8 0.81 5.07 1.69 0.015 4.155 3.37 3.3 0.085 36.26 29.13 0 -0.14 0.13 -1.07 -0.03 6.88 -7.65 1.62 0.36 -0.505 10.27 0.13 -0.005 1.575 3.11 3.33 0.05 27.85 30.66 0.06 -0.34 -0.09 -0.6 0.165 7.05",
  "TCGTG 5.29 0.09 4 12.46 0.16 4 -7.95 0.4 4 -1.52 0.03 4 -1.44 0.01 4 5.8 0.34 4 -2.18 0.54 4 33.99 0.3 4 33.77 0.18 4 -5.22 0.14 3 4.23 -0.03 0.2 0.57 -5.92 5.47 5.8 -2.18 -0.26 0.48 3.48 3.32 0.09 -0.29 -0.03 -7.95 7.09 -1.52 -1.44 33.99 33.77 12.42 -7.89 -1.25 0.93 2.44 5.07 0.23 0.03 1.26 3.37 3.35 0.07 36.26 29.11 0 0.14 0.13 -0.89 0.05 6.38 -9.49 1.62 0.64 -3.455 10.27 -0.54 -0.01 1.53 3.11 3.31 0.045 27.85 31.32 0.06 -0.01 -0.09 -0.45 0.13 6.705",
  "TCTAC 5.76 0.56 9 13.31 0.24 6 -6.38 1.53 11 -1.66 0.05 11 -1.33 0.07 11 -2.44 3.66 11 4.12 2.01 11 30.99 1.44 11 34.42 0.44 11 -6.72 0.13 9 4.02 -0.03 1.59 -0.01 -0.25 5.79 -2.44 4.12 -0.12 -1.22 3.27 3.21 -0.29 -0.05 0.05 -6.38 6.33 -1.66 -1.33 30.99 34.42 13.73 -6.465 -0.2 -1.11 0.73 4.8 1.1 -0.015 1.895 3.39 3.38 0.06 32.53 36.22 -0.04 0.04 -0.48 -0.28 -0.13 6.68 -10.01 -1.49 -0.14 -0.945 5.14 8.66 -0.035 3.545 3.37 2.99 0.03 31.06 27.73 -0.36 0.26 -0.69 -0.13 0.085 7.305",
  "TCTAG 5.84 0.16 7 13.73 0.49 7 -6.98 0.29 7 -1.69 0.06 7 -1.44 0.04 7 -1.22 0.64 7 5.27 0.85 7 31.57 0.25 7 34.35 0.41 7 -6.63 0.27 5 3.96 -0.03 1.77 0.02 -0.19 5.86 -1.22 5.27 -0.1 -0.86 3.28 3.29 -0.18 0 0 -6.98 7.25 -1.69 -1.44 31.57 34.35 13.73 -9.37 -0.2 0.25 -0.555 4.8 0.7 -0.04 1.91 3.39 3.4 0.03 32.53 36.29 -0.04 0.09 -0.48 0.16 -0.1 6.62 -11.57 -1.49 0.06 -1.805 5.14 9.68 -0.01 4.505 3.37 2.96 0.03 31.06 25.48 -0.36 -0.01 -0.69 -0.11 0.135 7.305",
  "TCTCC 4.92 0.19 16 14.5 0.29 12 -6.1 0.24 106 -1.76 0.04 106 -1.51 0.06 16 -2.23 0.57 106 -2.03 0.71 16 31.48 0.31 106 35.79 0.5 16 -7.26 0.11 86 4.14 -0.02 2.03 -0.39 -1.08 4.9 -2.23 -1.61 -0.08 -0.04 3.33 3.3 -0.17 0.16 -0.07 -6.1 2.62 -1.76 -1.54 31.48 35.82 15.25 0.555 -1.04 0.62 -4.075 4.02 3.94 -0.095 9.605 3.24 3.27 0.155 31.39 35.11 -0.12 0.28 -0.62 -0.35 -0.115 6.78 -10.87 -1.15 -1.85 0.69 5.12 3.18 0.06 2.185 3.36 3.21 0.025 30.19 33.48 -0.17 -0.18 -0.74 -0.37 -0.075 6.95",
  "TCTCG 5.17 0.21 20 13.74 0.27 14 -6.8 0.58 24 -1.72 0.05 24 -1.47 0.04 21 -1.9 1.34 24 -1.21 0.75 21 31.51 0.83 24 35.18 0.42 21 -7.13 0.13 19 4.18 -0.02 2.04 -0.16 -1.53 5.12 -1.9 -1.15 -0.1 -0.68 3.32 3.24 -0.23 0.14 -0.03 -6.79 5.91 -1.72 -1.47 31.51 35.24 14.1 -8.12 -1.04 1.54 0.93 4.02 0.27 -0.05 2.71 3.24 3.19 0.055 31.39 34.26 -0.12 0.08 -0.62 -0.3 -0.1 6.735 -10.55 -1.15 -2.1 6.26 5.12 1.53 0.06 2.405 3.36 3.38 0.035 30.19 35.75 -0.17 -0.34 -0.74 -0.12 0.055 7.4",
  "TCTGC 5.75 0.11 6 13.27 0.23 6 -6.69 0.46 13 -1.67 0.04 13 -1.43 0.04 9 -1.2 0.69 13 4.1 0.86 9 31.17 0.26 13 33.98 0.28 9 -6.55 0.15 9 3.96 -0.03 2.43 -0.83 -1.03 5.64 -1.2 4.21 -0.09 -0.65 3.3 3.33 -0.21 0.32 -0.07 -6.69 4.76 -1.67 -1.43 31.17 34.04 14.1 -4.825 0.5 1.82 0.83 3.48 3.42 -0.015 4.08 3.35 3.42 0.04 32.26 36.9 -0.15 0.1 -0.56 0.08 -0.105 6.46 -8.99 -1.77 -0.29 -2.43 5.04 9.67 0.01 3.94 3.28 2.88 0.025 29.92 23.83 -0.25 0.03 -0.32 -0.16 0.105 7.595",
  "TCTGG 5.56 0.21 27 13.78 0.32 8 -6.09 0.93 66 -1.73 0.05 27 -1.5 0.06 66 -2.71 0.63 27 2.85 1.14 66 31.02 0.23 27 33.91 0.61 66 -6.68 0.26 52 3.94 -0.02 2.2 -1.48 0.79 5.58 -1.57 2.85 -0.11 -0.54 3.31 3.31 -0.27 0.31 -0.09 -6.09 4.51 -1.72 -1.5 30.98 33.91 14.62 -5.635 0.5 -0.96 -0.67 3.48 3.87 -0.03 1.85 3.35 3.4 0.02 32.26 34.03 -0.15 -0.23 -0.56 -0.37 -0.09 6.625 -9.21 -1.77 -0.45 -2 5.04 9.82 0.005 3.685 3.28 2.85 0.025 29.92 23.51 -0.25 0.11 -0.32 -0.08 0.1 7.515",
  "TCTTC 4.52 0.31 7 14 0.26 4 -8.18 0.52 19 -1.78 0.05 19 -1.26 0.04 18 -2.28 1.35 19 -3.52 1.1 18 32.42 0.38 19 35.03 0.54 18 -7.96 0.29 15 4.38 -0.02 2.04 2.1 -6.57 4.77 -2.28 -3.49 -0.13 -0.96 3.43 3.12 -0.26 0.03 0.05 -8.18 6.08 -1.78 -1.26 32.42 35.05 14.12 1.615 -0.18 -1.21 2.695 1.41 2.49 -0.015 8.43 3.55 3.26 0.03 33.81 34.94 0.02 -0.08 -1.23 -0.71 -0.065 6.21 -14.045 -1.04 -2.45 4.91 4.57 1.66 0.115 3.355 3.39 3.19 0.02 31.3 32.17 -0.09 -0.09 -0.75 -0.48 0.04 6.205",
  "TCTTG 4.92 0.14 15 13.39 0.31 14 -9.12 0.48 15 -1.74 0.04 15 -1.21 0.03 15 -1.59 0.62 15 -3.37 0.58 15 32.47 0.32 15 34.77 0.22 15 -7.69 0.12 11 4.3 -0.03 2.09 2.35 -6.38 5.08 -1.59 -3.37 -0.14 -1.34 3.41 3.1 -0.28 0.02 0.04 -9.12 6.46 -1.74 -1.21 32.47 34.77 13.37 3.55 -0.18 0.99 5.365 1.41 -0.32 -0.135 11.62 3.55 3.14 -0.03 33.81 34.05 0.02 0.04 -1.23 -0.57 -0.03 5.92 -11.705 -1.04 -3.77 9.71 4.57 -0.87 0.085 3.645 3.39 3.32 0.02 31.3 37.64 -0.09 -0.6 -0.75 0.07 0.05 6.675",
  "TGAAC 5.35 0.27 17 13.3 0.22 15 -10.38 0.34 18 -1.41 0.07 18 -1.11 0.04 18 0.09 0.56 18 -2.98 0.75 18 35.12 0.53 18 35.57 0.26 18 -7.41 0.21 14 4.34 -0.03 1.7 -1.83 1.8 5.19 0.09 -2.98 0.1 -1.18 3.31 3.08 -0.33 -0.1 -0.18 -10.38 6.51 -1.41 -1.11 35.12 35.57 13.41 -4.04 -2.15 -0.08 5.645 3.57 -0.22 0.085 -3.5 1.72 3.24 0.01 35.09 34.75 -0.98 0.02 -1.41 -0.62 -0.11 5.805 -12.89 -0.97 -2.66 5.125 2.44 1.29 0.08 2.085 3.4 3.35 0.03 34.98 35.61 -0.42 -0.2 -0.2 -0.38 -0.04 6.145",
  "TGAAG 5.15 0.23 13 13.6 0.17 11 -10.24 0.76 13 -1.48 0.05 13 -1.26 0.04 13 0.22 0.89 13 -3.01 0.82 13 35.1 0.94 13 35.14 0.66 13 -7.47 0.14 10 4.29 -0.03 1.93 -2.15 0.32 5.01 0.22 -3.01 0.1 -1.14 3.36 3.14 -0.29 -0.03 -0.23 -10.24 6.44 -1.48 -1.26 35.1 35.14 13.86 -6.165 -2.15 -1.21 1.5 3.57 2.49 0.065 0.18 1.72 3.26 0.045 35.09 34.94 -0.98 -0.08 -1.41 -0.71 -0.095 6.595 -10.34 -0.97 -2.45 3.15 2.44 1.66 0.075 2.47 3.4 3.19 0.035 34.98 32.17 -0.42 -0.09 -0.2 -0.48 -0.075 6.625",
  "TGACA 5.43 0.27 64 13.23 0.27 57 -8.28 0.47 76 -1.38 0.06 66 -1.52 0.04 74 -1.53 1.13 66 -2.49 0.61 74 35.3 0.76 66 34.2 0.39 74 -7.12 0.21 60 4.19 -0.02 0.33 -0.63 4.09 5.42 -1.55 -2.49 0.11 -0.71 3.19 3.34 -0.23 0.3 0.05 -8.28 6.07 -1.37 -1.52 35.49 34.21 13.45 -9.33 1.57 0.11 1.82 1.92 0.71 -0.035 3.87 3.25 3.23 0.025 35.01 29.32 0.14 0.01 -0.09 -1.08 -0.115 6.675 -8.68 -2.37 -0.05 2.305 0.51 -0.33 0.025 1.575 3.39 3.36 0.04 38.79 31.44 -0.65 -0.36 0.16 -0.69 0.06 6.775",
  "TGACC 4.94 0.17 141 13.96 0.28 126 -7.96 0.47 144 -1.41 0.05 144 -1.57 0.04 141 -2.01 0.72 144 -3.46 0.74 141 35.47 0.41 144 34.83 0.25 141 -7.65 0.16 116 4.26 -0.02 0.61 -0.64 4.35 4.94 -2.01 -3.46 0.11 -0.39 3.22 3.39 -0.16 0.27 0.01 -7.96 6.41 -1.41 -1.57 35.47 34.82 14.09 -6.76 1.57 -1.38 -0.77 1.92 1.27 -0.02 1.125 3.25 3.25 0.055 35.01 30.21 0.14 -0.28 -0.09 -1.11 -0.12 6.82 -11.405 -2.37 0.68 3.515 0.51 -0.37 0.015 1.445 3.39 3.43 0.03 38.79 32.74 -0.65 -0.19 0.16 -0.74 0.065 6.21",
  "TGACG 5.39 0.18 45 13.08 0.36 41 -8.47 0.38 47 -1.38 0.04 45 -1.49 0.03 47 -1.16 0.59 45 -2.4 0.51 47 35.16 0.41 45 34.29 0.26 47 -7.05 0.14 36 4.18 -0.02 0.42 -0.3 4.3 5.34 -1.16 -2.4 0.11 -0.72 3.19 3.33 -0.23 0.27 0.03 -8.47 6.91 -1.38 -1.49 35.19 34.29 13.21 -4.4 1.57 0.8 -0.49 1.92 1.69 -0.02 5.095 3.25 3.3 0.06 35.01 29.13 0.14 -0.14 -0.09 -1.07 -0.085 7.045 -7.195 -2.37 0.36 4.06 0.51 0.13 0.03 1.57 3.39 3.33 0.045 38.79 30.66 -0.65 -0.34 0.16 -0.6 0.1 7.17",
  "TGAGA 5.29 0.28 6 14.07 0.39 4 -6.62 0.64 6 -1.49 0.05 6 -1.68 0.07 6 -1.29 0.99 6 -2.02 1.24 6 35.17 0.43 6 31.77 0.19 6 -7.09 0.15 4 4.21 -0.03 0.56 -1.93 1.73 5.22 -1.29 -2.02 0.1 -0.91 3.24 3.31 -0.17 0.22 -0.01 -6.62 6.63 -1.49 -1.68 35.17 31.77 14.03 -8.995 0.33 -1.04 0.21 -0.39 4.02 0.02 2.71 3.33 3.24 0.04 31.43 31.39 -0.29 -0.12 -0.56 -0.62 -0.11 5.875 -9.625 -2.58 -1.15 7.37 0.2 5.12 0.07 2.665 3.39 3.36 0.04 37.67 30.19 -0.54 -0.17 0.06 -0.74 0.045 7.205",
  "TGAGC 5.4 0.27 31 13.97 0.29 30 -6.75 0.4 33 -1.54 0.05 33 -1.73 0.04 33 -0.9 0.91 33 -2.11 0.76 33 34.81 0.52 33 31.45 0.26 33 -7.07 0.2 27 4.11 -0.03 0.68 -2.09 0.72 5.37 -0.9 -2.11 0.1 -0.72 3.26 3.27 -0.18 0.23 -0.04 -6.75 6.86 -1.54 -1.73 34.81 31.45 14.07 -9.535 0.33 0.48 -0.74 -0.39 4.13 0.005 0.955 3.33 3.36 0.035 31.43 31.86 -0.29 -0.15 -0.56 -0.68 -0.035 6.2 -12.005 -2.58 -2.57 8.52 0.2 4.35 0.08 2.43 3.39 3.45 0.04 37.67 33.22 -0.54 -0.25 0.06 -0.73 0.095 6.905",
  "TGAGG 5.3 0.1 9 13.95 0.16 8 -6.36 0.37 9 -1.54 0.03 9 -1.79 0.03 9 -0.98 0.4 9 -2.49 0.5 9 34.61 0.19 9 31.54 0.28 9 -6.99 0.07 7 4.09 -0.02 0.59 -2.26 2.32 5.28 -0.98 -2.49 0.09 -0.42 3.24 3.3 -0.15 0.26 -0.02 -6.36 7.06 -1.54 -1.79 34.61 31.54 14.04 -2.885 0.33 -1.38 -5.695 -0.39 2.37 -0.13 6.18 3.33 3.3 0.12 31.43 33.79 -0.29 0.01 -0.56 -0.71 0 6.145 -7.845 -2.58 -1.82 6.615 0.2 3.61 0.085 2.445 3.39 3.26 0.045 37.67 30.16 -0.54 -0.12 0.06 -0.81 0.03 7.27",
  "TGATC 4.77 0.38 91 14.04 0.36 77 -7.81 0.48 106 -1.56 0.06 106 -1.51 0.04 106 -1.37 1.37 106 -4.67 1.11 106 35.6 0.75 106 32.48 0.37 106 -7.84 0.34 83 4.3 -0.02 1.04 0.18 -1.92 4.89 -1.37 -4.67 0.1 -0.46 3.34 3.24 -0.21 0.03 -0.11 -7.81 6.29 -1.56 -1.51 35.6 32.48 14.18 -10.775 -1.17 -0.42 -1.425 0.99 1.51 -0.035 2.98 3.24 3.21 0.115 34.88 30.42 -0.13 -0.05 -0.25 -0.89 -0.165 5.87 -12.445 -2.26 -0.03 3.83 1.5 -1.65 0.1 1.555 3.44 3.37 0.035 38.64 31.48 -0.62 0.01 0 -0.8 0.03 6.2",
  "TGATG 5.22 0.43 223 13.21 0.36 209 -8.13 0.57 223 -1.54 0.06 223 -1.47 0.04 223 -0.46 1.37 223 -3.98 1.36 223 35.36 0.77 223 31.93 0.54 223 -7.34 0.29 177 4.21 -0.02 0.85 0.4 -2.07 5.31 -0.46 -3.98 0.1 -0.83 3.31 3.22 -0.25 0.02 -0.1 -8.13 7.09 -1.54 -1.47 35.36 31.93 13.28 -10.255 -1.17 0.06 -2.165 0.99 1.15 -0.03 2.865 3.24 3.23 0.095 34.88 27.88 -0.13 -0.12 -0.25 -1.11 -0.07 6.115 -9.805 -2.26 0.38 0.305 1.5 -0.45 0.07 2.295 3.44 3.21 0.04 38.64 29.55 -0.62 0 0 -0.75 0.01 6.56",
  "TGCAC 5.94 0.22 23 12.79 0.39 17 -3.74 0.37 23 -1.5 0.05 23 -1.2 0.08 23 -0.76 0.54 23 2.85 0.73 23 35.46 0.39 23 34.64 0.4 23 -4.97 0.12 19 4.15 -0.04 -0.26 1.21 -0.39 5.91 -0.76 2.85 0.25 0.18 3.36 3.19 -0.05 -0.28 0.17 -3.74 7.15 -1.5 -1.2 35.46 34.64 12.9 0.96 1.59 -0.61 -2.565 3.4 4.05 -0.125 8.66 3.09 3.3 0.075 27.05 34.03 -0.03 0.15 -0.41 -0.26 -0.07 7.165 -8.26 0.02 0.15 -1.455 0.1 9.88 -0.04 1.47 3.38 3.14 0.03 33.11 29.37 0.01 0.21 -0.56 -0.22 0.105 6.995",
  "TGCAG 5.79 0.22 11 12.96 0.2 11 -3.68 0.37 13 -1.51 0.06 11 -1.37 0.06 13 -0.7 0.53 11 3.43 0.63 13 35.64 0.49 11 34.5 0.37 13 -5 0.18 11 4.12 -0.04 0.16 1.1 0.33 5.74 -0.81 3.43 0.26 0.26 3.37 3.28 0.03 -0.26 0.12 -3.68 6.06 -1.53 -1.37 35.75 34.5 13.44 -2.97 1.59 1.82 3.855 3.4 3.42 0.025 4.18 3.09 3.42 0.065 27.05 36.9 -0.03 0.1 -0.41 0.08 -0.1 6.92 -7.07 0.02 -0.29 -4.245 0.1 9.67 -0.015 2.31 3.38 2.88 0.03 33.11 23.83 0.01 0.03 -0.56 -0.16 0.125 7.325",
  "TGCCC 5.02 0.08 27 14.17 0.26 25 -2.52 0.35 38 -1.59 0.04 38 -1.77 0.04 28 -1.81 0.41 38 -1.78 0.38 28 36.27 0.27 38 33.82 0.27 28 -5.16 0.2 30 4.18 -0.04 0.36 -0.24 0.12 5.07 -1.81 -1.72 0.29 0.37 3.38 3.36 0.03 -0.06 0.05 -2.52 5.4 -1.59 -1.79 36.27 33.75 14.43 -4.08 -1.98 0.71 7.14 1.75 5.14 -0.08 5.815 3.19 3.65 -0.01 31 33.56 -0.09 -0.11 -0.63 -1.15 -0.205 7.19 -13.96 0.32 -0.03 -0.31 -0.68 5.1 -0.01 0.605 3.37 3.61 0.01 35.57 34.08 0.31 -0.1 -0.36 -0.98 0.085 5.565",
  "TGCCG 5.17 0.14 24 13.36 0.2 23 -3.11 0.31 26 -1.56 0.05 24 -1.7 0.04 26 -1.38 0.41 24 -1.26 0.34 26 36.2 0.28 24 33.58 0.37 26 -5.05 0.13 21 4.19 -0.04 0.22 -0.05 -0.22 5.24 -1.38 -1.26 0.27 0.27 3.38 3.33 0.01 -0.09 0.08 -3.11 6.7 -1.57 -1.7 36.23 33.58 13.49 -2.385 -1.98 1.28 2.27 1.75 6.56 -0.025 5.645 3.19 3.5 0.1 31 33.36 -0.09 0.08 -0.63 -1 -0.115 7.155 -8.825 0.32 -1.21 2.29 -0.68 2.64 0.005 0.92 3.37 3.5 0.03 35.57 36 0.31 -0.57 -0.36 -0.25 0.145 6.645",
  "TGCGA 5.68 0.24 5 12.77 0.18 3 -3.81 0.34 5 -1.51 0.02 5 -1.46 0.08 5 -0.91 0.7 5 4.16 0.93 5 35.53 0.33 5 33.31 0.35 5 -4.84 0.14 4 4.15 -0.04 0.5 0.32 0.74 5.68 -0.91 4.16 0.25 0.28 3.36 3.34 0.01 -0.05 0.07 -3.81 7.15 -1.51 -1.46 35.53 33.31 12.87 1.57 0.01 -1.84 6.19 6.42 5.54 0.155 -6.005 3.24 3.48 0.115 28.89 36.68 0.07 -0.45 -0.7 0.32 -0.115 7.405 -6.8 -0.46 1.44 -1.625 -1.45 10.88 0.005 0.77 3.42 3.03 0.03 34.51 26.86 -0.21 0.1 -0.39 -0.07 0.15 7.125",
  "TGCGC 5.71 0.17 39 12.27 0.47 10 -3.94 0.39 84 -1.51 0.04 84 -1.51 0.04 84 -0.67 0.56 84 3.54 0.79 84 35.52 0.34 84 32.79 0.42 84 -4.75 0.14 89 4.06 -0.03 0.42 0.19 -0.07 5.75 -0.67 3.54 0.25 0.3 3.36 3.29 0.01 0.04 0.08 -3.94 5.35 -1.51 -1.51 35.52 32.79 13.6 0.355 0.01 -4.78 2.55 6.42 5.04 0.075 -2.19 3.24 -0.63 0.075 28.89 10.97 0.07 -2.27 -0.7 -0.62 -0.155 7.265 -8.61 -0.46 0.09 -0.15 -1.45 9.7 -0.005 0.44 3.42 3.17 0.025 34.51 30.33 -0.21 0.01 -0.39 -0.1 0.175 6.635",
  "TGCGG 5.59 0.21 9 12.94 0.17 9 -4.13 0.27 9 -1.47 0.02 9 -1.54 0.05 9 -0.88 0.47 9 2.75 0.7 9 35.63 0.3 9 33.13 0.19 9 -4.82 0.15 8 4.1 -0.03 0.73 -0.37 1.35 5.56 -0.88 2.75 0.25 0.32 3.36 3.32 0.03 0.02 0.06 -4.13 7.01 -1.47 -1.54 35.63 33.13 13.16 -2.23 0.01 -0.18 3.545 6.42 0.81 0.105 -1.965 3.24 3.37 0.145 28.89 36.72 0.07 0.14 -0.7 0.09 -0.065 7.5 -4.715 -0.46 0.43 -3.835 -1.45 8.69 -0.02 0.905 3.42 2.81 0.04 34.51 23.6 -0.21 0.05 -0.39 -0.12 0.16 7.225",
  "TGCTC 5.1 0.24 41 14.19 0.3 33 -0.94 0.38 41 -1.66 0.04 41 -1.71 0.03 41 -2.29 0.8 41 -2.44 0.74 41 36.61 0.54 41 31.46 0.27 41 -5.61 0.21 32 4.29 -0.01 -0.67 2.28 -3.75 5.16 -2.29 -2.44 0.25 0.24 3.44 3.25 0.01 -0.21 0.19 -0.94 6.61 -1.66 -1.71 36.61 31.46 14.15 4.515 1.31 0.48 -5.035 -0.48 4.13 -0.135 10.405 3.31 3.36 -0.05 31.95 31.86 -0.11 -0.15 -0.69 -0.68 0.02 6.56 -16.56 1.57 -2.57 1.715 -1.42 4.35 0.04 1.36 3.42 3.45 0.005 36.13 33.22 0.5 -0.25 -0.34 -0.73 0.215 5.805",
  "TGCTG 5.27 0.28 16 13.14 0.43 15 -1.72 0.4 18 -1.64 0.04 18 -1.64 0.04 18 -1.51 0.82 18 -1.86 0.93 18 36.65 0.44 18 31.23 0.34 18 -5.22 0.26 14 4.23 -0.02 -0.8 2.6 -3.74 5.3 -1.51 -1.86 0.24 0.15 3.43 3.24 -0.01 -0.22 0.19 -1.72 6.71 -1.64 -1.64 36.65 31.23 13.34 7.81 1.31 -0.88 -5.305 -0.48 2.66 -0.175 14.09 3.31 3.35 -0.055 31.95 31.67 -0.11 -0.23 -0.69 -0.63 0.055 6.75 -10.76 1.57 -3.59 2.735 -1.42 0.33 0.01 1.635 3.42 3.35 0.01 36.13 35.72 0.5 -0.61 -0.34 -0.23 0.195 6.42",
  "TGGAC 5.19 0.17 12 13.86 0.25 11 -5.78 0.61 20 -1.68 0.08 20 -1.39 0.1 17 -0.37 0.5 20 -2.08 0.71 17 33.79 0.45 20 36.11 0.6 17 -5.41 0.27 18 4.27 -0.04 1.09 0.64 0.02 5.17 -0.37 -1.88 -0.28 0.23 3.38 3.25 0.06 -0.14 0 -5.78 5.9 -1.68 -1.41 33.79 36.01 14.16 -7.33 6.86 -0.67 1.775 5.93 1.91 -0.135 8.97 2.48 3.21 0.005 27.51 33.89 0.13 -0.06 -0.58 -0.63 -0.095 6.835 -10.31 0.56 -2.03 4.18 5.9 1.62 0.015 1.225 3.52 3.36 0.025 31.9 37.52 -0.23 -0.31 -0.69 -0.2 0.025 6.54",
  "TGGAG 5.02 0.29 11 13.96 0.08 6 -5.45 0.48 23 -1.78 0.05 19 -1.5 0.05 23 -0.86 1.84 19 -1.81 0.72 23 33.85 0.79 19 35.8 0.53 23 -5.61 0.17 19 4.2 -0.05 1.25 0.52 -1.36 5.08 -0.78 -1.81 -0.29 0.27 3.44 3.27 0.02 -0.12 -0.05 -5.45 5.09 -1.78 -1.5 33.91 35.8 14.55 0.595 6.86 0.62 -3.2 5.93 3.94 -0.155 11.365 2.48 3.27 0.095 27.51 35.11 0.13 0.28 -0.58 -0.35 -0.08 7.02 -7.435 0.56 -1.85 1.75 5.9 3.18 0.015 1.17 3.52 3.21 0.03 31.9 33.48 -0.23 -0.18 -0.69 -0.37 -0.065 7.01",
  "TGGCA 5.24 0.18 32 13.56 0.21 29 -2.98 0.34 34 -1.71 0.06 32 -1.58 0.04 34 -1.33 0.65 32 -1.81 0.46 34 33.34 0.82 32 36.44 0.29 34 -5.21 0.21 21 4.18 -0.03 0.33 0.01 1.54 5.35 -1.34 -1.81 -0.27 0.21 3.3 3.39 0.1 0.03 0.11 -2.98 6.59 -1.71 -1.58 33.41 36.44 13.64 -4.71 0.26 -1.98 1 3.45 1.75 -0.095 2.09 3.37 3.19 0.035 32.46 31 -0.02 -0.09 -0.47 -0.63 -0.14 6.885 -9.53 -1.53 0.32 1.89 2.87 -0.68 -0.005 1.02 3.48 3.37 0.03 35.96 35.57 -0.6 0.31 -0.29 -0.36 0.125 6.475",
  "TGGCC 4.93 0.19 22 14.19 0.25 21 -2.54 0.46 33 -1.76 0.05 33 -1.6 0.04 22 -1.76 0.53 33 -2.42 0.51 22 33.23 0.57 33 37.04 0.43 22 -5.35 0.26 25 4.21 -0.03 0.59 0.24 1.1 4.92 -1.76 -2.29 -0.27 0.35 3.33 3.42 0.11 0.04 0.06 -2.54 4.93 -1.76 -1.62 33.23 36.91 14.68 -5.73 0.26 -0.12 -0.39 3.45 4.74 -0.06 0.51 3.37 3.3 0.085 32.46 30.88 -0.02 -0.18 -0.47 -1.21 -0.135 7.245 -9.77 -1.53 0.04 7.63 2.87 0 0.025 1.235 3.48 3.48 0.035 35.96 35.5 -0.6 0 -0.29 -0.71 0.175 6.45",
  "TGGCG 5.06 0.46 30 13.4 0.25 23 -2.98 0.75 50 -1.73 0.05 32 -1.56 0.04 48 -1.66 1.84 32 -1.9 2 48 33.36 1.11 32 36.34 0.76 48 -5.16 0.15 40 4.2 -0.04 0.56 0.16 0.47 5.14 -1.48 -1.9 -0.28 0.32 3.34 3.4 0.1 -0.02 0.06 -2.98 5.27 -1.75 -1.56 33.6 36.36 14.24 -1.77 0.26 0.05 -0.015 3.45 -1.11 -0.06 4.895 3.37 3.24 0.06 32.46 27.86 -0.02 0.2 -0.47 -0.51 -0.125 7.095 -9.2 -1.53 -0.2 1.25 2.87 -0.95 0 0.97 3.48 3.39 0.03 35.96 35.49 -0.6 0.26 -0.29 -0.36 0.115 6.53",
  "TGGGA 4.93 0.27 44 13.73 0.72 28 -2.42 0.55 74 -1.83 0.08 58 -1.83 0.06 74 -1.55 1.61 58 -0.93 1.09 74 33.23 0.93 58 33.69 0.78 74 -5.54 0.32 50 4.15 -0.04 0.36 1.17 1.24 4.91 -1.79 -0.93 -0.29 0.31 3.35 3.44 0.1 0.07 0.05 -2.42 5.43 -1.83 -1.83 33.34 33.69 14.56 -3.475 0.97 -0.21 2.085 5.25 6.31 0.035 0.795 3.42 3.44 0.02 30.63 31.55 -0.25 -0.12 -0.87 -0.75 -0.065 7.39 -5.455 -1 1.03 5.26 3.96 6.53 0.01 1.22 3.45 3.44 0.03 34.1 30.36 -0.36 0.02 -0.53 -0.92 0.005 7.37",
  "TGGGC 4.96 0.33 23 14.15 0.27 19 -2.77 0.69 25 -1.78 0.06 25 -1.78 0.05 23 -2.07 1.66 25 -1.99 1.14 23 33.45 0.65 25 33.75 0.61 23 -5.57 0.27 21 4.19 -0.04 0.59 0.56 0.94 4.94 -2.07 -1.89 -0.28 0.25 3.37 3.38 0.13 0.11 0.05 -2.77 6.32 -1.78 -1.79 33.45 33.74 14.33 -3.01 0.97 0.71 6.26 5.25 5.14 -0.03 4.09 3.42 3.65 -0.035 30.63 33.56 -0.25 -0.11 -0.87 -1.15 -0.145 7.4 -8.39 -1 -0.03 7.985 3.96 5.1 0.02 1.315 3.45 3.61 0.03 34.1 34.08 -0.36 -0.1 -0.53 -0.98 0.115 6.84",
  "TGGGG 4.89 0.11 12 14.1 0.29 9 -2.02 0.49 24 -1.82 0.04 24 -1.86 0.04 24 -1.74 0.53 24 -2.1 0.63 24 33.26 0.26 24 33.49 0.5 24 -5.39 0.26 14 4.11 -0.04 0.43 0.54 1.74 5.05 -1.74 -2.1 -0.29 0.34 3.34 3.39 0.13 0.13 0.05 -2.02 5.69 -1.82 -1.86 33.26 33.49 14.66 -14.83 0.97 -1.81 11.57 5.25 6.69 -0.18 10.825 3.42 3.39 0.025 30.63 33.69 -0.25 -0.39 -0.87 -0.6 -0.13 6.99 -3.285 -1 0.17 3.99 3.96 5.94 0.015 1.08 3.45 3.37 0.03 34.1 30.11 -0.36 0.05 -0.53 -1.15 -0.075 7.705",
  "TGGTC 4.84 0.17 37 13.69 0.3 34 -6.17 0.41 49 -1.75 0.05 49 -1.54 0.03 49 -0.69 0.52 49 -2.73 0.47 49 34.3 0.35 49 34.68 0.24 49 -5.62 0.17 41 4.33 -0.04 0.89 0.98 -3.2 4.94 -0.69 -2.73 -0.27 0.33 3.42 3.37 0.08 -0.22 0.02 -6.17 6.06 -1.75 -1.54 34.3 34.68 13.92 1.195 2.31 -1.38 -7.86 4.48 1.27 -0.145 9.885 3.62 3.25 0.07 34.57 30.21 0.07 -0.28 -0.82 -1.11 -0.22 6.92 -10.63 -0.68 0.68 2.88 3.91 -0.37 0.01 1.48 3.58 3.43 0.03 35.51 32.74 -0.43 -0.19 -0.62 -0.74 0.115 6.285",
  "TGGTG 4.84 0.19 10 13.28 0.29 10 -7 0.59 14 -1.73 0.05 14 -1.5 0.03 14 -0.68 0.66 14 -2.83 0.56 14 34.81 0.39 14 34.27 0.22 14 -5.36 0.31 12 4.32 -0.04 1.03 0.96 -4.31 4.95 -0.68 -2.83 -0.27 0.28 3.44 3.35 0.05 -0.25 0 -7 6.07 -1.73 -1.5 34.81 34.27 13.56 8.935 2.31 -0.05 -14.81 4.48 1.73 -0.335 21.745 3.62 3.35 0.055 34.57 32.09 0.07 0.05 -0.82 -1.18 -0.26 6.96 -9.16 -0.68 1.04 -2.11 3.91 -1.99 0 1.39 3.58 3.29 0.035 35.51 33.57 -0.43 0.12 -0.62 -0.51 0.03 6.395",
  "TGTAC 6.2 0.23 32 12.55 0.26 19 -8 0.54 89 -1.47 0.04 89 -1.26 0.07 89 -1.75 0.67 89 4.26 1.29 89 33.68 0.35 89 34.52 0.62 89 -6.58 0.25 72 4.06 -0.04 0.36 0.24 -1.23 6.03 -1.75 4.26 -0.11 -1.12 3.29 3.16 -0.26 0.02 0.12 -8 6.71 -1.47 -1.26 33.68 34.52 12.94 -3.08 0.3 -0.38 1.405 3.68 2.63 0.035 3.54 3.19 3.4 0.005 28.75 28.05 -0.1 -0.1 -0.85 -0.03 -0.13 6.515 -10.59 0.33 0.05 -4.28 0.51 8.27 -0.055 2.145 3.28 3.2 0.035 30.55 32.49 -0.09 0.04 -0.66 -0.15 0.1 6.575",
  "TGTAG 5.74 0.63 8 12.92 0.29 6 -8.6 2.11 8 -1.48 0.11 8 -1.29 0.11 8 -3.23 2.57 8 3.24 3.18 8 33.91 0.57 8 35.06 1.14 8 -6.73 0.24 6 3.97 -0.02 0.43 0.07 -2.29 5.85 -3.23 3.24 -0.13 -1.56 3.31 3.2 -0.31 0.06 0.09 -8.6 7.08 -1.48 -1.29 33.91 35.06 13.06 -3.23 0.3 -1.11 2.265 3.68 1.1 0.015 2.47 3.19 3.38 0.04 28.75 36.22 -0.1 0.04 -0.85 -0.28 -0.175 7.02 -8.425 0.33 -0.14 -6.03 0.51 8.66 -0.065 2.005 3.28 2.99 0.035 30.55 27.73 -0.09 0.26 -0.66 -0.13 0.07 6.72",
  "TGTCC 5.02 0.26 16 13.73 0.27 14 -7.71 0.5 68 -1.54 0.05 68 -1.35 0.07 28 -2.88 0.86 68 -2.2 0.87 28 34.09 0.77 68 36.22 0.57 28 -7.24 0.21 56 4.18 -0.01 0.82 -0.11 -3.61 5.09 -2.88 -1.98 -0.09 -0.14 3.34 3.22 -0.25 0.22 0.02 -7.71 3.73 -1.54 -1.37 34.09 36.24 14.43 -9.805 0.11 -0.67 2.12 0.71 1.91 -0.105 7.305 3.23 3.21 0.03 29.32 33.89 0.01 -0.06 -1.08 -0.63 -0.115 6.71 -12.135 -0.05 -2.03 -1.18 -0.33 1.62 0.025 1.31 3.36 3.36 0.03 31.44 37.52 -0.36 -0.31 -0.69 -0.2 0.02 6.105",
  "TGTCG 5.28 0.17 27 13.02 0.22 25 -8.25 0.26 27 -1.5 0.04 27 -1.31 0.04 27 -2.39 0.56 27 -1.7 0.53 27 34.23 0.29 27 35.73 0.41 27 -7.15 0.13 21 4.23 -0.03 0.72 0.25 -3.88 5.32 -2.39 -1.7 -0.11 -0.77 3.33 3.18 -0.28 0.2 0.05 -8.25 6.97 -1.5 -1.31 34.23 35.73 13.1 -5.945 0.11 -1.77 5.225 0.71 0.35 0.04 0.525 3.23 3.38 0.055 29.32 32.95 0.01 -0.4 -1.08 -0.48 -0.085 6.985 -7.88 -0.05 -2.22 2.91 -0.33 0.43 0.025 1.525 3.36 3.39 0.045 31.44 38.87 -0.36 -0.69 -0.69 0.19 0.08 7.055",
  "TGTGA 5.84 0.23 8 12.74 0.24 8 -7.82 0.61 12 -1.48 0.03 10 -1.19 0.1 10 -2.33 0.46 10 3.97 0.62 10 33.59 0.26 10 34.48 0.39 10 -6.63 0.17 10 4.08 -0.03 0.8 -0.55 -4.22 5.8 -2.37 4.25 -0.11 -0.92 3.31 3.26 -0.31 0.3 0.04 -7.82 5.62 -1.49 -1.18 33.72 34.66 13.31 -4.75 -0.02 -1.2 -0.3 1.43 4.14 -0.025 3.365 3.22 3.28 0.01 28.74 34.75 -0.1 -0.12 -0.73 0.34 -0.07 6.785 -7.12 0.59 1 -5.99 0.49 10.63 -0.035 1.825 3.28 2.95 0.035 30.57 23.47 -0.17 0.19 -0.6 -0.09 0.06 6.945",
  "TGTGC 5.94 0.13 17 12.44 0.26 17 -8.3 0.33 17 -1.45 0.03 17 -1.16 0.06 17 -1.85 0.52 17 3.31 0.56 17 33.55 0.22 17 35.01 0.25 17 -6.5 0.14 15 4.07 -0.04 0.84 -1.01 -4.01 5.92 -1.85 3.31 -0.1 -0.96 3.32 3.18 -0.31 0.32 0.05 -8.3 7.34 -1.45 -1.16 33.55 35.01 12.5 1.775 -0.02 -0.61 -5.495 1.43 4.05 -0.18 9.915 3.22 3.3 0.045 28.74 34.03 -0.1 0.15 -0.73 -0.26 -0.075 6.845 -9.36 0.59 0.15 -5.09 0.49 9.88 -0.035 1.825 3.28 3.14 0.035 30.57 29.37 -0.17 0.21 -0.6 -0.22 0.075 6.915",
  "TGTGG 5.8 0.16 6 12.61 0.22 5 -7.33 0.34 7 -1.46 0.05 6 -1.27 0.07 7 -1.82 0.87 6 2.59 0.68 7 33.07 0.48 6 34.79 0.48 7 -6.57 0.13 5 4.07 -0.03 1.16 -1.19 -2.27 5.81 -1.79 2.59 -0.1 -0.79 3.29 3.21 -0.26 0.31 0.03 -7.33 6.31 -1.48 -1.27 33.11 34.79 12.89 -3.85 -0.02 -1.4 -0.455 1.43 5.18 -0.06 3.02 3.22 3.36 0.02 28.74 35.26 -0.1 -0.01 -0.73 -0.18 -0.07 7.125 -6.725 0.59 -0.29 -6.61 0.49 9.42 -0.045 1.7 3.28 2.93 0.035 30.57 25.46 -0.17 0.26 -0.6 -0.17 0.035 7.175",
  "TGTTC 4.85 0.2 19 13.15 0.26 19 -10.91 0.74 68 -1.55 0.04 68 -1.09 0.04 68 -2.74 1.24 68 -3.14 1.08 68 34.81 0.56 68 35.68 0.36 68 -7.98 0.28 52 4.39 -0.01 0.37 2.2 -9.27 4.84 -2.74 -3.14 -0.14 -0.99 3.39 3.09 -0.4 0.14 0.08 -10.91 6.42 -1.55 -1.09 34.81 35.68 13.09 -6.225 0.69 -0.08 3.705 0.7 -0.22 0.055 -0.505 3.3 3.24 0.015 31.62 34.75 -0.07 0.02 -1.15 -0.62 -0.085 5.425 -13.13 -0.15 -2.66 1.65 -1.3 1.29 0.085 2.155 3.39 3.35 0.035 32.99 35.61 -0.45 -0.2 -0.69 -0.38 0.03 6.09",
  "TGTTG 5.24 0.2 9 12.68 0.21 8 -11.69 0.43 9 -1.54 0.05 9 -1.07 0.04 9 -2.5 0.47 9 -2.78 0.48 9 34.7 0.45 9 35.19 0.36 9 -7.46 0.14 7 4.31 -0.03 0.14 2.37 -9.77 5.31 -2.5 -2.78 -0.15 -1.79 3.39 3.06 -0.46 0.1 0.11 -11.69 6.53 -1.54 -1.07 34.7 35.19 12.8 -10.075 0.69 0.28 2.115 0.7 2.59 0 4.345 3.3 3.15 0.065 31.62 33.65 -0.07 0.16 -1.15 -0.56 -0.045 6.305 -7.79 -0.15 -3.66 2.92 -1.3 -1.25 0.06 2.65 3.39 3.3 0.035 32.99 37.43 -0.45 -0.68 -0.69 0.02 -0.015 7.05",
  "TTAAA 5.73 0.44 8 12.94 0.22 8 -10.7 0.83 8 -1.09 0.18 8 -1.05 0.04 8 5.72 1.47 8 -3 1.04 8 34.67 0.8 8 35.63 0.25 8 -7.41 0.32 6 4.51 0 0.06 -0.74 0.32 5.62 5.72 -3 0.12 -1.68 3.37 3.13 -0.04 -0.23 -0.16 -10.7 5.72 -1.09 -1.05 34.67 35.63 12.91 -2.01 -0.89 -0.07 -2.48 4.13 2.76 -0.1 6.645 3.49 3.06 0.055 37.51 32.53 -0.08 -0.03 0.51 -0.49 -0.155 5.48 -11.855 0.05 -2.08 1.425 12.18 0.98 0.005 4.42 3.2 3.32 0.025 25.22 35.05 0 -0.44 -0.2 -0.22 -0.07 6.475",
  "TTAAC 5.85 0.32 55 12.77 0.44 52 -10.44 0.67 58 -1.22 0.14 58 -1.14 0.07 58 7.53 1.88 58 -2.86 1.15 58 34.36 0.66 58 35.05 0.5 58 -7.16 0.32 45 4.27 -0.02 -0.24 -1.35 -0.18 5.67 7.53 -2.86 0.1 -1.18 3.42 3.07 -0.02 -0.13 -0.14 -10.44 6.6 -1.22 -1.14 34.36 35.05 12.88 -1 -0.89 0.25 -2.73 4.13 3.24 -0.125 11.64 3.49 3.12 0.035 37.51 31.75 -0.08 0.14 0.51 -0.64 -0.135 5.675 -10.365 0.05 -3.39 1.675 12.18 -0.75 0.005 4.195 3.2 3.27 0.03 25.22 36.43 0 -0.57 -0.2 -0.08 -0.045 6.795",
  "TTAAG 5.58 0.29 5 13.4 0.33 5 -9.57 0.37 5 -1.27 0.1 5 -1.29 0.07 5 6.23 1.27 5 -3.71 1.2 5 34.81 0.64 5 34.68 0.56 5 -7.24 0.13 3 4.27 -0.02 0.08 -1.51 -2.04 5.55 6.23 -3.71 0.11 -1.25 3.42 3.1 0.03 -0.05 -0.15 -9.57 6.18 -1.27 -1.29 34.81 34.68 13.46 3.43 -0.89 -0.17 -5.865 4.13 -1.34 -0.11 16.005 3.49 3.23 0.04 37.51 33.71 -0.08 -0.07 0.51 -0.55 -0.08 5.805 -10.885 0.05 -3.36 2.92 12.18 -0.07 0 4.655 3.2 3.29 0.035 25.22 36.23 0 -0.5 -0.2 -0.09 -0.03 6.765",
  "TTACA 5.99 0.31 29 12.6 0.44 29 -7.55 0.46 30 -1.29 0.08 30 -1.5 0.03 29 6.03 1.65 30 -2.1 1.02 29 34.6 0.68 30 33.74 0.46 29 -6.87 0.28 23 4.09 -0.03 -1.7 -0.4 0.58 5.94 6.03 -2.12 0.11 -1.07 3.32 3.29 0.08 0.23 0.12 -7.55 6.87 -1.29 -1.5 34.6 33.77 12.7 -1.8 -0.16 0.3 5.315 5.23 3.68 0.105 -0.06 3.46 3.19 0.01 36.67 28.75 -0.11 -0.1 -0.24 -0.85 -0.175 6.735 -8.4 1.75 0.33 -4.465 10.32 0.51 -0.05 2.245 3.06 3.28 0.035 26.12 30.55 0.12 -0.09 -0.16 -0.66 0.095 6.56",
  "TTACC 5.43 0.43 212 13.5 0.3 191 -7.21 1.32 250 -1.34 0.12 250 -1.56 0.1 214 5.01 2.19 250 -3.71 1.85 214 34.64 1.18 250 34.56 0.47 214 -7.44 0.22 195 4.15 -0.02 -1.54 -0.19 1.52 5.43 5.01 -3.59 0.12 -0.86 3.33 3.34 0.12 0.24 0.08 -7.21 5.99 -1.34 -1.56 34.64 34.54 13.74 -3.975 -0.16 0.49 3.68 5.23 0.32 0.065 0.095 3.46 3.29 0.015 36.67 30.81 -0.11 0.02 -0.24 -1.15 -0.125 6.46 -10.11 1.75 0.77 -5.89 10.32 -1.44 -0.06 2.06 3.06 3.27 0.03 26.12 32.83 0.12 0.08 -0.16 -0.52 0.075 6.095",
  "TTACG 6.11 0.23 178 12.48 0.39 176 -7.71 0.49 246 -1.25 0.08 246 -1.47 0.03 178 6.35 1.4 246 -1.95 0.81 178 34.26 0.76 246 33.58 0.32 178 -6.77 0.21 214 4.06 -0.03 -1.4 -0.01 0.6 6.02 6.35 -2.05 0.11 -0.99 3.29 3.29 0.12 0.22 0.1 -7.71 5.87 -1.25 -1.48 34.26 33.76 13.07 -2.865 -0.16 0.75 3.89 5.23 3.92 0.135 -1.815 3.46 3.13 0.03 36.67 26.92 -0.11 0.03 -0.24 -0.45 -0.085 7.275 -8.58 1.75 0.18 -4.01 10.32 0.77 -0.05 2.23 3.06 3.27 0.035 26.12 30.04 0.12 -0.1 -0.16 -0.56 0.115 6.565",
  "TTAGA 6 0.24 10 13.25 0.24 8 -6.61 0.43 10 -1.32 0.07 10 -1.67 0.06 10 6.26 0.9 10 -1.11 0.68 10 34.4 0.36 10 31.27 0.25 10 -6.73 0.19 8 4.08 -0.03 -1.35 -1.48 -0.93 5.88 6.26 -1.11 0.11 -1.21 3.34 3.26 0.11 0.19 0.03 -6.61 6.87 -1.32 -1.67 34.4 31.27 13.46 -7.3 0.18 -0.2 1.805 1.49 4.8 0.005 4.815 3.26 3.39 0.05 34.85 32.53 0.04 -0.04 -0.13 -0.48 -0.14 6.165 -11.65 -1.75 -1.49 -1.28 11.34 5.14 -0.025 4.285 3.04 3.37 0.03 24.59 31.06 0.16 -0.36 -0.19 -0.69 0.02 7.145",
  "TTAGC 5.82 0.19 16 13.53 0.18 16 -6.12 0.32 17 -1.36 0.05 17 -1.7 0.03 16 5.63 0.71 17 -2.69 0.55 16 34.68 0.38 17 31.43 0.26 16 -6.93 0.16 12 4.09 -0.03 -1.45 -1.38 -0.87 5.68 5.63 -2.63 0.11 -1.05 3.35 3.23 0.13 0.23 0.05 -6.12 6.47 -1.36 -1.7 34.68 31.42 13.77 -4.86 0.18 0.52 0.47 1.49 1.42 0.005 3.355 3.26 3.24 0.035 34.85 32.66 0.04 -0.01 -0.13 -0.7 -0.11 6.49 -9.65 -1.75 -3.2 0.595 11.34 1.56 -0.015 4.185 3.04 3.32 0.03 24.59 34.92 0.16 -0.62 -0.19 -0.28 0.075 7.105",
  "TTAGG 5.96 0.2 4 13.42 0.31 4 -5.77 0.5 4 -1.3 0.05 4 -1.71 0.01 4 5.87 1.51 4 -2.83 0.55 4 34.35 0.61 4 31.45 0.13 4 -6.85 0.15 3 4.09 -0.03 -1.45 -1.67 0.03 5.7 5.87 -2.83 0.1 -1.06 3.31 3.2 0.15 0.26 0.07 -5.77 6.85 -1.3 -1.71 34.35 31.45 13.74 -4.51 0.18 0.08 3.55 1.49 4.07 0.005 5.085 3.26 3.34 0.045 34.85 32.41 0.04 -0.17 -0.13 -0.56 -0.13 6.47 -9.41 -1.75 -2.61 0.755 11.34 2.13 -0.015 4.47 3.04 3.3 0.035 24.59 33.56 0.16 -0.49 -0.19 -0.46 0.08 7.2",
  "TTATC 5.89 0.43 64 13.06 0.39 58 -7.66 1.15 78 -1.35 0.11 78 -1.49 0.03 78 7.32 2.3 78 -3.54 1.15 78 34.59 1.61 78 31.94 0.52 78 -7.18 0.36 64 4.17 -0.02 -1.42 0.38 -4.39 5.77 7.32 -3.54 0.11 -0.82 3.43 3.2 0.13 -0.03 -0.02 -7.66 6.7 -1.35 -1.49 34.59 31.94 13.21 -7.965 -0.11 -0.48 -1.11 0.54 -0.09 -0.045 10.675 3.42 3.28 0.01 37.82 31.38 0.03 -0.1 -0.27 -0.95 -0.08 5.905 -12.07 1.94 0.19 2.12 10.51 0.42 0.02 3.615 3.27 3.23 0.04 29.6 29.64 0.05 0.03 -0.34 -0.86 0.11 6.43",
  "TTATG 6.02 0.45 138 12.37 0.48 133 -8.06 0.67 141 -1.33 0.1 141 -1.45 0.04 141 7.92 2.28 141 -3.28 1.47 141 34.54 0.95 141 31.48 0.45 141 -6.88 0.33 112 4.12 -0.02 -1.44 0.66 -4.86 6.01 7.92 -3.28 0.1 -1 3.43 3.19 0.12 -0.04 -0.01 -8.06 7.06 -1.33 -1.45 34.54 31.48 12.42 -7.95 -0.11 1.96 2.08 0.54 2.32 0.02 6.645 3.42 3.25 0.055 37.82 29.13 0.03 0.14 -0.27 -0.83 -0.145 5.745 -11.39 1.94 0.41 0.79 10.51 0.23 0.01 3.9 3.27 3.22 0.035 29.6 29.21 0.05 -0.01 -0.34 -0.78 0.095 6.465",
  "TTCAC 5.94 0.11 10 13.03 0.22 10 -6.21 0.17 10 -1.44 0.07 10 -1.17 0.04 10 0.69 0.68 10 4.07 0.52 10 34.8 0.98 10 34.78 0.35 10 -5.32 0.22 8 4.27 -0.04 -1.9 0.88 -0.19 5.84 0.69 4.07 0.26 0.16 3.34 3.23 0.3 -0.3 0.07 -6.21 6.64 -1.44 -1.17 34.8 34.78 13.14 -6.265 -2.15 -1.2 2.73 3.57 4.14 0.045 0.24 1.72 3.28 0.03 35.09 34.75 -0.98 -0.12 -1.41 0.34 -0.095 6.775 -6.205 -0.97 1 -0.69 2.44 10.63 -0.035 1.98 3.4 2.95 0.035 34.98 23.47 -0.42 0.19 -0.2 -0.09 0.01 7.02",
  "TTCAG 5.93 0.22 5 13.2 0.16 5 -5.95 0.19 6 -1.42 0.09 6 -1.35 0.06 5 0.57 1.01 6 5.37 1.41 5 35.08 0.8 6 34.21 0.56 5 -5.01 0.09 4 4.19 -0.04 -1.77 1.15 -0.12 5.89 0.57 5.44 0.28 0.25 3.32 3.35 0.34 -0.28 0.05 -5.95 5.69 -1.42 -1.38 35.08 34.18 13.52 -3.92 -2.15 1.23 4.275 3.57 4.71 0.07 3.995 1.72 3.45 0.01 35.09 36.83 -0.98 0.16 -1.41 -0.32 -0.095 6.89 -8.17 -0.97 1.17 -1.865 2.44 11.07 -0.01 3.14 3.4 2.91 0.035 34.98 22.06 -0.42 0.04 -0.2 0 0.055 7.1",
  "TTCCA 4.97 0.16 43 13.97 0.29 19 -5.2 0.33 72 -1.48 0.06 72 -1.77 0.05 62 -0.69 0.84 72 -0.87 0.57 62 36.04 0.6 72 33.8 0.4 62 -5.75 0.2 56 4.32 -0.04 -2.11 -0.96 -0.12 4.98 -0.69 -0.85 0.29 0.25 3.39 3.4 0.27 -0.06 -0.01 -5.2 5.09 -1.48 -1.77 36.04 33.87 14.34 -3.34 -0.78 6.86 5.375 3.61 5.93 -0.035 4.085 3.33 2.48 -0.005 33.12 27.51 -0.18 0.13 -0.66 -0.58 -0.115 6.54 -8.08 -0.52 0.56 3.11 3.33 5.9 0.01 1.235 3.27 3.52 0.025 33.83 31.9 -0.21 -0.23 -0.27 -0.69 -0.035 6.79",
  "TTCCC 4.73 0.23 19 14.64 0.53 7 -4.39 0.38 290 -1.51 0.05 290 -1.82 0.1 26 -0.97 0.81 290 -1.61 0.88 26 36.01 0.57 290 33.66 1.12 26 -5.5 0.2 226 4.29 -0.05 -1.98 -0.74 1.2 4.8 -0.97 -1.09 0.31 0.37 3.39 3.46 0.29 0 -0.06 -4.39 2.83 -1.51 -1.87 36.01 33.77 15.15 -3.015 -0.78 -0.21 5.07 3.61 6.31 0.06 0.665 3.33 3.44 0.05 33.12 31.55 -0.18 -0.12 -0.66 -0.75 -0.11 6.885 -8.52 -0.52 1.03 0.335 3.33 6.53 0.005 0.98 3.27 3.44 0.015 33.83 30.36 -0.21 0.02 -0.27 -0.92 -0.135 6.615",
  "TTCCG 5.09 0.1 12 13.61 0.11 10 -5.36 0.35 15 -1.4 0.05 15 -1.7 0.04 15 -1.8 5.04 15 -1.46 3.15 15 35.82 1.43 15 34.24 1.57 15 -5.73 0.19 62 4.39 -0.04 -1.25 -0.61 -0.23 4.93 -1.8 -1.46 0.27 0.19 3.35 3.42 0.38 -0.08 0 -5.36 6.27 -1.4 -1.7 35.82 34.24 13.74 -7.095 -0.78 -1.79 3.475 3.61 2.54 -0.05 3.465 3.33 0.77 0.03 33.12 30.08 -0.18 -0.19 -0.66 -0.75 -0.105 6.945 -7.97 -0.52 0.43 3.715 3.33 5.73 0.01 1.225 3.27 3.48 0.025 33.83 31.82 -0.21 -0.24 -0.27 -0.41 -0.005 6.91",
  "TTCGA 5.75 0.26 4 13.14 0.1 4 -5.99 0.41 15 -1.47 0.08 15 -1.58 0.1 15 0.19 0.72 15 5.38 0.7 15 34.95 0.75 15 32.98 0.34 15 -5.31 0.15 11 4.13 -0.04 -1.38 0.45 1.46 5.54 0.19 5.38 0.27 0.35 3.33 3.45 0.31 0.01 -0.03 -5.99 4.98 -1.47 -1.58 34.95 32.98 14.15 -5.635 0.64 -15.36 -0.475 4.33 7.72 -0.02 5.145 3.37 -16.86 0.105 33.2 9.75 0.12 -0.16 -0.59 1.56 -0.17 6.78 -6.14 -0.77 0.06 0.68 2.23 11.51 -0.025 1.705 3.42 3 0.05 35.44 22.93 -0.48 0 0 -0.06 0.025 7.305",
  "TTCGC 5.53 0.11 86 13.39 0.19 21 -6.08 0.26 90 -1.39 0.06 90 -1.53 0.04 88 -0.23 0.67 90 3.79 0.66 88 35.53 0.41 90 32.71 0.27 88 -5.38 0.2 103 4.26 -0.04 -1.49 -0.12 0.44 5.4 -0.23 3.8 0.26 0.3 3.33 3.34 0.28 0.09 -0.01 -6.08 6.28 -1.39 -1.53 35.53 32.71 13.32 -0.8 0.64 -1.84 3.975 4.33 5.54 0.085 0.8 3.37 3.48 0.07 33.2 36.68 0.12 -0.45 -0.59 0.32 -0.14 6.775 -5.985 -0.77 1.44 1.585 2.23 10.88 -0.01 1.32 3.42 3.03 0.04 35.44 26.86 -0.48 0.1 0 -0.07 0.09 7.385",
  "TTCGG 5.38 0.15 6 13.55 0.14 5 -6.08 0.36 10 -1.4 0.06 10 -1.58 0.05 7 -0.53 0.49 10 2.76 0.93 7 35.61 0.46 10 32.67 0.17 7 -5.29 0.26 8 4.22 -0.04 -1.39 -0.34 1.4 5.36 -0.53 3.4 0.27 0.34 3.32 3.39 0.28 0.08 -0.03 -6.08 4.97 -1.4 -1.59 35.61 32.76 14.09 -1.435 0.64 1.74 -7.075 4.33 3.99 -0.095 10.155 3.37 3.3 0.045 33.2 36.31 0.12 0.05 -0.59 -0.06 -0.04 6.81 -5.615 -0.77 -1.58 -0.905 2.23 10.1 -0.015 1.67 3.42 2.86 0.05 35.44 22.38 -0.48 -0.06 0 -0.05 0.04 7.475",
  "TTCTC 4.67 0.32 22 14.26 0.22 14 -2.4 0.81 26 -1.58 0.05 26 -1.75 0.04 26 -1.63 1.85 26 -2.79 1.01 26 36.61 0.68 26 31.51 0.81 26 -6.16 0.27 21 4.46 -0.03 -3.25 2.03 -3.66 4.7 -1.63 -2.79 0.26 0.16 3.49 3.32 0.28 -0.23 0.12 -2.4 5.63 -1.58 -1.75 36.61 31.51 14.4 -2.815 -0.79 -1.04 2.115 0.42 4.02 -0.015 3.185 3.34 3.24 0.045 35.9 31.39 -0.12 -0.12 -0.55 -0.62 -0.16 6.005 -11.88 0.69 -1.15 4.63 2.93 5.12 0.06 2.23 3.38 3.36 0.025 34.17 30.19 -0.12 -0.17 -0.45 -0.74 0.065 6.495",
  "TTCTG 5.14 0.29 5 13.4 0.29 5 -3.52 0.35 36 -1.49 0.07 36 -1.67 0.04 36 -0.54 0.93 36 -1.9 0.83 36 36.46 0.63 36 31.59 0.31 36 -5.96 0.21 26 4.47 -0.03 -2.78 2.42 -3.69 5.03 -0.54 -1.9 0.26 0.05 3.42 3.33 0.32 -0.23 0.13 -3.52 5.93 -1.49 -1.67 36.46 31.59 13.71 -3.83 -0.79 0.5 0.46 0.42 3.48 -0.035 1.685 3.34 3.35 0.025 35.9 32.26 -0.12 -0.15 -0.55 -0.56 -0.12 6.005 -10.53 0.69 -1.77 4.8 2.93 5.04 0.045 2.555 3.38 3.28 0.025 34.17 29.92 -0.12 -0.25 -0.45 -0.32 0.055 6.615",
  "TTGAA 6 0.25 28 13.17 0.24 28 -5.98 0.39 28 -1.09 0.11 28 -1.46 0.07 28 5.46 1.05 28 0.18 0.69 28 34.59 0.62 28 34.8 0.64 28 -5.63 0.21 22 4.36 -0.04 -2.25 2.06 -0.29 5.85 5.46 0.18 -0.27 0.21 3.33 3.34 0.43 -0.3 0.06 -5.98 6.06 -1.09 -1.46 34.59 34.8 13.32 -8.385 0.6 -2.15 -0.75 5.68 3.57 0.005 1.455 3.98 1.72 0.08 35.18 35.09 -0.04 -0.98 0.4 -1.41 -0.19 6.62 -8.49 -0.64 -0.97 -1.055 12.51 2.44 -0.03 2.715 3.05 3.4 0.03 22.3 34.98 0.08 -0.42 -0.12 -0.2 -0.08 6.975",
  "TTGAC 5.91 0.21 65 12.96 0.31 61 -7.07 0.49 68 -1.2 0.12 68 -1.43 0.08 65 6.83 1.23 68 -0.77 0.87 65 34.61 0.31 68 34.78 0.58 65 -5.27 0.19 52 4.21 -0.04 -2.01 0.62 -2.55 5.87 6.83 -0.75 -0.28 0.19 3.43 3.2 0.41 -0.22 0.02 -7.07 6.73 -1.2 -1.43 34.61 34.78 13.07 -9.77 0.6 1.57 -3.44 5.68 1.92 -0.045 3.78 3.98 3.25 0.075 35.18 35.01 -0.04 0.14 0.4 -0.09 -0.175 6.73 -7.885 -0.64 -2.37 1.28 12.51 0.51 -0.025 2.695 3.05 3.39 0.03 22.3 38.79 0.08 -0.65 -0.12 0.16 -0.035 7.2",
  "TTGAG 5.9 0.22 12 13.24 0.19 9 -6.36 0.47 12 -1.13 0.06 12 -1.54 0.06 12 5.89 1.1 12 -0.68 1.24 12 34.65 0.31 12 34.56 0.58 12 -5.39 0.19 9 4.16 -0.04 -1.87 0.8 -2.26 5.83 5.89 -0.68 -0.27 0.2 3.38 3.26 0.46 -0.18 0.01 -6.36 6.4 -1.13 -1.54 34.65 34.56 13.73 -11.87 0.6 0.33 -3.83 5.68 -0.39 -0.02 2.715 3.98 3.33 0.055 35.18 31.43 -0.04 -0.29 0.4 -0.56 -0.155 6.045 -7.22 -0.64 -2.58 2.045 12.51 0.2 -0.015 2.855 3.05 3.39 0.04 22.3 37.67 0.08 -0.54 -0.12 0.06 -0.045 7.255",
  "TTGCA 5.78 0.22 24 12.62 0.27 23 -3.8 0.57 24 -1.23 0.12 24 -1.54 0.05 24 4.6 1.04 24 -1.25 0.78 24 34.61 0.9 24 35.49 0.42 24 -5.27 0.24 19 4.22 -0.04 -2.51 0.13 -0.73 5.83 4.61 -1.25 -0.25 0.2 3.34 3.36 0.42 0.02 0.14 -3.8 6.89 -1.23 -1.54 34.61 35.49 12.69 -0.07 3.97 1.59 5.165 3.56 3.4 0.11 -2.52 3.42 3.09 0.05 34.96 27.05 0.38 -0.03 0.18 -0.41 -0.1 6.955 -7.815 -1.99 0.02 -5.325 11.7 0.1 -0.03 2.25 2.91 3.38 0.03 21.48 33.11 0.13 0.01 -0.16 -0.56 0.015 7.1",
  "TTGCC 5.3 0.22 40 13.62 0.35 39 -3.14 0.48 50 -1.36 0.09 50 -1.6 0.06 40 3.97 1.13 50 -2.26 0.83 40 34.5 0.49 50 36.34 0.31 40 -5.51 0.26 38 4.27 -0.03 -2.3 0.26 -1.06 5.31 3.97 -2.14 -0.25 0.24 3.4 3.39 0.47 0.01 0.1 -3.14 5.66 -1.36 -1.6 34.5 36.3 13.95 -0.17 3.97 -1.98 4.37 3.56 1.75 0.03 -1.66 3.42 3.19 0.025 34.96 31 0.38 -0.09 0.18 -0.63 -0.15 6.77 -11.125 -1.99 0.32 -9.25 11.7 -0.68 -0.05 2.015 2.91 3.37 0.02 21.48 35.57 0.13 0.31 -0.16 -0.36 -0.01 6.38",
  "TTGCG 5.81 0.14 16 12.5 0.2 16 -4.14 0.31 18 -1.21 0.09 18 -1.51 0.02 16 4.82 0.44 18 -0.77 0.3 16 34.85 0.29 18 35.42 0.23 16 -5.2 0.16 37 4.2 -0.04 -2.21 0.32 -1.45 5.8 4.82 -0.83 -0.25 0.18 3.35 3.36 0.45 -0.02 0.11 -4.14 6.46 -1.21 -1.51 34.85 35.49 12.76 3.345 3.97 0.01 5.145 3.56 6.42 0.16 -5.965 3.42 3.24 0.08 34.96 28.89 0.38 0.07 0.18 -0.7 -0.13 7.14 -8.025 -1.99 -0.46 -4.835 11.7 -1.45 -0.02 2.22 2.91 3.42 0.03 21.48 34.51 0.13 -0.21 -0.16 -0.39 0.03 7.035",
  "TTGGA 5.42 0.44 24 13.68 0.31 22 -2.74 0.97 24 -1.29 0.09 24 -1.74 0.06 24 2.7 2.98 24 -1.03 1.24 24 34.57 0.66 24 33.66 0.42 24 -5.65 0.19 18 4.32 -0.04 -2.55 1.2 0.67 5.32 2.7 -1.03 -0.26 0.16 3.34 3.41 0.5 0.05 0.13 -2.74 6.18 -1.29 -1.74 34.57 33.66 13.89 -5.46 -2.12 6.86 1.595 4.21 5.93 -0.065 6.305 3.1 2.48 0 16.27 27.51 0.02 0.13 -0.1 -0.58 -0.115 6.875 -7.2 -1.98 0.56 -1.065 11 5.9 -0.045 2.36 2.96 3.52 0.025 23.39 31.9 0.1 -0.23 -0.14 -0.69 -0.005 7.32",
  "TTGGC 5.56 0.16 12 13.38 0.2 12 -3.85 0.59 12 -1.33 0.09 12 -1.75 0.05 12 4.45 0.72 12 -1.23 0.58 12 34.72 0.35 12 33 0.97 12 -5.24 0.13 10 4.2 -0.05 -2.56 0.44 -1.13 5.5 4.45 -1.23 -0.26 0.1 3.4 3.3 0.47 0.07 0.09 -3.85 6.74 -1.33 -1.75 34.72 33 13.47 -5.3 -2.12 0.26 -0.675 4.21 3.45 -0.05 2.455 3.1 3.37 0.045 16.27 32.46 0.02 -0.02 -0.1 -0.47 -0.125 6.925 -6.145 -1.98 -1.53 1.085 11 2.87 -0.035 2.615 2.96 3.48 0.035 23.39 35.96 0.1 -0.6 -0.14 -0.29 0.045 7.525",
  "TTGGG 5.44 0.38 28 13.82 0.49 20 -3.45 1.39 31 -1.51 0.19 31 -1.86 0.09 31 6.64 2.94 31 -0.64 1.97 31 34.28 0.81 31 32.76 1.13 31 -5.39 0.23 15 4.02 -0.05 -3.32 0.7 -0.56 5.34 6.64 -0.64 -0.27 0.2 3.54 3.33 0.43 0.12 0.04 -3.45 6.84 -1.51 -1.86 34.28 32.76 13.7 -3.69 -2.12 0.97 0.415 4.21 5.25 -0.015 2.28 3.1 3.42 0.015 16.27 30.63 0.02 -0.25 -0.1 -0.87 -0.095 7.12 -5.105 -1.98 -1 0.6 11 3.96 -0.03 2.545 2.96 3.45 0.035 23.39 34.1 0.1 -0.36 -0.14 -0.53 0 7.665",
  "TTGTC 5.57 0.3 9 12.96 0.41 9 -7.48 0.57 15 -1.19 0.13 15 -1.5 0.05 15 6.28 1.05 15 -1.95 0.65 15 34.98 0.39 15 33.76 0.26 15 -5.56 0.25 13 4.36 -0.04 -2.13 0.88 -5.54 5.7 6.28 -1.95 -0.27 0.32 3.42 3.32 0.51 -0.28 0.05 -7.48 6.42 -1.19 -1.5 34.98 33.76 12.92 -7.185 1.28 0.11 3.655 5.52 0.71 -0.07 5.785 3.49 3.23 -0.005 35.6 29.32 0.15 0.01 -0.55 -1.08 -0.12 6.315 -10.4 -1.94 -0.05 -6.005 12.12 -0.33 -0.025 2.625 3.2 3.36 0.03 26.37 31.44 0.15 -0.36 -0.32 -0.69 -0.035 6.645",
  "TTGTG 5.2 0.35 10 12.38 0.18 6 -8.23 0.9 14 -1.29 0.11 14 -1.46 0.04 14 6.07 0.76 14 -2.4 0.81 14 35.72 0.49 14 33.59 0.52 14 -5.43 0.27 10 4.4 -0.03 -1.98 0.73 -6.52 5.35 6.07 -2.4 -0.27 0.42 3.49 3.31 0.43 -0.35 0.03 -8.23 6.02 -1.29 -1.46 35.72 33.59 12.63 -3.095 1.28 -0.02 0.875 5.52 1.43 -0.075 5.545 3.49 3.22 0.005 35.6 28.74 0.15 -0.1 -0.55 -0.73 -0.095 6.34 -9.84 -1.94 0.59 -6.985 12.12 0.49 -0.025 2.605 3.2 3.28 0.03 26.37 30.57 0.15 -0.17 -0.32 -0.6 -0.06 6.79",
  "TTTAC 5.91 0.24 206 12.49 0.33 181 -11.89 0.62 208 -1.06 0.04 208 -1.24 0.09 208 -0.99 1.11 208 6.47 1.59 208 35.53 0.45 208 34.25 0.72 208 -7.24 0.28 178 4.23 -0.02 0.93 -1.47 -0.88 5.88 -0.99 6.47 -0.09 -1.2 3.17 3.3 0.23 0.12 -0.18 -11.89 6.68 -1.06 -1.24 35.53 34.25 12.58 -3.945 -0.07 -0.16 4.865 2.76 5.23 0.07 -3.65 3.06 3.46 0.035 32.53 36.67 -0.03 -0.11 -0.49 -0.24 -0.16 6.07 -9.455 -2.08 1.75 1.65 0.98 10.32 0.005 3.665 3.32 3.06 0.025 35.05 26.12 -0.44 0.12 -0.22 -0.16 0.025 6.62",
  "TTTAG 5.82 0.33 8 12.87 0.17 6 -11.18 0.74 9 -1.03 0.07 9 -1.33 0.05 8 -1.41 1.21 9 6.08 0.94 8 35.72 0.25 9 34.35 0.51 8 -6.93 0.43 7 4.11 -0.02 1.02 -1.3 -0.97 6.01 -1.41 6.5 -0.08 -1.01 3.15 3.36 0.29 0.13 -0.2 -11.18 5.89 -1.03 -1.33 35.72 34.22 13.32 -6.21 -0.07 0.18 2.89 2.76 1.49 0 1.8 3.06 3.26 0.055 32.53 34.85 -0.03 0.04 -0.49 -0.13 -0.17 5.84 -11.12 -2.08 -1.75 -0.25 0.98 11.34 0 4.165 3.32 3.04 0.025 35.05 24.59 -0.44 0.16 -0.22 -0.19 -0.065 6.62",
  "TTTCA 5.4 0.38 13 13.16 0.1 13 -10.81 0.18 13 -1.03 0.05 13 -1.44 0.07 13 -1.64 0.91 13 0.49 0.98 13 35.9 0.41 13 34.89 0.91 13 -7.56 0.34 11 4.38 -0.03 1.23 -2 -1.41 5.49 -1.64 0.49 -0.09 -1.24 3.16 3.33 0.26 0.32 -0.22 -10.81 6.33 -1.03 -1.44 35.9 34.89 13.16 -5.785 -1.76 -2.15 4.06 -1.32 3.57 0.01 5.145 1.86 1.72 -0.005 36.31 35.09 0.02 -0.98 -0.55 -1.41 -0.145 5.595 -10.805 -1.25 -0.97 3.99 1.83 2.44 0.04 2.43 3.27 3.4 0.03 32.4 34.98 -0.14 -0.42 -0.44 -0.2 -0.07 6.36",
  "TTTCC 4.63 0.23 24 13.83 0.4 12 -10.09 0.42 298 -1.07 0.07 298 -1.44 0.06 30 -3.36 1.17 298 -1.41 0.94 30 35.97 0.63 298 36.46 0.58 30 -8.22 0.24 249 4.46 -0.03 1.27 -1.83 -0.13 4.71 -3.36 -1 -0.08 -0.69 3.17 3.39 0.26 0.33 -0.26 -10.09 2.08 -1.07 -1.44 35.97 36.49 14.45 -3.655 -1.76 -0.78 5.27 -1.32 3.61 -0.01 6.02 1.86 3.33 -0.015 36.31 33.12 0.02 -0.18 -0.55 -0.66 -0.15 5.445 -11.425 -1.25 -0.52 1.77 1.83 3.33 0.04 2.155 3.27 3.27 0.02 32.4 33.83 -0.14 -0.21 -0.44 -0.27 -0.125 6.165",
  "TTTCG 4.98 0.21 24 13.11 0.19 20 -10.58 0.38 24 -1.09 0.04 24 -1.38 0.05 24 -2.61 0.93 24 -0.38 0.7 24 35.88 0.37 24 35.62 0.48 24 -8.32 0.33 50 4.55 -0.03 1.14 -1.5 -0.83 4.83 -2.61 -0.38 -0.1 -1.21 3.18 3.32 0.2 0.28 -0.22 -10.58 5.99 -1.09 -1.38 35.88 35.62 13.22 -4.04 -1.76 0.64 1.725 -1.32 4.33 -0.025 10.375 1.86 3.37 -0.01 36.31 33.2 0.02 0.12 -0.55 -0.59 -0.17 5.48 -10.015 -1.25 -0.77 6.025 1.83 2.23 0.03 2.44 3.27 3.42 0.035 32.4 35.44 -0.14 -0.48 -0.44 0 -0.035 6.56",
  "TTTGA 5.6 0.34 79 12.84 0.29 76 -10.28 0.69 79 -1.04 0.06 79 -1.16 0.12 79 -2.67 1.1 79 5.24 1.58 79 35.3 0.3 79 34.64 0.67 79 -7.57 0.28 63 4.31 -0.03 1.45 -2.03 -1.26 5.77 -2.67 5.24 -0.1 -1.59 3.14 3.39 0.18 0.45 -0.22 -10.28 6.34 -1.04 -1.16 35.3 34.64 12.99 -1.925 -0.39 0.6 -11.79 1.92 5.68 -0.245 14.49 3.28 3.98 -0.015 34.88 35.18 -0.07 -0.04 -0.43 0.4 -0.18 6.085 -9.605 -2.46 -0.64 0.63 0.84 12.51 -0.005 3.745 3.31 3.05 0.02 35.22 22.3 -0.5 0.08 -0.09 -0.12 -0.13 7.07",
  "TTTGC 5.41 0.26 14 13 0.33 9 -10.88 0.88 17 -1.08 0.1 17 -1.25 0.05 15 -3.68 1.21 17 3.96 1.28 15 35.29 1.29 17 34.35 0.5 15 -7.8 0.39 20 4.37 -0.03 1.36 -2.02 -1.9 5.11 -3.68 4.15 -0.1 -1.71 3.13 3.37 0.07 0.54 -0.24 -10.88 5.23 -1.08 -1.24 35.29 34.34 13.03 5.69 -0.39 3.97 -5.775 1.92 3.56 -0.125 8.645 3.28 3.42 -0.055 34.88 34.96 -0.07 0.38 -0.43 0.18 -0.12 6.09 -9.115 -2.46 -1.99 -1.975 0.84 11.7 0 3.79 3.31 2.91 0.025 35.22 21.48 -0.5 0.13 -0.09 -0.16 -0.115 7.19",
  "TTTGG 5.42 0.34 25 13.11 0.27 24 -9.32 0.59 25 -1.04 0.05 25 -1.3 0.08 25 -3.1 0.95 25 2.51 2.94 25 35.2 0.26 25 34.57 0.66 25 -7.64 0.18 20 4.3 -0.03 1.52 -2.58 0.22 5.51 -3.1 2.51 -0.09 -1.26 3.11 3.35 0.22 0.51 -0.23 -9.32 6.27 -1.04 -1.3 35.2 34.57 13.44 1.1 -0.39 -2.12 -8.85 1.92 4.21 -0.22 14.31 3.28 3.1 -0.04 34.88 16.27 -0.07 0.02 -0.43 -0.1 -0.125 6.23 -8.665 -2.46 -1.98 -0.42 0.84 11 -0.01 3.61 3.31 2.96 0.02 35.22 23.39 -0.5 0.1 -0.09 -0.14 -0.135 7.2",
  "TTTTC 4.35 0.52 30 13.02 0.13 9 -13.16 1.61 104 -1.05 0.1 104 -1.02 0.08 103 -4.32 1.79 104 -3.67 1.77 103 37 0.75 104 36.32 0.81 103 -9.65 0.85 94 4.71 -0.01 1.03 1.13 -6 4.29 -4.32 -3.68 -0.16 -2.28 3.23 3.17 0.12 0.3 -0.16 -13.16 4.32 -1.05 -1.02 37 36.33 13.19 1.715 -0.1 -1.76 -4.015 -1.96 -1.32 -0.26 19.89 3.21 1.86 -0.12 36.32 36.31 0.04 0.02 -0.74 -0.55 -0.125 4.425 -14.395 -0.79 -1.25 3.63 0.56 1.83 0.085 3.045 3.31 3.27 0.015 33.46 32.4 -0.11 -0.14 -0.64 -0.44 -0.05 5.495",
  "TTTTG 4.76 0.27 12 12.63 0.31 9 -13.79 1.07 27 -1.07 0.05 27 -1.01 0.06 27 -2.76 1.2 27 -2.19 1.23 27 36.92 0.42 27 35.51 0.54 27 -8.76 0.34 21 4.63 -0.03 1.01 1.53 -7.51 4.84 -2.76 -2.19 -0.15 -2.39 3.23 3.15 0.06 0.18 -0.11 -13.79 5.7 -1.07 -1.01 36.92 35.51 12.44 8.59 -0.1 -0.39 -14.355 -1.96 1.92 -0.44 25.96 3.21 3.28 -0.15 36.32 34.88 0.04 -0.07 -0.74 -0.43 -0.1 4.875 -12.515 -0.79 -2.46 5.615 0.56 0.84 0.09 3.375 3.31 3.31 0.015 33.46 35.22 -0.11 -0.5 -0.64 -0.09 -0.09 6",
  "AAAAM 4.51 0.53 27 12.15 0.3 23 -14.75 0.77 28 -0.99 0.06 27 -1 0.06 28 -1.92 1.43 27 -3.37 2.4 28 36.3 0.55 27 37.7 0.53 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAACM 4.56 0.32 20 12.75 0.41 17 -12.35 0.65 20 -1.17 0.04 20 -1.65 0.03 20 -2.26 1.18 20 -2.31 1.05 20 35.87 0.46 20 35.63 0.34 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAAGM 4.58 0.22 17 13.36 0.34 16 -10.48 0.63 17 -1.27 0.05 17 -1.78 0.04 17 -2.79 0.89 17 -2 0.94 17 35.68 0.44 17 32.97 0.3 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAATM 3.85 0.41 25 13.28 0.31 23 -11.25 0.74 25 -1.31 0.05 25 -1.62 0.04 25 -3.54 1.13 25 -6.19 1.09 25 36.63 0.7 25 33.59 0.43 25 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAAMQ 4.38 0.37 88 12.3 0.31 80 -13.26 0.76 88 -1 0.04 88 -1.41 0.05 88 -2.93 1.53 88 -5.27 0.99 88 37.27 0.52 88 34.38 0.44 88 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AACAM 5.39 0.18 12 12.03 0.38 12 -10.15 0.53 12 -1.49 0.03 12 -1.12 0.07 12 -1.68 0.45 12 5.03 0.55 12 34.21 0.34 12 36.16 0.4 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AACCM 4.02 0.19 17 13.84 0.41 17 -7.68 0.71 17 -1.63 0.04 17 -1.9 0.04 17 -3.69 0.68 17 -1.06 0.84 17 35.52 0.33 17 35.08 0.44 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AACGM 4.75 0.22 11 12.69 0.52 10 -10.06 0.43 11 -1.49 0.02 11 -1.64 0.08 11 -2.47 0.5 11 4.57 1.09 11 34.68 0.29 11 34.39 0.42 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AACTM 3.75 0.81 11 14.05 0.4 6 -4.85 1.22 11 -1.77 0.07 11 -1.81 0.05 11 -5.15 3.71 11 -4.52 4.32 11 36.15 0.91 11 32.04 1.74 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AACMQ 4.51 0.36 77 13.48 0.37 72 -5.84 0.92 78 -1.65 0.05 77 -1.72 0.08 78 -2.61 1.11 77 -4.1 1.72 78 35.44 0.49 77 32.73 0.67 78 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAGAM 4.7 0.22 12 13.48 0.45 11 -4.46 0.44 12 -1.71 0.04 12 -1.34 0.04 12 -1.4 1 12 -2.97 0.87 12 32.31 0.22 12 37.89 0.44 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAGCM 4.51 0.17 11 14.1 0.23 10 -1.39 0.23 11 -1.82 0.03 11 -1.73 0.02 11 -2.47 0.69 11 -2.87 0.56 11 32.01 0.21 11 37.7 0.39 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAGGM 4.49 0.15 12 14.41 0.28 9 -1.31 0.56 12 -1.85 0.04 12 -1.88 0.05 12 -2.81 0.41 12 -2.75 0.43 12 32.12 0.39 12 34.59 0.74 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAGTM 3.97 0.22 11 13.94 0.26 11 -4.45 0.33 11 -1.86 0.03 11 -1.7 0.02 11 -2.86 0.69 11 -4.77 0.56 11 33.01 0.38 11 35.73 0.26 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAGMQ 4.67 0.22 75 13.96 0.37 70 -1.88 0.45 76 -1.77 0.04 75 -1.74 0.05 76 -2.03 0.68 75 -4.88 0.77 76 32.63 0.36 75 34.84 0.4 76 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AATAM 5.38 0.29 11 12.77 0.25 11 -10.17 0.47 11 -1.53 0.04 11 -1.33 0.08 11 -4.02 0.8 11 5.46 1.43 11 32.46 0.39 11 35.32 1.55 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AATCM 4.07 0.38 12 14.08 0.33 11 -9.96 0.64 13 -1.59 0.04 12 -1.73 0.1 13 -5.71 0.96 12 -1.47 2.15 13 33.27 0.46 12 36.45 0.89 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AATGM 4.86 0.38 13 12.83 0.43 11 -10.23 0.5 13 -1.51 0.03 13 -1.48 0.11 13 -4.67 0.88 13 4.44 1.2 13 32.51 0.44 13 35.68 0.24 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AATTM 3.38 0.41 23 13.48 0.18 17 -12.17 0.51 23 -1.66 0.05 23 -1.32 0.04 23 -7.51 1.38 23 -4.81 1.04 23 34.32 0.6 23 36.58 0.37 23 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AATMQ 4.5 0.36 86 13.53 0.3 78 -8.49 0.56 86 -1.6 0.04 86 -1.34 0.05 86 -5.47 1.28 86 -3.8 0.79 86 33.17 0.51 86 35.07 0.39 86 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAMQA 4.53 0.23 110 12.55 0.25 107 -15.74 1.32 110 -1.4 0.02 110 -1.57 0.05 110 -4.59 0.49 110 12.23 0.65 110 33.8 0.36 110 35.82 0.34 110 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAMQC 4.54 0.23 126 12.87 0.37 122 -15.48 0.61 126 -1.41 0.03 126 -1.65 0.06 126 -4.79 0.62 126 10.21 0.94 126 33.84 0.4 126 35.07 0.54 126 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAMQG 4.59 0.2 122 13.01 0.29 118 -15.15 0.65 123 -1.41 0.03 122 -1.63 0.04 123 -4.66 0.45 122 9.69 0.78 123 33.68 0.3 122 35.11 0.41 123 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAMQT 3.94 0.32 106 12.31 0.43 103 -16.21 0.92 106 -1.42 0.05 106 -1.69 0.05 106 -5.47 0.92 106 11.25 1.4 106 34.25 0.48 106 36.58 0.57 106 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AAMQM 4.6 0.23 17 12.31 0.47 17 -16.31 0.78 17 -1.38 0.05 17 -1.57 0.07 17 -4.27 0.82 17 11.47 1.07 17 33.62 0.46 17 36.05 0.61 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACAAM 5.62 0.16 8 12.43 0.3 8 -11.53 0.45 8 -1.12 0.08 8 -1.02 0.03 8 6.09 0.6 8 -3 0.51 8 34.67 0.43 8 35.97 0.33 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACACM 5.35 0.11 7 13.06 0.56 7 -8.3 0.34 7 -1.38 0.06 7 -1.6 0.06 7 4.66 0.66 7 -2.34 0.46 7 34.65 0.49 7 34.27 0.24 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACAGM 5.48 0.07 7 13.19 0.25 6 -7.41 0.18 7 -1.44 0.04 7 -1.68 0.02 7 5.35 0.31 7 -1.78 0.2 7 34.5 0.21 7 31.7 0.23 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACATM 4.85 0.26 8 13.28 0.39 8 -8.02 0.6 8 -1.57 0.09 8 -1.53 0.03 8 4.86 0.95 8 -4.99 0.69 8 35.39 0.46 8 32.45 0.27 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACAMQ 5.53 0.17 60 12.12 0.44 56 -9.69 0.54 60 -1.07 0.07 60 -1.33 0.03 60 4.43 0.73 60 -4.23 0.54 60 36.04 0.45 60 32.89 0.28 60 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACCAM 5.51 0.13 7 12.96 0.36 7 -5.3 0.73 7 -1.7 0.06 7 -1.23 0.04 7 -0.07 0.43 7 3.05 0.87 7 33.99 0.45 7 35.2 0.29 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACCCM 4.44 0.12 8 14.69 0.19 6 -2.52 0.53 9 -1.87 0.05 8 -1.92 0.05 9 -1.33 0.62 8 -2.35 0.64 9 34.5 0.39 8 33.72 0.37 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACCGM 5.14 0.12 7 13.41 0.28 7 -4.32 0.2 7 -1.75 0.02 7 -1.6 0.04 7 -0.66 0.53 7 2.23 0.52 7 34.11 0.38 7 33 0.21 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACCTM 4.24 0.33 7 14.49 0.23 7 -1.1 0.43 7 -1.95 0.04 7 -1.86 0.03 7 -1.76 0.65 7 -4 0.65 7 34.96 0.47 7 32.07 0.52 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACCMQ 4.68 0.19 65 14.18 0.38 58 -1.31 0.57 66 -1.88 0.04 65 -1.81 0.05 66 -1.04 0.67 65 -5.03 0.77 66 34.88 0.4 65 31.83 0.38 66 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACGAM 5.15 0.42 7 12.71 0.95 7 -7.01 0.59 7 -1.61 0.11 7 -1.29 0.09 7 4.57 2.79 7 -1.81 1.78 7 33.27 1.09 7 36.27 0.88 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACGCM 5.05 0.17 7 13.24 0.33 7 -3.81 0.28 7 -1.69 0.06 7 -1.6 0.04 7 4.09 0.68 7 -1.71 0.48 7 32.73 0.37 7 36.76 0.4 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACGGM 5.1 0.11 7 13.41 0.26 7 -3.8 0.39 7 -1.66 0.06 7 -1.71 0.04 7 3.84 0.45 7 -1.64 0.48 7 33.12 0.32 7 34.01 0.36 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACGTM 4.63 0.14 7 12.99 0.22 7 -8.06 0.26 7 -1.75 0.04 7 -1.51 0.01 7 5.03 0.63 7 -3.39 0.32 7 34.02 0.21 7 34.79 0.24 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACGMQ 5.16 0.28 57 12.88 0.52 54 -4.1 0.53 57 -1.58 0.08 57 -1.55 0.08 57 4.28 0.78 57 -3.91 1.31 57 34.15 0.54 57 34.09 0.56 57 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACTAM 5.66 0.21 7 12.99 0.41 7 -8.4 0.45 7 -1.7 0.05 7 -1.35 0.08 7 -1.1 0.82 7 4.98 1.21 7 31.59 0.2 7 35.09 0.47 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACTCM 4.83 0.2 10 14.37 0.21 8 -7.67 0.5 10 -1.81 0.04 10 -1.65 0.05 10 -1.6 1.06 10 -0.81 0.91 10 31.82 0.29 10 35.59 0.49 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACTGM 5.52 0.08 8 13.04 0.31 7 -8.05 0.62 8 -1.69 0.03 8 -1.39 0.04 8 -0.97 0.59 8 4.31 0.68 8 31.42 0.3 8 34.73 0.13 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACTTM 4.09 0.31 8 13.8 0.34 6 -9.94 0.65 9 -1.88 0.07 8 -1.31 0.05 9 -3.58 1.74 8 -4.92 1.08 9 33.48 0.44 8 35.5 0.3 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACTMQ 4.81 0.4 61 13.92 0.3 55 -6.95 0.64 61 -1.8 0.06 61 -1.36 0.08 61 -3.1 2.02 61 -4.37 1.97 61 32.29 0.82 61 34.24 0.81 61 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACMQA 5.17 0.18 148 13.73 0.31 142 -9.9 0.6 148 -1.72 0.08 148 -1.52 0.05 148 -3.62 0.73 148 10.03 0.84 148 32.31 0.57 148 34.33 0.37 148 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACMQC 5.14 0.28 162 13.95 0.37 148 -9.67 0.73 162 -1.72 0.07 162 -1.59 0.06 162 -3.75 1.22 162 8.31 0.88 162 32.3 0.59 162 33.79 0.45 162 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACMQG 5.14 0.33 157 14.09 0.24 142 -9.36 0.88 157 -1.72 0.07 157 -1.58 0.08 157 -3.79 0.97 157 7.69 1.55 157 32.28 0.49 157 33.77 0.75 157 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACMQT 4.83 0.2 137 13.4 0.37 130 -9.94 0.56 137 -1.7 0.06 137 -1.62 0.04 137 -3.92 0.55 137 9.56 0.76 137 32.58 0.45 137 34.93 0.44 137 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ACMQM 5.25 0.11 27 13.54 0.4 23 -10.08 0.54 27 -1.69 0.05 27 -1.51 0.06 27 -3.34 0.45 27 8.88 0.7 27 32.25 0.24 27 34.44 0.7 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGAAM 5.08 0.29 9 13.51 0.38 9 -10.4 0.56 9 -1.48 0.09 9 -1.02 0.02 9 -0.27 1.2 9 -2.79 1.37 9 35.85 0.75 9 36.21 0.86 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGACM 4.79 0.25 10 14.19 0.13 7 -7.86 0.31 10 -1.58 0.03 10 -1.65 0.02 10 -1.88 2.07 10 -2.66 0.5 10 35.9 0.66 10 34.78 0.12 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGAGM 5.01 0.09 9 14.45 0.12 7 -7.08 0.33 9 -1.63 0.03 9 -1.76 0.03 9 -0.92 0.46 9 -2.1 0.38 9 35.77 0.26 9 31.94 0.3 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGATM 4.5 0.26 10 14.39 0.18 8 -7.8 0.52 10 -1.74 0.05 10 -1.57 0.03 10 -1.11 0.98 10 -5.11 0.72 10 36.43 0.66 10 32.8 0.31 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGAMQ 4.85 0.18 59 13.59 0.31 54 -8.35 0.46 59 -1.33 0.05 59 -1.45 0.03 59 -2.29 0.71 59 -5.16 0.48 59 37.38 0.54 59 33.24 0.23 59 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGCAM 5.7 0.15 10 13.06 0.25 10 -4.21 0.33 10 -1.59 0.03 10 -1.2 0.04 10 -1.02 0.57 10 3.01 0.65 10 36.2 0.28 10 35.1 0.36 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGCCM 4.67 0.08 10 14.64 0.22 7 -2.63 0.38 10 -1.7 0.03 10 -1.87 0.02 10 -2.39 0.43 10 -1.6 0.43 10 37.25 0.3 10 33.74 0.22 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGCGM 5.27 0.15 10 13.53 0.64 10 -3.92 0.54 10 -1.64 0.05 10 -1.58 0.07 10 -1.99 1.01 10 2.88 0.53 10 36.63 0.53 10 32.92 0.73 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGCTM 4.58 0.19 10 14.56 0.26 9 -1.1 0.25 10 -1.79 0.03 10 -1.81 0.03 10 -3.01 0.69 10 -3.39 0.71 10 37.63 0.25 10 31.66 0.33 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGCMQ 4.9 0.18 62 14.25 0.3 50 -0.92 0.51 62 -1.72 0.04 62 -1.78 0.06 62 -2.25 0.96 62 -4.48 0.47 62 37.5 0.42 62 31.54 0.54 62 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGGAM 4.82 0.11 8 14.13 0.38 5 -5.73 0.54 9 -1.83 0.02 8 -1.32 0.03 9 -0.77 0.44 8 -2.77 0.41 9 34.34 0.3 8 36.94 0.42 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGGCM 4.64 0.13 8 14.69 0.32 7 -2.37 0.25 9 -1.92 0.03 8 -1.67 0.02 9 -1.74 0.72 8 -2.34 0.39 9 33.75 0.3 8 37.15 0.13 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGGGM 4.72 0.18 10 14.62 0.12 8 -2.33 0.3 11 -1.92 0.03 10 -1.81 0.05 11 -1.96 0.96 10 -2.01 0.55 11 33.9 0.41 10 33.93 0.46 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGGTM 4.28 0.24 8 14.17 0.64 8 -6.03 0.47 9 -1.94 0.03 8 -1.59 0.03 9 -1.56 1.23 8 -3.8 0.84 9 34.97 0.4 8 34.98 0.2 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGGMQ 4.69 0.24 61 14.54 0.3 51 -2.48 0.43 62 -1.87 0.04 61 -1.7 0.06 62 -2.08 0.74 61 -4.97 1.77 62 34.46 0.55 61 34.35 0.68 62 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGTAM 5.71 0.18 12 13.12 0.31 11 -8.5 0.41 12 -1.61 0.02 12 -1.28 0.04 12 -2.24 0.6 12 3.97 1.03 12 34.5 0.21 12 35.09 0.42 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGTCM 4.67 0.23 10 14.44 0.13 9 -7.81 0.41 10 -1.74 0.04 10 -1.59 0.06 10 -3.65 1.08 10 -1.57 0.97 10 34.99 0.36 10 35.42 0.55 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGTGM 5.49 0.16 10 13.21 0.28 10 -8.03 0.34 10 -1.6 0.04 10 -1.31 0.04 10 -2.61 0.59 10 3.18 0.65 10 34.43 0.25 10 34.8 0.28 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGTTM 4.45 0.12 10 13.61 0.22 10 -11.09 0.42 10 -1.74 0.03 10 -1.24 0.03 10 -3.71 0.57 10 -3.69 0.32 10 35.84 0.19 10 35.33 0.28 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGTMQ 4.91 0.19 64 13.86 0.33 59 -7.18 0.38 64 -1.68 0.04 64 -1.32 0.04 64 -3.82 0.73 64 -4.28 0.42 64 35.34 0.36 64 34.14 0.29 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGMQA 5.09 0.15 157 14.01 0.29 143 -8.79 0.42 158 -1.73 0.04 157 -1.56 0.05 158 -4.24 0.51 157 9.71 0.68 158 34.5 0.27 157 33.99 0.34 158 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGMQC 5.08 0.2 164 14.22 0.31 148 -8.65 0.39 165 -1.73 0.04 165 -1.62 0.07 164 -4.24 0.51 165 8.03 1.46 164 34.54 0.32 165 33.38 0.53 164 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGMQG 5.1 0.16 159 14.31 0.29 140 -8.53 0.57 163 -1.73 0.06 161 -1.61 0.05 161 -4.16 0.64 161 7.73 0.81 161 34.37 0.46 161 33.46 0.48 161 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGMQT 4.72 0.2 145 13.72 0.41 135 -8.91 0.46 145 -1.74 0.05 145 -1.66 0.05 145 -4.8 1.26 145 9.32 0.92 145 34.76 0.39 145 34.54 0.39 145 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AGMQM 5.15 0.12 29 13.91 0.4 23 -8.96 0.43 29 -1.71 0.03 29 -1.56 0.04 29 -3.91 0.49 29 8.41 0.75 29 34.28 0.3 29 34.17 0.42 29 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATAAM 5.86 0.19 12 12.66 0.31 11 -11.11 0.49 12 -1.27 0.1 12 -0.99 0.04 12 6.94 1.06 12 -2.56 0.67 12 34.22 0.44 12 36.44 0.28 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATACM 5.59 0.26 14 13.12 0.39 11 -8.2 0.58 14 -1.46 0.05 14 -1.61 0.03 14 6.17 1.31 14 -1.95 0.65 14 34.36 0.64 14 34.68 0.21 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATAGM 5.7 0.11 13 13.47 0.33 9 -7.43 0.44 13 -1.5 0.03 13 -1.72 0.04 13 6.43 0.73 13 -1.59 0.56 13 34.44 0.34 13 31.78 0.32 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATATM 5.22 0.38 12 13.34 0.39 12 -7.78 0.69 12 -1.56 0.06 12 -1.56 0.04 12 6.43 1.54 12 -4.53 1.04 12 35.18 0.37 12 32.58 0.25 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATAMQ 5.68 0.24 75 12.65 0.42 67 -8.85 0.8 75 -1.29 0.07 75 -1.44 0.05 75 5.34 1.12 75 -4.24 0.65 75 35.24 0.86 75 33.07 0.31 75 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATCAM 5.8 0.25 14 13 0.35 14 -7.09 0.62 14 -1.52 0.06 14 -1.11 0.12 14 -0.21 1.12 14 4.13 0.77 14 35.11 0.65 14 35.16 1.24 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATCCM 4.64 0.12 12 14.49 0.21 9 -5.08 0.51 12 -1.58 0.04 12 -1.88 0.03 12 -1.14 0.62 12 -1.02 0.5 12 36.25 0.4 12 34.23 0.35 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATCGM 5.35 0.16 11 13.29 0.31 10 -7 0.46 11 -1.49 0.04 11 -1.53 0.06 11 -0.46 0.65 11 4.21 0.63 11 35.48 0.4 11 33.66 0.39 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATCTM 4.38 0.57 15 14.3 0.2 9 -2.57 1.39 15 -1.7 0.06 15 -1.79 0.06 15 -2.41 3.44 15 -3.92 2.06 15 36.86 1.01 15 31.66 1.34 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATCMQ 4.87 0.44 79 14.13 0.31 66 -2.8 1.28 79 -1.67 0.07 79 -1.76 0.09 79 -0.64 1.89 79 -4.35 1.59 79 36.3 0.82 79 31.98 0.86 79 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATGAM 5.63 0.12 13 13.05 0.47 12 -6.76 0.47 13 -1.33 0.06 13 -1.31 0.05 13 5.99 0.97 13 -1.7 0.44 13 34.8 0.38 13 36.14 0.37 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATGCM 5.28 0.17 15 13.46 0.29 12 -3.57 0.27 15 -1.48 0.07 15 -1.62 0.03 15 4.25 0.62 15 -1.63 0.44 15 34.55 0.33 15 36.75 0.21 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATGGM 5.06 0.69 15 13.49 0.36 12 -3.43 1.47 16 -1.5 0.07 15 -1.73 0.06 16 2.57 5.8 15 -2.18 1.99 16 34.55 0.93 15 34.22 0.63 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATGTM 4.96 0.17 15 13.09 0.25 13 -7.53 0.23 15 -1.49 0.05 15 -1.53 0.02 15 5.27 0.54 15 -3.17 0.42 15 35.6 0.35 15 34.68 0.23 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATGMQ 5.44 0.32 77 12.98 0.39 72 -3.91 0.39 77 -1.38 0.09 77 -1.58 0.08 77 4.49 0.9 77 -3.63 1.88 77 35.5 0.5 77 33.97 0.46 77 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATTAM 5.6 0.32 15 12.78 0.33 15 -11.77 0.56 15 -1.2 0.04 15 -1.27 0.05 15 -2.09 1.16 15 5.85 1.49 15 35.51 0.45 15 35.13 0.62 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATTCM 4.7 0.13 14 13.82 0.33 14 -10.9 0.59 14 -1.23 0.05 14 -1.59 0.05 14 -2.47 0.92 14 0.28 0.6 14 35.91 0.33 14 36.03 0.42 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATTGM 5.4 0.15 15 12.79 0.17 14 -11.23 0.34 15 -1.16 0.03 15 -1.26 0.06 15 -2.3 0.62 15 5.12 0.63 15 35.29 0.29 15 35.33 0.26 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATTTM 4.02 0.38 24 13.09 0.29 23 -13.43 0.51 24 -1.27 0.04 24 -1.14 0.04 24 -4.33 1.41 24 -3.82 1.27 24 37.41 0.51 24 36.3 0.57 24 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATTMQ 4.74 0.27 93 13.5 0.25 88 -9.59 0.42 93 -1.29 0.05 93 -1.24 0.04 93 -3.74 1.03 93 -3.49 0.63 93 36.09 0.5 93 34.84 0.28 93 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATMQA 5.28 0.16 112 13.45 0.22 107 -13.26 0.49 112 -1.35 0.05 112 -1.49 0.05 112 -3.31 0.39 112 12.19 0.52 112 34.5 0.49 112 34.84 0.31 112 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATMQC 5.27 0.15 128 13.69 0.33 117 -12.9 0.56 128 -1.34 0.04 128 -1.55 0.06 128 -3.42 0.5 128 10.22 0.89 128 34.58 0.39 128 34.19 0.45 128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATMQG 5.29 0.18 125 13.79 0.29 110 -12.88 0.52 125 -1.34 0.05 125 -1.55 0.04 125 -3.38 0.6 125 9.96 0.78 125 34.44 0.43 125 34.22 0.4 125 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATMQT 4.93 0.21 103 13.05 0.35 99 -13.36 0.63 105 -1.33 0.04 104 -1.59 0.04 104 -3.85 0.62 104 11.81 0.83 104 34.8 0.39 104 35.55 0.45 104 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "ATMQM 5.38 0.09 19 13.24 0.31 17 -13.65 0.56 19 -1.33 0.07 19 -1.48 0.04 19 -2.91 0.38 19 11.33 0.69 19 34.09 0.62 19 35.31 0.52 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQAA 5.3 0.22 126 12.85 0.36 124 -12.21 1.3 126 -1.49 0.05 126 -1.18 0.06 126 11.71 0.86 126 -3.39 0.69 126 35.53 0.64 126 34.8 0.63 126 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQAC 5.26 0.14 128 12.87 0.34 123 -12.48 0.46 128 -1.5 0.05 128 -1.25 0.05 128 11.73 0.75 128 -4.15 0.39 128 35.55 0.46 128 34.44 0.36 128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQAG 5.12 0.15 74 13.08 0.35 72 -12.47 0.62 74 -1.56 0.04 74 -1.34 0.04 74 11.72 0.7 74 -4.16 0.53 74 35.44 0.43 74 34.26 0.45 74 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQAM 5.31 0.16 13 12.84 0.37 10 -12.34 0.38 13 -1.49 0.06 13 -1.19 0.04 13 11.83 0.82 13 -4.24 0.47 13 35.29 0.33 13 35.13 0.24 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQCA 5.28 0.21 74 12.71 0.41 71 -9.27 0.42 74 -1.54 0.05 74 -1.53 0.06 74 10.21 0.77 74 -3.14 0.58 74 35.29 0.53 74 33.96 0.3 74 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQCC 4.91 0.16 113 13.71 0.41 101 -8.52 0.52 113 -1.61 0.05 113 -1.66 0.05 113 9.41 0.7 113 -4.42 0.5 113 34.47 0.45 113 34.5 0.37 113 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQCG 5.13 0.31 151 12.54 0.38 143 -9.46 0.74 151 -1.57 0.08 151 -1.54 0.07 151 10.23 1.94 151 -3.45 0.67 151 35.02 0.66 151 34.01 0.38 151 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQCM 4.85 0.11 12 13.57 0.44 12 -9.05 0.47 12 -1.66 0.07 12 -1.65 0.03 12 9.46 0.63 12 -4.21 0.56 12 34.38 0.84 12 34.99 0.33 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQGA 5.08 0.17 114 13.56 0.36 106 -8.4 0.56 115 -1.57 0.05 114 -1.67 0.06 115 9.15 0.77 114 -3.91 0.57 115 34.93 0.46 114 32.33 0.26 115 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQGC 5.11 0.13 93 13.53 0.38 89 -8.48 0.54 93 -1.59 0.05 93 -1.72 0.06 93 9.33 0.84 93 -4.33 0.65 93 34.85 0.47 93 31.87 0.31 93 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQGG 5.02 0.16 100 13.67 0.36 94 -7.62 0.57 101 -1.59 0.05 101 -1.79 0.05 100 9 0.79 101 -4.92 0.58 100 34.57 0.41 101 31.99 0.33 100 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQGM 5.15 0.13 13 13.53 0.38 12 -8.83 0.36 13 -1.57 0.06 13 -1.69 0.05 13 9.67 0.76 13 -4.23 0.33 13 34.69 0.63 13 32.4 0.19 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQTA 4.79 0.34 93 12.54 0.45 86 -12.85 0.77 93 -1.62 0.06 93 -1.42 0.05 93 10.86 1.23 93 -4.45 0.78 93 36.16 0.62 93 32.98 0.46 93 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQTC 4.49 0.24 117 12.96 0.54 115 -13.36 0.81 118 -1.66 0.06 117 -1.44 0.03 118 10.8 1.16 117 -5.17 0.76 118 35.93 0.74 117 33.3 0.36 118 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQTG 4.78 0.31 80 12.01 0.45 78 -14.23 0.96 84 -1.62 0.07 81 -1.34 0.04 83 11.79 1.28 81 -4.35 0.51 83 36.44 0.9 81 32.73 0.37 83 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQTM 4.38 0.21 13 13.01 0.34 13 -13.17 0.49 13 -1.67 0.05 13 -1.46 0.03 13 10.27 0.94 13 -5.67 0.53 13 36.18 0.33 13 33.66 0.23 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "AMQMQ 5.23 0.2 72 12.35 0.77 70 -9.16 0.62 72 -1.52 0.06 72 -1.51 0.09 72 10.76 1.11 72 -5.25 0.92 72 35.87 0.64 72 32.49 0.38 72 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAAAM 5.06 0.23 7 12.17 0.59 6 -13.48 1.18 8 -0.99 0.06 7 -0.99 0.02 8 -1.55 1.53 7 -2.71 1.16 8 34.98 0.53 7 37.32 0.55 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAACM 4.96 0.17 7 13.05 0.13 6 -10.49 0.42 7 -1.17 0.03 7 -1.64 0.02 7 -2.77 0.56 7 -2.39 0.57 7 34.49 0.24 7 35.43 0.38 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAAGM 5.09 0.1 7 13.34 0.18 6 -9.09 0.28 7 -1.23 0.03 7 -1.74 0.04 7 -2.52 0.34 7 -1.57 0.34 7 34.3 0.21 7 32.59 0.21 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAATM 4.73 0.17 10 13.31 0.22 9 -9.6 0.32 10 -1.23 0.03 10 -1.57 0.02 10 -2.52 0.62 10 -4.66 0.55 10 35.02 0.29 10 32.95 0.23 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAAMQ 5.01 0.15 70 12.43 0.32 62 -11.88 0.55 70 -1.01 0.03 70 -1.41 0.03 70 -2.76 0.52 70 -4.67 0.6 70 35.84 0.26 70 33.9 0.35 70 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CACAM 5.89 0.14 9 11.96 0.3 9 -8.31 0.24 9 -1.39 0.03 9 -1.03 0.07 9 -1.32 0.37 9 4.62 0.71 9 32.92 0.11 9 36.36 0.31 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CACCM 4.63 0.08 9 13.84 0.12 9 -6.07 0.15 9 -1.55 0.02 9 -1.85 0.02 9 -2.94 0.35 9 -0.83 0.18 9 34.19 0.15 9 34.97 0.18 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CACGM 5.42 0.15 9 12.41 0.29 7 -8.11 0.45 9 -1.43 0.03 9 -1.51 0.05 9 -1.84 0.43 9 4.86 0.75 9 33.45 0.16 9 34.43 0.36 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CACTM 4.67 0.25 9 13.74 0.21 7 -3.87 0.37 9 -1.66 0.05 9 -1.77 0.03 9 -2.97 0.59 9 -2.55 0.58 9 34.48 0.33 9 32.34 0.36 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CACMQ 5.09 0.16 64 13.32 0.35 59 -4.35 0.49 64 -1.56 0.04 64 -1.67 0.06 64 -2.07 0.57 64 -3.42 0.66 64 34.19 0.24 64 32.56 0.37 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAGAM 5.39 0.16 9 13.39 0.18 7 -3.89 0.32 9 -1.6 0.03 9 -1.34 0.04 9 -0.88 0.34 9 -1.62 0.46 9 30.92 0.26 9 37.08 0.38 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAGCM 4.99 0.15 9 13.77 0.29 9 -1.19 0.27 9 -1.71 0.02 9 -1.7 0.04 9 -2.13 0.51 9 -1.98 0.53 9 30.94 0.29 9 37.53 0.43 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAGGM 4.98 0.11 9 14.11 0.23 8 -1.18 0.42 9 -1.75 0.03 9 -1.85 0.04 9 -2.33 0.52 9 -1.94 0.51 9 31.02 0.11 9 34.52 0.36 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAGTM 4.76 0.17 10 13.75 0.37 9 -4.04 0.47 10 -1.72 0.04 10 -1.66 0.04 10 -1.79 0.68 10 -3.38 0.52 10 31.57 0.26 10 35.29 0.2 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAGMQ 5.11 0.16 67 13.72 0.34 63 -1.64 0.38 67 -1.67 0.04 67 -1.72 0.05 67 -1.91 0.64 67 -4.1 0.63 67 31.53 0.27 67 34.49 0.57 67 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CATAM 5.93 0.24 11 12.35 0.3 11 -9 0.28 11 -1.43 0.03 11 -1.27 0.07 11 -2.95 0.64 11 5.56 0.93 11 31.46 0.31 11 35.39 0.53 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CATCM 4.85 0.13 10 13.68 0.17 8 -8.76 0.59 11 -1.48 0.02 10 -1.62 0.04 11 -4.15 0.27 10 -0.08 0.39 11 32.17 0.2 10 36.32 0.45 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CATGM 5.61 0.12 11 12.43 0.46 11 -8.83 0.45 11 -1.41 0.03 11 -1.32 0.06 11 -3.36 0.51 11 4.69 0.82 11 31.28 0.17 11 35.71 0.33 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CATTM 4.39 0.32 12 13.39 0.33 10 -10.77 0.28 12 -1.55 0.07 12 -1.26 0.05 12 -5.44 1.24 12 -3.56 1.07 12 32.85 0.52 12 35.85 0.75 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CATMQ 5.13 0.17 69 13.23 0.28 67 -7.2 0.34 69 -1.5 0.03 69 -1.31 0.03 69 -4.19 0.62 69 -3.23 0.51 69 32.08 0.28 69 34.65 0.31 69 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAMQA 5.19 0.19 88 12.4 0.27 86 -13.56 0.81 89 -1.35 0.03 88 -1.49 0.06 89 -3.96 0.45 88 12.03 0.69 89 32.46 0.26 88 35.77 0.6 89 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAMQC 5.18 0.15 100 12.72 0.37 94 -13.22 0.69 101 -1.36 0.03 101 -1.57 0.06 100 -4.14 0.46 101 10.07 0.75 100 32.56 0.26 101 34.92 0.46 100 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAMQG 5.19 0.16 81 12.85 0.27 77 -12.97 0.78 81 -1.36 0.04 81 -1.57 0.04 81 -4.01 0.57 81 9.59 0.68 81 32.4 0.36 81 35 0.46 81 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CAMQM 5.29 0.12 11 12.22 0.51 9 -13.89 0.88 11 -1.32 0.04 11 -1.48 0.04 11 -3.6 0.48 11 11.19 1 11 32.2 0.21 11 36.13 0.67 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCAAM 5.67 0.11 8 12.82 0.08 8 -10.05 0.17 8 -1.19 0.03 8 -1.02 0.02 8 4.11 0.24 8 -2.88 0.46 8 34.43 0.29 8 35.7 0.14 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCACM 5.49 0.11 8 13.37 0.25 8 -7.1 0.23 8 -1.38 0.03 8 -1.54 0.03 8 2.83 0.38 8 -2.19 0.34 8 34.21 0.28 8 34.21 0.21 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCAGM 5.64 0.23 8 13.72 0.44 7 -6.16 0.63 8 -1.46 0.03 8 -1.66 0.02 8 3.19 1.15 8 -2.02 0.88 8 34.06 0.36 8 31.37 0.26 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCATM 5.28 0.11 9 13.61 0.37 9 -6.93 0.48 9 -1.55 0.08 9 -1.5 0.04 9 3.47 0.4 9 -4.33 0.6 9 34.51 0.77 9 32.12 0.26 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCAMQ 5.71 0.14 57 12.53 0.35 51 -7.59 0.42 57 -1.19 0.06 57 -1.36 0.03 57 2.88 0.89 57 -4.17 0.45 57 35.29 0.44 57 32.39 0.19 57 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCCAM 5.71 0.12 10 13.29 0.4 9 -3.29 0.45 10 -1.74 0.05 10 -1.18 0.07 10 -1.42 0.56 10 2.32 0.6 10 33.08 0.34 10 35.2 0.33 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCCCM 4.81 0.08 8 14.95 0.15 8 -1.32 0.32 8 -1.88 0.02 8 -1.91 0.03 8 -1.98 0.66 8 -1.9 0.53 8 33.34 0.24 8 33.57 0.24 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCCGM 5.44 0.1 8 13.53 0.28 8 -3.04 0.63 8 -1.75 0.03 8 -1.51 0.04 8 -1.49 0.46 8 2.34 0.69 8 33.14 0.28 8 33.34 0.34 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCCTM 4.73 0.17 8 14.7 0.24 7 -0.17 0.4 8 -1.93 0.03 8 -1.83 0.02 8 -2.3 0.56 8 -3.38 0.59 8 33.92 0.3 8 31.79 0.17 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCCMQ 4.97 0.13 55 14.58 0.28 48 0.08 0.38 55 -1.9 0.04 55 -1.81 0.04 55 -1.99 0.57 55 -4.89 0.5 55 33.81 0.31 55 31.67 0.22 55 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCGAM 5.58 0.12 8 13.3 0.29 8 -7.03 0.79 8 -1.57 0.15 8 -1.27 0.04 8 4.62 0.92 8 -2.04 1.07 8 31.74 1.92 8 36.56 0.74 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCGCM 5.18 0.17 8 13.89 0.21 8 -3.31 0.32 8 -1.66 0.04 8 -1.6 0.03 8 1.59 0.68 8 -1.77 0.59 8 32.26 0.15 8 36.55 0.26 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCGGM 5.33 0.13 8 13.81 0.31 7 -3.64 0.49 8 -1.61 0.05 8 -1.68 0.07 8 1.84 0.8 8 -1.48 0.58 8 32.5 0.33 8 33.89 0.56 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCGTM 5.06 0.1 8 13.24 0.19 8 -7.7 0.21 8 -1.68 0.03 8 -1.5 0.02 8 3.8 0.6 8 -2.71 0.4 8 33.2 0.27 8 34.45 0.19 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCGMQ 5.5 0.15 48 13.14 0.28 47 -3.77 0.27 48 -1.54 0.05 48 -1.54 0.04 48 2.58 0.64 48 -3.23 0.42 48 33.19 0.28 48 33.77 0.23 48 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCTAM 5.81 0.13 8 13.45 0.21 7 -6.87 0.56 8 -1.76 0.03 8 -1.31 0.04 8 -2.2 0.71 8 4.06 1.01 8 31.32 0.24 8 34.87 0.47 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCTCM 5.05 0.12 9 14.49 0.14 8 -6.38 0.22 9 -1.82 0.02 9 -1.62 0.05 9 -2.23 0.56 9 -0.85 0.54 9 31.48 0.14 9 35.43 0.47 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCTGM 5.69 0.09 9 13.35 0.21 9 -6.42 0.45 9 -1.72 0.02 9 -1.35 0.04 9 -2.07 0.69 9 3.6 0.75 9 31.15 0.16 9 34.68 0.25 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCTTM 4.69 0.12 8 13.99 0.18 6 -8.54 0.43 8 -1.87 0.05 8 -1.31 0.03 8 -2.94 0.71 8 -3.91 0.54 8 32.22 0.34 8 35.16 0.28 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCTMQ 5.12 0.14 54 14.05 0.27 46 -5.64 0.49 54 -1.83 0.03 54 -1.38 0.04 54 -3.37 0.67 54 -4.01 0.48 54 31.85 0.3 54 33.88 0.39 54 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCMQA 5.36 0.14 119 13.97 0.24 111 -7.6 0.46 120 -1.79 0.05 119 -1.48 0.05 120 -4.52 0.59 119 9.42 0.59 120 31.77 0.29 119 33.96 0.31 120 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCMQC 5.34 0.13 124 14.18 0.29 106 -7.38 0.55 125 -1.8 0.04 124 -1.54 0.07 125 -4.62 0.51 124 7.68 0.85 125 31.75 0.28 124 33.48 0.59 125 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCMQG 5.32 0.13 113 14.28 0.28 96 -7.29 0.43 116 -1.79 0.04 114 -1.53 0.05 115 -4.61 0.48 114 7.31 0.69 115 31.66 0.27 114 33.58 0.31 115 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CCMQM 5.37 0.1 16 13.92 0.28 14 -7.97 0.99 16 -1.78 0.09 16 -1.49 0.04 16 -4.3 0.37 16 8.11 0.56 16 31.52 0.95 16 34.24 0.54 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGAAM 5.29 0.13 39 12.96 0.19 36 -10.73 0.93 186 -1.34 0.05 39 -1.02 0.04 186 0.09 0.36 39 -2.58 0.54 186 35.02 0.37 39 36.38 0.44 186 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGACM 5.17 0.13 39 13.47 0.29 35 -8.08 0.29 353 -1.42 0.05 39 -1.62 0.04 353 -0.96 0.47 39 -2.15 0.62 353 35.11 0.47 39 34.67 0.28 353 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGAGM 5.28 0.09 37 13.93 0.24 33 -7.21 0.42 369 -1.5 0.04 37 -1.73 0.03 369 -0.73 0.41 37 -1.81 1.03 369 34.92 0.31 37 31.72 0.4 369 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGATM 4.99 0.14 38 13.67 0.31 32 -7.44 0.3 181 -1.52 0.04 38 -1.54 0.03 181 -0.43 0.52 38 -4.3 0.45 181 35.6 0.42 38 32.45 0.19 181 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGAMQ 5.16 0.16 133 13.01 0.44 127 -8.11 0.38 133 -1.27 0.05 133 -1.43 0.03 133 -1.76 0.64 133 -4.61 0.69 133 36.23 0.52 133 33.03 0.34 133 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGCAM 5.99 0.13 38 12.28 0.24 31 -4.62 0.35 112 -1.48 0.03 38 -1.13 0.06 112 -0.29 0.32 38 3.51 0.53 112 35.01 0.39 38 35.25 0.47 112 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGCCM 4.93 0.08 39 13.96 0.19 32 -3.06 0.31 223 -1.6 0.03 39 -1.86 0.04 223 -1.65 0.28 39 -1.26 0.41 223 36.19 0.21 39 33.8 0.37 223 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGCGM 5.65 0.12 38 12.49 0.29 35 -4.42 0.28 448 -1.5 0.03 38 -1.51 0.05 448 -0.75 0.34 38 3.4 0.47 448 35.42 0.26 38 33.16 0.41 448 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGCTM 4.96 0.11 38 13.83 0.24 33 -1.39 0.36 115 -1.66 0.03 38 -1.77 0.04 115 -1.85 0.4 38 -2.67 0.42 115 36.69 0.31 38 31.64 0.26 115 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGCMQ 5.19 0.11 132 13.55 0.32 118 -1.29 0.38 132 -1.59 0.04 132 -1.7 0.05 132 -1.43 0.49 132 -4.04 0.42 132 36.63 0.3 132 31.82 0.38 132 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGGAM 5.18 0.12 38 13.52 0.27 36 -6.04 0.31 185 -1.69 0.05 38 -1.32 0.05 185 0.03 0.47 38 -2.04 0.45 185 33.54 0.38 38 36.7 0.63 185 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGGCM 4.95 0.12 38 13.8 0.3 33 -2.81 0.25 113 -1.76 0.04 38 -1.63 0.04 113 -1.23 0.4 38 -1.73 0.34 113 33.21 0.31 38 37.09 0.29 113 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGGGM 5.02 0.09 38 13.96 0.2 34 -2.8 0.4 181 -1.78 0.03 38 -1.79 0.04 181 -1.25 0.41 38 -1.57 0.58 181 33.21 0.25 38 33.97 0.4 181 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGGTM 4.68 0.11 38 13.56 0.21 34 -6.26 0.34 282 -1.75 0.03 38 -1.56 0.03 282 -0.74 0.47 38 -3.26 0.51 282 34.35 0.29 38 34.95 0.27 282 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGGMQ 5.08 0.11 132 13.69 0.3 121 -3.09 0.31 132 -1.7 0.05 132 -1.63 0.04 132 -1.3 0.4 132 -3.92 0.39 132 33.86 0.39 132 34.37 0.31 132 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGTAM 5.96 0.12 39 12.3 0.24 34 -9 0.32 185 -1.46 0.02 39 -1.23 0.05 185 -1.67 0.42 39 4.22 0.71 185 33.8 0.2 39 34.8 0.41 185 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGTCM 5.09 0.13 39 13.34 0.23 34 -8.73 0.4 282 -1.52 0.03 39 -1.48 0.05 282 -2.39 0.39 39 -0.85 0.45 282 34.32 0.32 39 35.69 0.55 282 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGTGM 5.85 0.08 39 12.17 0.25 32 -8.7 0.4 113 -1.44 0.03 38 -1.18 0.05 113 -1.88 0.37 38 3.62 0.52 113 33.51 0.19 38 34.95 0.54 113 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGTTM 4.71 0.13 37 12.87 0.28 34 -11.52 0.32 289 -1.54 0.02 37 -1.15 0.03 289 -2.99 0.38 37 -3.3 0.39 289 35.14 0.19 37 35.6 0.3 289 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGTMQ 5.21 0.1 134 13.02 0.37 129 -7.74 0.41 134 -1.51 0.03 134 -1.23 0.04 134 -3.08 0.45 134 -3.87 0.38 134 34.65 0.29 134 34.42 0.34 134 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGMQA 5.45 0.15 160 12.98 0.29 150 -9.18 0.37 160 -1.54 0.06 160 -1.45 0.06 160 -3.23 0.85 160 10.39 0.65 160 33.85 0.37 160 34.41 0.35 160 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGMQC 5.41 0.25 178 13.23 0.49 163 -8.99 0.65 178 -1.54 0.07 178 -1.52 0.08 178 -3.3 0.62 178 8.66 1.48 178 33.88 0.37 178 33.89 0.55 178 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGMQG 5.45 0.11 167 13.3 0.28 155 -8.89 0.41 167 -1.54 0.04 167 -1.51 0.05 167 -3.15 0.45 167 8.4 0.78 167 33.75 0.23 167 33.91 0.46 167 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CGMQM 5.5 0.1 26 12.74 0.43 24 -9.58 0.49 26 -1.51 0.03 26 -1.44 0.04 26 -2.86 0.4 26 9.4 0.86 26 33.7 0.22 26 34.77 0.51 26 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTAAM 5.79 0.12 7 13 0.21 7 -10.48 0.38 7 -1.27 0.07 7 -1.03 0.03 7 5.51 0.88 7 -2.92 0.62 7 34.36 0.25 7 36.1 0.31 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTACM 5.81 0.1 7 13.39 0.2 7 -7.64 0.25 7 -1.44 0.02 7 -1.58 0.03 7 5.36 0.79 7 -1.78 0.41 7 33.84 0.15 7 34.54 0.22 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTAGM 5.86 0.12 9 13.55 0.29 9 -7.1 0.48 9 -1.45 0.03 9 -1.69 0.03 9 5.32 0.98 9 -1.59 0.76 9 34.13 0.29 9 31.65 0.22 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTATM 5.63 0.17 9 13.38 0.17 9 -7.79 0.73 9 -1.5 0.03 9 -1.53 0.02 9 6.09 1.1 9 -3.74 0.41 9 34.53 0.65 9 32.27 0.26 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTAMQ 5.84 0.16 53 12.82 0.29 49 -7.92 0.62 53 -1.32 0.06 53 -1.44 0.04 53 4.66 1.29 53 -4.07 0.62 53 34.8 0.84 53 32.71 0.41 53 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTCAM 5.93 0.13 7 13.11 0.24 7 -6.61 0.28 7 -1.48 0.05 7 -1.07 0.05 7 -0.65 0.58 7 4.05 0.58 7 34.58 0.52 7 35.62 0.37 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTCCM 4.79 0.1 9 14.5 0.28 9 -4.88 0.41 9 -1.52 0.04 9 -1.84 0.05 9 -2.11 0.57 9 -0.86 0.31 9 35.91 0.34 9 34.24 0.41 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTCGM 5.57 0.11 6 13.16 0.16 6 -6.79 0.96 6 -1.46 0.03 6 -1.47 0.08 6 -0.91 0.58 6 4.67 0.57 6 34.88 0.42 6 33.67 0.27 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTCTM 4.88 0.22 7 14.44 0.17 6 -2.89 0.48 7 -1.62 0.07 7 -1.77 0.05 7 -1.7 1.24 7 -2.39 0.83 7 36.18 0.64 7 31.73 0.78 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTCMQ 5.14 0.13 63 14.24 0.24 53 -2.66 0.49 64 -1.62 0.05 63 -1.73 0.05 64 -0.78 0.68 63 -3.81 0.47 64 35.57 0.44 63 31.97 0.24 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTGAM 5.8 0.15 9 13.19 0.24 9 -6.44 0.5 9 -1.29 0.07 9 -1.28 0.07 9 4.76 0.59 9 -1.63 0.44 9 34.31 0.26 9 36.15 0.31 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTGCM 5.43 0.1 9 13.62 0.11 9 -3.37 0.21 10 -1.46 0.06 9 -1.6 0.05 10 3.13 0.48 9 -1.36 0.49 10 33.99 0.46 9 36.66 0.37 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTGGM 5.48 0.19 7 13.6 0.37 5 -3.69 0.61 7 -1.46 0.08 7 -1.71 0.06 7 3.8 1.17 7 -1.35 0.55 7 33.65 1.01 7 34.19 0.64 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTGTM 5.24 0.05 7 13.28 0.14 6 -7.27 0.14 7 -1.46 0.03 7 -1.51 0.02 7 4.15 1.4 7 -2.7 0.26 7 34.67 0.31 7 34.52 0.24 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTGMQ 5.71 0.13 55 13.1 0.27 53 -3.77 0.32 56 -1.36 0.05 55 -1.56 0.05 56 3.89 0.72 55 -2.98 0.43 56 34.72 0.45 55 33.83 0.32 56 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTTAM 5.75 0.15 7 12.98 0.11 7 -10.91 0.26 7 -1.22 0.04 7 -1.27 0.04 7 -2.27 0.34 7 5.6 0.92 7 34.85 0.35 7 34.89 0.61 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTTCM 4.81 0.19 10 14.01 0.17 9 -9.93 0.56 11 -1.27 0.06 10 -1.58 0.05 11 -3.32 1.17 10 -0.06 0.75 11 35.06 0.64 10 36.01 0.38 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTTGM 5.56 0.17 9 12.84 0.2 5 -10.32 0.34 9 -1.22 0.02 9 -1.23 0.09 9 -3.03 0.87 9 5.01 0.8 9 34.41 0.41 9 35.22 0.39 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTTTM 4.57 0.14 7 13.08 0.15 6 -12.84 0.33 7 -1.23 0.03 7 -1.11 0.04 7 -3.73 0.89 7 -2.67 0.4 7 36.35 0.32 7 36.08 0.34 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTTMQ 4.99 0.17 56 13.59 0.25 48 -8.82 0.41 56 -1.3 0.04 56 -1.23 0.05 56 -3.86 0.86 56 -3.26 0.49 56 35.29 0.34 56 34.64 0.38 56 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTMQA 5.44 0.13 86 13.49 0.17 82 -12.1 0.34 86 -1.36 0.03 86 -1.44 0.05 86 -3.77 0.36 86 11.85 0.5 86 34.1 0.26 86 34.66 0.33 86 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTMQC 5.42 0.12 99 13.72 0.28 88 -11.89 0.69 100 -1.37 0.04 99 -1.52 0.06 100 -3.91 0.56 99 10.04 0.72 100 34.02 0.38 99 34.14 0.43 100 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTMQG 5.4 0.22 90 13.79 0.23 81 -11.76 0.55 91 -1.38 0.07 91 -1.52 0.04 90 -3.94 1.7 91 9.68 0.76 90 33.9 0.66 91 34.16 0.44 90 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CTMQM 5.44 0.13 11 13.54 0.45 10 -12.27 0.42 11 -1.36 0.04 11 -1.46 0.04 11 -3.75 0.28 11 10.77 0.48 11 33.86 0.34 11 34.93 0.4 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQAA 5.57 0.31 146 13.63 0.2 133 -11.59 0.51 147 -1.46 0.08 146 -1.2 0.05 147 9.41 2.22 146 -3.09 0.39 147 34.1 0.77 146 34.48 0.4 147 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQAC 5.56 0.11 149 13.64 0.23 143 -11.81 0.53 149 -1.46 0.05 149 -1.28 0.05 149 9.72 0.69 149 -3.9 0.4 149 34.21 0.35 149 34.11 0.4 149 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQAM 5.6 0.09 20 13.6 0.13 19 -11.64 0.37 20 -1.46 0.04 20 -1.21 0.03 20 9.63 0.45 20 -3.94 0.34 20 34.01 0.29 20 34.86 0.26 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQCA 5.57 0.16 95 13.52 0.31 90 -8.63 0.54 95 -1.49 0.05 95 -1.54 0.06 95 8.17 0.84 95 -2.89 0.61 95 34.14 0.4 95 33.68 0.4 95 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQCC 5.19 0.24 142 14.35 0.27 113 -7.92 0.53 143 -1.57 0.08 142 -1.66 0.05 143 7.33 1.87 142 -4.08 0.48 143 33.41 0.71 142 34.2 0.27 143 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQCM 5.19 0.14 20 14.2 0.23 18 -8.41 0.69 21 -1.58 0.04 20 -1.68 0.06 21 7.89 0.77 20 -3.61 0.47 21 33.57 0.26 20 34.33 0.38 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQGA 5.43 0.17 134 14.18 0.26 120 -8 0.55 137 -1.52 0.06 134 -1.68 0.07 137 7.58 0.85 134 -3.54 0.68 137 33.7 0.63 134 31.94 0.32 137 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQGC 5.36 0.28 110 14.17 0.21 99 -8.11 0.46 112 -1.54 0.09 110 -1.72 0.05 112 7.36 1.73 110 -4.2 0.42 112 33.8 0.86 110 31.65 0.25 112 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQGM 5.41 0.11 20 14.29 0.24 18 -8.28 0.27 20 -1.53 0.03 20 -1.7 0.04 20 7.64 0.54 20 -4.07 0.36 20 33.68 0.33 20 32.14 0.31 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQTA 5.27 0.21 113 13.26 0.23 104 -11.84 0.58 113 -1.55 0.05 113 -1.42 0.03 113 9.02 0.78 113 -3.99 0.46 113 34.75 0.42 113 32.6 0.36 113 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQTC 4.96 0.16 121 13.63 0.26 114 -12.32 0.6 121 -1.6 0.04 121 -1.44 0.03 121 9.01 0.76 121 -4.7 0.43 121 34.55 0.4 121 32.91 0.22 121 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQTM 4.91 0.13 20 13.71 0.19 19 -12.35 0.37 20 -1.63 0.04 20 -1.45 0.02 20 8.82 0.58 20 -4.95 0.3 20 34.59 0.34 20 33.2 0.14 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "CMQMQ 5.43 0.16 91 13.38 0.5 85 -8.44 0.44 91 -1.48 0.05 91 -1.58 0.07 91 8.52 0.73 91 -5.33 0.55 91 34.42 0.52 91 32.33 0.26 91 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAAAM 4.88 0.13 28 12.9 0.19 9 -12.7 0.33 28 -1.01 0.03 28 -1.01 0.02 28 -1.71 0.54 28 -2.81 0.77 28 35.53 0.28 28 36.94 0.32 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAACM 4.67 0.24 28 13.58 0.24 8 -10.14 0.47 28 -1.19 0.03 28 -1.66 0.06 28 -2.79 0.59 28 -2.86 1.52 28 35.03 0.23 28 35.35 0.48 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAAGM 4.84 0.12 28 14.13 0.2 10 -8.45 0.37 28 -1.27 0.03 28 -1.78 0.03 28 -2.85 0.56 28 -2.2 0.53 28 34.79 0.25 28 32.4 0.22 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAATM 4.49 0.18 27 13.82 0.21 11 -9.16 0.41 27 -1.28 0.03 27 -1.59 0.03 27 -2.55 0.49 27 -5.04 0.56 27 35.47 0.31 27 32.89 0.27 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAAMQ 4.78 0.17 247 12.99 0.29 88 -11.21 0.99 248 -1.02 0.04 247 -1.41 0.03 248 -2.63 0.61 247 -4.76 0.56 248 36.38 0.46 247 33.7 0.32 248 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GACAM 5.74 0.13 17 12.75 0.27 15 -7.57 0.31 17 -1.45 0.02 17 -1.09 0.06 17 -1.62 0.39 17 4.19 0.87 17 33.51 0.18 17 35.79 0.43 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GACCM 4.44 0.14 16 14.36 0.31 9 -5.63 0.44 16 -1.6 0.03 16 -1.89 0.04 16 -3.17 0.55 16 -1.11 0.57 16 34.67 0.22 16 34.65 0.23 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GACGM 5.2 0.18 15 13.07 0.31 10 -7.43 0.39 15 -1.5 0.02 15 -1.58 0.03 15 -2.07 0.7 15 4.11 0.72 15 33.83 0.47 15 33.88 0.34 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GACTM 4.43 0.31 17 14.43 0.35 10 -3.46 0.53 17 -1.7 0.04 17 -1.82 0.08 17 -3.29 0.59 17 -3.13 1.07 17 34.82 0.25 17 32.37 0.6 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GACMQ 4.9 0.19 413 13.97 0.36 92 -3.56 0.58 413 -1.62 0.04 413 -1.73 0.07 413 -2.18 0.61 413 -3.78 0.74 413 34.67 0.27 413 32.23 0.52 413 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAGAM 5.13 0.13 16 14.02 0.22 12 -3.61 0.21 16 -1.66 0.03 16 -1.35 0.06 16 -1.27 0.46 16 -2.2 0.52 16 31.44 0.2 16 37.19 0.46 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAGCM 4.82 0.11 19 14.56 0.24 13 -0.82 0.27 19 -1.78 0.03 19 -1.73 0.04 19 -2.34 0.5 19 -2.24 0.49 19 31.27 0.21 19 37.37 0.32 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAGGM 4.83 0.12 17 14.68 0.21 10 -0.9 0.42 18 -1.79 0.03 17 -1.87 0.04 18 -2.37 0.56 17 -1.99 0.58 18 31.43 0.18 17 34.35 0.43 18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAGTM 4.48 0.15 21 14.44 0.39 15 -3.74 0.47 21 -1.79 0.03 21 -1.68 0.03 21 -2.18 0.57 21 -3.91 0.39 21 31.97 0.33 21 35.34 0.25 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAGMQ 4.97 0.2 434 14.38 0.27 93 -1.18 0.34 434 -1.73 0.03 434 -1.74 0.04 434 -1.86 0.98 434 -4.33 0.81 434 31.74 0.38 434 34.46 0.34 434 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GATAM 5.77 0.18 28 13.05 0.43 11 -8.41 0.36 28 -1.47 0.02 28 -1.3 0.07 28 -3.22 0.39 28 5.25 1.21 28 31.93 0.17 28 35.16 0.9 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GATCM 4.57 0.39 28 14.33 0.19 9 -8.49 0.65 28 -1.52 0.04 28 -1.66 0.05 28 -4.43 0.58 28 -0.73 2.58 28 32.57 0.2 28 36.32 1.12 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GATGM 5.36 0.17 28 13.18 0.25 10 -8.51 0.86 28 -1.46 0.02 28 -1.38 0.05 28 -3.81 0.39 28 4.4 0.97 28 31.87 0.24 28 35.31 0.64 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GATTM 4.21 0.22 32 13.8 0.3 13 -10.63 0.33 32 -1.59 0.04 32 -1.28 0.04 32 -5.49 0.8 32 -3.54 0.59 32 33.23 0.36 32 36.03 0.32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GATMQ 4.98 0.17 242 13.92 0.28 90 -6.66 0.43 242 -1.55 0.03 242 -1.35 0.05 242 -4.38 0.59 242 -3.49 0.46 242 32.48 0.29 242 34.39 0.43 242 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAMQA 4.96 0.17 121 13.24 0.21 119 -12.88 0.65 123 -1.44 0.03 121 -1.54 0.05 123 -4.59 0.41 121 11.41 0.63 123 32.99 0.27 121 35.19 0.33 123 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAMQC 4.95 0.16 134 13.53 0.33 124 -12.49 0.62 134 -1.45 0.03 134 -1.61 0.06 134 -4.79 0.46 134 9.43 0.88 134 33.01 0.25 134 34.54 0.56 134 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GAMQM 5.1 0.12 15 12.98 0.34 14 -13.26 0.52 15 -1.41 0.03 15 -1.51 0.04 15 -4.2 0.41 15 10.65 0.77 15 32.65 0.35 15 35.64 0.58 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCAAM 5.82 0.19 30 12.53 0.39 12 -10.45 0.42 32 -1.14 0.09 30 -1 0.04 32 4.99 0.55 30 -2.67 0.45 32 34.04 0.4 30 35.86 0.26 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCACM 5.63 0.15 27 13.04 0.21 10 -7.55 0.29 27 -1.35 0.05 27 -1.55 0.02 27 3.67 0.58 27 -2.02 0.41 27 34.09 0.32 27 34.22 0.22 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCAGM 5.7 0.1 30 13.62 0.4 13 -6.65 0.69 30 -1.44 0.06 30 -1.67 0.04 30 4.11 1.02 30 -1.91 0.66 30 33.76 0.79 30 31.57 0.31 30 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCATM 5.34 0.12 29 13.39 0.28 9 -7.44 0.39 29 -1.48 0.04 29 -1.5 0.03 29 4.2 0.72 29 -4.21 0.46 29 34.76 0.32 29 32.11 0.24 29 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCAMQ 5.77 0.15 177 12.44 0.36 90 -8.13 0.55 177 -1.14 0.07 177 -1.35 0.04 177 3.22 0.97 177 -4.03 0.53 177 35.21 0.6 177 32.47 0.33 177 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCCAM 5.78 0.1 14 12.99 0.23 12 -4.35 0.43 15 -1.66 0.05 14 -1.18 0.05 15 -0.8 0.48 14 3.06 0.72 15 33.19 0.34 14 35.38 0.45 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCCCM 4.79 0.14 15 14.7 0.21 10 -2.05 0.43 15 -1.85 0.06 15 -1.9 0.04 15 -1.59 0.72 15 -1.92 0.54 15 33.3 0.69 15 33.88 0.37 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCCGM 5.48 0.11 11 13.35 0.26 9 -3.62 0.45 11 -1.75 0.03 11 -1.56 0.03 11 -1.02 0.57 11 2.81 0.76 11 32.96 0.33 11 33.1 0.21 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCCTM 4.74 0.15 16 14.53 0.18 10 -0.92 0.34 17 -1.9 0.05 16 -1.83 0.03 17 -1.82 0.58 16 -3.26 0.61 17 34.02 0.43 16 31.87 0.28 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCCMQ 5 0.11 283 14.34 0.27 90 -0.76 0.45 283 -1.86 0.04 283 -1.79 0.05 283 -1.35 0.45 283 -4.54 0.46 283 33.83 0.36 283 31.78 0.38 283 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCGAM 5.64 0.11 95 13.08 0.28 11 -6.94 0.65 95 -1.51 0.06 95 -1.26 0.04 95 4.81 0.64 95 -1.73 0.45 95 32.56 0.44 95 36.23 0.45 95 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCGCM 5.33 0.11 96 13.45 0.2 10 -3.67 0.29 96 -1.63 0.03 96 -1.59 0.04 96 3.02 0.49 96 -1.43 0.47 96 32.22 0.27 96 36.64 0.3 96 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCGGM 5.4 0.09 95 13.37 0.26 10 -3.91 0.41 95 -1.62 0.04 95 -1.7 0.05 95 3.08 0.53 95 -1.26 0.37 95 32.33 0.27 95 33.85 0.37 95 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCGTM 4.97 0.21 96 13.24 0.27 11 -7.71 0.32 96 -1.69 0.05 96 -1.51 0.02 96 4.13 0.6 96 -3.11 0.45 96 33.14 0.36 96 34.67 0.28 96 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCGMQ 5.58 0.13 506 12.9 0.41 90 -3.87 0.33 507 -1.51 0.05 507 -1.53 0.05 507 3.35 0.5 507 -3.18 0.47 507 33.16 0.42 507 33.85 0.3 507 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCTAM 5.93 0.1 15 13.24 0.18 14 -7.33 0.49 15 -1.68 0.05 15 -1.31 0.05 15 -1.52 0.56 15 4.48 0.8 15 31.2 0.3 15 34.98 0.4 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCTCM 5.08 0.12 19 14.48 0.19 17 -6.62 0.31 19 -1.77 0.03 19 -1.62 0.04 19 -2.16 0.51 19 -0.87 0.58 19 31.44 0.26 19 35.64 0.39 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCTGM 5.72 0.08 15 13.3 0.22 14 -6.81 0.29 15 -1.67 0.04 15 -1.36 0.03 15 -1.73 0.37 15 3.84 0.41 15 31.08 0.18 15 34.81 0.33 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCTTM 4.73 0.14 16 13.82 0.25 16 -9.11 0.47 16 -1.8 0.03 16 -1.29 0.03 16 -2.46 0.71 16 -3.74 0.63 16 32.38 0.21 16 35.38 0.25 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCTMQ 5.22 0.12 175 13.92 0.3 90 -5.96 0.38 176 -1.78 0.04 175 -1.37 0.04 176 -2.76 0.51 175 -3.77 0.43 176 31.64 0.27 175 34.05 0.29 176 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCMQA 5.41 0.37 108 13.82 0.24 99 -8.48 0.89 108 -1.72 0.08 108 -1.49 0.09 108 -4.08 0.82 108 9.57 2.5 108 31.73 0.59 108 34.17 0.85 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCMQC 5.4 0.11 126 14.09 0.32 118 -8.21 0.56 126 -1.73 0.05 126 -1.54 0.06 126 -4.24 0.46 126 7.98 0.75 126 31.7 0.38 126 33.75 0.46 126 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GCMQM 5.43 0.09 10 13.75 0.31 10 -8.53 0.6 10 -1.7 0.05 10 -1.47 0.03 10 -4.01 0.4 10 8.26 0.85 10 31.67 0.47 10 34.53 0.44 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGAAM 5.09 0.15 30 13.57 0.27 11 -10.12 0.72 30 -1.42 0.05 30 -1.03 0.03 30 -0.13 0.67 30 -2.92 0.55 30 35.35 0.8 30 36.32 0.43 30 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGACM 4.98 0.12 28 14.26 0.28 10 -7.29 0.28 28 -1.5 0.04 28 -1.63 0.03 28 -1.36 0.54 28 -2.35 0.48 28 35.42 0.38 28 34.58 0.22 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGAGM 5.08 0.12 33 14.52 0.22 10 -6.47 0.4 33 -1.55 0.04 33 -1.73 0.04 33 -1.18 0.63 33 -2.31 0.55 33 35.43 0.4 33 31.79 0.24 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGATM 4.8 0.25 29 14.32 0.26 11 -7.08 0.53 29 -1.6 0.04 29 -1.56 0.03 29 -0.75 0.55 29 -4.52 0.97 29 35.98 0.34 29 32.4 0.59 29 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGAMQ 4.96 0.13 245 13.68 0.31 89 -7.58 0.48 245 -1.32 0.05 245 -1.45 0.03 245 -2.1 0.5 245 -4.85 0.47 245 36.72 0.59 245 32.97 0.31 245 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGCAM 5.75 0.23 30 13.25 0.46 12 -3.51 0.51 30 -1.54 0.04 30 -1.16 0.05 30 -1.15 1.09 30 2.56 1.71 30 35.8 0.47 30 34.96 0.98 30 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGCCM 4.75 0.1 30 14.72 0.38 12 -2.3 0.3 30 -1.65 0.04 30 -1.84 0.04 30 -2.31 0.3 30 -1.77 0.46 30 36.67 0.3 30 33.89 0.32 30 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGCGM 5.5 0.11 28 13.39 0.33 10 -3.48 0.49 28 -1.57 0.05 28 -1.49 0.04 28 -1.22 0.37 28 2.88 0.62 28 35.79 0.54 28 33.16 0.32 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGCTM 4.82 0.08 28 14.53 0.19 11 -0.95 0.19 28 -1.71 0.02 28 -1.79 0.03 28 -2.32 0.33 28 -2.9 0.31 28 37.01 0.22 28 31.6 0.22 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGCMQ 5.06 0.12 176 14.24 0.38 83 -0.76 0.47 176 -1.64 0.04 176 -1.73 0.04 176 -1.86 0.53 176 -4.27 0.57 176 37.1 0.31 176 31.64 0.29 176 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGGAM 4.99 0.1 29 14.22 0.17 10 -5.49 0.33 30 -1.79 0.03 29 -1.35 0.04 30 -0.46 0.42 29 -2.21 0.66 30 33.63 0.28 29 36.59 0.5 30 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGGCM 4.81 0.09 30 14.65 0.31 10 -2.3 0.37 34 -1.83 0.03 30 -1.65 0.04 34 -1.57 0.44 30 -1.95 0.41 34 33.38 0.23 30 37.07 0.27 34 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGGGM 4.83 0.1 36 14.86 0.37 13 -2.06 0.51 46 -1.86 0.04 36 -1.82 0.04 46 -2 0.67 36 -1.96 0.41 46 33.45 0.38 36 33.79 0.39 46 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGGTM 4.5 0.13 32 14.35 0.25 13 -5.92 0.35 34 -1.85 0.04 32 -1.57 0.02 34 -1.18 0.54 32 -3.45 0.45 34 34.46 0.38 32 35.04 0.24 34 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGGMQ 4.91 0.11 262 14.47 0.35 89 -2.47 0.4 275 -1.79 0.04 262 -1.67 0.04 275 -1.68 0.57 262 -4.21 0.44 275 33.95 0.4 262 34.26 0.32 275 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGTAM 5.74 0.18 19 13.16 0.38 11 -8.09 0.52 19 -1.52 0.03 19 -1.24 0.08 19 -2.42 0.5 19 3.39 1.97 19 34.31 0.22 19 35.01 0.87 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGTCM 4.92 0.09 22 14.13 0.29 15 -8.23 0.5 22 -1.59 0.04 22 -1.5 0.08 22 -2.74 0.32 22 -1.18 0.32 22 34.65 0.25 22 35.64 1.41 22 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGTGM 5.63 0.1 20 13.07 0.21 15 -8.02 0.29 20 -1.5 0.03 20 -1.21 0.05 20 -2.46 0.39 20 3.06 0.52 20 34.04 0.22 20 35.05 0.4 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGTTM 4.51 0.28 21 13.54 0.33 15 -11.35 0.43 21 -1.61 0.06 21 -1.17 0.03 21 -3.79 1.77 21 -3.67 0.7 21 35.73 0.76 21 35.63 0.26 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGTMQ 5.11 0.12 347 13.66 0.27 94 -7.26 0.4 347 -1.56 0.03 347 -1.28 0.04 347 -3.29 0.52 347 -3.96 0.43 347 34.96 0.27 347 34.18 0.44 347 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGMQA 5.23 0.14 120 14 0.22 108 -8.35 0.39 120 -1.65 0.04 120 -1.5 0.05 120 -4.09 0.46 120 9.66 0.58 120 34.36 0.23 120 33.95 0.33 120 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGMQC 5.21 0.22 146 14.24 0.41 131 -8.2 0.66 148 -1.66 0.06 147 -1.57 0.06 147 -4.18 1.31 147 8 0.84 147 34.26 0.53 147 33.44 0.49 147 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GGMQM 5.27 0.16 17 13.96 0.42 10 -8.28 0.6 17 -1.64 0.03 17 -1.52 0.06 17 -4 0.5 17 7.86 1.34 17 34.2 0.24 17 33.96 0.72 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTAAM 6.02 0.12 25 12.78 0.2 8 -10.63 0.29 25 -1.21 0.08 25 -1.03 0.02 25 5.87 0.77 25 -2.6 0.5 25 33.84 0.41 25 35.9 0.22 25 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTACM 5.98 0.16 26 12.85 0.45 9 -8.02 1.23 26 -1.36 0.07 26 -1.54 0.03 26 5.52 1.66 26 -1.58 0.55 26 33.67 1.36 26 34.44 0.3 26 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTAGM 5.97 0.11 27 13.16 0.39 11 -7.08 0.39 27 -1.37 0.02 27 -1.67 0.04 27 5.28 0.73 27 -1.8 0.44 27 34.12 0.28 27 31.7 0.26 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTATM 5.9 0.15 31 13.08 0.34 13 -7.39 0.51 32 -1.39 0.03 31 -1.51 0.03 32 6.26 0.88 31 -3.29 0.49 32 34.33 0.36 31 32.08 0.23 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTAMQ 5.89 0.15 237 12.58 0.36 90 -7.94 0.5 237 -1.24 0.06 237 -1.41 0.03 237 4.15 0.96 237 -3.98 0.54 237 34.86 0.49 237 32.65 0.36 237 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTCAM 6.04 0.15 16 12.87 0.2 11 -7.17 0.51 16 -1.37 0.04 16 -1 0.05 16 -0.83 0.54 16 4.14 0.71 16 34.63 0.38 16 35.64 0.42 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTCCM 4.9 0.11 17 14.28 0.25 13 -5.56 0.71 17 -1.42 0.06 17 -1.81 0.03 17 -1.93 0.62 17 -0.6 0.36 17 35.9 0.84 17 34.35 0.37 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTCGM 5.64 0.15 16 13.04 0.24 12 -6.9 0.45 16 -1.35 0.04 16 -1.45 0.06 16 -1.16 0.52 16 4.29 0.87 16 35.16 0.42 16 33.73 0.34 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTCTM 5 0.25 17 13.99 0.27 11 -3.74 0.83 17 -1.47 0.05 17 -1.7 0.03 17 -1.56 0.78 17 -1.85 0.9 17 36.32 0.41 17 31.87 0.64 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTCMQ 5.27 0.15 336 13.91 0.37 87 -3.24 0.53 336 -1.49 0.06 336 -1.66 0.06 336 -0.89 0.56 336 -3.46 0.73 336 35.69 0.7 336 32.13 0.43 336 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTGAM 6.03 0.15 16 12.97 0.22 15 -6.88 0.47 17 -1.12 0.07 16 -1.29 0.05 17 4.53 0.74 16 -1.46 0.77 17 34.4 0.42 16 35.81 0.51 17 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTGCM 5.63 0.16 14 13.12 0.29 14 -3.94 0.26 14 -1.28 0.06 14 -1.54 0.03 14 3.31 0.52 14 -0.97 0.28 14 34.35 0.3 14 36.65 0.21 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTGGM 5.72 0.13 13 13.33 0.19 10 -4.37 0.33 13 -1.29 0.05 13 -1.68 0.04 13 3.46 0.45 13 -0.94 0.38 13 34.34 0.46 13 33.7 0.57 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTGTM 5.56 0.16 14 12.96 0.29 14 -7.49 0.22 14 -1.23 0.07 14 -1.49 0.03 14 4.5 0.72 14 -2.34 0.42 14 35 0.58 14 34.2 0.22 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTGMQ 5.91 0.14 165 12.69 0.37 86 -4.11 0.33 165 -1.19 0.07 165 -1.51 0.04 165 3.54 0.61 165 -2.69 0.47 165 34.95 0.5 165 33.73 0.29 165 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTTAM 6.02 0.26 14 12.56 0.31 11 -11.36 0.34 14 -1.08 0.03 14 -1.17 0.1 14 -2.1 0.53 14 5.85 1.72 14 35.27 0.27 14 34.39 1.7 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTTCM 5.04 0.16 19 13.6 0.28 12 -10.39 0.52 19 -1.11 0.05 19 -1.48 0.06 19 -2.85 0.9 19 0.11 0.57 19 35.6 0.3 19 36.01 0.46 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTTGM 5.78 0.11 15 12.63 0.15 9 -10.76 0.39 15 -1.09 0.04 15 -1.1 0.04 15 -2.59 0.42 15 4.82 0.53 15 34.88 0.3 15 35.11 0.39 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTTTM 4.84 0.22 20 12.61 0.15 14 -13.63 0.52 20 -1.1 0.05 20 -1.03 0.02 20 -2.67 1 20 -1.98 0.78 20 36.39 0.39 20 36.11 0.28 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTTMQ 5.23 0.14 342 13.21 0.31 84 -9.11 0.41 342 -1.16 0.04 342 -1.17 0.04 342 -3.34 0.44 342 -3.02 0.39 342 35.59 0.31 342 34.55 0.44 342 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTMQA 5.57 0.14 152 13.3 0.21 140 -12.1 0.39 152 -1.27 0.05 152 -1.4 0.06 152 -3.86 0.5 152 11.74 0.55 152 34.24 0.5 152 34.77 0.31 152 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTMQC 5.54 0.12 158 13.53 0.3 144 -11.86 0.42 158 -1.27 0.04 158 -1.46 0.06 158 -4.01 0.37 158 9.9 0.66 158 34.29 0.33 158 34.31 0.45 158 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GTMQM 5.62 0.07 23 13.13 0.21 21 -12.39 0.38 23 -1.25 0.04 23 -1.41 0.03 23 -3.59 0.25 23 10.7 0.46 23 34.11 0.27 23 34.99 0.34 23 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQAA 5.58 0.15 143 13.5 0.25 139 -11.72 0.38 143 -1.45 0.07 143 -1.19 0.05 143 9.9 0.6 143 -3.16 0.42 143 34.23 0.44 143 34.69 0.3 143 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQAM 5.6 0.13 21 13.45 0.3 18 -11.79 0.49 21 -1.44 0.06 21 -1.2 0.05 21 9.94 0.54 21 -4.04 0.31 21 34.09 0.38 21 34.91 0.57 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQCA 5.62 0.16 103 13.33 0.41 99 -8.84 0.41 104 -1.5 0.07 104 -1.55 0.05 103 8.84 0.74 104 -2.87 0.51 103 33.97 0.57 104 33.74 0.31 103 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQCM 5.14 0.14 21 14.14 0.31 19 -8.57 0.49 21 -1.61 0.05 21 -1.68 0.04 21 8.14 0.72 21 -3.8 0.49 21 33.55 0.5 21 34.5 0.34 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQGA 5.36 0.36 148 14.13 0.32 130 -7.96 0.96 148 -1.53 0.09 148 -1.7 0.1 148 7.59 1.89 148 -3.88 1.43 148 33.7 0.78 148 32.04 0.8 148 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQGM 5.38 0.12 24 14.14 0.35 21 -8.3 0.5 24 -1.53 0.07 24 -1.7 0.05 24 7.88 0.79 24 -4.18 0.55 24 33.77 0.48 24 32.2 0.29 24 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQTA 5.24 0.29 114 13.12 0.39 110 -12.11 0.61 114 -1.57 0.09 114 -1.43 0.03 114 9.45 2.16 114 -3.99 0.49 114 34.64 0.73 114 32.7 0.29 114 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQTM 4.89 0.16 21 13.48 0.39 19 -12.5 0.45 21 -1.63 0.06 21 -1.46 0.03 21 9.26 0.83 21 -5.08 0.41 21 34.66 0.57 21 33.31 0.21 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "GMQMQ 5.41 0.16 99 13.27 0.64 95 -8.4 0.62 99 -1.5 0.07 99 -1.58 0.08 99 8.7 1.02 99 -5.43 0.75 99 34.42 0.62 99 32.4 0.33 99 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAAAM 5.3 0.25 11 12.47 0.32 11 -13.19 0.5 11 -0.99 0.05 11 -1 0.03 11 -0.8 0.9 11 -2.37 0.77 11 35.15 0.32 11 36.95 0.27 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAACM 5.05 0.24 8 13.39 0.16 6 -10.52 0.57 8 -1.17 0.06 8 -1.6 0.07 8 -2.58 0.52 8 -2.52 0.52 8 34.83 0.36 8 35.06 0.93 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAAGM 5.14 0.18 9 13.7 0.16 8 -8.92 0.31 9 -1.26 0.03 9 -1.75 0.03 9 -2.31 0.48 9 -2.01 0.5 9 34.57 0.34 9 32.46 0.35 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAATM 4.54 0.7 10 13.5 0.19 8 -9.98 1.2 10 -1.23 0.06 10 -1.56 0.04 10 -2.93 2.05 10 -5.83 2.79 10 35.53 0.61 10 33.2 0.92 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAAMQ 5.1 0.2 67 12.72 0.31 58 -11.59 0.53 67 -1.01 0.04 67 -1.4 0.04 67 -2.49 0.7 67 -4.8 0.85 67 36.09 0.34 67 33.82 0.44 67 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TACAM 6.07 0.22 8 12.23 0.19 7 -7.28 0.24 8 -1.43 0.03 8 -1.01 0.06 8 -0.89 0.47 8 4.15 0.35 8 32.91 0.53 8 36.12 0.29 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TACCM 4.68 0.26 9 14.06 0.2 7 -5.74 0.42 9 -1.56 0.05 9 -1.86 0.03 9 -2.72 0.6 9 -1.35 0.84 9 34.42 0.32 9 34.82 0.62 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TACGM 5.45 0.11 8 12.74 0.14 6 -7.3 0.29 8 -1.45 0.03 8 -1.51 0.06 8 -1.63 0.19 8 4 0.42 8 33.75 0.19 8 34.2 0.4 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TACTM 4.77 0.19 11 13.9 0.36 10 -3.63 0.42 11 -1.67 0.06 11 -1.76 0.04 11 -2.68 0.58 11 -2.48 0.6 11 34.7 0.32 11 32.25 0.31 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TACMQ 5.2 0.16 69 13.48 0.29 65 -3.98 0.51 69 -1.56 0.04 69 -1.66 0.05 69 -1.67 0.55 69 -3.48 0.51 69 34.45 0.29 69 32.5 0.31 69 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAGAM 5.38 0.2 9 13.66 0.09 9 -4 0.27 9 -1.61 0.03 9 -1.3 0.06 9 -1.15 0.46 9 -1.97 0.5 9 31.22 0.28 9 37.22 0.5 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAGCM 5.03 0.31 9 13.92 0.25 5 -1.27 0.14 9 -1.75 0.04 9 -1.71 0.08 9 -1.89 0.74 9 -2.24 2.02 9 31.06 0.25 9 37.54 0.68 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAGGM 5.15 0.21 9 14.04 0.15 8 -1.61 0.38 9 -1.76 0.03 9 -1.84 0.05 9 -1.66 0.53 9 -1.4 0.61 9 31.2 0.19 9 34.19 0.69 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAGTM 4.93 0.25 9 13.81 0.2 7 -4.03 0.44 9 -1.75 0.05 9 -1.66 0.04 9 -1.07 0.39 9 -3 0.57 9 31.47 0.53 9 34.94 0.41 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAGMQ 5.23 0.17 73 13.78 0.36 70 -1.79 0.36 73 -1.68 0.04 73 -1.68 0.05 73 -1.68 0.6 73 -3.95 0.63 73 31.7 0.28 73 34.6 0.27 73 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TATAM 6.24 0.33 11 12.64 0.28 10 -7.76 0.55 11 -1.45 0.03 11 -1.21 0.04 11 -2.31 1 11 5.2 0.89 11 31.2 0.89 11 35.22 0.44 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TATCM 5.03 0.33 13 13.91 0.35 12 -8.04 0.49 13 -1.51 0.02 13 -1.63 0.05 13 -3.55 0.7 13 -0.18 1.29 13 32.24 0.25 13 36.19 0.6 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TATGM 5.74 0.17 11 12.65 0.25 11 -8.11 0.38 11 -1.43 0.02 11 -1.3 0.05 11 -2.88 0.52 11 4.53 0.66 11 31.53 0.26 11 35.69 0.38 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TATTM 4.7 0.22 12 13.35 0.27 11 -10.52 0.45 12 -1.55 0.03 12 -1.24 0.04 12 -4.48 1.07 12 -2.88 0.67 12 32.78 0.33 12 35.92 0.23 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TATMQ 5.33 0.2 77 13.42 0.32 70 -6.46 0.38 77 -1.52 0.04 77 -1.32 0.04 77 -3.59 0.74 77 -3.23 0.48 77 32.19 0.29 77 34.46 0.32 77 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAMQA 5.28 0.23 102 12.82 0.26 97 -12.4 0.74 102 -1.42 0.03 102 -1.49 0.06 102 -3.84 0.45 102 11.51 0.83 102 32.68 0.27 102 35.37 0.5 102 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TAMQM 5.28 0.21 15 12.71 0.53 14 -12.6 0.94 15 -1.4 0.03 15 -1.48 0.06 15 -3.73 0.43 15 10.05 1.05 15 32.56 0.32 15 35.7 0.57 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCAAM 5.75 0.15 8 12.86 0.14 8 -10.05 0.38 8 -1.09 0.08 8 -1.03 0.03 8 5.54 0.4 8 -3.2 0.42 8 34.42 0.2 8 35.82 0.26 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCACM 5.63 0.16 8 13.3 0.41 8 -7.36 0.26 8 -1.31 0.06 8 -1.56 0.05 8 4.5 0.41 8 -2.21 0.44 8 34.25 0.3 8 34.17 0.15 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCAGM 5.74 0.12 8 13.61 0.29 8 -6.4 0.45 8 -1.39 0.06 8 -1.67 0.02 8 4.91 0.78 8 -1.96 0.75 8 34.11 0.21 8 31.39 0.17 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCATM 5.47 0.12 9 13.27 0.23 9 -7.26 0.29 9 -1.45 0.04 9 -1.5 0.04 9 5.5 0.58 9 -3.89 0.36 9 35 0.26 9 31.91 0.21 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCAMQ 5.83 0.16 61 12.59 0.34 59 -8.12 0.67 61 -1.04 0.09 61 -1.35 0.03 61 4.13 0.71 61 -4.16 0.51 61 35.43 0.71 61 32.49 0.31 61 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCCAM 5.68 0.13 11 13.09 0.53 10 -4.03 0.83 11 -1.66 0.07 11 -1.19 0.06 11 -0.11 0.9 11 2.54 1.25 11 33.45 0.44 11 35.5 0.51 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCCCM 4.79 0.15 9 14.68 0.17 7 -2.11 0.79 9 -1.86 0.08 9 -1.88 0.04 9 -0.67 1.05 9 -1.94 0.69 9 33.49 0.95 9 33.89 0.26 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCCGM 5.42 0.08 8 13.45 0.14 8 -3.32 0.37 8 -1.72 0.05 8 -1.52 0.03 8 -0.38 0.4 8 2.35 0.45 8 33.51 0.2 8 33.27 0.29 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCCTM 4.76 0.09 9 14.5 0.2 8 -0.8 0.36 9 -1.9 0.06 9 -1.82 0.03 9 -0.96 0.32 9 -3.12 0.31 9 34.25 0.37 9 31.82 0.21 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCCMQ 5.01 0.11 62 14.28 0.26 57 -0.75 0.45 62 -1.82 0.05 62 -1.77 0.04 62 -0.71 0.49 62 -4.59 0.45 62 34.27 0.39 62 31.85 0.22 62 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCGAM 5.61 0.11 9 13.17 0.19 8 -6.94 0.42 9 -1.46 0.07 9 -1.28 0.03 9 5.46 0.63 9 -1.65 0.4 9 33.04 0.33 9 36.07 0.5 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCGCM 5.33 0.17 8 13.45 0.22 6 -3.55 0.19 8 -1.57 0.05 8 -1.59 0.03 8 3.91 0.67 8 -1.37 0.49 8 32.64 0.24 8 36.57 0.3 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCGGM 5.36 0.11 8 13.62 0.15 8 -3.65 0.31 8 -1.58 0.06 8 -1.71 0.06 8 4.06 0.53 8 -1.52 0.42 8 32.48 0.69 8 33.91 0.62 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCGTM 5.01 0.16 9 13.01 0.16 8 -7.86 0.18 9 -1.61 0.05 9 -1.48 0.02 9 5.21 0.53 9 -3.03 0.35 9 33.76 0.26 9 34.62 0.25 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCGMQ 5.54 0.19 56 13.03 0.37 55 -3.8 0.44 56 -1.47 0.07 56 -1.55 0.1 56 4.27 0.74 56 -3.34 0.98 56 33.62 0.42 56 33.82 0.48 56 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCTAM 6.03 0.27 9 13.3 0.31 9 -7.73 1.62 9 -1.69 0.06 9 -1.33 0.09 9 -0.88 0.92 9 5.12 2.29 9 31.35 0.35 9 34.36 1.73 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCTCM 5.05 0.12 11 14.36 0.26 11 -6.79 0.47 11 -1.74 0.04 11 -1.58 0.04 11 -1.71 0.79 11 -1.04 0.64 11 31.81 0.2 11 35.8 0.35 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCTGM 5.72 0.11 9 13.39 0.21 8 -6.97 0.76 9 -1.67 0.05 9 -1.36 0.06 9 -1.24 0.61 9 3.75 0.97 9 31.17 0.54 9 34.67 0.9 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCTTM 4.7 0.12 9 13.85 0.14 8 -9.12 0.23 9 -1.78 0.03 9 -1.28 0.04 9 -1.9 0.51 9 -3.86 0.55 9 32.6 0.22 9 35.45 0.32 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCTMQ 5.16 0.26 63 13.94 0.27 56 -5.99 0.69 63 -1.73 0.06 63 -1.35 0.04 63 -2.66 1.42 63 -3.91 0.78 63 31.82 0.78 63 34.04 0.48 63 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCMQA 5.45 0.16 135 13.87 0.27 128 -8.33 0.49 135 -1.67 0.06 135 -1.47 0.06 135 -3.41 0.64 135 9.62 0.78 135 32.09 0.31 135 34.18 0.42 135 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TCMQM 5.49 0.1 24 13.81 0.18 22 -8.44 0.35 24 -1.66 0.05 24 -1.45 0.03 24 -3.35 0.43 24 8.32 0.57 24 32 0.2 24 34.45 0.28 24 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGAAM 5.62 0.32 8 13.16 0.28 7 -10.83 1.04 8 -1.44 0.1 8 -0.99 0.04 8 0.75 1.37 8 -2.33 0.78 8 33.83 1.98 8 36.72 0.54 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGACM 5.29 0.19 8 13.9 0.24 7 -7.8 0.32 8 -1.49 0.03 8 -1.62 0.03 8 -0.84 0.58 8 -2.19 0.43 8 34.66 0.41 8 34.76 0.17 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGAGM 5.43 0.13 9 14.15 0.32 9 -6.95 0.51 9 -1.54 0.05 9 -1.7 0.03 9 -0.83 0.69 9 -2.13 0.62 9 34.73 0.58 9 32.02 0.33 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGATM 5.23 0.25 8 13.88 0.21 8 -7.41 0.17 8 -1.59 0.04 8 -1.54 0.02 8 0.01 0.58 8 -3.99 0.4 8 35.15 0.56 8 32.51 0.11 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGAMQ 5.4 0.19 63 13.25 0.3 59 -8.21 0.41 65 -1.3 0.06 63 -1.43 0.03 65 -1.49 0.57 63 -4.64 0.55 65 35.82 0.48 63 33.14 0.29 65 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGCAM 6.2 0.24 11 12.5 0.35 10 -4.17 0.45 11 -1.48 0.03 11 -1.02 0.08 11 -0.24 0.75 11 2.93 0.93 11 34.89 0.54 11 35.62 0.41 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGCCM 4.98 0.06 8 14 0.29 7 -3.03 0.45 8 -1.58 0.05 8 -1.78 0.04 8 -1.61 0.26 8 -1.46 0.33 8 36.35 0.27 8 34.32 0.32 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGCGM 5.87 0.14 8 12.61 0.24 8 -4.02 0.19 8 -1.49 0.04 8 -1.41 0.05 8 -0.33 0.34 8 3.52 0.43 8 35.28 0.23 8 33.71 0.46 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGCTM 5.03 0.18 8 14.2 0.21 7 -1.43 0.23 8 -1.67 0.03 8 -1.75 0.03 8 -1.78 0.5 8 -2.95 0.6 8 36.59 0.43 8 31.87 0.31 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGCMQ 5.31 0.16 63 13.74 0.28 60 -1.45 0.64 63 -1.58 0.05 63 -1.68 0.07 63 -1.26 0.52 63 -4.07 0.94 63 36.55 0.33 63 31.97 0.48 63 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGGAM 5.22 0.12 7 13.55 0.12 7 -6.1 0.33 7 -1.66 0.04 7 -1.27 0.03 7 -0.27 0.36 7 -2.13 0.49 7 33.76 0.26 7 37.04 0.27 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGGCM 4.96 0.31 8 14.12 0.38 8 -2.85 0.65 8 -1.8 0.08 8 -1.62 0.06 8 -1.21 0.4 8 -2.19 1.69 8 32.96 0.79 8 37.4 0.63 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGGGM 5.05 0.16 9 14.29 0.27 9 -2.92 0.42 10 -1.77 0.05 9 -1.77 0.04 10 -1.45 0.69 9 -1.68 0.6 10 33.39 0.43 9 34.1 0.39 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGGTM 4.81 0.19 8 13.73 0.24 8 -6.54 0.37 8 -1.75 0.05 8 -1.52 0.02 8 -0.74 0.39 8 -3.07 0.24 8 34.44 0.34 8 35.07 0.18 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGGMQ 5.19 0.23 64 13.84 0.34 58 -3.38 0.53 64 -1.7 0.06 64 -1.61 0.04 64 -1.36 1.19 64 -3.8 0.64 64 33.85 0.59 64 34.41 0.36 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGTAM 6.19 0.21 8 12.52 0.17 8 -8.52 0.36 8 -1.45 0.03 8 -1.18 0.05 8 -1.36 0.63 8 4 0.66 8 33.65 0.32 8 35.25 0.22 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGTCM 5.3 0.29 8 13.46 0.51 8 -9.27 1.3 8 -1.52 0.06 8 -1.45 0.17 8 -1.95 0.5 8 -0.73 1.93 8 34.21 0.5 8 36.01 2.13 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGTGM 6.05 0.13 8 12.44 0.24 8 -8.59 0.32 8 -1.45 0.03 8 -1.13 0.07 8 -1.44 0.54 8 3.76 0.76 8 33.33 0.19 8 35.27 0.53 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGTTM 4.93 0.21 8 12.92 0.28 7 -11.66 0.41 8 -1.54 0.03 8 -1.1 0.03 8 -2.7 0.72 8 -3.22 0.71 8 35.09 0.38 8 36.07 0.22 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGTMQ 5.46 0.23 58 13.17 0.29 55 -7.52 0.42 58 -1.5 0.04 58 -1.23 0.03 58 -2.57 0.69 58 -3.86 0.42 58 34.26 0.61 58 34.56 0.31 58 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGMQA 5.6 0.23 91 13.11 0.27 88 -9.01 0.46 91 -1.53 0.08 91 -1.42 0.05 91 -3.01 1.82 91 10.31 0.68 91 33.74 0.46 91 34.67 0.41 91 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TGMQM 5.67 0.14 13 13.06 0.33 13 -9.08 0.4 13 -1.52 0.05 13 -1.42 0.04 13 -2.64 0.48 13 8.98 0.71 13 33.5 0.31 13 34.91 0.44 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTAAM 6.2 0.39 9 12.66 0.21 8 -10.45 0.41 9 -1.13 0.12 9 -1.03 0.04 9 8 2.3 9 -2.55 0.7 9 33.15 2.08 9 35.98 0.27 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTACM 5.87 0.19 9 13.08 0.15 8 -7.28 0.31 9 -1.32 0.07 9 -1.56 0.02 9 6.42 0.94 9 -1.79 0.41 9 34.22 0.41 9 34.34 0.27 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTAGM 5.99 0.14 10 13.43 0.22 10 -6.53 0.33 10 -1.35 0.04 10 -1.66 0.03 10 6.48 0.74 10 -2 0.5 10 34.33 0.44 10 31.65 0.25 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTATM 5.85 0.16 10 13.17 0.21 9 -7.11 0.39 10 -1.41 0.06 10 -1.54 0.02 10 7.56 0.89 10 -3.6 0.44 10 34.3 0.5 10 32.15 0.15 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTAMQ 5.99 0.26 58 12.64 0.33 54 -7.38 0.67 58 -1.2 0.1 58 -1.43 0.03 58 5.77 1.62 58 -4.11 0.59 58 34.63 1.26 58 32.64 0.25 58 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTCAM 6.13 0.2 10 12.95 0.16 10 -6.5 0.37 10 -1.44 0.06 10 -1.02 0.03 10 0.79 0.85 10 3.83 0.68 10 34.12 1.16 10 35.56 0.4 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTCCM 4.84 0.06 10 14.26 0.13 9 -4.92 0.16 10 -1.43 0.09 10 -1.81 0.05 10 -0.94 0.36 10 -1.01 0.27 10 36.4 0.43 10 34.34 0.4 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTCGM 5.65 0.12 9 13.18 0.22 9 -6.43 1.18 9 -1.4 0.13 9 -1.45 0.06 9 0.14 0.31 9 3.86 0.68 9 34.93 1.52 9 33.75 0.33 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTCTM 4.85 0.22 11 14.14 0.15 9 -2.9 0.28 11 -1.52 0.05 11 -1.76 0.03 11 -0.9 0.95 11 -2.85 0.76 11 36.72 0.4 11 31.95 0.17 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTCMQ 5.23 0.19 72 13.97 0.31 66 -2.82 0.61 73 -1.52 0.08 72 -1.69 0.06 73 0.15 0.77 72 -3.81 0.71 73 35.97 0.54 72 32.09 0.41 73 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTGAM 5.98 0.16 10 13.08 0.21 10 -6.84 0.32 10 -1.09 0.12 10 -1.32 0.05 10 6.02 0.49 10 -1.57 0.3 10 34.44 0.35 10 35.7 0.33 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTGCM 5.51 0.09 10 13.46 0.19 10 -3.43 0.25 10 -1.31 0.06 10 -1.6 0.02 10 4.53 0.45 10 -1.51 0.38 10 34.35 0.19 10 36.54 0.15 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTGGM 5.64 0.18 14 13.37 0.42 13 -3.98 0.66 14 -1.3 0.08 14 -1.71 0.06 14 4.81 0.98 14 -1.25 0.68 14 34.51 0.29 14 33.62 0.43 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTGTM 5.4 0.19 8 12.9 0.15 8 -7.56 0.37 8 -1.29 0.08 8 -1.51 0.02 8 6.18 0.87 8 -2.64 0.6 8 35.19 0.33 8 34.38 0.27 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTGMQ 5.89 0.21 69 12.85 0.36 66 -4.07 0.61 69 -1.16 0.1 69 -1.55 0.06 69 5.06 0.8 69 -2.89 0.61 69 35.09 0.47 69 33.6 0.43 69 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTTAM 5.93 0.29 8 12.45 0.21 7 -11.5 0.29 8 -1.03 0.06 8 -1.16 0.08 8 -1.39 0.9 8 5.48 1.67 8 35.44 0.42 8 34.85 0.83 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTTCM 5.07 0.24 14 13.59 0.28 9 -10.8 0.66 14 -1.08 0.08 14 -1.53 0.08 14 -1.38 1.13 14 0.37 0.97 14 35.56 0.89 14 35.9 0.74 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTTGM 5.75 0.24 16 12.46 0.42 16 -11.23 0.51 16 -1.03 0.05 16 -1.15 0.09 16 -1.28 1.06 16 5.41 1.11 16 35.2 0.38 16 35.05 0.63 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTTTM 4.51 0.4 20 12.76 0.25 19 -13.98 2.24 20 -1.04 0.11 20 -1.07 0.09 20 -2.61 1.73 20 -3.25 1.67 20 37 0.43 20 36.47 1.31 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTTMQ 5.11 0.3 84 13.15 0.24 80 -9.43 1.22 85 -1.08 0.07 84 -1.17 0.06 85 -2.92 1.36 84 -3.21 0.67 85 36.17 0.78 84 34.71 0.67 85 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTMQA 5.62 0.17 141 13.26 0.2 136 -11.95 0.41 141 -1.19 0.05 141 -1.39 0.06 141 -3.02 0.49 141 11.83 0.56 141 34.61 0.36 141 34.63 0.31 141 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TTMQM 5.69 0.15 27 13.21 0.3 25 -12.16 0.58 27 -1.18 0.06 27 -1.41 0.05 27 -2.84 0.36 27 10.59 1.05 27 34.28 0.69 27 34.84 0.91 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TMQAM 5.63 0.09 21 13.24 0.2 20 -11.96 0.32 21 -1.36 0.06 21 -1.21 0.04 21 11.69 0.46 21 -3.96 0.32 21 34.52 0.31 21 34.99 0.29 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TMQCM 5.18 0.09 21 13.87 0.25 21 -8.83 0.35 22 -1.53 0.05 21 -1.66 0.04 22 9.86 0.64 21 -3.82 0.35 22 34.11 0.29 21 34.6 0.27 22 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TMQGM 5.44 0.15 19 13.89 0.22 18 -8.78 0.39 19 -1.47 0.05 19 -1.68 0.05 19 9.71 0.86 19 -3.96 0.53 19 34.12 0.32 19 32.3 0.25 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TMQTM 4.95 0.13 21 13.27 0.25 21 -12.7 0.5 21 -1.53 0.05 21 -1.45 0.02 21 11.08 0.8 21 -4.91 0.49 21 35.45 0.28 21 33.24 0.23 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "TMQMQ 5.51 0.17 94 12.92 0.48 89 -8.85 0.52 94 -1.42 0.06 94 -1.55 0.07 94 10.83 0.81 94 -5.06 0.57 94 35 0.62 94 32.29 0.36 94 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQAAM 5.33 0.11 8 13.11 0.11 7 -9.34 0.18 8 -1.15 0.02 8 -1.03 0.02 8 -2.93 0.22 8 -3.18 0.23 8 34.28 0.19 8 36.8 0.17 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQACM 5.22 0.2 7 13.77 0.08 7 -6.82 0.26 7 -1.33 0.03 7 -1.6 0.02 7 -3.63 0.48 7 -2.71 0.65 7 33.83 0.27 7 35.1 0.32 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQAGM 5.23 0.1 7 14.11 0.23 7 -6.14 0.27 7 -1.36 0.03 7 -1.74 0.03 7 -3.69 0.12 7 -2.85 0.32 7 33.98 0.18 7 32.2 0.26 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQATM 5.16 0.07 14 13.91 0.25 13 -6.25 0.27 14 -1.36 0.03 14 -1.56 0.04 14 -3.11 0.31 14 -4.3 0.31 14 34.31 0.23 14 32.6 0.15 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQAMQ 5.2 0.14 89 13.26 0.34 83 -7.46 0.4 89 -1.2 0.04 89 -1.45 0.03 89 -4 0.39 89 -5.03 0.52 89 34.92 0.4 89 33.29 0.26 89 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQCAM 6.01 0.1 9 12.75 0.26 8 -4.4 0.29 9 -1.5 0.05 9 -1.07 0.05 9 -2.47 0.41 9 3.28 0.7 9 33.34 0.16 9 35.94 0.46 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQCCM 4.94 0.08 7 14.47 0.16 7 -2.87 0.16 7 -1.67 0.02 7 -1.82 0.04 7 -3.96 0.2 7 -1.36 0.4 7 34.13 0.17 7 34.58 0.11 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQCGM 5.54 0.12 14 13.22 0.24 13 -3.73 0.17 14 -1.54 0.03 14 -1.46 0.05 14 -3.37 0.3 14 2.56 0.36 14 33.72 0.15 14 34.13 0.21 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQCTM 4.87 0.12 7 14.49 0.17 7 -1.43 0.27 7 -1.73 0.04 7 -1.74 0.03 7 -4.6 0.63 7 -2.85 0.32 7 34.76 0.46 7 32.2 0.26 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQCMQ 5.17 0.13 90 14.04 0.36 83 -1.44 0.46 90 -1.66 0.05 90 -1.69 0.05 90 -3.75 0.51 90 -4.05 0.5 90 34.53 0.37 90 32.21 0.28 90 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQGAM 5.41 0.12 7 13.63 0.12 7 -3.9 0.19 7 -1.58 0.04 7 -1.31 0.04 7 -2.9 0.39 7 -1.31 0.49 7 32.03 0.22 7 37.21 0.24 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQGCM 5.04 0.12 16 14.32 0.19 15 -0.9 0.52 16 -1.76 0.03 16 -1.67 0.04 16 -4.33 0.46 16 -1.57 0.52 16 31.61 0.26 16 37.38 0.63 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQGGM 5.1 0.08 7 14.37 0.13 7 -0.9 0.45 7 -1.79 0.06 7 -1.82 0.04 7 -4.03 0.54 7 -1.36 0.4 7 31.4 0.65 7 34.58 0.11 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQGTM 4.96 0.22 7 14.05 0.16 7 -3.93 0.12 7 -1.71 0.03 7 -1.6 0.02 7 -3.58 0.74 7 -2.71 0.65 7 32.3 0.21 7 35.1 0.32 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQTAM 5.91 0.22 14 12.6 0.34 14 -8.41 0.37 14 -1.39 0.02 14 -1.14 0.09 14 -3.76 0.68 14 3.44 1.76 14 32.59 0.2 14 35.89 0.82 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQTCM 5.08 0.14 7 13.42 0.15 7 -8.57 0.29 7 -1.42 0.02 7 -1.31 0.04 7 -4.58 0.58 7 -1.31 0.49 7 33.12 0.21 7 37.21 0.24 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQTGM 5.86 0.12 9 12.44 0.22 9 -8.48 0.32 9 -1.35 0.03 9 -1.07 0.05 9 -3.83 0.49 9 3.28 0.7 9 32.37 0.18 9 35.94 0.46 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQTTM 4.75 0.07 8 12.85 0.11 8 -12.02 0.19 8 -1.4 0.02 8 -1.03 0.02 8 -4.74 0.19 8 -3.18 0.23 8 33.92 0.14 8 36.8 0.17 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "MQMQM 5.44 0.08 14 13.34 0.32 14 -8.67 0.52 14 -1.59 0.05 14 -1.45 0.04 14 -5.35 0.51 14 8.71 0.68 14 32.29 0.27 14 35.05 0.5 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAAAM 4.88 0.22 13 12.75 0.19 13 -13.16 0.48 13 -1.05 0.03 13 -1 0.02 13 -2.31 0.73 13 -2.87 0.73 13 35.6 0.36 13 37.32 0.32 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAACM 4.66 0.13 14 13.53 0.27 14 -10.69 0.48 14 -1.23 0.04 14 -1.65 0.02 14 -3.43 0.49 14 -2.68 0.43 14 35.31 0.3 14 35.57 0.24 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAAGM 4.79 0.18 14 13.91 0.3 13 -9.27 0.38 14 -1.31 0.03 14 -1.78 0.06 14 -3.28 0.67 14 -1.97 0.76 14 35.04 0.33 14 32.79 0.33 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAATM 4.4 0.22 14 13.83 0.25 12 -9.66 0.44 14 -1.34 0.03 14 -1.62 0.02 14 -3.3 0.64 14 -5.33 0.6 14 35.73 0.42 14 33.1 0.24 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QACAM 5.72 0.29 14 12.55 0.31 13 -7.94 0.33 14 -1.46 0.03 14 -1.06 0.05 14 -2.05 0.84 14 4.26 0.61 14 33.69 0.91 14 36.01 0.5 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QACCM 4.45 0.17 14 14.18 0.45 13 -6.06 0.3 14 -1.58 0.03 14 -1.88 0.05 14 -3.42 0.55 14 -0.89 0.6 14 35.04 0.23 14 34.87 0.33 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QACGM 5.04 0.14 14 13.03 0.39 14 -7.97 0.29 14 -1.49 0.03 14 -1.61 0.09 14 -3.02 0.44 14 4.03 0.49 14 34.55 0.34 14 34.03 0.78 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QACTM 4.41 0.24 13 14.17 0.3 12 -3.87 0.44 13 -1.7 0.04 13 -1.81 0.06 13 -3.79 0.57 13 -2.74 0.54 13 35.34 0.31 13 32.39 0.31 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAGAM 4.99 0.16 13 14.02 0.21 11 -3.73 0.4 13 -1.67 0.05 13 -1.34 0.05 13 -2.23 0.67 13 -2.45 0.44 13 31.86 0.29 13 37.46 0.53 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAGCM 4.77 0.23 14 14.33 0.41 12 -1.13 0.29 14 -1.81 0.03 14 -1.73 0.04 14 -2.61 0.82 14 -1.98 0.79 14 31.55 0.35 14 37.49 0.37 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAGGM 4.67 0.2 13 14.53 0.27 11 -0.99 0.36 13 -1.81 0.03 13 -1.88 0.04 13 -3.33 0.83 13 -2.17 0.92 13 31.76 0.26 13 34.61 0.49 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QATAM 5.84 0.21 14 12.95 0.32 14 -7.81 0.43 14 -1.49 0.03 14 -1.3 0.05 14 -3.35 0.63 14 5.35 1.06 14 32.08 0.28 14 35.23 0.57 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QATCM 4.67 0.21 14 14.26 0.23 11 -7.52 0.38 14 -1.57 0.03 14 -1.68 0.03 14 -4.76 0.59 14 -0.55 0.75 14 32.68 0.24 14 36.21 0.42 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QATGM 5.46 0.19 14 13.18 0.28 13 -7.89 0.42 14 -1.49 0.03 14 -1.41 0.06 14 -3.79 0.6 14 4.51 0.73 14 31.9 0.22 14 35.43 0.39 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QAMQM 4.95 0.17 14 12.89 0.5 14 -13.36 0.78 14 -1.43 0.04 14 -1.53 0.05 14 -4.65 0.47 14 10.47 1.12 14 33.11 0.26 14 35.85 0.74 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCAAM 5.82 0.16 14 12.47 0.29 14 -10.8 0.51 14 -1.08 0.07 14 -1.01 0.03 14 4.87 0.74 14 -2.48 0.58 14 34.76 0.39 14 35.8 0.28 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCACM 5.69 0.23 14 12.75 0.22 11 -8 0.55 14 -1.29 0.05 14 -1.55 0.04 14 3.7 0.88 14 -1.89 0.94 14 34.77 0.32 14 34.1 0.32 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCAGM 5.7 0.13 14 13.19 0.24 13 -7.04 0.56 14 -1.34 0.06 14 -1.65 0.04 14 3.98 0.76 14 -1.87 0.6 14 34.68 0.41 14 31.54 0.21 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCCAM 5.76 0.18 14 13.07 0.27 12 -4.61 0.28 14 -1.65 0.03 14 -1.19 0.06 14 -0.91 0.59 14 3.25 0.72 14 33.63 0.44 14 35.15 0.47 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCCCM 4.73 0.12 14 14.76 0.22 12 -2.3 0.3 14 -1.8 0.03 14 -1.88 0.03 14 -1.88 0.44 14 -1.9 0.51 14 34.14 0.34 14 33.88 0.22 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCCGM 5.43 0.12 14 13.36 0.24 13 -3.95 0.28 14 -1.69 0.03 14 -1.54 0.04 14 -1.24 0.42 14 2.85 0.55 14 33.76 0.32 14 33.22 0.29 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCGAM 5.59 0.19 14 13.06 0.27 12 -6.94 0.45 14 -1.44 0.05 14 -1.27 0.06 14 4.37 0.73 14 -1.87 0.64 14 33.36 0.56 14 36.13 0.61 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCGCM 5.36 0.13 13 13.17 0.33 13 -3.82 0.31 13 -1.53 0.04 13 -1.56 0.03 13 2.98 0.58 13 -1.19 0.51 13 33.1 0.33 13 36.54 0.33 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCTAM 5.96 0.15 14 13.22 0.27 14 -7.54 0.51 14 -1.65 0.03 14 -1.31 0.05 14 -1.34 0.74 14 4.72 1.01 14 31.7 0.35 14 34.71 0.58 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCTCM 5.1 0.12 14 14.46 0.2 14 -7 0.41 14 -1.76 0.04 14 -1.64 0.04 14 -1.85 0.49 14 -0.41 0.66 14 31.78 0.21 14 35.35 0.47 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QCMQM 5.47 0.17 14 13.74 0.5 13 -8.93 0.45 14 -1.67 0.04 14 -1.47 0.06 14 -3.74 0.56 14 8.82 0.78 14 32.05 0.18 14 34.46 0.46 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGAAM 5.08 0.21 14 13.45 0.36 14 -10.64 0.35 14 -1.45 0.06 14 -1.01 0.03 14 0 0.95 14 -2.64 0.68 14 35.9 0.67 14 36.48 0.27 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGACM 4.99 0.21 14 14.06 0.45 13 -7.96 0.36 14 -1.54 0.03 14 -1.63 0.04 14 -0.88 0.62 14 -2.15 0.56 14 35.7 0.32 14 34.75 0.19 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGCAM 5.76 0.28 14 13.11 0.44 13 -3.77 0.64 14 -1.53 0.07 14 -1.16 0.08 14 -0.9 0.56 14 2.7 0.8 14 36.16 0.27 14 35.18 0.52 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGCCM 4.68 0.13 12 14.58 0.31 9 -2.49 0.23 12 -1.67 0.03 12 -1.86 0.03 12 -2.24 0.47 12 -1.62 0.44 12 37.12 0.36 12 33.87 0.24 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGGAM 4.95 0.16 14 14.04 0.23 12 -5.8 0.38 14 -1.79 0.04 14 -1.31 0.04 14 -0.27 0.5 14 -2.14 0.5 14 34.18 0.43 14 36.93 0.39 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGTAM 5.93 0.19 13 12.78 0.34 13 -8.35 0.35 13 -1.54 0.04 13 -1.25 0.08 13 -1.39 0.49 13 4.5 1.47 13 34.26 0.26 13 34.93 0.73 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QGMQM 5.27 0.16 14 13.64 0.35 14 -9.07 0.33 14 -1.63 0.04 14 -1.52 0.04 14 -3.38 0.51 14 8.75 0.62 14 34.36 0.25 14 34.37 0.52 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QTAAM 6.13 0.33 14 12.38 0.47 11 -11.76 1.01 14 -1.14 0.12 14 -0.99 0.04 14 5.87 2.04 14 -1.97 0.87 14 34.06 1.53 14 36.2 0.38 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QTCAM 6.09 0.16 14 12.84 0.27 14 -7.25 0.44 14 -1.29 0.06 14 -1 0.08 14 -1.19 0.55 14 4.37 0.74 14 35.42 0.43 14 35.26 0.44 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0",
  "QTMQM 5.62 0.15 14 12.94 0.45 13 -12.41 0.7 14 -1.21 0.04 14 -1.38 0.05 14 -3.86 0.5 14 10.84 0.85 14 34.7 0.45 14 34.94 0.48 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"

};

void add_groove_width_to_pentamers_table(std::string filename,DNA_to_properties &onemap,std::string sequence,int object_index, \
					 std::string object_name,bool verbose,bool debug,bool five){

  //construct the matrix from the file
  std::vector<double_vector> matrix;
  matrix.clear();
  std::ifstream in_file(filename.c_str());

  if (!in_file){
    //if (debug)
    //  std::cout << "Cannot open the file: " << filename << std::endl;
    in_file.close();
    return;
  }

  std::string line;

  while (getline(in_file,line)){
    double_vector double_row;
    double_row.clear();
    string_vector string_row;
    parse_string_to_list(line,"\t ",string_row);
    if ((string_row.size()>0) and (string_vector_to_double_vector(string_row,double_row)))
      matrix.push_back(double_row);
  }
  //if the file is empty, then return
  if (matrix.size()==0)
    return;

  //  Matrix definition
  //  0--ResId    1--Levels  3--Average minor/major groove width
  //  8--occurrences

  int no_of_positions = sequence.size();

  //if (debug){
  //  for (unsigned int i=0;i<matrix.size();i++){
  //    for (unsigned int j=0;j<matrix[i].size();j++)
	//std::cout <<"\t"<<matrix[i][j];
  //    std::cout<<"\n";
  //  }
  //  std::cout<<"No of positions: "<<no_of_positions<<std::endl;
  //}

  std::vector<int> num_of_levels;     //num of levels for each ResId
  for (int i=0;i<=no_of_positions;i++)
    num_of_levels.push_back(0);

  //std::cout << "Vector size: "<<num_of_levels.size()<<std::endl;
  for (unsigned int i=0; i<matrix.size(); i++){
    //std::cout << double_to_int(matrix[i][0])  <<std::endl;
    num_of_levels[double_to_int(matrix[i][0])]++;
  }

  /*
  int starting_row_no[MAX_SEQ_LEN_IN_LIB]={0};    //starting row no. in matrix for each position, initialize all the elements to 0
  int no_of_levels[MAX_SEQ_LEN_IN_LIB]={0};
  for (int i=0;i<matrix.size();i++){
    if (no_of_levels[double_to_int(matrix[i][0])]==0)
      starting_row_no[double_to_int(matrix[i][0])]=i;
    no_of_levels[double_to_int(matrix[i][0])]++;
  }
  */
  //std::cout << "Mark\n";

  int start_pos = 4;  //discard the first 3 positions      //the ResID of the first sequence character is 1
  int end_pos=no_of_positions-4; // discard the last 3
  double current_value,prev_value,next_value,prevprev_value,nextnext_value;
  nextnext_value = -99999;
  int current_id;
  std::string current_pentamer;
  for (unsigned int i=1;i<(matrix.size()-1);i++){
    if ((double_to_int(matrix[i][0])>=start_pos) and (double_to_int(matrix[i][0])<=end_pos) \
	and (double_to_int(matrix[i][1])==1) and (double_to_int(matrix[i][8])>100000)){   //the first is level is 1

      current_id = double_to_int(matrix[i][0]);
      current_pentamer = sequence.substr(current_id-1-2,5);  //1bp shift
      current_value = matrix[i][object_index];

      if ((double_to_int(matrix[i+1][0])==current_id) and (double_to_int(matrix[i+1][1])==2) \
	  and (double_to_int(matrix[i+1][8])>100000))
	next_value = matrix[i+1][object_index];
      else
	continue;

      if (five){  // Use 5 levels instead of 3
	if ((i+2<matrix.size()) and (double_to_int(matrix[i+2][0])==current_id)	\
	    and (double_to_int(matrix[i+2][1])==3) and (double_to_int(matrix[i+2][8])>100000))
	  nextnext_value = matrix[i+2][object_index];
	else
	  continue;
      }

      int tp = i;
      bool flag = false;
      for (int j=0;j<num_of_levels[current_id-1];j++){
	tp--;
	if ((double_to_int(matrix[tp][1])<=4) and (double_to_int(matrix[tp][8])>100000)){
	    flag = true;
	    prev_value = matrix[tp][object_index];
	    break;
	  }
      }
      if (!flag) continue;

      if (five){
	if ((tp-1>=0) and (double_to_int(matrix[tp-1][0])==current_id-1) and (double_to_int(matrix[tp-1][8])>100000)){
	  prevprev_value = matrix[tp-1][object_index];
	}
	else
	  continue;
      }

      double final_value;
      if (five)
	final_value = (prevprev_value + prev_value + current_value + next_value + nextnext_value)/5;
      else
	final_value = (prev_value + current_value + next_value)/3;

      if (found_str_in_map(current_pentamer,onemap))
	onemap[current_pentamer].push(final_value,object_name);
      else
	onemap[opposite_strand(current_pentamer)].push(final_value,object_name);
    }
  }
  /*
  for (int i=start_pos;i<=end_pos;i++){
    double current_value =0;
    std::string current_pentamer = sequence.substr(i-1-2,5);   //there is 1bp shift between pos and sequence index
    if (((starting_row_no[i]+1)<matrix.size()) and ((starting_row_no[i]-1)>=0) and \
	(matrix[starting_row_no[i]+1][0]==matrix[starting_row_no[i]][0]) and \
	(no_of_levels[i-1]>0) and (matrix[starting_row_no[i]][1]==1) and \
	(matrix[starting_row_no[i]-1][0]==(matrix[starting_row_no[i]][0]-1))) {  //make sure it is consecutive, the first level is level 1
      //next level is the same position, and its level 2
      current_value = matrix[starting_row_no[i]][object_index]+\
	matrix[starting_row_no[i]+1][object_index];           //currentvalue =   3 |||0,1
      if (matrix[starting_row_no[i]-1][1]==5){
	if ((starting_row_no[i]-2<0) or ((matrix[starting_row_no[i]-2][0]+1)!=matrix[starting_row_no[i]][0]))
	  continue;
	current_value+=matrix[starting_row_no[i]-2][object_index];
      }
      else
	current_value+=matrix[starting_row_no[i]-1][object_index];
      current_value=current_value/3;
      if (debug)
	std::cout<< current_pentamer << " : "<<current_value <<std::endl;
      if (found_str_in_map(current_pentamer,onemap))
	onemap[current_pentamer].push(current_value,object_name);
      else
	onemap[opposite_strand(current_pentamer)].push(current_value,object_name);
    }
  }
  */
  in_file.close();
}



void add_ep_to_pentamers_table(std::string filename,DNA_to_properties &onemap,std::string sequence,int object_index, \
					 std::string object_name,bool verbose,bool debug,bool five){

  //construct the matrix from the file
  std::vector<double_vector> matrix;
  matrix.clear();
  std::ifstream in_file(filename.c_str());

  if (!in_file){
    //if (debug)
      //std::cout << "Cannot open the file: " << filename << std::endl;
    in_file.close();
    return;
  }

  std::string line;

  while (getline(in_file,line)){
    double_vector double_row;
    double_row.clear();
    string_vector string_row;
    parse_string_to_list(line,"\t ",string_row);
    if ((string_row.size()>0) and (string_vector_to_double_vector(string_row,double_row)))
      matrix.push_back(double_row);
  }
  //if the file is empty, then return
  if (matrix.size()==0)
    return;

  //  Matrix definition
  //  4--Electrostatic potential from the second position

  int no_of_positions = sequence.size();

  //if (debug){
  //  for (unsigned int i=0;i<matrix.size();i++){
  //    for (unsigned int j=0;j<matrix[i].size();j++)
		//std::cout <<"\t"<<matrix[i][j];
		//std::cout<<"\n";
  //  }
    //std::cout<<"No of positions: "<<no_of_positions<<std::endl;
  //}


  unsigned int start_pos = 0;  //start from the second position
  unsigned int end_pos = no_of_positions-5; //end at the second last position
  double current_value;
  std::string current_pentamer;

  for (unsigned int i=0;i<matrix.size();i++){
    if ((i>=start_pos) and (i<=end_pos) and (i+1<matrix.size())){
      current_pentamer = sequence.substr(i,5);  //1bp shift
      current_value = matrix[i+1][object_index];

      if (found_str_in_map(current_pentamer,onemap)){
		if(current_value<=0 && current_value>=-20){ //put constrains
			onemap[current_pentamer].push(current_value,object_name);
			//if (debug){
				//std::cout<<"ep pentamer verify:"<<current_pentamer<<":"<<current_value<<":"<<filename<<":"<<i+3<<":"<<sequence<<":"<<std::endl;
      //      }
		}else{
			//if (debug){
				//std::cout<<"ep pentamer verify:"<<current_pentamer<<":"<<current_value<<":"<<filename<<":"<<i+3<<":"<<sequence<<":eliminated"<<std::endl;
      //      }
		}

	  }else{
		if(current_value<=0 && current_value>=-20){ //put constrains
			onemap[opposite_strand(current_pentamer)].push(current_value,object_name);
			//if (debug){
                 //std::cout<<"ep pentamer verify:"<<opposite_strand(current_pentamer)<<":"<<current_value<<":"<<filename<<":"<<i+3<<":"<<sequence<<":opposite_strand"<<std::endl;
      //      }
		}else{
			//if (debug){
				 //std::cout<<"ep pentamer verify:"<<opposite_strand(current_pentamer)<<":"<<current_value<<":"<<filename<<":"<<i+3<<":"<<sequence<<":opposite_strand,eliminated"<<std::endl;
      //      }
		}
	  }

		//if (debug){
			//std::cout<<	"current_pentamer:" << current_pentamer << "\t";
			//std::cout<<	"current_value:" << current_value << std::endl;
		//}
    }
  }

  in_file.close();
}



void add_step_info_to_pentamers_table(DNA_to_properties& onemap, std::string filename, std::string sequence,bool verbose, bool debug){
  std::ifstream cclis_inf(filename.c_str());
  if (cclis_inf){
    std::string line;
    std::vector<double_vector> matrix;
    matrix.clear();

    //add propel(omega) informaton
    while (getline(cclis_inf,line)){
      if (line.find("|D| AV")!=std::string::npos){
	//skip 7 lines
	for (int i=0;i<7;i++)
	  getline(cclis_inf,line);

	string_vector string_row;
	double_vector double_row;
	do{
	  getline(cclis_inf,line);
	  parse_string_to_list(line,"\t ",string_row);
	  if (string_row.size()==12){
	    //delete the first 4 elements of the vector
	    for (int j=0;j<4;j++)
	      string_row.erase(string_row.begin());
	    string_vector_to_double_vector(string_row,double_row);
	    matrix.push_back(double_row);
	  }
	  else if (string_row.size()>0){
	    //std::cout << "Error: Cannot parse the line: "<<line<<std::endl;
	    return;
	  }
	}while (string_row.size()==8);
	break;
      }
    }
    //if (debug){
      //std::cout<<"Block |D|"<<std::endl;
      //for (unsigned int i=0;i<matrix.size();i++){
	//for (unsigned int j=0;j<matrix[i].size();j++)
	  //std::cout << "\t"<<matrix[i][j];
	//std::cout << std::endl;
      //}
    //}
    if (matrix.size()>0){
      add_propel_to_table(onemap,sequence,matrix,4,"propel",verbose,debug);

    matrix.clear();
    //add step information
    while (getline(cclis_inf,line)){
      if (line.find("|H| AV")!=std::string::npos){
	  //skip 7 lines
	  for (int i=0;i<7; i++)
	    getline(cclis_inf,line);

	  string_vector string_row;
	  double_vector double_row;
	  do{
	    getline(cclis_inf,line);
	    parse_string_to_list(line,"\t ",string_row);
	    if (string_row.size()==11){
	      //delete the first 4 elements of the vector
	      for (int j=0;j<4;j++)
		string_row.erase(string_row.begin());
	      string_vector_to_double_vector(string_row,double_row);
	      matrix.push_back(double_row);
	    }
	    else if (string_row.size()>0){
	      //std::cout << "Cannot parse the line: "<<line<<std::endl;
	      //exit(1);
	    }

	  }while (string_row.size()==7);
	  break;
      }
    }

    //if (debug){
      //std::cout<<"Block |H|:"<<std::endl;
      //for (unsigned int i=0;i<matrix.size();i++){
	//for (unsigned int j=0; j<matrix[i].size(); j++)
	  //std::cout << "\t"<<matrix[i][j];
	//std::cout <<std::endl;
      //}
    //}

    if (matrix.size()>0){
      add_one_step_info(onemap,sequence,matrix,1,"slide",verbose,debug);
      add_one_step_info(onemap,sequence,matrix,4,"roll",verbose,debug);
      add_one_step_info(onemap,sequence,matrix,5,"twist",verbose,debug);
    }
  }
  else
    //if (debug)
      //std::cout<<"Cannot open the cclis file: " <<filename<<std::endl;

    cclis_inf.close();
  }
}



void add_one_step_info(DNA_to_properties& onemap,std::string sequence,std::vector<double_vector> &matrix,int object_index, \
		       std::string object_name, bool verbose, bool debug){
  if (matrix.size()!=sequence.size()-1){
    //if (debug)
      //std::cout << "Error: Size of step info matrix does not equal to (len(sequence)-1)"<<std::endl;
    return;
  }
  //discard the first 2 step and last 2
  // N - N -(step1) - N - (step2) - N     what is object_name1, what is object_name2
  std::string current_pentamer1,current_pentamer2;
  std::string object_name1 = object_name + "1";
  std::string object_name2 = object_name + "2";
  for (unsigned int i=2; i<matrix.size()-2; i++){
    current_pentamer1 = sequence.substr(i-1,5);
    current_pentamer2 = sequence.substr(i-2,5);

    if (found_str_in_map(current_pentamer1,onemap))
      onemap[current_pentamer1].push(matrix[i][object_index],object_name1);
    else
      onemap[opposite_strand(current_pentamer1)].push(matrix[i][object_index],object_name2);

    if (found_str_in_map(current_pentamer2,onemap))
      onemap[current_pentamer2].push(matrix[i][object_index],object_name2);
    else
      onemap[opposite_strand(current_pentamer2)].push(matrix[i][object_index],object_name1);
  }

}

void add_propel_to_table(DNA_to_properties& onemap,std::string sequence, std::vector<double_vector> &matrix,int object_index,\
			  std::string object_name,bool verbose,bool debug){
   if (matrix.size()!=sequence.size()){
     //if (debug)
       //std::cout << "Error: Size of Global Base-Base Parameters does not equal to len(sequence)"<<std::endl;
     return;
   }
   //discard the first 2 liens and last 2
   std::string current_pentamer;
   for (unsigned int i=2; i<matrix.size()-2; i++){
     current_pentamer = sequence.substr(i-2,5);
     if (found_str_in_map(current_pentamer,onemap))
       onemap[current_pentamer].push(matrix[i][object_index],object_name);
     else
       onemap[opposite_strand(current_pentamer)].push(matrix[i][object_index],object_name);
   }
 }

void process_querytable_file(std::string querytable_filename,DNA_to_properties& onemap,bool debug){
	std::ifstream qt_ifstream(querytable_filename.c_str());
	if (!qt_ifstream){     //check if the file exist
		Rcout << "Cannot open the following file containing query table: " << querytable_filename << std::endl;

  }else{
  	std::string line,current_pentamer;
  	string_vector sv;
  	double_vector dv;
  	while (getline(qt_ifstream,line)){
  		if (line.size()>0){
  			parse_string_to_list(line," ",sv);
  			//if (sv.size()==28){
  			if (sv.size()==91){ //add ep, xrc and md
  				current_pentamer = sv[0];
  				sv.erase(sv.begin());
  				string_vector_to_double_vector(sv,dv);
  				properties p = properties();
  				p.load_data_from_vector(dv);
  				onemap[current_pentamer] = p;
  			}else {
  				Rcout << "Cannot parse the following line:\n" << sv.size() << std::endl;
  			}
  		}
  	}
	}
}

void process_querytable(DNA_to_properties& onemap,bool debug){ //by Tsu-Pei
  	std::string line,current_pentamer;
  	string_vector sv;
  	double_vector dv;
    for(unsigned int i=0; i<sizeQueryTable; i++){ //by Tsu-Pei
      line = QueryTable[i]; //by Tsu-Pei
  		if (line.size()>0){
  			parse_string_to_list(line," ",sv);
  			//if (sv.size()==28){
  			if (sv.size()==91){ //Tsu-Pei
  				current_pentamer = sv[0];
  				sv.erase(sv.begin());
  				string_vector_to_double_vector(sv,dv);
  				properties p = properties();
  				p.load_data_from_vector(dv);
  				onemap[current_pentamer] = p;
  			}else {
  				Rcout << "Cannot parse the following line:\n"<< line << std::endl;
  			}
  		}
  	}
}

void add_groove_width_to_inosine_table(std::string filename,DNA_to_properties &onemap,std::string sequence,int object_index, \
					 std::string object_name,bool verbose,bool debug,bool five){

  //construct the matrix from the file
  std::vector<double_vector> matrix;
  matrix.clear();
  std::ifstream in_file(filename.c_str());

  if (!in_file){
    //if (debug)
      //std::cout << "Cannot open the file: " << filename << std::endl;
    in_file.close();
    return;
  }

  std::string line;

  while (getline(in_file,line)){
    double_vector double_row;
    double_row.clear();
    string_vector string_row;
    parse_string_to_list(line,"\t ",string_row);
    if ((string_row.size()>0) and (string_vector_to_double_vector(string_row,double_row)))
      matrix.push_back(double_row);
  }
  //if the file is empty, then return
  if (matrix.size()==0)
    return;

  //  Matrix definition
  //  0--ResId    1--Levels  3--Average minor/major groove width
  //  8--occurrences

  int no_of_positions = sequence.size();

  //if (debug){
    //for (unsigned int i=0;i<matrix.size();i++){
      //for (unsigned int j=0;j<matrix[i].size();j++)
	//std::cout <<"\t"<<matrix[i][j];
      //std::cout<<"\n";
    //}
    //std::cout<<"No of positions: "<<no_of_positions<<std::endl;
  //}

  std::vector<int> num_of_levels;     //num of levels for each ResId
  for (int i=0;i<=no_of_positions;i++)
    num_of_levels.push_back(0);

  //std::cout << "Vector size: "<<num_of_levels.size()<<std::endl;
  for (unsigned int i=0; i<matrix.size(); i++){
    //std::cout << double_to_int(matrix[i][0])  <<std::endl;
    num_of_levels[double_to_int(matrix[i][0])]++;
  }


  int start_pos = 4;  //discard the first 3 positions      //the ResID of the first sequence character is 1
  int end_pos=no_of_positions-4; // discard the last 3
  double current_value,prev_value,next_value,prevprev_value,nextnext_value;
  nextnext_value = -99999;
  int current_id;
  std::string current_pentamer;
  for (unsigned int i=1;i<(matrix.size()-1);i++){
    if ((double_to_int(matrix[i][0])>=start_pos) and (double_to_int(matrix[i][0])<=end_pos) \
	and (double_to_int(matrix[i][1])==1) and (double_to_int(matrix[i][8])>100000)   //the first is level is 1
	and (double_to_int(matrix[i][0])==7)){   //CGCG NNNNN CGCG  , only utilize the information of central pentamer

      current_id = double_to_int(matrix[i][0]);
      current_pentamer = sequence.substr(current_id-1-2,5);  //1bp shift
      current_value = matrix[i][object_index];

      if ((double_to_int(matrix[i+1][0])==current_id) and (double_to_int(matrix[i+1][1])==2) \
	  and (double_to_int(matrix[i+1][8])>100000))
	next_value = matrix[i+1][object_index];
      else
	continue;

      if (five){  // Use 5 levels instead of 3
	if ((i+2<matrix.size()) and (double_to_int(matrix[i+2][0])==current_id)	\
	    and (double_to_int(matrix[i+2][1])==3) and (double_to_int(matrix[i+2][8])>100000))
	  nextnext_value = matrix[i+2][object_index];
	else
	  continue;
      }

      int tp = i;
      bool flag = false;
      for (int j=0;j<num_of_levels[current_id-1];j++){
	tp--;
	if ((double_to_int(matrix[tp][1])<=4) and (double_to_int(matrix[tp][8])>100000)){
	    flag = true;
	    prev_value = matrix[tp][object_index];
	    break;
	  }
      }
      if (!flag) continue;

      if (five){
	if ((tp-1>=0) and (double_to_int(matrix[tp-1][0])==current_id-1) and (double_to_int(matrix[tp-1][8])>100000)){
	  prevprev_value = matrix[tp-1][object_index];
	}
	else
	  continue;
      }

      double final_value;
      if (five)
	final_value = (prevprev_value + prev_value + current_value + next_value + nextnext_value)/5;
      else
	final_value = (prev_value + current_value + next_value)/3;

      //std::cout << "Final value: "<<final_value << std::endl;
      if (!found_str_in_map(current_pentamer,onemap)){
	properties p=properties();
	onemap[current_pentamer]=p;
      }

      onemap[current_pentamer].push(final_value,object_name);

    }
  }
  in_file.close();
}


