% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotShape.R
\name{plotShape}
\alias{plotShape}
\title{Plot metaprofiles of DNA shape features}
\usage{
plotShape(shapeMatrix, background = NULL,
colDots = rgb( 0, 0, 1, 0.1),
colDotsBg = rgb( 0, 0, 0, 0.1),
colLine = 'steelblue', colLineBg = 'gray50', cex = 0.5, lwd = 2, ylim, ...)
}
\arguments{
\item{shapeMatrix}{A matrix containing DNAshape prediction results}

\item{background}{A matrix containing DNAshape prediction results for a set of background regions. Default to NULL, i.e. background not provided.}

\item{colDots}{A character vector specifying the color of the points representing the column mean of shapeMatrix. Default to rgb( 0, 0, 1, 0.1).}

\item{colDotsBg}{A character vector specifying the color of the points representing the column mean of background. Default to rgb( 0, 0, 0, 0.1).}

\item{colLine}{A character string giving the color name of line representing the column mean of shapeMatrix. Default to 'steelblue'.}

\item{colLineBg}{A character string giving the color name of line representing the column mean of background. Default to 'gray50'.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default. Default to 0.5.}

\item{lwd}{A numerical value specifying the line width. Default to 2.}

\item{ylim}{A numerical vector of size 2 specifying the y-axis plot range.}

\item{...}{Additional parameters to be passed to the R plot function.}
}
\value{
Called for its effects
}
\description{
DNA shape features can be visualized as
aggregated line plots (also known as metaprofiles, see Comoglio et al., 2015), heat maps (Yang et al., 2014) and
genome browser tracks (Chiu et al., 2014).
}
\examples{
fn <- system.file("extdata", "CGRsample.fa", package = "DNAshapeR")
pred <- getShape(fn)
plotShape(pred$MGW)
plotShape(pred$ProT)
plotShape(pred$Roll)
plotShape(pred$HelT)
}
\author{
Federico Comoglio
}
\keyword{core}
