% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAfusion_functions.R
\name{introns_ALK_EML4}
\alias{introns_ALK_EML4}
\title{Detect ALK and EML4 introns of the breakpoint}
\usage{
introns_ALK_EML4(file, genome = "hg38")
}
\arguments{
\item{file}{The name of the file which the data are to be read from.}

\item{genome}{\code{character} representing the reference genome.
Can be either "hg38" or "hg19". Default="hg38".}
}
\value{
A\code{dataframe}of the ALK- and EML4-intron of the breakpoint is returned
corresponding to the transcript ENST00000389048.8 for ALK and
ENST00000318522.10 for EML4.
If the breakpoint is not located in introns of ALK or EML4,
"Breakpoint not located in intron of ALK" or
"Breakpoint not located in intron of EML4" is returned.
If no EML4-ALK is detected “No EML4-ALK was detected” is returned.
}
\description{
This function identifies the introns of ALK and EML4
where the breakpoint has happened.
}
\examples{
H3122_bam <- system.file("extdata",
"H3122_EML4.bam",
package="DNAfusion")
HCC827_bam <-  system.file("extdata",
"HCC827_EML4.bam",
package="DNAfusion")
introns_ALK_EML4(file=H3122_bam,genome="hg38")
introns_ALK_EML4(file=HCC827_bam,genome="hg38")
}
