% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycle.R
\name{cycle_fasta}
\alias{cycle_fasta}
\title{Predict Cyclizability}
\usage{
cycle_fasta(
  file_path,
  smooth,
  n_cores = 1,
  chunk_length = 1e+05,
  save_path_prefix = ""
)
}
\arguments{
\item{file_path}{.fasta input file path}

\item{smooth}{Whether to predict smoothed C0 (DNAcycP2) or original C0
(DNAcycP)}

\item{n_cores}{Number of cores to use for parallel processing (default=1)}

\item{chunk_length}{Length of sequence that each core will predict on at a
given time.
(default=100000)}

\item{save_path_prefix}{Base path for output files. If it is an empty string,
the output files will not be saved (default="")}
}
\value{
A list of predictions for each ID in the .fasta file.

Each list item has the following columns: position, c_score_norm (
predictions on a normalized scale), and c_score_unnorm (predictions on an
unnormalized scale).

Each list item is named "cycle_$id$" corresponding to the fasta id
}
\description{
This predicts cyclizability for all subsequences of length 50bp from a
.fasta input file.
}
\details{
Optionally, saves output files (use argument 'save_path_prefix')
}
\examples{
# Create a temporary file
temp_file <- tempfile(fileext = ".fasta")
writeLines(">1", temp_file)
writeLines("ACTGCTAGTCACTGCTAGTCACTGCTAGTCACTGCTAGTCACTGCTAGTC", temp_file)

# Example usage of cycle_fasta
cycle_fasta(temp_file, smooth=TRUE)

# Cleanup
unlink(temp_file)
}
