% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{plotOverlapProfile}
\alias{plotOverlapProfile}
\title{Plot overlap profile}
\usage{
plotOverlapProfile(
  overlapsProfiles1,
  overlapsProfiles2 = NULL,
  names = NULL,
  labels = NULL,
  col = NULL,
  title = "",
  logscale = FALSE,
  maxValue = NULL
)
}
\arguments{
\item{overlapsProfiles1}{a  \code{\link{GRanges}} object with the overlaps
profile; see \code{\link{computeOverlapProfile}}.}

\item{overlapsProfiles2}{a  \code{\link{GRanges}} object with the overlaps
profile; see \code{\link{computeOverlapProfile}}. This is optional. For
example, one can be use \code{overlapsProfiles1} to display hypomethylated
regions and \code{overlapsProfiles2} the hypermethylated regions.}

\item{names}{a \code{vector} of \code{character} to add labels for the two
overlapsProfiles. This is an optinal parameter.}

\item{labels}{a \code{vector} of \code{character} used to add a subfigure
character to the plot. If \code{NULL} nothing is added.}

\item{col}{a \code{character} vector with the colours. It needs to contain 2
colours. If not or if \code{NULL}, the defalut colours will be used.}

\item{title}{the title of the plot.}

\item{logscale}{a \code{logical} value indicating if the colours are on
logscale or not.}

\item{maxValue}{a maximum value in a region. Used for the colour scheme.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
This function plots the distribution of a set of subregions on a large
region.
}
\examples{

# load the methylation data
data(methylationDataList)

# load the DMRs in CG context
data(DMRsNoiseFilterCG)

# the coordinates of the area to be plotted
largeRegion <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E5))

# compute overlaps distribution
hotspotsHypo <- computeOverlapProfile(DMRsNoiseFilterCG, largeRegion,
                 windowSize = 10000, binary = FALSE)

plotOverlapProfile(GRangesList("Chr3"=hotspotsHypo),
                   names = c("hypomethylated"), title = "CG methylation")

\dontrun{

largeRegion <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E6))

hotspotsHypo <- computeOverlapProfile(
               DMRsNoiseFilterCG[(DMRsNoiseFilterCG$regionType == "loss")],
               largeRegion, windowSize=2000, binary=TRUE, cores=1)

hotspotsHyper <- computeOverlapProfile(
               DMRsNoiseFilterCG[(DMRsNoiseFilterCG$regionType == "gain")],
               largeRegion, windowSize=2000, binary=TRUE, cores=1)

plotOverlapProfile(GRangesList("Chr3"=hotspotsHypo),
                   GRangesList("Chr3"=hotspotsHyper),
                   names=c("loss", "gain"), title="CG methylation")
}

}
\seealso{
\code{\link{computeOverlapProfile}}, \code{\link{filterDMRs}},
\code{\link{computeDMRs}} and \code{\link{mergeDMRsIteratively}}
}
\author{
Nicolae Radu Zabet
}
