% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDMRs.R
\name{analyseReadsInsideRegionsForCondition}
\alias{analyseReadsInsideRegionsForCondition}
\title{Analyse reads inside regions for condition}
\usage{
analyseReadsInsideRegionsForCondition(
  regions,
  methylationData,
  context,
  label = "",
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{regions}{a \code{\link{GRanges}} object with a list of regions on the 
genome; e.g. could be a list of DMRs}

\item{methylationData}{the methylation data in one condition
(see \code{\link{methylationDataList}}).}

\item{context}{the context in which to extract the reads (\code{"CG"}, 
\code{"CHG"} or \code{"CHH"}).}

\item{label}{a string to be added to the columns to identify the condition}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
a \code{\link{GRanges}} object with additional four metadata columns
\describe{
 \item{sumReadsM}{the number of methylated reads}
 \item{sumReadsN}{the total number of reads} 
 \item{proportion}{the proportion methylated reads} 
 \item{cytosinesCount}{the number of cytosines in the regions} 
}
}
\description{
This function extracts from the methylation data the total number of reads, 
the number of methylated reads and the number of cytosines in the specific 
context from a region (e.g. DMRs)
}
\examples{

# load the methylation data
data(methylationDataList)
 
#load the DMRs in CG context. These DMRs were computed with minGap = 200.
data(DMRsNoiseFilterCG)

#retrive the number of reads in CHH context in WT
DMRsNoiseFilterCGreadsCHH <- analyseReadsInsideRegionsForCondition(
                             DMRsNoiseFilterCG[1:10], 
                             methylationDataList[["WT"]], context = "CHH", 
                             label = "WT")


}
\seealso{
\code{\link{readONTbam}}, \code{\link{filterDMRs}}, \code{\link{computeDMRs}}, 
\code{\link{DMRsNoiseFilterCG}}, and \code{\link{mergeDMRsIteratively}}
}
\author{
Nicolae Radu Zabet
}
