% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/findDMCs-method.R
\name{findDMCs-method}
\alias{findDMCs-method}
\alias{findDMCs,BSDMCs-method}
\alias{findDMCs}
\title{findDMCs method}
\usage{
findDMCs(
  object,
  formula,
  FDRthreshold,
  Methylthreshold,
  mc.cores,
  windowsize,
  weightfunction
)

\S4method{findDMCs}{BSDMCs}(
  object,
  formula,
  FDRthreshold,
  Methylthreshold,
  mc.cores,
  windowsize,
  weightfunction
)
}
\arguments{
\item{object}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}
object}

\item{formula}{A formula}

\item{FDRthreshold}{A numeric value}

\item{Methylthreshold}{A positive numeric value; the default is 0.001}

\item{mc.cores}{An integer greater than 0}

\item{windowsize}{An integer value for partitioning data into windows of size
windowsize.}

\item{weightfunction}{A function to create weights using variance obtained
form the MCMC algorithm}
}
\value{
\code{\link{BSDMCs-class}} object
}
\description{
finds the DMCs after smoothing using HMM
}
\examples{
set.seed(1980)
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc)),nr,nc)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep(c('G1','G2'),each=nc/2),row.names=LETTERS[1:nc])
OBJ1 <- cBSData(rowRanges=r1,methReads=methc,totalReads=metht,colData=cd1)
OBJ2 <- methHMEM(OBJ1, MaxK=2, mc.cores=2)
OBJ3 <- methHMMCMC(OBJ2, mc.cores=2)
OBJ4 <- findDMCs(OBJ3, mc.cores=2)
head(metadata(OBJ4)$DMCHMM)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
